/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import org.refcodes.data.SystemProperty;

public enum OperatingSystem {
    UNIX(SystemProperty.OPERATING_SYSTEM_NAME.getValue()),
    WINDOWS(SystemProperty.OPERATING_SYSTEM_NAME.getValue()),
    MAC(SystemProperty.OPERATING_SYSTEM_NAME.getValue()),
    UNKNOWN(null);

    private String _version = SystemProperty.OPERATING_SYSTEM_VERSION.getValue();

    private OperatingSystem(String string2) {
        if (string2 != null && (this._version == null || this._version.length() == 0)) {
            for (int i = 0; i < string2.length(); ++i) {
                if (!Character.isDigit(string2.charAt(i)) && string2.charAt(i) != '.') continue;
                this._version = this._version + string2.charAt(i);
            }
        }
    }

    public static OperatingSystem toOperatingSystem() {
        String string = SystemProperty.OPERATING_SYSTEM_NAME.getValue();
        if (string != null) {
            if ((string = string.toLowerCase()).indexOf("win") >= 0) {
                return WINDOWS;
            }
            if (string.indexOf("mac") >= 0) {
                return MAC;
            }
            if (string.indexOf("linux") >= 0) {
                return UNIX;
            }
            if (string.indexOf("sunos") >= 0) {
                return UNIX;
            }
            if (string.indexOf("aix") >= 0) {
                return UNIX;
            }
            if (string.indexOf("nix") >= 0) {
                return UNIX;
            }
        }
        return UNKNOWN;
    }

    public String getVersion() {
        if (this == OperatingSystem.toOperatingSystem()) {
            return this._version;
        }
        return null;
    }
}

