/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import org.refcodes.mixin.ResultAccessor;

public class ProcessResult
implements ResultAccessor<String, RuntimeException> {
    private String _result;

    public ProcessResult(Process process) throws IOException {
        try {
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this._result = this.toResult(process);
    }

    public ProcessResult(Process process, int n) throws InterruptedException, IOException {
        if (n != -1) {
            process.waitFor(n, TimeUnit.MILLISECONDS);
            if (process.isAlive()) {
                try {
                    process.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new InterruptedException("Killed process <" + process.toString() + ">!");
            }
        } else {
            process.waitFor();
        }
        this._result = this.toResult(process);
    }

    public String getResult() {
        return this._result;
    }

    public boolean hasResult() {
        return this._result != null;
    }

    public String toString() {
        return this._result;
    }

    private String toResult(Process process) throws IOException {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string);
                }
            }
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            StringBuilder stringBuilder = new StringBuilder();
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                if (bufferedReader != null) {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        stringBuilder.append(string);
                    }
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stringBuilder.length() != 0) {
                throw new IOException(stringBuilder.toString(), iOException);
            }
            throw iOException;
        }
    }
}

