/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.refcodes.struct.Attribute;
import org.refcodes.struct.AttributeImpl;

public final class ReflectionUtility {
    public static final String ALIAS_SET = "set";
    public static final String ALIAS_GET = "get";
    public static final String ALIAS_HAS = "has";
    public static final String ALIAS_IS = "is";
    public static final String ALIAS_TOSTRING = "toString";
    public static final NonExistingValueClass NON_EXISTING_VALUE = new NonExistingValueClass();

    private ReflectionUtility() {
    }

    public static Set<Annotation> annotations(Class<?> clazz) {
        return ReflectionUtility.annotations(clazz.getAnnotations(), new HashSet<Annotation>());
    }

    public static Set<Annotation> annotations(Field field) {
        return ReflectionUtility.annotations(field.getAnnotations(), new HashSet<Annotation>());
    }

    public static Set<Annotation> annotations(Method method) {
        return ReflectionUtility.annotations(method.getAnnotations(), new HashSet<Annotation>());
    }

    public static Set<Annotation> annotations(Object object) {
        return ReflectionUtility.annotations(object.getClass().getAnnotations(), new HashSet<Annotation>());
    }

    public static Annotation findAnnotation(Class<? extends Annotation> clazz, Class<?> clazz2) {
        return ReflectionUtility.findAnnotation(clazz, clazz2.getAnnotations(), new HashSet<Annotation>());
    }

    public static Annotation findAnnotation(Class<? extends Annotation> clazz, Field field) {
        return ReflectionUtility.findAnnotation(clazz, field.getAnnotations(), new HashSet<Annotation>());
    }

    public static Annotation findAnnotation(Class<? extends Annotation> clazz, Method method) {
        return ReflectionUtility.findAnnotation(clazz, method.getAnnotations(), new HashSet<Annotation>());
    }

    public static Annotation findAnnotation(Class<? extends Annotation> clazz, Object object) {
        return ReflectionUtility.findAnnotation(clazz, object.getClass().getAnnotations(), new HashSet<Annotation>());
    }

    public static boolean hasAnnotation(Class<? extends Annotation> clazz, Class<?> clazz2) {
        return ReflectionUtility.hasAnnotation(clazz, clazz2.getAnnotations(), new HashSet<Annotation>());
    }

    public static boolean hasAnnotation(Class<? extends Annotation> clazz, Field field) {
        return ReflectionUtility.hasAnnotation(clazz, field.getAnnotations(), new HashSet<Annotation>());
    }

    public static boolean hasAnnotation(Class<? extends Annotation> clazz, Method method) {
        return ReflectionUtility.hasAnnotation(clazz, method.getAnnotations(), new HashSet<Annotation>());
    }

    public static boolean hasAnnotation(Class<? extends Annotation> clazz, Object object) {
        return ReflectionUtility.hasAnnotation(clazz, object.getClass().getAnnotations(), new HashSet<Annotation>());
    }

    public static boolean hasGetterAttribute(Object object, String string, Class<?> clazz) {
        Method[] methodArray = object.getClass().getMethods();
        try {
            for (int i = 0; i < methodArray.length; ++i) {
                if (methodArray[i].getParameterTypes().length != 0 || !methodArray[i].getReturnType().equals(clazz)) continue;
                String string2 = methodArray[i].getName();
                if (methodArray[i].getModifiers() != 1 && methodArray[i].getModifiers() != 9 || !(string2.indexOf(ALIAS_GET) == 0 && Character.isUpperCase(string2.charAt(ALIAS_GET.length())) ? string.equalsIgnoreCase(string2 = string2.substring(ALIAS_GET.length(), string2.length())) : (string2.indexOf(ALIAS_HAS) == 0 && Character.isUpperCase(string2.charAt(ALIAS_HAS.length())) ? string.equalsIgnoreCase(string2 = string2.substring(ALIAS_HAS.length(), string2.length())) : (string2.indexOf(ALIAS_IS) == 0 && Character.isUpperCase(string2.charAt(ALIAS_IS.length())) ? string.equalsIgnoreCase(string2 = string2.substring(ALIAS_IS.length(), string2.length())) : string2.indexOf(ALIAS_TOSTRING) == 0 && Character.isUpperCase(string2.charAt(ALIAS_TOSTRING.length())) && string.equalsIgnoreCase(string2 = string2.substring(ALIAS_TOSTRING.length(), string2.length())))))) continue;
                return true;
            }
        }
        catch (Exception exception) {
            System.err.println("ReflectionUtility.setAttribute(): Caught an exception of aClass <" + exception.getClass().getName() + "> with message = " + exception.getMessage() + ".");
            exception.printStackTrace();
        }
        return false;
    }

    public static boolean hasSetterAttribute(Object object, String string, Class<?> clazz) {
        Method[] methodArray = object.getClass().getMethods();
        try {
            for (int i = 0; i < methodArray.length; ++i) {
                if (methodArray[i].getParameterTypes().length != 1 || !methodArray[i].getParameterTypes()[0].isAssignableFrom(clazz) || !methodArray[i].getReturnType().equals(Void.TYPE)) continue;
                String string2 = methodArray[i].getName();
                if (methodArray[i].getModifiers() != 1 && methodArray[i].getModifiers() != 9 || string2.indexOf(ALIAS_SET) != 0 || !Character.isUpperCase(string2.charAt(ALIAS_SET.length())) || !string.equalsIgnoreCase(string2 = string2.substring(ALIAS_SET.length(), string2.length()))) continue;
                return true;
            }
        }
        catch (Exception exception) {
            System.err.println("ReflectionUtility.setAttribute(): Caught an exception of aClass <" + exception.getClass().getName() + "> with message = " + exception.getMessage() + ".");
            exception.printStackTrace();
        }
        return false;
    }

    public static void setAttribute(Object object, Attribute attribute) throws NoSuchMethodException {
        ReflectionUtility.setAttribute(object, (String)attribute.getKey(), attribute.getValue());
    }

    public static void setAttribute(Object object, String string, Object object2) throws NoSuchMethodException {
        boolean bl = false;
        Method[] methodArray = object.getClass().getMethods();
        try {
            for (int i = 0; i < methodArray.length; ++i) {
                if (methodArray[i].getParameterTypes().length != 1 || !methodArray[i].getParameterTypes()[0].isAssignableFrom(object2.getClass()) || !methodArray[i].getReturnType().equals(Void.TYPE)) continue;
                String string2 = methodArray[i].getName();
                if (methodArray[i].getModifiers() != 1 && methodArray[i].getModifiers() != 9 || string2.indexOf(ALIAS_SET) != 0 || !Character.isUpperCase(string2.charAt(ALIAS_SET.length())) || !string.equalsIgnoreCase(string2 = string2.substring(ALIAS_SET.length(), string2.length()))) continue;
                try {
                    methodArray[i].invoke(object, object2);
                    bl = true;
                }
                catch (Exception exception) {
                    System.err.println("ReflectionUtility.setAttribute(): Caught an exception of aClass <" + exception.getClass().getName() + "> while invoking the method <" + string2 + "> with message = " + exception.getMessage() + ".");
                    exception.printStackTrace();
                }
                break;
            }
        }
        catch (Exception exception) {
            System.err.println("ReflectionUtility.setAttribute(): Caught an exception of aClass <" + exception.getClass().getName() + "> with message = " + exception.getMessage() + ".");
            exception.printStackTrace();
        }
        if (!bl) {
            throw new NoSuchMethodException("ReflectionUtility.setAttribute(): The method for the attribute <" + string + "> for the class <" + object.getClass().getName() + "> cannot be found.");
        }
    }

    public static Attribute[] toBeanAttributes(Object object) {
        ArrayList<AttributeImpl> arrayList = new ArrayList<AttributeImpl>();
        Method[] methodArray = object.getClass().getMethods();
        try {
            for (int i = 0; i < methodArray.length; ++i) {
                if (methodArray[i].getParameterTypes().length != 0 || methodArray[i].getReturnType().equals(Void.TYPE)) continue;
                boolean bl = false;
                Object object2 = NON_EXISTING_VALUE;
                String string = methodArray[i].getName();
                if (methodArray[i].getModifiers() != 1 && methodArray[i].getModifiers() != 9) continue;
                if (string.indexOf(ALIAS_GET) == 0 && Character.isUpperCase(string.charAt(ALIAS_GET.length()))) {
                    bl = true;
                    string = string.substring(ALIAS_GET.length(), string.length());
                } else if (string.indexOf(ALIAS_HAS) == 0 && Character.isUpperCase(string.charAt(ALIAS_HAS.length()))) {
                    bl = true;
                    string = string.substring(ALIAS_HAS.length(), string.length());
                } else if (string.indexOf(ALIAS_IS) == 0 && Character.isUpperCase(string.charAt(ALIAS_IS.length()))) {
                    bl = true;
                    string = string.substring(ALIAS_IS.length(), string.length());
                } else if (string.equals(ALIAS_TOSTRING)) {
                    bl = true;
                }
                if (!bl) continue;
                try {
                    object2 = methodArray[i].invoke(object, new Object[0]);
                }
                catch (Exception exception) {
                    System.err.println("ReflectionUtility.setAttribute(): Caught an exception of aClass <" + exception.getClass().getName() + "> while invoking the method <" + string + "> with message = " + exception.getMessage() + ".");
                    exception.printStackTrace();
                }
                arrayList.add(new AttributeImpl(string, object2));
            }
        }
        catch (Exception exception) {
            System.err.println("ReflectionUtility.setAttribute(): Caught an exception of aClass <" + exception.getClass().getName() + "> with message = " + exception.getMessage() + ".");
            exception.printStackTrace();
        }
        return (Attribute[])arrayList.toArray(new AttributeImpl[arrayList.size()]);
    }

    private static Set<Annotation> annotations(Annotation[] annotationArray, Set<Annotation> set) {
        for (Annotation annotation : annotationArray) {
            if (set.contains(annotation)) continue;
            set.add(annotation);
            ReflectionUtility.annotations(annotation.annotationType().getAnnotations(), set);
        }
        return set;
    }

    private static Annotation findAnnotation(Class<? extends Annotation> clazz, Annotation[] annotationArray, Set<Annotation> set) {
        for (Annotation annotation : annotationArray) {
            if (set.contains(annotation)) continue;
            if (clazz.isAssignableFrom(annotation.getClass())) {
                return annotation;
            }
            set.add(annotation);
            Annotation annotation2 = ReflectionUtility.findAnnotation(clazz, annotation.annotationType().getAnnotations(), set);
            if (annotation2 == null) continue;
            return annotation2;
        }
        return null;
    }

    private static boolean hasAnnotation(Class<? extends Annotation> clazz, Annotation[] annotationArray, Set<Annotation> set) {
        for (Annotation annotation : annotationArray) {
            if (set.contains(annotation)) continue;
            if (clazz.isAssignableFrom(annotation.getClass())) {
                return true;
            }
            set.add(annotation);
            if (!ReflectionUtility.hasAnnotation(clazz, annotation.annotationType().getAnnotations(), set)) continue;
            return true;
        }
        return false;
    }

    public static class NonExistingValueClass {
    }
}

