/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.runtime;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.fusesource.jansi.AnsiConsole;
import org.fusesource.jansi.AnsiPrintStream;
import org.refcodes.data.CommandArgPrefix;
import org.refcodes.data.Delimiter;
import org.refcodes.data.EnvironmentVariable;
import org.refcodes.data.ExitCode;
import org.refcodes.data.Folder;
import org.refcodes.data.Literal;
import org.refcodes.data.Scheme;
import org.refcodes.data.SleepLoopTime;
import org.refcodes.data.SystemProperty;
import org.refcodes.exception.ExceptionUtility;
import org.refcodes.runtime.OperatingSystem;
import sun.misc.Signal;

public final class RuntimeUtility {
    public static final String CTRL_C_SIGNAL = "INT";
    private static final String SPACE_PLACEHOLDER = "%20";
    private static final String[] RESERVED_PACKAGE_PREFIXES = new String[]{"sun.", "com.sun.", "java.", "javax."};
    private static String[] MAIN_METHODS = new String[]{"main", "start", "<clinit>", "<init>"};
    private static String[] MAIN_METHOD_PREFIXES = new String[]{"test"};
    private static String[] FRAMEWORK_LAUNCHERS = new String[]{"JarLauncher", "TestRunner", "ForkedBooter"};
    private static Scheme[] JAR_PROTOCOLS = new Scheme[]{Scheme.JAR, Scheme.ZIP, Scheme.SH};
    private static boolean _hasShutdownHandle = false;
    private static Boolean _isUnderTest = null;
    private static Class<?> _mainClass = null;
    private static File _launcherDir = null;
    private static File _currentDir = null;
    private static boolean _isAnsiInstalled = false;

    private RuntimeUtility() {
    }

    public static void setLoggingHandler(Handler handler) {
        LogManager.getLogManager().reset();
        Logger logger = LogManager.getLogManager().getLogger("");
        logger.addHandler(handler);
    }

    public static void setLoggingStreams(final OutputStream outputStream, final OutputStream outputStream2, final Level level) {
        RuntimeUtility.setLoggingHandler(new Handler(){
            PrintWriter _stdWriter;
            PrintWriter _errWriter;
            {
                this._stdWriter = new PrintWriter(outputStream);
                this._errWriter = new PrintWriter(outputStream2);
            }

            @Override
            public void publish(LogRecord logRecord) {
                if (logRecord.getLevel().intValue() >= level.intValue()) {
                    Throwable throwable = logRecord.getThrown();
                    String string = logRecord.getLevel() + ": " + RuntimeUtility.toFormatted(logRecord.getMessage(), logRecord.getParameters());
                    if (throwable != null && throwable.getMessage() != null) {
                        string = string + " (" + throwable.getMessage() + ")";
                    }
                    if (logRecord.getLevel().intValue() > Level.INFO.intValue()) {
                        this._errWriter.println(string);
                        if (throwable != null) {
                            throwable.printStackTrace(this._errWriter);
                        }
                    } else {
                        if (throwable == null) {
                            this._stdWriter.println(string);
                        } else {
                            this._errWriter.println(string);
                        }
                        if (throwable != null) {
                            throwable.printStackTrace(this._errWriter);
                        }
                    }
                }
            }

            @Override
            public void flush() {
                this._stdWriter.flush();
                this._errWriter.flush();
            }

            @Override
            public void close() throws SecurityException {
                this._stdWriter.close();
                this._errWriter.close();
            }
        });
    }

    public static String toFormatted(String string, Object ... objectArray) {
        try {
            return MessageFormat.format(string, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (objectArray == null || objectArray.length == 0) {
                return string;
            }
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = objectArray[i] instanceof String ? "\"" + objectArray[i] + "\"" : (objectArray[i] instanceof Character ? "'" + objectArray[i] + "'" : objectArray[i]);
            }
            String string2 = Arrays.toString(objectArray2);
            if (string2.startsWith("[") && string2.endsWith("]")) {
                string2 = string2.substring(1, string2.length() - 1);
            }
            return string + " (" + string2 + ")";
        }
    }

    public static PrintStream toBootstrapStandardOut() {
        return new PrintStream(new FileOutputStream(FileDescriptor.out));
    }

    public static PrintStream toBootstrapStandardError() {
        return new PrintStream(new FileOutputStream(FileDescriptor.err));
    }

    public static InputStream toBootstrapStandardIn() {
        return new FileInputStream(FileDescriptor.in);
    }

    public static PrintStream toSystemOut() {
        return OperatingSystem.toOperatingSystem() == OperatingSystem.WINDOWS && !RuntimeUtility.isUnderTest() ? RuntimeUtility.toAnsiOut() : System.out;
    }

    public static PrintStream toSystemErr() {
        return OperatingSystem.toOperatingSystem() == OperatingSystem.WINDOWS && !RuntimeUtility.isUnderTest() ? RuntimeUtility.toAnsiErr() : System.err;
    }

    public static boolean isUnderTest() {
        block2: {
            if (_isUnderTest != null) {
                return _isUnderTest;
            }
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            List<StackTraceElement> list = Arrays.asList(stackTraceElementArray);
            for (StackTraceElement stackTraceElement : list) {
                if (!stackTraceElement.getClassName().startsWith("org.junit.") && !stackTraceElement.getClassName().startsWith("org.testng.")) continue;
                _isUnderTest = true;
                break block2;
            }
            _isUnderTest = false;
        }
        return _isUnderTest;
    }

    public static String toStackTrace() {
        StringWriter stringWriter = new StringWriter();
        new Throwable("").printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static StackTraceElement getCallerStackTraceElement() {
        StackTraceElement[] stackTraceElementArray;
        for (StackTraceElement stackTraceElement : stackTraceElementArray = Thread.currentThread().getStackTrace()) {
            if (RuntimeUtility.isSkipStackTraceElement(stackTraceElement)) continue;
            return stackTraceElement;
        }
        return null;
    }

    public static StackTraceElement getCallerStackTraceElement(Class<?> clazz) {
        return RuntimeUtility.getCallerStackTraceElement(clazz.getName());
    }

    public static StackTraceElement getCallerStackTraceElement(StackTraceElement stackTraceElement) {
        return RuntimeUtility.getCallerStackTraceElement(stackTraceElement.getClassName());
    }

    public static StackTraceElement getCallerStackTraceElement(Class<?> ... classArray) {
        StackTraceElement stackTraceElement = null;
        for (Class<?> clazz : classArray) {
            stackTraceElement = RuntimeUtility.getCallerStackTraceElement(clazz);
            if (stackTraceElement == null) continue;
            return stackTraceElement;
        }
        return null;
    }

    public static StackTraceElement getCallerStackTraceElement(StackTraceElement ... stackTraceElementArray) {
        StackTraceElement stackTraceElement = null;
        for (StackTraceElement stackTraceElement2 : stackTraceElementArray) {
            stackTraceElement = RuntimeUtility.getCallerStackTraceElement(stackTraceElement2);
            if (stackTraceElement == null) continue;
            return stackTraceElement;
        }
        return null;
    }

    public static StackTraceElement getCallerStackTraceElement(String ... stringArray) {
        StackTraceElement stackTraceElement = null;
        for (String string : stringArray) {
            stackTraceElement = RuntimeUtility.getCallerStackTraceElement(string);
            if (stackTraceElement == null) continue;
            return stackTraceElement;
        }
        return null;
    }

    public static StackTraceElement getCallerStackTraceElement(String string) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        boolean bl = false;
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            if (bl && !stackTraceElement.getClassName().startsWith(string)) {
                return stackTraceElement;
            }
            if (!stackTraceElement.getClassName().startsWith(string)) continue;
            bl = true;
        }
        return null;
    }

    private static boolean hasReservedPackagePrefix(StackTraceElement stackTraceElement) {
        String string = stackTraceElement.getClassName();
        for (String string2 : RESERVED_PACKAGE_PREFIXES) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static StackTraceElement toBestCallerStackTraceElement(String string) {
        StackTraceElement stackTraceElement;
        StackTraceElement stackTraceElement2 = stackTraceElement = RuntimeUtility.getCallerStackTraceElement(string);
        while (stackTraceElement2 != null && RuntimeUtility.hasReservedPackagePrefix(stackTraceElement2)) {
            stackTraceElement2 = RuntimeUtility.getCallerStackTraceElement(stackTraceElement2);
        }
        return stackTraceElement2 != null ? stackTraceElement2 : stackTraceElement;
    }

    public static StackTraceElement toBestCallerStackTraceElement(StackTraceElement stackTraceElement) {
        return RuntimeUtility.toBestCallerStackTraceElement(stackTraceElement.getClassName());
    }

    public static StackTraceElement toBestCallerStackTraceElement(Class<?> clazz) {
        return RuntimeUtility.toBestCallerStackTraceElement(clazz.getName());
    }

    public static StackTraceElement toBestCallerStackTraceElement(String[] stringArray) {
        for (String string : stringArray) {
            StackTraceElement stackTraceElement = RuntimeUtility.toBestCallerStackTraceElement(string);
            if (stackTraceElement == null) continue;
            return stackTraceElement;
        }
        return null;
    }

    public static StackTraceElement toBestCallerStackTraceElement(StackTraceElement[] stackTraceElementArray) {
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            StackTraceElement stackTraceElement2 = RuntimeUtility.toBestCallerStackTraceElement(stackTraceElement);
            if (stackTraceElement2 == null) continue;
            return stackTraceElement2;
        }
        return null;
    }

    public static StackTraceElement toBestCallerStackTraceElement(Class<?>[] classArray) {
        for (Class<?> clazz : classArray) {
            StackTraceElement stackTraceElement = RuntimeUtility.toBestCallerStackTraceElement(clazz);
            if (stackTraceElement == null) continue;
            return stackTraceElement;
        }
        return null;
    }

    public static Class<?> getCallerType() {
        StackTraceElement stackTraceElement = RuntimeUtility.getCallerStackTraceElement();
        return RuntimeUtility.toClass(stackTraceElement);
    }

    public static Class<?> getCallerType(Class<?> clazz) {
        StackTraceElement stackTraceElement = RuntimeUtility.getCallerStackTraceElement(clazz);
        return RuntimeUtility.toClass(stackTraceElement);
    }

    public static Class<?> getCallerType(Class<?> ... classArray) {
        StackTraceElement stackTraceElement = RuntimeUtility.getCallerStackTraceElement(classArray);
        return RuntimeUtility.toClass(stackTraceElement);
    }

    public static Class<?> getCallerType(StackTraceElement stackTraceElement) {
        StackTraceElement stackTraceElement2 = RuntimeUtility.getCallerStackTraceElement(stackTraceElement);
        return RuntimeUtility.toClass(stackTraceElement2);
    }

    public static Class<?> getCallerType(String ... stringArray) {
        StackTraceElement stackTraceElement = RuntimeUtility.getCallerStackTraceElement(stringArray);
        return RuntimeUtility.toClass(stackTraceElement);
    }

    public static Class<?> getCallerType(String string) {
        StackTraceElement stackTraceElement = RuntimeUtility.getCallerStackTraceElement(string);
        return RuntimeUtility.toClass(stackTraceElement);
    }

    public static Class<?> getCallerType(StackTraceElement ... stackTraceElementArray) {
        StackTraceElement stackTraceElement = RuntimeUtility.getCallerStackTraceElement(stackTraceElementArray);
        return RuntimeUtility.toClass(stackTraceElement);
    }

    public static Class<?> toClass(StackTraceElement stackTraceElement) {
        try {
            return Class.forName(stackTraceElement.getClassName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InternalError(classNotFoundException);
        }
    }

    public static String toMethodName(StackTraceElement stackTraceElement) {
        if (stackTraceElement == null) {
            return null;
        }
        return stackTraceElement.getMethodName();
    }

    public static String toClassName(StackTraceElement stackTraceElement) {
        if (stackTraceElement == null) {
            return null;
        }
        return RuntimeUtility.toClassName(stackTraceElement.getClassName());
    }

    public static String toFullyQualifiedClassName(StackTraceElement stackTraceElement) {
        if (stackTraceElement == null) {
            return null;
        }
        return stackTraceElement.getClassName();
    }

    public static String toFullyQualifiedMethodName(StackTraceElement stackTraceElement) {
        if (stackTraceElement == null) {
            return null;
        }
        return stackTraceElement.getClassName() + Delimiter.METHOD_NAME.getChar() + stackTraceElement.getMethodName();
    }

    public static String toFullyQualifiedClassName() {
        StackTraceElement stackTraceElement = RuntimeUtility.getCallerStackTraceElement();
        return stackTraceElement.getClassName();
    }

    public static String toFullyQualifiedMethodName() {
        StackTraceElement stackTraceElement = RuntimeUtility.getCallerStackTraceElement();
        return stackTraceElement.getClassName() + Delimiter.METHOD_NAME.getChar() + stackTraceElement.getMethodName();
    }

    public static String toMethodName() {
        StackTraceElement stackTraceElement = RuntimeUtility.getCallerStackTraceElement();
        return stackTraceElement.getMethodName();
    }

    public static String toClassName() {
        return RuntimeUtility.toClassName(RuntimeUtility.toFullyQualifiedClassName());
    }

    public static String toFullyQualifiedPackageName() {
        return RuntimeUtility.toFullyQualifiedPackageName(RuntimeUtility.toFullyQualifiedClassName());
    }

    public static String toFullyQualifiedPackageName(StackTraceElement stackTraceElement) {
        return RuntimeUtility.toFullyQualifiedPackageName(RuntimeUtility.toFullyQualifiedClassName(stackTraceElement));
    }

    public static String toClassName(String string) {
        int n = string.lastIndexOf(46);
        String string2 = n != -1 ? string.substring(n + 1) : string;
        int n2 = string2.indexOf(36);
        if (n2 != -1) {
            string2 = string2.substring(n2 + 1);
        }
        return string2;
    }

    public static String toFullyQualifiedPackageName(String string) {
        int n = string.lastIndexOf(46);
        if (n != -1) {
            return string.substring(0, n);
        }
        return "";
    }

    public static <T> T toClone(T t) throws CloneNotSupportedException {
        if (t instanceof Cloneable) {
            try {
                return (T)t.getClass().getMethod("clone", new Class[0]).invoke(t, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                throw new CloneNotSupportedException(ExceptionUtility.toMessage((Throwable)exception));
            }
        }
        throw new CloneNotSupportedException("The type \"" + t.getClass().getName() + "}\" does not implement the \"" + Cloneable.class.getName() + "\" interface.");
    }

    public static String toString(String string, String string2) {
        return string + " (" + string2 + ")";
    }

    public static Long getPid() {
        Long l;
        block4: {
            l = null;
            try {
                l = Long.parseLong(SystemProperty.PROCESS_ID.getValue());
            }
            catch (NumberFormatException numberFormatException) {
                String string = ManagementFactory.getRuntimeMXBean().getName();
                if (string.indexOf(64) == -1) break block4;
                try {
                    l = Long.parseLong(string.substring(0, string.indexOf(64)));
                }
                catch (NumberFormatException numberFormatException2) {
                    // empty catch block
                }
            }
        }
        return l;
    }

    public static Process killProcess(Long l) throws IOException {
        Process process = null;
        switch (OperatingSystem.toOperatingSystem()) {
            case WINDOWS: {
                String string = "taskkill /F /PID " + l;
                process = Runtime.getRuntime().exec(string);
                break;
            }
            case UNIX: {
                String string = "kill -9 " + l;
                process = Runtime.getRuntime().exec(string);
                break;
            }
        }
        return process;
    }

    public static boolean kill(Long l) throws IOException, InterruptedException {
        Process process = RuntimeUtility.killProcess(l);
        if (process != null) {
            process.waitFor();
            return process.exitValue() == 0;
        }
        return false;
    }

    public static File toUserWorkingDir() {
        String string;
        if (_currentDir == null && (string = SystemProperty.USER_DIR.getValue()) != null && string.length() != 0) {
            File file = new File(string);
            if (file.exists() && file.isDirectory()) {
                _currentDir = file;
            } else {
                string = EnvironmentVariable.USER_DIR.getValue();
                if (string != null && string.length() != 0 && (file = new File(string)).exists() && file.isDirectory()) {
                    _currentDir = file;
                }
            }
        }
        return _currentDir;
    }

    public static File toLauncherDir() {
        if (_launcherDir == null) {
            Scheme scheme;
            String string;
            Object object;
            Class<RuntimeUtility> clazz;
            String string2 = SystemProperty.LAUNCHER_DIR.getValue();
            if (string2 != null && string2.length() != 0 && ((File)((Object)(clazz = new File(string2)))).exists() && ((File)((Object)clazz)).isDirectory()) {
                return clazz;
            }
            clazz = RuntimeUtility.getMainClass();
            if (clazz == null) {
                clazz = RuntimeUtility.class;
            }
            if (((String)(object = clazz.getProtectionDomain().getCodeSource().getLocation().getPath())).startsWith(Scheme.FILE.toProtocol())) {
                object = ((String)object).substring(Scheme.FILE.toProtocol().length());
            }
            try {
                String string3 = clazz.getCanonicalName();
                string = string3.replace('.', '/');
            }
            catch (Exception exception) {
                return null;
            }
            string = string.substring(0, string.indexOf(clazz.getSimpleName()));
            int n = ((String)object).indexOf(string);
            if (n > 0) {
                object = ((String)object).substring(0, n);
            }
            if (((String)object).endsWith("" + Delimiter.PATH.getChar())) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            if (((String)object).endsWith(Folder.CLASSES.getName())) {
                object = ((String)object).substring(0, ((String)object).indexOf(Folder.CLASSES.getName()));
            }
            int n2 = -1;
            Scheme[] schemeArray = JAR_PROTOCOLS;
            int n3 = schemeArray.length;
            for (int i = 0; i < n3 && (n2 = (scheme = schemeArray[i]).firstMarkerIndex(((String)object).toLowerCase())) == -1; ++i) {
            }
            if (n2 != -1 && (n2 = ((String)(object = ((String)object).substring(0, n2))).lastIndexOf(Delimiter.PATH.getChar())) != -1) {
                object = ((String)object).substring(0, n2);
            }
            if (!((String)object).endsWith("" + Delimiter.PATH.getChar())) {
                object = (String)object + Delimiter.PATH.getChar();
            }
            _launcherDir = new File((String)object);
            if (!((String)object).endsWith(Folder.TARGET.getName() + Delimiter.PATH.getChar())) {
                _launcherDir = _launcherDir.getParentFile();
            }
            if (!_launcherDir.exists() && ((String)object).contains(SPACE_PLACEHOLDER)) {
                object = ((String)object).replaceAll(Matcher.quoteReplacement(SPACE_PLACEHOLDER), " ");
                _launcherDir = new File((String)object);
                if (!((String)object).endsWith(Folder.TARGET.getName() + Delimiter.PATH.getChar())) {
                    _launcherDir = _launcherDir.getParentFile();
                }
            }
        }
        return _launcherDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Class getMainClass() {
        if (_mainClass != null) return _mainClass;
        Class<RuntimeUtility> clazz = RuntimeUtility.class;
        synchronized (RuntimeUtility.class) {
            Class<?> clazz2;
            StackTraceElement stackTraceElement;
            int n;
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            ArrayList<StackTraceElement> arrayList = new ArrayList<StackTraceElement>();
            for (n = 0; n < stackTraceElementArray.length; ++n) {
                stackTraceElement = stackTraceElementArray[n];
                if (!RuntimeUtility.hasTestAnnotation(stackTraceElement)) continue;
                arrayList.add(stackTraceElement);
            }
            for (n = stackTraceElementArray.length - 1; n > 0; --n) {
                stackTraceElement = stackTraceElementArray[n];
                for (String string : MAIN_METHODS) {
                    if (!stackTraceElement.getMethodName().equals(string)) continue;
                    arrayList.add(stackTraceElement);
                }
                for (String string : MAIN_METHOD_PREFIXES) {
                    if (!stackTraceElement.getMethodName().startsWith(string)) continue;
                    arrayList.add(stackTraceElement);
                }
            }
            block11: for (StackTraceElement stackTraceElement2 : arrayList) {
                for (String string : FRAMEWORK_LAUNCHERS) {
                    if (stackTraceElement2.getClassName().toLowerCase().contains(string.toLowerCase())) continue block11;
                }
                try {
                    clazz2 = Class.forName(stackTraceElement2.getClassName());
                    if (clazz2.getProtectionDomain().getCodeSource() == null) continue;
                    _mainClass = clazz2;
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return _mainClass;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            for (StackTraceElement stackTraceElement3 : arrayList) {
                try {
                    clazz2 = Class.forName(stackTraceElement3.getClassName());
                    if (clazz2.getProtectionDomain().getCodeSource() == null) continue;
                    _mainClass = clazz2;
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return _mainClass;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return _mainClass;
        }
    }

    private static boolean hasTestAnnotation(StackTraceElement stackTraceElement) {
        try {
            Method[] methodArray;
            Class<?> clazz = Class.forName(stackTraceElement.getClassName());
            String string = stackTraceElement.getMethodName();
            for (Method method : methodArray = clazz.getMethods()) {
                Annotation[] annotationArray;
                if (!method.getName().equals(string)) continue;
                for (Annotation annotation : annotationArray = method.getDeclaredAnnotations()) {
                    String string2 = annotation.annotationType().getSimpleName();
                    if (!string2.equals("Test")) continue;
                    return true;
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static Map<String, String> toProperties(String[] stringArray) {
        return RuntimeUtility.toProperties(stringArray, CommandArgPrefix.toPrefixes(), Delimiter.INDEX.getChar());
    }

    public static Map<String, String> toProperties(String[] stringArray, String[] stringArray2, char c) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            String string3 = RuntimeUtility.toOption(string2, stringArray2);
            if (string != null) {
                if (string3 == null) {
                    RuntimeUtility.putProperty(hashMap, string, string2, c);
                    string = null;
                    continue;
                }
                RuntimeUtility.putProperty(hashMap, string, Literal.TRUE.getValue(), c);
                string = string3;
                if (i != stringArray.length - 1) continue;
                RuntimeUtility.putProperty(hashMap, string, Literal.TRUE.getValue(), c);
                continue;
            }
            if (string3 != null) {
                string = string3;
                if (i != stringArray.length - 1) continue;
                RuntimeUtility.putProperty(hashMap, string, Literal.TRUE.getValue(), c);
                continue;
            }
            RuntimeUtility.putProperty(hashMap, null, string2, c);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addShutdownHook(Thread thread) {
        Runtime.getRuntime().addShutdownHook(thread);
        if (_hasShutdownHandle || !"runtime".equalsIgnoreCase(SystemProperty.GRAALVM_IMAGE_CODE_KEY.getValue())) return;
        Class<RuntimeUtility> clazz = RuntimeUtility.class;
        synchronized (RuntimeUtility.class) {
            if (_hasShutdownHandle) return;
            _hasShutdownHandle = true;
            Signal.handle(new Signal(CTRL_C_SIGNAL), signal -> System.exit(ExitCode.CONTROL_C.getStatusCode()));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void addShutdownHook(Runnable runnable) {
        Runtime.getRuntime().addShutdownHook(new Thread(runnable));
        if (_hasShutdownHandle || !"runtime".equalsIgnoreCase(SystemProperty.GRAALVM_IMAGE_CODE_KEY.getValue())) return;
        Class<RuntimeUtility> clazz = RuntimeUtility.class;
        synchronized (RuntimeUtility.class) {
            if (_hasShutdownHandle) return;
            _hasShutdownHandle = true;
            Signal.handle(new Signal(CTRL_C_SIGNAL), signal -> System.exit(ExitCode.CONTROL_C.getStatusCode()));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected static void putProperty(Map<String, String> map, String string, String string2, char c) {
        if (map.containsKey(string)) {
            String string3 = RuntimeUtility.toNextKey(map, string, c);
            map.put(string3, map.remove(string));
            string3 = RuntimeUtility.toNextKey(map, string, c);
            map.put(string3, string2);
        } else if (map.containsKey(string + c + "0")) {
            String string4 = RuntimeUtility.toNextKey(map, string, c);
            map.put(string4, string2);
        } else {
            map.put(string, string2);
        }
    }

    protected static String toNextKey(Map<String, String> map, String string, char c) {
        if (map.containsKey(string) || map.containsKey(string + c + "0")) {
            int n = 0;
            String string2 = string + c + n;
            while (map.containsKey(string2)) {
                string2 = string + c + ++n;
            }
            return string2;
        }
        return null;
    }

    protected static String toOption(String string, String ... stringArray) {
        Arrays.sort(stringArray, Collections.reverseOrder());
        for (String string2 : stringArray) {
            if (!string.startsWith(string2)) continue;
            return string.substring(string2.length());
        }
        return null;
    }

    @SafeVarargs
    protected static boolean containsDir(File file, List<File> ... listArray) {
        for (List<File> list : listArray) {
            if (!list.contains(file)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSkipStackTraceElement(StackTraceElement stackTraceElement) {
        return stackTraceElement.getClassName().equals(Thread.class.getName()) || stackTraceElement.getClassName().equals(RuntimeUtility.class.getName()) || stackTraceElement.getLineNumber() <= 1;
    }

    private static AnsiPrintStream toAnsiOut() {
        RuntimeUtility.doInstallAnsi();
        return AnsiConsole.out();
    }

    private static AnsiPrintStream toAnsiErr() {
        RuntimeUtility.doInstallAnsi();
        return AnsiConsole.err();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void doInstallAnsi() {
        if (_isAnsiInstalled) return;
        Class<RuntimeUtility> clazz = RuntimeUtility.class;
        synchronized (RuntimeUtility.class) {
            if (_isAnsiInstalled) return;
            AnsiConsole.systemInstall();
            try {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RuntimeUtility.doUninstallAnsi();
                        }
                        catch (Error | Exception throwable) {
                            // empty catch block
                        }
                    }
                });
                thread.setDaemon(true);
                RuntimeUtility.addShutdownHook(thread);
            }
            catch (Exception exception) {
                // empty catch block
            }
            _isAnsiInstalled = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static void doUninstallAnsi() {
        try {
            Thread.sleep(SleepLoopTime.MIN.getTimeInMs());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        RuntimeUtility.toSystemOut().flush();
        RuntimeUtility.toSystemErr().flush();
        AnsiConsole.systemUninstall();
    }
}

