/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct;

import java.util.Collection;
import org.refcodes.data.BooleanLiterals;
import org.refcodes.data.Literal;
import org.refcodes.mixin.AliasAccessor;
import org.refcodes.struct.PathMap;
import org.refcodes.struct.Relation;

public interface InterOperableMap<T>
extends PathMap<T> {
    default public Boolean getBoolean(Object ... objectArray) throws NumberFormatException {
        return this.getBoolean(this.toPath(objectArray));
    }

    default public Boolean getBoolean(Collection<?> collection) throws NumberFormatException {
        return this.getBoolean(this.toPath(collection));
    }

    default public Boolean getBoolean(Object object) throws NumberFormatException {
        return this.getBoolean(InterOperableMap.asKey(object));
    }

    default public Boolean getBoolean(String ... stringArray) throws NumberFormatException {
        return this.getBoolean(this.toPath(stringArray));
    }

    default public Boolean getBoolean(String string) throws NumberFormatException {
        Object v = this.get((Object)string);
        if (v == null) {
            return false;
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v instanceof String) {
            for (String string2 : BooleanLiterals.TRUE.getNames()) {
                if (!string2.equalsIgnoreCase((String)v)) continue;
                return true;
            }
            for (String string2 : BooleanLiterals.FALSE.getNames()) {
                if (!string2.equalsIgnoreCase((String)v)) continue;
                return false;
            }
        }
        throw new NumberFormatException("Unable to parse a boolean from the value <" + v + "> of type <" + v.getClass().getName() + ">!");
    }

    default public Boolean getBooleanOr(Object object, Boolean bl) throws NumberFormatException {
        Boolean bl2 = this.getBoolean(object);
        if (bl2 == null) {
            return bl;
        }
        return bl2;
    }

    default public Boolean getBooleanOr(Object[] objectArray, Boolean bl) throws NumberFormatException {
        return this.getBooleanOr(this.toPath(objectArray), bl);
    }

    default public Boolean getBooleanOr(Collection<?> collection, Boolean bl) throws NumberFormatException {
        return this.getBooleanOr(this.toPath(collection), bl);
    }

    default public Boolean getBooleanOr(String string, Boolean bl) throws NumberFormatException {
        Boolean bl2 = this.getBoolean(string);
        if (bl2 == null) {
            return bl;
        }
        return bl2;
    }

    default public Boolean getBooleanOr(String[] stringArray, Boolean bl) throws NumberFormatException {
        return this.getBooleanOr(this.toPath(stringArray), bl);
    }

    default public Byte getByte(Object ... objectArray) throws NumberFormatException {
        return this.getByte(this.toPath(objectArray));
    }

    default public Byte getByte(Collection<?> collection) throws NumberFormatException {
        return this.getByte(this.toPath(collection));
    }

    default public Byte getByte(Object object) throws NumberFormatException {
        return this.getByte(InterOperableMap.asKey(object));
    }

    default public Byte getByte(String ... stringArray) throws NumberFormatException {
        return this.getByte(this.toPath(stringArray));
    }

    default public Byte getByte(String string) throws NumberFormatException {
        Object v = this.get((Object)string);
        if (v == null) {
            return null;
        }
        if (v instanceof Byte) {
            return (Byte)v;
        }
        if (v instanceof String) {
            String string2 = (String)v;
            if (string2.endsWith(".0")) {
                string2 = string2.substring(0, string2.length() - 2);
            }
            return Byte.valueOf(string2);
        }
        throw new NumberFormatException("Unable to parse a byte from the value <" + v + "> of type <" + v.getClass().getName() + ">!");
    }

    default public Byte getByteOr(Object object, Byte by) throws NumberFormatException {
        Byte by2 = this.getByte(object);
        if (by2 == null) {
            return by;
        }
        return by2;
    }

    default public Byte getByteOr(Object[] objectArray, Byte by) throws NumberFormatException {
        return this.getByteOr(this.toPath(objectArray), by);
    }

    default public Byte getByteOr(Collection<?> collection, Byte by) throws NumberFormatException {
        return this.getByteOr(this.toPath(collection), by);
    }

    default public Byte getByteOr(String string, Byte by) throws NumberFormatException {
        Byte by2 = this.getByte(string);
        if (by2 == null) {
            return by;
        }
        return by2;
    }

    default public Byte getByteOr(String[] stringArray, Byte by) throws NumberFormatException {
        return this.getByteOr(this.toPath(stringArray), by);
    }

    default public Character getChar(Object object) throws NumberFormatException {
        return this.getChar(InterOperableMap.asKey(object));
    }

    default public Character getChar(String string) throws NumberFormatException {
        String string2;
        Object v = this.get((Object)string);
        if (v == null) {
            return null;
        }
        if (v instanceof Character) {
            return (Character)v;
        }
        if (v instanceof String && (string2 = (String)v).length() == 1) {
            return Character.valueOf(string2.charAt(0));
        }
        throw new NumberFormatException("Unable to convert a character from the value <" + v + "> of type <" + v.getClass().getName() + ">!");
    }

    default public Character getChar(String ... stringArray) throws NumberFormatException {
        return this.getChar(this.toPath(stringArray));
    }

    default public Character getChar(Object ... objectArray) throws NumberFormatException {
        return this.getChar(this.toPath(objectArray));
    }

    default public Character getChar(Collection<?> collection) throws NumberFormatException {
        return this.getChar(this.toPath(collection));
    }

    default public Character getCharOr(Object object, Character c) throws NumberFormatException {
        Character c2 = this.getChar(object);
        if (c2 == null) {
            return c;
        }
        return c2;
    }

    default public Character getCharOr(Object[] objectArray, Character c) throws NumberFormatException {
        return this.getCharOr(this.toPath(objectArray), c);
    }

    default public Character getCharOr(Collection<?> collection, Character c) throws NumberFormatException {
        return this.getCharOr(this.toPath(collection), c);
    }

    default public Character getCharOr(String string, Character c) throws NumberFormatException {
        Character c2 = this.getChar(string);
        if (c2 == null) {
            return c;
        }
        return c2;
    }

    default public Character getCharOr(String[] stringArray, Character c) throws NumberFormatException {
        return this.getCharOr(this.toPath(stringArray), c);
    }

    default public <C> Class<C> getClass(Object ... objectArray) throws NumberFormatException {
        return this.getClass(this.toPath(objectArray));
    }

    default public <C> Class<C> getClass(Collection<?> collection) throws NumberFormatException {
        return this.getClass(this.toPath(collection));
    }

    default public <C> Class<C> getClass(Object object) throws NumberFormatException {
        return this.getClass(InterOperableMap.asKey(object));
    }

    default public <C> Class<C> getClass(String ... stringArray) throws NumberFormatException {
        return this.getClass(this.toPath(stringArray));
    }

    default public <C> Class<C> getClass(String string) throws NumberFormatException {
        Object v = this.get((Object)string);
        if (v == null) {
            return null;
        }
        if (v instanceof Class) {
            try {
                return (Class)v;
            }
            catch (ClassCastException classCastException) {
                throw new NumberFormatException("Unable to parse a class from the value <" + v + "> of type <" + v.getClass().getName() + ">: " + classCastException.getMessage());
            }
        }
        if (v instanceof String) {
            String string2 = (String)v;
            try {
                return Class.forName(string2);
            }
            catch (Exception exception) {
                throw new NumberFormatException("Unable to parse a class from the value <" + v + "> of type <" + v.getClass().getName() + ">: " + exception.getMessage());
            }
        }
        throw new NumberFormatException("Unable to parse a class from the value <" + v + "> of type <" + v.getClass().getName() + ">!");
    }

    default public <C> Class<C> getClassOr(Object object, Class<C> clazz) throws NumberFormatException {
        Class<C> clazz2 = this.getClass(object);
        if (clazz2 == null) {
            return clazz;
        }
        return clazz2;
    }

    default public <C> Class<C> getClassOr(Object[] objectArray, Class<C> clazz) throws NumberFormatException {
        return this.getClassOr(this.toPath(objectArray), clazz);
    }

    default public <C> Class<C> getClassOr(Collection<?> collection, Class<C> clazz) throws NumberFormatException {
        return this.getClassOr(this.toPath(collection), clazz);
    }

    default public <C> Class<C> getClassOr(String string, Class<C> clazz) throws NumberFormatException {
        Class<C> clazz2 = this.getClass(string);
        if (clazz2 == null) {
            return clazz;
        }
        return clazz2;
    }

    default public <C> Class<C> getClassOr(String[] stringArray, Class<C> clazz) throws NumberFormatException {
        return this.getClassOr(this.toPath(stringArray), clazz);
    }

    default public Double getDouble(Object ... objectArray) throws NumberFormatException {
        return this.getDouble(this.toPath(objectArray));
    }

    default public Double getDouble(Collection<?> collection) throws NumberFormatException {
        return this.getDouble(this.toPath(collection));
    }

    default public Double getDouble(Object object) throws NumberFormatException {
        return this.getDouble(InterOperableMap.asKey(object));
    }

    default public Double getDouble(String ... stringArray) throws NumberFormatException {
        return this.getDouble(this.toPath(stringArray));
    }

    default public Double getDouble(String string) throws NumberFormatException {
        Object v = this.get((Object)string);
        if (v == null) {
            return null;
        }
        if (v instanceof Double) {
            return (Double)v;
        }
        if (v instanceof String) {
            return Double.valueOf((String)v);
        }
        throw new NumberFormatException("Unable to convert a double from the value <" + v + "> of type <" + v.getClass().getName() + ">!");
    }

    default public Double getDoubleOr(Object object, Double d) throws NumberFormatException {
        Double d2 = this.getDouble(object);
        if (d2 == null) {
            return d;
        }
        return d2;
    }

    default public Double getDoubleOr(Object[] objectArray, Double d) throws NumberFormatException {
        return this.getDoubleOr(this.toPath(objectArray), d);
    }

    default public Double getDoubleOr(Collection<?> collection, Double d) throws NumberFormatException {
        return this.getDoubleOr(this.toPath(collection), d);
    }

    default public Double getDoubleOr(String string, Double d) throws NumberFormatException {
        Double d2 = this.getDouble(string);
        if (d2 == null) {
            return d;
        }
        return d2;
    }

    default public Double getDoubleOr(String[] stringArray, Double d) throws NumberFormatException {
        return this.getDoubleOr(this.toPath(stringArray), d);
    }

    default public <E extends Enum<E>> E getEnum(Class<E> clazz, Object object) throws NumberFormatException {
        return this.getEnum(clazz, InterOperableMap.asKey(object));
    }

    default public <E extends Enum<E>> E getEnum(Class<E> clazz, String string) throws NumberFormatException {
        Object v = this.get((Object)string);
        if (v == null) {
            return null;
        }
        if (v instanceof String) {
            Enum[] enumArray;
            for (Enum enum_ : enumArray = (Enum[])clazz.getEnumConstants()) {
                if (!enum_.name().equals(v)) continue;
                return (E)enum_;
            }
        }
        if (v instanceof Enum) {
            try {
                return (E)((Enum)v);
            }
            catch (Exception exception) {
                throw new NumberFormatException("Unable to convert a enumeration from the value <" + v + "> of type <" + v.getClass().getName() + "> to enum type <\" + aEnumType.getName() + \">:" + exception.getMessage());
            }
        }
        throw new NumberFormatException("Unable to convert a enumeration from the value <" + v + "> of type <" + v.getClass().getName() + "> to enum type <" + clazz.getName() + ">!");
    }

    default public <E extends Enum<E>> E getEnum(Class<E> clazz, String ... stringArray) throws NumberFormatException {
        return this.getEnum(clazz, this.toPath(stringArray));
    }

    default public <E extends Enum<E>> E getEnum(Class<E> clazz, Object ... objectArray) throws NumberFormatException {
        return this.getEnum(clazz, this.toPath(objectArray));
    }

    default public <E extends Enum<E>> E getEnum(Class<E> clazz, Collection<?> collection) throws NumberFormatException {
        return this.getEnum(clazz, this.toPath(collection));
    }

    default public <E extends Enum<E>> E getEnumOr(Class<E> clazz, Object object, E e) throws NumberFormatException {
        E e2 = this.getEnum(clazz, object);
        if (e2 == null) {
            return e;
        }
        return e2;
    }

    default public <E extends Enum<E>> E getEnumOr(Class<E> clazz, Object[] objectArray, E e) throws NumberFormatException {
        return this.getEnumOr(clazz, this.toPath(objectArray), e);
    }

    default public <E extends Enum<E>> E getEnumOr(Class<E> clazz, Collection<?> collection, E e) throws NumberFormatException {
        return this.getEnumOr(clazz, this.toPath(collection), e);
    }

    default public <E extends Enum<E>> E getEnumOr(Class<E> clazz, String string, E e) throws NumberFormatException {
        E e2 = this.getEnum(clazz, string);
        if (e2 == null) {
            return e;
        }
        return e2;
    }

    default public <E extends Enum<E>> E getEnumOr(Class<E> clazz, String[] stringArray, E e) throws NumberFormatException {
        return this.getEnumOr(clazz, this.toPath(stringArray), e);
    }

    default public <E extends Enum<E>> E getEnumOr(Object object, E e) throws NumberFormatException {
        Object obj = this.getEnum((Class<E>)e.getClass(), object);
        if (obj == null) {
            return e;
        }
        return (E)obj;
    }

    default public <E extends Enum<E>> E getEnumOr(Object[] objectArray, E e) throws NumberFormatException {
        return this.getEnumOr(this.toPath(objectArray), e);
    }

    default public <E extends Enum<E>> E getEnumOr(Collection<?> collection, E e) throws NumberFormatException {
        return this.getEnumOr(this.toPath(collection), e);
    }

    default public <E extends Enum<E>> E getEnumOr(String string, E e) throws NumberFormatException {
        Object obj = this.getEnum((Class<E>)e.getClass(), string);
        if (obj == null) {
            return e;
        }
        return (E)obj;
    }

    default public <E extends Enum<E>> E getEnumOr(String[] stringArray, E e) throws NumberFormatException {
        return this.getEnumOr(this.toPath(stringArray), e);
    }

    default public Float getFloat(Object ... objectArray) throws NumberFormatException {
        return this.getFloat(this.toPath(objectArray));
    }

    default public Float getFloat(Collection<?> collection) throws NumberFormatException {
        return this.getFloat(this.toPath(collection));
    }

    default public Float getFloat(Object object) throws NumberFormatException {
        return this.getFloat(InterOperableMap.asKey(object));
    }

    default public Float getFloat(String ... stringArray) throws NumberFormatException {
        return this.getFloat(this.toPath(stringArray));
    }

    default public Float getFloat(String string) throws NumberFormatException {
        Object v = this.get((Object)string);
        if (v == null) {
            return null;
        }
        if (v instanceof Float) {
            return (Float)v;
        }
        if (v instanceof String) {
            return Float.valueOf((String)v);
        }
        throw new NumberFormatException("Unable to convert a float from the value <" + v + "> of type <" + v.getClass().getName() + ">!");
    }

    default public Float getFloatOr(Object object, Float f) throws NumberFormatException {
        Float f2 = this.getFloat(object);
        if (f2 == null) {
            return f;
        }
        return f2;
    }

    default public Float getFloatOr(Object[] objectArray, Float f) throws NumberFormatException {
        return this.getFloatOr(this.toPath(objectArray), f);
    }

    default public Float getFloatOr(Collection<?> collection, Float f) throws NumberFormatException {
        return this.getFloatOr(this.toPath(collection), f);
    }

    default public Float getFloatOr(String string, Float f) throws NumberFormatException {
        Float f2 = this.getFloat(string);
        if (f2 == null) {
            return f;
        }
        return f2;
    }

    default public Float getFloatOr(String[] stringArray, Float f) throws NumberFormatException {
        return this.getFloatOr(this.toPath(stringArray), f);
    }

    default public Integer getInt(Object ... objectArray) throws NumberFormatException {
        return this.getInt(this.toPath(objectArray));
    }

    default public Integer getInt(Collection<?> collection) throws NumberFormatException {
        return this.getInt(this.toPath(collection));
    }

    default public Integer getInt(Object object) throws NumberFormatException {
        return this.getInt(InterOperableMap.asKey(object));
    }

    default public Integer getInt(String ... stringArray) throws NumberFormatException {
        return this.getInt(this.toPath(stringArray));
    }

    default public Integer getInt(String string) throws NumberFormatException {
        Object v = this.get((Object)string);
        if (v == null) {
            return null;
        }
        if (v instanceof Integer) {
            return (Integer)v;
        }
        if (v instanceof String) {
            String string2 = (String)v;
            if (string2.endsWith(".0")) {
                string2 = string2.substring(0, string2.length() - 2);
            }
            return Integer.valueOf(string2);
        }
        throw new NumberFormatException("Unable to convert an Integer from the value <" + v + "> of type <" + v.getClass().getName() + ">!");
    }

    default public Integer getIntOr(Object object, Integer n) throws NumberFormatException {
        Integer n2 = this.getInt(object);
        if (n2 == null) {
            return n;
        }
        return n2;
    }

    default public Integer getIntOr(Object[] objectArray, Integer n) throws NumberFormatException {
        return this.getIntOr(this.toPath(objectArray), n);
    }

    default public Integer getIntOr(Collection<?> collection, Integer n) throws NumberFormatException {
        return this.getIntOr(this.toPath(collection), n);
    }

    default public Integer getIntOr(String string, Integer n) throws NumberFormatException {
        Integer n2 = this.getInt(string);
        if (n2 == null) {
            return n;
        }
        return n2;
    }

    default public Integer getIntOr(String[] stringArray, Integer n) throws NumberFormatException {
        return this.getIntOr(this.toPath(stringArray), n);
    }

    default public Long getLong(Object ... objectArray) throws NumberFormatException {
        return this.getLong(this.toPath(objectArray));
    }

    default public Long getLong(Collection<?> collection) throws NumberFormatException {
        return this.getLong(this.toPath(collection));
    }

    default public Long getLong(Object object) throws NumberFormatException {
        return this.getLong(InterOperableMap.asKey(object));
    }

    default public Long getLong(String ... stringArray) throws NumberFormatException {
        return this.getLong(this.toPath(stringArray));
    }

    default public Long getLong(String string) throws NumberFormatException {
        Object v = this.get((Object)string);
        if (v == null) {
            return null;
        }
        if (v instanceof Long) {
            return (Long)v;
        }
        if (v instanceof String) {
            String string2 = (String)v;
            if (string2.endsWith(".0")) {
                string2 = string2.substring(0, string2.length() - 2);
            }
            return Long.valueOf(string2);
        }
        throw new NumberFormatException("Unable to convert an Long from the value <" + v + "> of type <" + v.getClass().getName() + ">!");
    }

    default public Long getLongOr(Object object, Long l) throws NumberFormatException {
        Long l2 = this.getLong(object);
        if (l2 == null) {
            return l;
        }
        return l2;
    }

    default public Long getLongOr(Object[] objectArray, Long l) throws NumberFormatException {
        return this.getLongOr(this.toPath(objectArray), l);
    }

    default public Long getLongOr(Collection<?> collection, Long l) throws NumberFormatException {
        return this.getLongOr(this.toPath(collection), l);
    }

    default public Long getLongOr(String string, Long l) throws NumberFormatException {
        Long l2 = this.getLong(string);
        if (l2 == null) {
            return l;
        }
        return l2;
    }

    default public Long getLongOr(String[] stringArray, Long l) throws NumberFormatException {
        return this.getLongOr(this.toPath(stringArray), l);
    }

    default public Short getShort(Object ... objectArray) throws NumberFormatException {
        return this.getShort(this.toPath(objectArray));
    }

    default public Short getShort(Collection<?> collection) throws NumberFormatException {
        return this.getShort(this.toPath(collection));
    }

    default public Short getShort(Object object) throws NumberFormatException {
        return this.getShort(InterOperableMap.asKey(object));
    }

    default public Short getShort(String ... stringArray) throws NumberFormatException {
        return this.getShort(this.toPath(stringArray));
    }

    default public Short getShort(String string) throws NumberFormatException {
        Object v = this.get((Object)string);
        if (v == null) {
            return null;
        }
        if (v instanceof Short) {
            return (Short)v;
        }
        if (v instanceof String) {
            String string2 = (String)v;
            if (string2.endsWith(".0")) {
                string2 = string2.substring(0, string2.length() - 2);
            }
            return Short.valueOf(string2);
        }
        throw new NumberFormatException("Unable to convert an Short from the value <" + v + "> of type <" + v.getClass().getName() + ">!");
    }

    default public Short getShortOr(Object object, Short s) throws NumberFormatException {
        Short s2 = this.getShort(object);
        if (s2 == null) {
            return s;
        }
        return s2;
    }

    default public Short getShortOr(Object[] objectArray, Short s) throws NumberFormatException {
        return this.getShortOr(this.toPath(objectArray), s);
    }

    default public Short getShortOr(Collection<?> collection, Short s) throws NumberFormatException {
        return this.getShortOr(this.toPath(collection), s);
    }

    default public Short getShortOr(String string, Short s) throws NumberFormatException {
        Short s2 = this.getShort(string);
        if (s2 == null) {
            return s;
        }
        return s2;
    }

    default public Short getShortOr(String[] stringArray, Short s) throws NumberFormatException {
        return this.getShortOr(this.toPath(stringArray), s);
    }

    default public String getString(Object ... objectArray) throws NumberFormatException {
        return this.getString(this.toPath(objectArray));
    }

    default public String getString(Collection<?> collection) throws NumberFormatException {
        return this.getString(this.toPath(collection));
    }

    default public String getString(Object object) throws NumberFormatException {
        return this.getString(InterOperableMap.asKey(object));
    }

    default public String getString(String ... stringArray) throws NumberFormatException {
        return this.getString(this.toPath(stringArray));
    }

    default public String getString(String string) throws NumberFormatException {
        Object v = this.get((Object)string);
        if (v == null) {
            return null;
        }
        if (v instanceof String) {
            return (String)v;
        }
        throw new NumberFormatException("Unable to convert an String from the value <" + v + "> of type <" + v.getClass().getName() + ">!");
    }

    default public String getStringOr(Object object, String string) throws NumberFormatException {
        String string2 = this.getString(object);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    default public String getStringOr(Object[] objectArray, String string) throws NumberFormatException {
        return this.getStringOr(this.toPath(objectArray), string);
    }

    default public String getStringOr(Collection<?> collection, String string) throws NumberFormatException {
        return this.getStringOr(this.toPath(collection), string);
    }

    default public String getStringOr(String string, String string2) throws NumberFormatException {
        String string3 = this.getString(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    default public String getStringOr(String[] stringArray, String string) throws NumberFormatException {
        return this.getStringOr(this.toPath(stringArray), string);
    }

    private static String asKey(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof AliasAccessor && ((AliasAccessor)object).getAlias() != null) {
            return ((AliasAccessor)object).getAlias();
        }
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public static interface MutableInterOperableMap<T>
    extends PathMap.MutablePathMap<T> {
        @Override
        default public boolean containsValue(Object object) {
            return this.values().contains(object);
        }

        @Override
        default public void insert(InterOperableMapBuilder<T> interOperableMapBuilder) {
            this.insert((Object)interOperableMapBuilder);
        }

        @Override
        default public void insertBetween(String string, InterOperableMapBuilder<T> interOperableMapBuilder, String string2) {
            this.insertBetween(string, (Object)interOperableMapBuilder, string2);
        }

        @Override
        default public void insertFrom(InterOperableMapBuilder<T> interOperableMapBuilder, String string) {
            this.insertFrom((Object)interOperableMapBuilder, string);
        }

        @Override
        default public void insertTo(String string, InterOperableMapBuilder<T> interOperableMapBuilder) {
            this.insertTo(string, (Object)interOperableMapBuilder);
        }

        default public T putBoolean(Object object, Boolean bl) {
            return this.putBoolean(InterOperableMap.asKey(object), bl);
        }

        default public T putBoolean(Object[] objectArray, Boolean bl) {
            return this.putBoolean(this.toPath(objectArray), bl);
        }

        default public T putBoolean(Collection<?> collection, Boolean bl) {
            return this.putBoolean(this.toPath(collection), bl);
        }

        default public T putBoolean(String string, Boolean bl) {
            if (bl == null) {
                return (T)this.put(string, null);
            }
            if (this.getType().isAssignableFrom(Boolean.class)) {
                return (T)this.put(string, bl);
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(string, Boolean.TRUE.equals(bl) ? Literal.TRUE.getValue() : Literal.FALSE.getValue());
            }
            throw new NumberFormatException("Unable to convert a boolean from the value <" + bl + "> of type <" + bl.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public T putBoolean(String[] stringArray, Boolean bl) {
            return this.putBoolean(this.toPath(stringArray), bl);
        }

        default public T putByte(Object object, Byte by) {
            return this.putByte(InterOperableMap.asKey(object), by);
        }

        default public T putByte(Object[] objectArray, Byte by) {
            return this.putByte(this.toPath(objectArray), by);
        }

        default public T putByte(Collection<?> collection, Byte by) {
            return this.putByte(this.toPath(collection), by);
        }

        default public T putByte(String string, Byte by) {
            if (by == null) {
                return (T)this.put(string, null);
            }
            if (this.getType().isAssignableFrom(Byte.class)) {
                return (T)this.put(string, by);
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(string, by.toString());
            }
            throw new NumberFormatException("Unable to convert a byte from the value <" + by + "> of type <" + by.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public T putByte(String[] stringArray, Byte by) {
            return this.putByte(this.toPath(stringArray), by);
        }

        default public T putChar(Object object, Character c) {
            return this.putChar(InterOperableMap.asKey(object), c);
        }

        default public T putChar(Object[] objectArray, Character c) {
            return this.putChar(this.toPath(objectArray), c);
        }

        default public T putChar(Collection<?> collection, Character c) {
            return this.putChar(this.toPath(collection), c);
        }

        default public T putChar(String string, Character c) {
            if (c == null) {
                return (T)this.put(string, null);
            }
            if (this.getType().isAssignableFrom(Character.class)) {
                return (T)this.put(string, c);
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(string, c.toString());
            }
            throw new NumberFormatException("Unable to convert a character from the value <" + c + "> of type <" + c.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public T putChar(String[] stringArray, Character c) {
            return this.putChar(this.toPath(stringArray), c);
        }

        default public <C> T putClass(Object object, Class<C> clazz) {
            return this.putClass(InterOperableMap.asKey(object), clazz);
        }

        default public <C> T putClass(Object[] objectArray, Class<C> clazz) {
            return this.putClass(this.toPath(objectArray), clazz);
        }

        default public <C> T putClass(Collection<?> collection, Class<C> clazz) {
            return this.putClass(this.toPath(collection), clazz);
        }

        default public <C> T putClass(String string, Class<C> clazz) {
            if (clazz == null) {
                return (T)this.put(string, null);
            }
            if (this.getType().isAssignableFrom(Class.class)) {
                try {
                    return (T)this.put(string, clazz);
                }
                catch (Exception exception) {
                    throw new NumberFormatException("Unable to convert a class from the value <" + clazz + "> of type <" + clazz.getClass().getName() + "> to type <" + this.getType().getName() + ">: " + exception.getMessage());
                }
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(string, clazz.getName());
            }
            throw new NumberFormatException("Unable to convert a class from the value <" + clazz + "> of type <" + clazz.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public <C> T putClass(String[] stringArray, Class<C> clazz) {
            return this.putClass(this.toPath(stringArray), clazz);
        }

        default public T putDouble(Object object, Double d) {
            return this.putDouble(InterOperableMap.asKey(object), d);
        }

        default public T putDouble(Object[] objectArray, Double d) {
            return this.putDouble(this.toPath(objectArray), d);
        }

        default public T putDouble(Collection<?> collection, Double d) {
            return this.putDouble(this.toPath(collection), d);
        }

        default public T putDouble(String string, Double d) {
            if (d == null) {
                return (T)this.put(string, null);
            }
            if (this.getType().isAssignableFrom(Double.class)) {
                return (T)this.put(string, d);
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(string, d.toString());
            }
            throw new NumberFormatException("Unable to convert a double from the value <" + d + "> of type <" + d.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public T putDouble(String[] stringArray, Double d) {
            return this.putDouble(this.toPath(stringArray), d);
        }

        default public <E extends Enum<E>> T putEnum(Object object, E e) {
            return this.putEnum(InterOperableMap.asKey(object), e);
        }

        default public <E extends Enum<E>> T putEnum(Object[] objectArray, E e) {
            return this.putEnum(this.toPath(objectArray), e);
        }

        default public <E extends Enum<E>> T putEnum(Collection<?> collection, E e) {
            return this.putEnum(this.toPath(collection), e);
        }

        default public <E extends Enum<E>> T putEnum(String string, E e) {
            if (e == null) {
                return (T)this.put(string, null);
            }
            if (this.getType().isAssignableFrom(Enum.class)) {
                try {
                    return (T)this.put(string, e);
                }
                catch (Exception exception) {
                    throw new NumberFormatException("Unable to convert a enumeration from the value <" + e + "> of type <" + e.getClass().getName() + "> to type <" + this.getType().getName() + ">: " + exception.getMessage());
                }
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(string, e.name());
            }
            throw new NumberFormatException("Unable to convert a enumeration from the value <" + e + "> of type <" + e.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public <E extends Enum<E>> T putEnum(String[] stringArray, E e) {
            return this.putEnum(this.toPath(stringArray), e);
        }

        default public T putFloat(Object object, Float f) {
            return this.putFloat(InterOperableMap.asKey(object), f);
        }

        default public T putFloat(Object[] objectArray, Float f) {
            return this.putFloat(this.toPath(objectArray), f);
        }

        default public T putFloat(Collection<?> collection, Float f) {
            return this.putFloat(this.toPath(collection), f);
        }

        default public T putFloat(String string, Float f) {
            if (f == null) {
                return (T)this.put(string, null);
            }
            if (this.getType().isAssignableFrom(Float.class)) {
                return (T)this.put(string, f);
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(string, f.toString());
            }
            throw new NumberFormatException("Unable to convert a float from the value <" + f + "> of type <" + f.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public T putFloat(String[] stringArray, Float f) {
            return this.putFloat(this.toPath(stringArray), f);
        }

        default public T putInt(Object object, Integer n) {
            return this.putInt(InterOperableMap.asKey(object), n);
        }

        default public T putInt(Object[] objectArray, Integer n) {
            return this.putInt(this.toPath(objectArray), n);
        }

        default public T putInt(Collection<?> collection, Integer n) {
            return this.putInt(this.toPath(collection), n);
        }

        default public T putInt(String string, Integer n) {
            if (n == null) {
                return (T)this.put(string, null);
            }
            if (this.getType().isAssignableFrom(Integer.class)) {
                return (T)this.put(string, n);
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(string, n.toString());
            }
            throw new NumberFormatException("Unable to convert a integer from the value <" + n + "> of type <" + n.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public T putInt(String[] stringArray, Integer n) {
            return this.putInt(this.toPath(stringArray), n);
        }

        default public T putLong(Object object, Long l) {
            return this.putLong(InterOperableMap.asKey(object), l);
        }

        default public T putLong(Object[] objectArray, Long l) {
            return this.putLong(this.toPath(objectArray), l);
        }

        default public T putLong(Collection<?> collection, Long l) {
            return this.putLong(this.toPath(collection), l);
        }

        default public T putLong(String string, Long l) {
            if (l == null) {
                return (T)this.put(string, null);
            }
            if (this.getType().isAssignableFrom(Long.class)) {
                return (T)this.put(string, l);
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(string, l.toString());
            }
            throw new NumberFormatException("Unable to convert a long from the value <" + l + "> of type <" + l.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public T putLong(String[] stringArray, Long l) {
            return this.putLong(this.toPath(stringArray), l);
        }

        default public T putShort(Object object, Short s) {
            return this.putShort(InterOperableMap.asKey(object), s);
        }

        default public T putShort(Object[] objectArray, Short s) {
            return this.putShort(this.toPath(objectArray), s);
        }

        default public T putShort(Collection<?> collection, Short s) {
            return this.putShort(this.toPath(collection), s);
        }

        default public T putShort(String string, Short s) {
            if (s == null) {
                return (T)this.put(string, null);
            }
            if (this.getType().isAssignableFrom(Short.class)) {
                return (T)this.put(string, s);
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(string, s.toString());
            }
            throw new NumberFormatException("Unable to convert a short from the value <" + s + "> of type <" + s.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public T putShort(String[] stringArray, Short s) {
            return this.putShort(this.toPath(stringArray), s);
        }

        default public T putString(Object object, String string) {
            return this.putString(InterOperableMap.asKey(object), string);
        }

        default public T putString(Object[] objectArray, String string) {
            return this.putString(this.toPath(objectArray), string);
        }

        default public T putString(Collection<?> collection, String string) {
            return this.putString(this.toPath(collection), string);
        }

        default public T putString(String string, String string2) {
            if (string2 == null) {
                return (T)this.put(string, null);
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(string, string2);
            }
            throw new NumberFormatException("Unable to convert a string from the value <" + string2 + "> of type <" + string2.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public T putString(String[] stringArray, String string) {
            return this.putString(this.toPath(stringArray), string);
        }
    }

    public static interface InterOperableMapBuilder<T>
    extends MutableInterOperableMap<T>,
    PathMap.PathMapBuilder<T> {
        @Override
        default public InterOperableMapBuilder<T> withInsert(Object object) {
            this.insert(object);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsert(PathMap<T> pathMap) {
            this.insert((Object)pathMap);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertBetween(Collection<?> collection, Object object, Collection<?> collection2) {
            this.insertBetween(collection, object, collection2);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertBetween(Collection<?> collection, PathMap<T> pathMap, Collection<?> collection2) {
            this.insertBetween(collection, (Object)pathMap, collection2);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertBetween(Object object, Object object2, Object object3) {
            this.insertBetween(object, object2, object3);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertBetween(Object object, PathMap<T> pathMap, Object object2) {
            this.insertBetween(object, (Object)pathMap, object2);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertBetween(Object[] objectArray, Object object, Object[] objectArray2) {
            this.insertBetween(objectArray, object, objectArray2);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertBetween(Object[] objectArray, PathMap<T> pathMap, Object[] objectArray2) {
            this.insertBetween(objectArray, (Object)pathMap, objectArray2);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertBetween(String string, Object object, String string2) {
            this.insertBetween(string, object, string2);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertBetween(String string, PathMap<T> pathMap, String string2) {
            this.insertBetween(string, (Object)pathMap, string2);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertBetween(String[] stringArray, Object object, String[] stringArray2) {
            this.insertBetween(stringArray, object, stringArray2);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertBetween(String[] stringArray, PathMap<T> pathMap, String[] stringArray2) {
            this.insertBetween(stringArray, (Object)pathMap, stringArray2);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertFrom(Object object, Collection<?> collection) {
            this.insertFrom(object, collection);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertFrom(Object object, Object object2) {
            this.insertFrom(object, object2);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertFrom(Object object, Object ... objectArray) {
            this.insertFrom(object, objectArray);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertFrom(Object object, String string) {
            this.insertFrom(object, string);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertFrom(Object object, String ... stringArray) {
            this.insertFrom(object, stringArray);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertFrom(PathMap<T> pathMap, Collection<?> collection) {
            return this.withInsertFrom((Object)pathMap, (Collection)collection);
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertFrom(PathMap<T> pathMap, Object object) {
            return this.withInsertFrom((Object)pathMap, object);
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertFrom(PathMap<T> pathMap, Object ... objectArray) {
            return this.withInsertFrom((Object)pathMap, objectArray);
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertFrom(PathMap<T> pathMap, String string) {
            this.insertFrom((Object)pathMap, string);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertFrom(PathMap<T> pathMap, String ... stringArray) {
            return this.withInsertFrom((Object)pathMap, stringArray);
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertTo(Collection<?> collection, Object object) {
            this.insertTo(collection, object);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertTo(Collection<?> collection, PathMap<T> pathMap) {
            return this.withInsertTo((Collection)collection, (Object)pathMap);
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertTo(Object object, Object object2) {
            this.insertTo(object, object2);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertTo(Object object, PathMap<T> pathMap) {
            return this.withInsertTo(object, (Object)pathMap);
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertTo(Object[] objectArray, Object object) {
            this.insertTo(objectArray, object);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertTo(Object[] objectArray, PathMap<T> pathMap) {
            return this.withInsertTo(objectArray, (Object)pathMap);
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertTo(String string, Object object) {
            this.insertTo(string, object);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertTo(String string, PathMap<T> pathMap) {
            this.insertTo(string, (Object)pathMap);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertTo(String[] stringArray, Object object) {
            this.insertTo(stringArray, object);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertTo(String[] stringArray, PathMap<T> pathMap) {
            return this.withInsertTo(stringArray, (Object)pathMap);
        }

        @Override
        default public InterOperableMapBuilder<T> withMerge(Object object) {
            this.merge(object);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMerge(PathMap<T> pathMap) {
            this.merge((Object)pathMap);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeBetween(Collection<?> collection, Object object, Collection<?> collection2) {
            this.mergeBetween(collection, object, collection2);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeBetween(Collection<?> collection, PathMap<T> pathMap, Collection<?> collection2) {
            this.mergeBetween(collection, (Object)pathMap, collection2);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeBetween(Object object, Object object2, Object object3) {
            this.mergeBetween(object, object2, object3);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeBetween(Object object, PathMap<T> pathMap, Object object2) {
            this.mergeBetween(object, (Object)pathMap, object2);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeBetween(Object[] objectArray, Object object, Object[] objectArray2) {
            this.mergeBetween(objectArray, object, objectArray2);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeBetween(Object[] objectArray, PathMap<T> pathMap, Object[] objectArray2) {
            this.mergeBetween(objectArray, (Object)pathMap, objectArray2);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeBetween(String string, Object object, String string2) {
            this.mergeBetween(string, object, string2);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeBetween(String string, PathMap<T> pathMap, String string2) {
            this.mergeBetween(string, (Object)pathMap, string2);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeBetween(String[] stringArray, Object object, String[] stringArray2) {
            this.mergeBetween(stringArray, object, stringArray2);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeBetween(String[] stringArray, PathMap<T> pathMap, String[] stringArray2) {
            this.mergeBetween(stringArray, (Object)pathMap, stringArray2);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeFrom(Object object, Collection<?> collection) {
            this.mergeFrom(object, collection);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeFrom(Object object, Object object2) {
            this.mergeFrom(object, object2);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeFrom(Object object, Object ... objectArray) {
            this.mergeFrom(object, objectArray);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeFrom(Object object, String string) {
            this.mergeFrom(object, string);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeFrom(Object object, String ... stringArray) {
            this.mergeFrom(object, stringArray);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeFrom(PathMap<T> pathMap, Collection<?> collection) {
            return this.withMergeFrom((Object)pathMap, (Collection)collection);
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeFrom(PathMap<T> pathMap, Object object) {
            return this.withMergeFrom((Object)pathMap, object);
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeFrom(PathMap<T> pathMap, Object ... objectArray) {
            return this.withMergeFrom((Object)pathMap, objectArray);
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeFrom(PathMap<T> pathMap, String string) {
            this.mergeFrom((Object)pathMap, string);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeFrom(PathMap<T> pathMap, String ... stringArray) {
            return this.withMergeFrom((Object)pathMap, stringArray);
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeTo(Collection<?> collection, Object object) {
            this.mergeTo(collection, object);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeTo(Collection<?> collection, PathMap<T> pathMap) {
            return this.withMergeTo((Collection)collection, (Object)pathMap);
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeTo(Object object, Object object2) {
            this.mergeTo(object, object2);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeTo(Object object, PathMap<T> pathMap) {
            return this.withMergeTo(object, (Object)pathMap);
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeTo(Object[] objectArray, Object object) {
            this.mergeTo(objectArray, object);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeTo(Object[] objectArray, PathMap<T> pathMap) {
            return this.withMergeTo(objectArray, (Object)pathMap);
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeTo(String string, Object object) {
            this.mergeTo(string, object);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeTo(String string, PathMap<T> pathMap) {
            this.mergeTo(string, (Object)pathMap);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeTo(String[] stringArray, Object object) {
            this.mergeTo(stringArray, object);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeTo(String[] stringArray, PathMap<T> pathMap) {
            return this.withMergeTo(stringArray, (Object)pathMap);
        }

        @Override
        default public InterOperableMapBuilder<T> withPut(Collection<?> collection, T t) {
            this.put(this.toPath(collection), t);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withPut(Object[] objectArray, T t) throws NumberFormatException {
            this.put(this.toPath(objectArray), t);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withPut(Relation<String, T> relation) {
            this.put(relation);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withPut(String string, T t) {
            this.put(string, t);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withPut(String[] stringArray, T t) throws NumberFormatException {
            this.put(this.toPath(stringArray), t);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutBoolean(Collection<?> collection, Boolean bl) {
            this.putBoolean(this.toPath(collection), bl);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutBoolean(Object object, Boolean bl) {
            this.putBoolean(object, bl);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutBoolean(Object[] objectArray, Boolean bl) {
            this.putBoolean(this.toPath(objectArray), bl);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutBoolean(String string, Boolean bl) {
            this.putBoolean(string, bl);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutBoolean(String[] stringArray, Boolean bl) {
            this.putBoolean(this.toPath(stringArray), bl);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutByte(Collection<?> collection, Byte by) {
            this.putByte(this.toPath(collection), by);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutByte(Object object, Byte by) {
            this.putByte(object, by);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutByte(Object[] objectArray, Byte by) {
            this.putByte(this.toPath(objectArray), by);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutByte(String string, Byte by) {
            this.putByte(string, by);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutByte(String[] stringArray, Byte by) {
            this.putByte(this.toPath(stringArray), by);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutChar(Collection<?> collection, Character c) {
            this.putChar(this.toPath(collection), c);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutChar(Object object, Character c) {
            this.putChar(object, c);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutChar(Object[] objectArray, Character c) {
            this.putChar(this.toPath(objectArray), c);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutChar(String string, Character c) {
            this.putChar(string, c);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutChar(String[] stringArray, Character c) {
            this.putChar(this.toPath(stringArray), c);
            return this;
        }

        default public <C> InterOperableMapBuilder<T> withPutClass(Collection<?> collection, Class<C> clazz) {
            this.putClass(this.toPath(collection), clazz);
            return this;
        }

        default public <C> InterOperableMapBuilder<T> withPutClass(Object object, Class<C> clazz) {
            this.putClass(object, clazz);
            return this;
        }

        default public <C> InterOperableMapBuilder<T> withPutClass(Object[] objectArray, Class<C> clazz) {
            this.putClass(this.toPath(objectArray), clazz);
            return this;
        }

        default public <C> InterOperableMapBuilder<T> withPutClass(String string, Class<C> clazz) {
            this.putClass(string, clazz);
            return this;
        }

        default public <C> InterOperableMapBuilder<T> withPutClass(String[] stringArray, Class<C> clazz) {
            this.putClass(this.toPath(stringArray), clazz);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withPutDirAt(int n, Object object) throws IllegalArgumentException {
            this.putDirAt(n, object);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withPutDirAt(int n, PathMap<T> pathMap) throws IllegalArgumentException {
            this.putDirAt(n, pathMap);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withPutDirAt(Object object, int n, Object object2) throws IllegalArgumentException {
            this.putDirAt(object, n, object2);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withPutDirAt(Object object, int n, PathMap<T> pathMap) throws IllegalArgumentException {
            this.putDirAt(object, n, pathMap);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withPutDirAt(Object[] objectArray, int n, Object object) throws IllegalArgumentException {
            this.putDirAt(objectArray, n, object);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withPutDirAt(Object[] objectArray, int n, PathMap<T> pathMap) throws IllegalArgumentException {
            this.putDirAt(objectArray, n, pathMap);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withPutDirAt(String string, int n, Object object) throws IllegalArgumentException {
            this.putDirAt(string, n, object);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withPutDirAt(String string, int n, PathMap<T> pathMap) throws IllegalArgumentException {
            this.putDirAt(string, n, pathMap);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withPutDirAt(String[] stringArray, int n, Object object) throws IllegalArgumentException {
            this.putDirAt(stringArray, n, object);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withPutDirAt(String[] stringArray, int n, PathMap<T> pathMap) throws IllegalArgumentException {
            this.putDirAt(stringArray, n, pathMap);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutDouble(Collection<?> collection, Double d) {
            this.putDouble(this.toPath(collection), d);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutDouble(Object object, Double d) {
            this.putDouble(object, d);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutDouble(Object[] objectArray, Double d) {
            this.putDouble(this.toPath(objectArray), d);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutDouble(String string, Double d) {
            this.putDouble(string, d);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutDouble(String[] stringArray, Double d) {
            this.putDouble(this.toPath(stringArray), d);
            return this;
        }

        default public <E extends Enum<E>> InterOperableMapBuilder<T> withPutEnum(Collection<?> collection, E e) {
            this.putEnum(this.toPath(collection), e);
            return this;
        }

        default public <E extends Enum<E>> InterOperableMapBuilder<T> withPutEnum(Object object, E e) {
            this.putEnum(object, e);
            return this;
        }

        default public <E extends Enum<E>> InterOperableMapBuilder<T> withPutEnum(Object[] objectArray, E e) {
            this.putEnum(this.toPath(objectArray), e);
            return this;
        }

        default public <E extends Enum<E>> InterOperableMapBuilder<T> withPutEnum(String string, E e) {
            this.putEnum(string, e);
            return this;
        }

        default public <E extends Enum<E>> InterOperableMapBuilder<T> withPutEnum(String[] stringArray, E e) {
            this.putEnum(this.toPath(stringArray), e);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutFloat(Collection<?> collection, Float f) {
            this.putFloat(this.toPath(collection), f);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutFloat(Object object, Float f) {
            this.putFloat(object, f);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutFloat(Object[] objectArray, Float f) {
            this.putFloat(this.toPath(objectArray), f);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutFloat(String string, Float f) {
            this.putFloat(string, f);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutFloat(String[] stringArray, Float f) {
            this.putFloat(this.toPath(stringArray), f);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutInt(Collection<?> collection, Integer n) {
            this.putInt(this.toPath(collection), n);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutInt(Object object, Integer n) {
            this.putInt(object, n);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutInt(Object[] objectArray, Integer n) {
            this.putInt(this.toPath(objectArray), n);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutInt(String string, Integer n) {
            this.putInt(string, n);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutInt(String[] stringArray, Integer n) {
            this.putInt(this.toPath(stringArray), n);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutLong(Collection<?> collection, Long l) {
            this.putLong(this.toPath(collection), l);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutLong(Object object, Long l) {
            this.putLong(object, l);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutLong(Object[] objectArray, Long l) {
            this.putLong(this.toPath(objectArray), l);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutLong(String string, Long l) {
            this.putLong(string, l);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutLong(String[] stringArray, Long l) {
            this.putLong(this.toPath(stringArray), l);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutShort(Collection<?> collection, Short s) {
            this.putShort(this.toPath(collection), s);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutShort(Object object, Short s) {
            this.putShort(object, s);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutShort(Object[] objectArray, Short s) {
            this.putShort(this.toPath(objectArray), s);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutShort(String string, Short s) {
            this.putShort(string, s);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutShort(String[] stringArray, Short s) {
            this.putShort(this.toPath(stringArray), s);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutString(Collection<?> collection, String string) {
            this.putString(this.toPath(collection), string);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutString(Object object, String string) {
            this.putString(object, string);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutString(Object[] objectArray, String string) {
            this.putString(this.toPath(objectArray), string);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutString(String string, String string2) {
            this.putString(string, string2);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutString(String[] stringArray, String string) {
            this.putString(this.toPath(stringArray), string);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withRemoveFrom(Collection<?> collection) {
            this.removeFrom(collection);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withRemoveFrom(Object object) {
            this.removeFrom(object);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withRemoveFrom(Object ... objectArray) {
            this.removeFrom(objectArray);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withRemoveFrom(String string) {
            this.removeFrom(string);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withRemoveFrom(String ... stringArray) {
            this.removeFrom(stringArray);
            return this;
        }
    }
}

