/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import org.refcodes.data.Annotator;
import org.refcodes.data.Delimiter;
import org.refcodes.matcher.PathMatcher;
import org.refcodes.matcher.PathMatcherImpl;
import org.refcodes.mixin.AnnotatorAccessor;
import org.refcodes.mixin.DelimiterAccessor;
import org.refcodes.mixin.Dumpable;
import org.refcodes.mixin.TypeAccessor;
import org.refcodes.struct.Dictionary;
import org.refcodes.struct.PathComparator;
import org.refcodes.struct.PathMapBuilderImpl;
import org.refcodes.struct.PathMapImpl;
import org.refcodes.struct.PathSortStrategy;
import org.refcodes.struct.Relation;
import org.refcodes.struct.SimpleType;
import org.refcodes.struct.StructureUtility;
import org.refcodes.struct.TypeUtility;

public interface PathMap<T>
extends Dictionary<String, T>,
TypeAccessor<T>,
Dumpable,
DelimiterAccessor,
AnnotatorAccessor {
    public static final char ANNOTATOR = Annotator.JAVA.getChar();
    public static final char DELIMITER = Delimiter.PATH.getChar();

    default public Set<String> children() {
        return this.children(this.getRootPath());
    }

    default public Set<String> children(Collection<?> collection) {
        return this.children(this.toPath(collection));
    }

    default public Set<String> children(Object object) {
        return this.children(this.toPath(object));
    }

    default public Set<String> children(Object ... objectArray) {
        return this.children(this.toPath(objectArray));
    }

    default public Set<String> children(String string) {
        String string2 = this.toNormalizedPath(string);
        String string4 = this.getRootPath();
        HashSet<String> hashSet = new HashSet<String>();
        this.keySet(string2).forEach(string3 -> {
            if (string3.length() == 0 && string2.equals(string4) || string3.length() > 0) {
                int n = string3.indexOf(this.getDelimiter(), 0);
                if (n == -1) {
                    hashSet.add((String)string3);
                } else if ((string3 = string3.substring(0, n)).length() > 0) {
                    hashSet.add((String)string3);
                }
            }
        });
        return hashSet;
    }

    default public Set<String> children(String ... stringArray) {
        return this.children(this.toPath(stringArray));
    }

    default public boolean containsKey(Collection<?> collection) {
        return this.containsKey((Object)this.toPath(collection));
    }

    default public boolean containsKey(Object ... objectArray) {
        return this.containsKey((Object)this.toPath(objectArray));
    }

    default public boolean containsKey(String ... stringArray) {
        return this.containsKey((Object)this.toPath(stringArray));
    }

    default public Set<String> dirs() {
        return this.dirs(this.getRootPath());
    }

    default public Set<String> dirs(Collection<?> collection) {
        return this.dirs(this.toPath(collection));
    }

    default public Set<String> dirs(Object object) {
        return this.dirs(this.toPath(object));
    }

    default public Set<String> dirs(Object ... objectArray) {
        return this.dirs(this.toPath(objectArray));
    }

    default public Set<String> dirs(String string2) {
        string2 = this.toNormalizedPath(string2);
        HashSet<String> hashSet = new HashSet<String>();
        this.keySet(string2).forEach(string -> {
            int n = string.indexOf(this.getDelimiter(), 0);
            if (n != -1 && (string = string.substring(0, n)).length() > 0) {
                hashSet.add((String)string);
            }
        });
        return hashSet;
    }

    default public Set<String> dirs(String ... stringArray) {
        return this.dirs(this.toPath(stringArray));
    }

    default public Set<String> findPaths(T t) {
        HashSet<String> hashSet = new HashSet<String>();
        if (t != null) {
            for (String string : this.keySet()) {
                if (!t.equals(this.get((Object)string))) continue;
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    default public String fromExternalPath(String string, char ... cArray) {
        if (cArray != null && cArray.length > 0) {
            for (char c : cArray) {
                if (c == this.getDelimiter()) continue;
                string = string.replace(c, this.getDelimiter());
            }
        }
        return this.toNormalizedPath(string);
    }

    default public T get(Collection<?> collection) {
        return (T)this.get((Object)this.toPath(collection));
    }

    default public T get(Object ... objectArray) {
        return (T)this.get((Object)this.toPath(objectArray));
    }

    default public T get(String ... stringArray) {
        return (T)this.get((Object)this.toPath(stringArray));
    }

    default public T[] getArray() {
        return this.getArray(this.getRootPath());
    }

    default public T[] getArray(Collection<?> collection) {
        return this.getArray(this.toPath(collection));
    }

    default public T[] getArray(Object ... objectArray) {
        return this.getArray(this.toPath(objectArray));
    }

    default public T[] getArray(String ... stringArray) {
        return this.getArray(this.toPath(stringArray));
    }

    default public T[] getArray(String string) {
        Object object;
        int n;
        string = this.toNormalizedPath(string);
        boolean bl = false;
        int n2 = -1;
        PathMap<T> pathMap = this.retrieveFrom(string);
        for (String objectArray : pathMap.leaves()) {
            try {
                if (!pathMap.hasValue(objectArray)) {
                    throw new IllegalArgumentException("The provided path \"" + string + "\" does not point to an array structure. Use \"isArray( String )\" to test if the leaves below the given path can be retrieved as array.");
                }
                n = Integer.valueOf(objectArray);
                if (n < 0) {
                    throw new IllegalArgumentException("The provided path \"" + string + "\" does not point to an array structure. Use \"isArray( String )\" to test if the leaves below the given path can be retrieved as array.");
                }
                n2 = n > n2 ? n : n2;
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
        }
        if (n2 != -1) {
            object = (Object[])Array.newInstance(this.getType(), n2 + 1);
            for (String string2 : pathMap.children()) {
                try {
                    if (!pathMap.hasValue(string2)) {
                        throw new IllegalArgumentException("The provided path \"" + string + "\" does not point to an array structure. Use \"isArray( String )\" to test if the leaves below the given path can be retrieved as array.");
                    }
                    n = Integer.valueOf(string2);
                    object[n] = pathMap.get((Object)string2);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return object;
        }
        object = this.get((Object)string);
        if (object != null) {
            Object[] objectArray = (Object[])Array.newInstance(this.getType(), 1);
            objectArray[0] = object;
            return objectArray;
        }
        if (bl) {
            throw new IllegalArgumentException("The provided path \"" + string + "\" does not point to an array structure. Use \"isArray( String )\" to test if the leaves below the given path can be retrieved as array.");
        }
        return (Object[])Array.newInstance(this.getType(), 0);
    }

    default public T[] getArrayOr(T[] TArray) {
        return this.getArrayOr(this.getRootPath(), TArray);
    }

    default public T[] getArrayOr(Collection<?> collection, T[] TArray) {
        return this.getArrayOr(this.toPath(collection), TArray);
    }

    default public T[] getArrayOr(Object[] objectArray, T[] TArray) {
        return this.getArrayOr(this.toPath(objectArray), TArray);
    }

    default public T[] getArrayOr(String string, T[] TArray) {
        try {
            return this.getArray(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return TArray;
        }
    }

    default public T[] getArrayOr(String[] stringArray, T[] TArray) {
        return this.getArrayOr(this.toPath(stringArray), TArray);
    }

    default public int[] getArrayIndexes() {
        return this.getArrayIndexes(this.getRootPath());
    }

    default public int[] getArrayIndexes(Collection<?> collection) {
        return this.getArrayIndexes(this.toPath(collection));
    }

    default public int[] getArrayIndexes(Object ... objectArray) {
        return this.getArrayIndexes(this.toPath(objectArray));
    }

    default public int[] getArrayIndexes(String string) throws IllegalArgumentException {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        string = this.toNormalizedPath(string);
        PathMap<T> pathMap = this.retrieveFrom(string);
        for (String string2 : pathMap.children()) {
            try {
                if (!pathMap.hasValue(string2)) {
                    throw new IllegalArgumentException("The provided path \"" + string + "\" does not point to an array structure. Use \"isArray( String )\" to test if the leaves below the given path can be retrieved as array.");
                }
                if (string2.startsWith("" + ANNOTATOR)) continue;
                int n = Integer.valueOf(string2);
                if (n < 0) {
                    throw new IllegalArgumentException("The provided path \"" + string + "\" does not point to an array structure. Use \"isArray( String )\" to test if the leaves below the given path can be retrieved as array.");
                }
                if (hashSet.add(n)) continue;
                throw new IllegalArgumentException("The provided path \"" + string + "\" does not point to an array structure as we have multiple entries for index <" + n + ">. Use \"isArray( String )\" to test if the leaves below the given path can be retrieved as array.");
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("The provided path \"" + string + "\" does not point to an array structure. Use \"isArray( String )\" to test if the leaves below the given path can be retrieved as array.");
            }
        }
        Object object = new int[hashSet.size()];
        int n = 0;
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            object[n] = n2;
            ++n;
        }
        Arrays.sort((int[])object);
        return object;
    }

    default public int[] getArrayIndexes(String ... stringArray) {
        return this.getArrayIndexes(this.toPath(stringArray));
    }

    default public PathMap<T> getDirAt(Collection<?> collection, int n) {
        return this.getDirAt(this.toPath(collection), n);
    }

    default public PathMap<T> getDirAt(int n) {
        return this.getDirAt(this.getRootPath(), n);
    }

    default public PathMap<T> getDirAt(Object object, int n) {
        return this.getDirAt(this.toPath(object), n);
    }

    default public PathMap<T> getDirAt(Object[] objectArray, int n) {
        return this.getDirAt(this.toPath(objectArray), n);
    }

    default public PathMap<T> getDirAt(String string, int n) {
        return this.retrieveFrom(this.toPath(string, n));
    }

    default public PathMap<T> getDirAt(String[] stringArray, int n) {
        return this.getDirAt(this.toPath(stringArray), n);
    }

    default public int[] getDirIndexes() {
        return this.getDirIndexes(this.getRootPath());
    }

    default public int[] getDirIndexes(Collection<?> collection) {
        return this.getDirIndexes(this.toPath(collection));
    }

    default public int[] getDirIndexes(Object ... objectArray) {
        return this.getDirIndexes(this.toPath(objectArray));
    }

    default public int[] getDirIndexes(String string) throws IllegalArgumentException {
        string = this.toNormalizedPath(string);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        Set<String> set = this.paths(string);
        boolean bl = false;
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            int n;
            String string2 = iterator.next();
            if (string2.startsWith("" + this.getDelimiter())) {
                string2 = string2.substring(1);
            }
            if ((n = string2.indexOf(this.getDelimiter())) != -1) {
                bl = true;
                string2 = string2.substring(0, n);
            }
            try {
                if (string2.startsWith("" + this.getAnnotator())) {
                    iterator.remove();
                    continue;
                }
                int n2 = Integer.parseInt(string2);
                if (!hashSet.contains(n2)) {
                    hashSet.add(n2);
                }
                iterator.remove();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("The path <" + (Serializable)(string == null || string.length() == 0 ? Character.valueOf(this.getDelimiter()) : string) + "> does not point to an indexed path. Use \"isIndexDir( String aPath )\" to test beforehand.");
            }
        }
        if (!bl && !set.isEmpty()) {
            throw new IllegalArgumentException("The path <" + (Serializable)(string == null || string.length() == 0 ? Character.valueOf(this.getDelimiter()) : string) + "> does not point to an indexed path. Use \"isIndexDir( String aPath )\" to test beforehand.");
        }
        int[] nArray = new int[hashSet.size()];
        int n = 0;
        Iterator iterator2 = hashSet.iterator();
        while (iterator2.hasNext()) {
            int n3;
            nArray[n] = n3 = ((Integer)iterator2.next()).intValue();
            ++n;
        }
        Arrays.sort(nArray);
        return nArray;
    }

    default public int[] getDirIndexes(String ... stringArray) {
        return this.getDirIndexes(this.toPath(stringArray));
    }

    default public String getRootPath() {
        return "" + this.getDelimiter();
    }

    default public T getValueAt(Collection<?> collection, int n) {
        return (T)this.get((Object)this.toPath(collection, n));
    }

    default public T getValueAt(int n) {
        return (T)this.get((Object)n);
    }

    default public T getValueAt(Object object, int n) {
        return (T)this.get((Object)this.toPath(object, n));
    }

    default public T getValueAt(Object[] objectArray, int n) {
        return this.get(this.toPath(objectArray), n);
    }

    default public T getValueAt(String string, int n) {
        return (T)this.get((Object)this.toPath(string, n));
    }

    default public T getValueAt(String[] stringArray, int n) {
        return this.get(this.toPath(stringArray), n);
    }

    default public boolean hasChildren(Collection<?> collection) {
        return this.hasChildren(this.toPath(collection));
    }

    default public boolean hasChildren(Object object) {
        return this.hasChildren(this.toPath(object));
    }

    default public boolean hasChildren(Object ... objectArray) {
        return this.hasChildren(this.toPath(objectArray));
    }

    default public boolean hasChildren(String string) {
        Set<String> set = this.children(string);
        return set != null && set.size() != 0;
    }

    default public boolean hasChildren(String ... stringArray) {
        return this.hasChildren(this.toPath(stringArray));
    }

    default public boolean hasDirAt(Collection<?> collection) {
        return this.hasDirAt(this.toPath(collection));
    }

    default public boolean hasDirAt(Collection<?> collection, int n) {
        return this.hasDirAt(this.toPath(collection), n);
    }

    default public boolean hasDirAt(int n) {
        return this.hasDirAt(this.getRootPath(), n);
    }

    default public boolean hasDirAt(Object object) {
        return this.hasDirAt(this.toPath(object));
    }

    default public boolean hasDirAt(Object ... objectArray) {
        return this.hasDirAt(this.toPath(objectArray));
    }

    default public boolean hasDirAt(Object object, int n) {
        return this.isDir(this.toPath(object, "" + n));
    }

    default public boolean hasDirAt(Object[] objectArray, int n) {
        return this.isDir(this.toPath(objectArray, n));
    }

    default public boolean hasDirAt(String string) {
        String[] stringArray = this.toPathElements(string);
        if (stringArray != null && stringArray.length > 0) {
            try {
                int n = Integer.valueOf(stringArray[stringArray.length - 1]);
                string = this.toParentPath(string);
                return this.hasDirAt(string, n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    default public boolean hasDirAt(String ... stringArray) {
        return this.hasDirAt(this.toPath(stringArray));
    }

    default public boolean hasDirAt(String string, int n) {
        return this.isDir(this.toPath(string, "" + n));
    }

    default public boolean hasDirAt(String[] stringArray, int n) {
        return this.hasDirAt(this.toPath(stringArray), n);
    }

    default public boolean hasParentPath(String string) {
        int n = (string = this.toNormalizedPath(string)).lastIndexOf(this.getDelimiter());
        return n > 0;
    }

    default public boolean hasPath(Collection<?> collection) {
        return this.hasPath(this.toPath(collection));
    }

    default public boolean hasPath(Object ... objectArray) {
        return this.hasPath(this.toPath(objectArray));
    }

    default public boolean hasPath(String string) {
        return !this.paths(string).isEmpty();
    }

    default public boolean hasPath(String ... stringArray) {
        return this.hasPath(this.toPath(stringArray));
    }

    default public boolean hasValueAt(Collection<?> collection, int n) {
        return this.hasValue(this.toPath(this.toPath(collection), "" + n));
    }

    default public boolean hasValueAt(int n) {
        return this.hasValueAt(this.getRootPath(), n);
    }

    default public boolean hasValueAt(Object object) {
        return this.hasValueAt(this.toPath(object));
    }

    default public boolean hasValueAt(Object object, int n) {
        return this.hasValue(this.toPath(object, n));
    }

    default public boolean hasValueAt(Object[] objectArray, int n) {
        return this.hasValue(this.toPath(objectArray, n));
    }

    default public boolean hasValueAt(String string) {
        String[] stringArray = this.toPathElements(string);
        if (stringArray != null && stringArray.length > 0) {
            try {
                int n = Integer.valueOf(stringArray[stringArray.length - 1]);
                string = this.toParentPath(string);
                return this.hasValueAt(string, n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    default public boolean hasValueAt(String string, int n) {
        return this.hasValue(this.toPath(string, n));
    }

    default public boolean hasValueAt(String[] stringArray, int n) {
        return this.hasValue(this.toPath(stringArray, n));
    }

    default public boolean isArray() {
        return this.isArray(this.getRootPath());
    }

    default public boolean isArray(String ... stringArray) {
        return this.isArray(this.toPath(stringArray));
    }

    default public boolean isArray(Collection<?> collection) {
        return this.isArray(this.toPath(collection));
    }

    default public boolean isArray(Object object) {
        return this.isArray(this.toPath(object));
    }

    default public boolean isArray(Object ... objectArray) {
        return this.isArray(this.toPath(objectArray));
    }

    default public boolean isArray(String string) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        string = this.toNormalizedPath(string);
        int n = 0;
        PathMap<T> pathMap = this.retrieveFrom(string);
        for (String string2 : pathMap.children()) {
            try {
                if (!pathMap.hasValue(string2)) {
                    return false;
                }
                if (string2.startsWith("" + this.getAnnotator())) {
                    ++n;
                    continue;
                }
                int n2 = Integer.valueOf(string2);
                if (n2 < 0) {
                    return false;
                }
                if (hashSet.add(n2)) continue;
                return false;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return pathMap.size() - n != 0;
    }

    default public boolean isChild(Collection<?> collection) {
        return this.isChild(this.toPath(collection));
    }

    default public boolean isChild(Object ... objectArray) {
        return this.isChild(this.toPath(objectArray));
    }

    default public boolean isChild(String string) {
        return this.hasValue(string) || this.isDir(string);
    }

    default public boolean isChild(String ... stringArray) {
        return this.hasValue(stringArray) || this.isDir(stringArray);
    }

    default public boolean isDir(Collection<?> collection) {
        return this.isDir(this.toPath(collection));
    }

    default public boolean isDir(Object object) {
        return this.isDir(this.toPath(object));
    }

    default public boolean isDir(Object ... objectArray) {
        return this.isDir(this.toPath(objectArray));
    }

    default public boolean isDir(String object) {
        if (!((String)(object = this.toNormalizedPath((String)object))).endsWith("" + this.getDelimiter())) {
            object = (String)object + this.getDelimiter();
        }
        String string = object;
        String string2 = this.getRootPath();
        for (String string3 : this.keySet()) {
            if ((string3.length() <= string.length() || !string3.startsWith(string)) && (!string3.equals(string2) || !string.equals(string2))) continue;
            return true;
        }
        return false;
    }

    default public boolean isDir(String ... stringArray) {
        return this.isDir(this.toPath(stringArray));
    }

    default public boolean isLeaf(Collection<?> collection) {
        return this.isLeaf(this.toPath(collection));
    }

    default public boolean isLeaf(Object object) {
        return this.isLeaf(this.toPath(object));
    }

    default public boolean isLeaf(Object ... objectArray) {
        return this.isLeaf(this.toPath(objectArray));
    }

    default public boolean isLeaf(String string) {
        return this.containsKey((Object)string);
    }

    default public boolean isLeaf(String ... stringArray) {
        return this.isLeaf(this.toPath(stringArray));
    }

    default public boolean isIndexDir() {
        return this.isIndexDir(this.getRootPath());
    }

    default public boolean isIndexDir(Collection<?> collection) {
        return this.isIndexDir(this.toPath(collection));
    }

    default public boolean isIndexDir(Object ... objectArray) {
        return this.isIndexDir(this.toPath(objectArray));
    }

    default public boolean isIndexDir(String string) {
        string = this.toNormalizedPath(string);
        try {
            Set<String> set = this.paths(string);
            if (set.size() != 0) {
                Iterator<String> iterator = set.iterator();
                while (iterator.hasNext()) {
                    int n;
                    String string2 = iterator.next();
                    if (string2.length() == 0) {
                        return false;
                    }
                    if (string2.startsWith("" + this.getDelimiter())) {
                        string2 = string2.substring(1);
                    }
                    if ((n = string2.indexOf(this.getDelimiter())) != -1) {
                        string2 = string2.substring(0, n);
                    }
                    if (string2.startsWith("" + this.getAnnotator())) {
                        iterator.remove();
                        continue;
                    }
                    Integer.parseInt(string2);
                }
                return !set.isEmpty();
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    default public boolean isIndexDir(String ... stringArray) {
        return this.isIndexDir(this.toPath(stringArray));
    }

    default public boolean isEqualTo(PathMap<?> pathMap) {
        if (this.size() != pathMap.size()) {
            return false;
        }
        for (String string : this.keySet()) {
            Object v;
            Object v2 = this.get((Object)string);
            if (v2 == (v = pathMap.get((Object)string))) continue;
            if (v2 != null) {
                if (v2.equals(v)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    default public boolean hasSubDirs(Collection<?> collection) {
        return this.hasSubDirs(this.toPath(collection));
    }

    default public boolean hasSubDirs(Object object) {
        return this.hasSubDirs(this.toPath(object));
    }

    default public boolean hasSubDirs(Object ... objectArray) {
        return this.hasSubDirs(this.toPath(objectArray));
    }

    default public boolean hasSubDirs(String string) {
        return this.dirs(string).size() != 0;
    }

    default public boolean hasValue(Collection<?> collection) {
        return this.hasValue(this.toPath(collection));
    }

    default public boolean hasValue(Object object) {
        return this.hasValue(this.toPath(object));
    }

    default public boolean hasValue(Object ... objectArray) {
        return this.hasValue(this.toPath(objectArray));
    }

    default public boolean hasValue(String string) {
        string = this.toNormalizedPath(string);
        return this.containsKey((Object)string);
    }

    default public boolean hasValue(String ... stringArray) {
        return this.hasValue(this.toPath(stringArray));
    }

    default public boolean isRootPath(String string) {
        string = this.toNormalizedPath(string);
        String string2 = this.toNormalizedPath(this.getRootPath());
        return string2.equals(string);
    }

    default public Set<String> keySet(String object) {
        if (!((String)(object = this.toNormalizedPath((String)object))).endsWith("" + this.getDelimiter())) {
            object = (String)object + this.getDelimiter();
        }
        String string = object;
        String string2 = this.getRootPath();
        HashSet<String> hashSet = new HashSet<String>();
        this.keySet().forEach(string3 -> {
            if (string3.length() > string.length() && string3.startsWith(string) || string3.equals(string2) && string.equals(string2)) {
                String string4 = string3.substring(string.length());
                hashSet.add(string4);
            }
        });
        return hashSet;
    }

    default public Set<String> keySet(Collection<?> collection) {
        return this.keySet(this.toPath(collection));
    }

    default public Set<String> keySet(Object object) {
        return this.keySet(this.toPath(object));
    }

    default public Set<String> keySet(Object ... objectArray) {
        return this.keySet(this.toPath(objectArray));
    }

    default public Set<String> keySet(String ... stringArray) {
        return this.keySet(this.toPath(stringArray));
    }

    default public int lastArrayIndex() {
        return this.lastArrayIndex(this.getRootPath());
    }

    default public int lastArrayIndex(Collection<?> collection) {
        return this.lastArrayIndex(this.toPath(collection));
    }

    default public int lastArrayIndex(Object object) {
        return this.lastArrayIndex(this.toPath(object));
    }

    default public int lastArrayIndex(Object ... objectArray) {
        return this.lastArrayIndex(this.toPath(objectArray));
    }

    default public int lastArrayIndex(String string) {
        int n = -1;
        int[] nArray = this.getArrayIndexes(string);
        if (nArray != null && nArray.length != 0) {
            n = nArray[nArray.length - 1];
        }
        return n;
    }

    default public int lastArrayIndex(String ... stringArray) {
        return this.lastArrayIndex(this.toPath(stringArray));
    }

    default public int lastDirIndex() {
        return this.lastDirIndex(this.getRootPath());
    }

    default public int lastDirIndex(Collection<?> collection) {
        return this.lastDirIndex(this.toPath(collection));
    }

    default public int lastDirIndex(Object object) {
        return this.lastDirIndex(this.toPath(object));
    }

    default public int lastDirIndex(Object ... objectArray) {
        return this.lastDirIndex(this.toPath(objectArray));
    }

    default public int lastDirIndex(String string) {
        int n = -1;
        int[] nArray = this.getDirIndexes(string);
        if (nArray != null && nArray.length != 0) {
            n = nArray[nArray.length - 1];
        }
        return n;
    }

    default public int lastDirIndex(String ... stringArray) {
        return this.lastDirIndex(this.toPath(stringArray));
    }

    default public Set<String> leaves() {
        return this.leaves(this.getRootPath());
    }

    default public Set<String> leaves(Collection<?> collection) {
        return this.leaves(this.toPath(collection));
    }

    default public Set<String> leaves(Object object) {
        return this.leaves(this.toPath(object));
    }

    default public Set<String> leaves(Object ... objectArray) {
        return this.leaves(this.toPath(objectArray));
    }

    default public Set<String> leaves(String string2) {
        string2 = this.toNormalizedPath(string2);
        HashSet<String> hashSet = new HashSet<String>();
        this.keySet(string2).forEach(string -> {
            if (string.length() > 0 && string.indexOf(this.getDelimiter(), 0) == -1) {
                hashSet.add((String)string);
            }
        });
        return hashSet;
    }

    default public Set<String> leaves(String ... stringArray) {
        return this.leaves(this.toPath(stringArray));
    }

    default public int nextArrayIndex() {
        return this.nextArrayIndex(this.getRootPath());
    }

    default public int nextArrayIndex(Collection<?> collection) {
        return this.nextArrayIndex(this.toPath(collection));
    }

    default public int nextArrayIndex(Object object) {
        return this.lastArrayIndex(object) + 1;
    }

    default public int nextArrayIndex(Object ... objectArray) {
        return this.nextArrayIndex(this.toPath(objectArray));
    }

    default public int nextArrayIndex(String string) {
        try {
            return this.lastArrayIndex(string) + 1;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 0;
        }
    }

    default public int nextArrayIndex(String ... stringArray) {
        return this.nextArrayIndex(this.toPath(stringArray));
    }

    default public int nextDirIndex() {
        return this.nextDirIndex(this.getRootPath());
    }

    default public int nextDirIndex(Collection<?> collection) {
        return this.nextDirIndex(this.toPath(collection));
    }

    default public int nextDirIndex(Object object) {
        return this.lastDirIndex(object) + 1;
    }

    default public int nextDirIndex(Object ... objectArray) {
        return this.nextDirIndex(this.toPath(objectArray));
    }

    default public int nextDirIndex(String string) {
        return this.lastDirIndex(string) + 1;
    }

    default public int nextDirIndex(String ... stringArray) {
        return this.nextDirIndex(this.toPath(stringArray));
    }

    default public Set<String> paths() {
        return this.keySet();
    }

    default public Set<String> paths(Collection<?> collection) {
        return this.paths(this.toPath(collection));
    }

    default public Set<String> paths(Object object) {
        return this.paths(this.toPath(object));
    }

    default public Set<String> paths(Object ... objectArray) {
        return this.paths(this.toPath(objectArray));
    }

    default public Set<String> paths(String string) {
        return this.keySet(string);
    }

    default public Set<String> paths(String ... stringArray) {
        return this.paths(this.toPath(stringArray));
    }

    default public PathMap<T> query(Collection<?> collection) {
        return this.query(this.toPath(collection));
    }

    default public PathMap<T> query(Object ... objectArray) {
        return this.query(this.toPath(objectArray));
    }

    default public PathMap<T> query(Pattern pattern) {
        PathMapBuilderImpl pathMapBuilderImpl = new PathMapBuilderImpl(this.getType());
        for (String string : this.paths()) {
            if (!pattern.matcher(string).matches()) continue;
            pathMapBuilderImpl.put(string, this.get((Object)string));
        }
        return pathMapBuilderImpl;
    }

    default public PathMap<T> query(String string) {
        PathMapBuilderImpl pathMapBuilderImpl = new PathMapBuilderImpl(this.getType());
        PathMatcherImpl pathMatcherImpl = new PathMatcherImpl(string, this.getDelimiter());
        for (String string2 : this.paths()) {
            if (!pathMatcherImpl.isMatching(string2)) continue;
            pathMapBuilderImpl.put(string2, this.get((Object)string2));
        }
        return pathMapBuilderImpl;
    }

    default public PathMap<T> query(String ... stringArray) {
        return this.query(this.toPath(stringArray));
    }

    default public PathMap<T> queryBetween(Collection<?> collection, Collection<?> collection2, Collection<?> collection3) {
        return this.queryBetween(this.toPath(collection), this.toPath(collection2), this.toPath(collection3));
    }

    default public PathMap<T> queryBetween(Object object, Object object2, Object object3) {
        return this.queryBetween(this.toPath(object), this.toPath(object2), this.toPath(object3));
    }

    default public PathMap<T> queryBetween(Object[] objectArray, Object[] objectArray2, Object[] objectArray3) {
        return this.queryBetween(this.toPath(objectArray), this.toPath(objectArray2), this.toPath(objectArray3));
    }

    default public PathMap<T> queryBetween(String string, Pattern pattern, String string2) {
        PathMap<T> pathMap = this.retrieveFrom(string);
        PathMapBuilderImpl pathMapBuilderImpl = new PathMapBuilderImpl(this.getType());
        for (String string3 : pathMap.keySet()) {
            if (!pattern.matcher(string3).matches()) continue;
            pathMapBuilderImpl.put(string3, pathMap.get((Object)string3));
        }
        return pathMapBuilderImpl.retrieveTo(string2);
    }

    default public PathMap<T> queryBetween(String string, String string2, String string3) {
        PathMap<T> pathMap = this.retrieveFrom(string);
        PathMapBuilderImpl pathMapBuilderImpl = new PathMapBuilderImpl(this.getType());
        PathMatcherImpl pathMatcherImpl = new PathMatcherImpl(string2, this.getDelimiter());
        for (String string4 : pathMap.keySet()) {
            if (!pathMatcherImpl.isMatching(string4)) continue;
            pathMapBuilderImpl.put(string4, pathMap.get((Object)string4));
        }
        return pathMapBuilderImpl.retrieveTo(string3);
    }

    default public PathMap<T> queryBetween(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        return this.queryBetween(this.toPath(stringArray), this.toPath(stringArray2), this.toPath(stringArray3));
    }

    default public PathMap<T> queryFrom(Collection<?> collection, Collection<?> collection2) {
        return this.queryFrom(this.toPath(collection), this.toPath(collection2));
    }

    default public PathMap<T> queryFrom(Object object, Object object2) {
        return this.queryFrom(this.toPath(object), this.toPath(object2));
    }

    default public PathMap<T> queryFrom(Object[] objectArray, Object[] objectArray2) {
        return this.queryFrom(this.toPath(objectArray), this.toPath(objectArray2));
    }

    default public PathMap<T> queryFrom(Pattern pattern, String string) {
        PathMap<T> pathMap = this.retrieveFrom(string);
        PathMapBuilderImpl pathMapBuilderImpl = new PathMapBuilderImpl(this.getType());
        for (String string2 : pathMap.keySet()) {
            if (!pattern.matcher(string2).matches()) continue;
            pathMapBuilderImpl.put(string2, pathMap.get((Object)string2));
        }
        return pathMapBuilderImpl;
    }

    default public PathMap<T> queryFrom(String string, String string2) {
        PathMap<T> pathMap = this.retrieveFrom(string2);
        PathMapBuilderImpl pathMapBuilderImpl = new PathMapBuilderImpl(this.getType());
        PathMatcherImpl pathMatcherImpl = new PathMatcherImpl(string, this.getDelimiter());
        for (String string3 : pathMap.keySet()) {
            if (!pathMatcherImpl.isMatching(string3)) continue;
            pathMapBuilderImpl.put(string3, pathMap.get((Object)string3));
        }
        return pathMapBuilderImpl;
    }

    default public PathMap<T> queryFrom(String[] stringArray, String[] stringArray2) {
        return this.queryFrom(this.toPath(stringArray), this.toPath(stringArray2));
    }

    default public Set<String> queryPaths(Collection<?> collection) {
        return this.queryPaths(this.toPath(collection));
    }

    default public Set<String> queryPaths(Object object) {
        return this.queryPaths(this.toPath(object));
    }

    default public Set<String> queryPaths(Object ... objectArray) {
        return this.queryPaths(this.toPath(objectArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Set<String> queryPaths(Pattern pattern) {
        HashSet<String> hashSet = new HashSet<String>();
        for (String string : this.paths()) {
            if (!pattern.matcher(string).matches()) continue;
            HashSet<String> hashSet2 = hashSet;
            synchronized (hashSet2) {
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    default public Set<String> queryPaths(String ... stringArray) {
        return this.queryPaths(this.toPath(stringArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public Set<String> queryPaths(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        PathMatcherImpl pathMatcherImpl = new PathMatcherImpl(string, this.getDelimiter());
        for (String string2 : this.paths()) {
            if (!pathMatcherImpl.isMatching(string2)) continue;
            HashSet<String> hashSet2 = hashSet;
            synchronized (hashSet2) {
                hashSet.add(string2);
            }
        }
        return hashSet;
    }

    default public PathMap<T> queryTo(Collection<?> collection, String string) {
        return this.queryTo(this.toPath(collection), string);
    }

    default public PathMap<T> queryTo(Object object, String string) {
        return this.queryTo(this.toPath(object), string);
    }

    default public PathMap<T> queryTo(Object[] objectArray, String string) {
        return this.queryTo(this.toPath(objectArray), string);
    }

    default public PathMap<T> queryTo(Pattern pattern, String string) {
        PathMapBuilderImpl pathMapBuilderImpl = new PathMapBuilderImpl(this.getType());
        for (String string2 : this.paths()) {
            if (!pattern.matcher(string2).matches()) continue;
            pathMapBuilderImpl.put(string2, this.get((Object)string2));
        }
        return pathMapBuilderImpl.retrieveTo(string);
    }

    default public PathMap<T> queryTo(String string, String string2) {
        PathMapBuilderImpl pathMapBuilderImpl = new PathMapBuilderImpl(this.getType());
        PathMatcherImpl pathMatcherImpl = new PathMatcherImpl(string, this.getDelimiter());
        HashSet<String> hashSet = new HashSet<String>(this.paths());
        hashSet.parallelStream().forEach(arg_0 -> this.lambda$queryTo$4((PathMatcher)pathMatcherImpl, pathMapBuilderImpl, arg_0));
        for (String string3 : this.paths()) {
            if (!pathMatcherImpl.isMatching(string3)) continue;
            pathMapBuilderImpl.put(string3, this.get((Object)string3));
        }
        return pathMapBuilderImpl.retrieveTo(string2);
    }

    default public PathMap<T> queryTo(String[] stringArray, String string) {
        return this.queryTo(this.toPath(stringArray), string);
    }

    default public PathMap<T> retrieveBetween(Collection<?> collection, Collection<?> collection2) {
        PathMap<T> pathMap = this.retrieveFrom(collection);
        return pathMap.retrieveTo(collection2);
    }

    default public PathMap<T> retrieveBetween(Object object, Object object2) {
        PathMap<T> pathMap = this.retrieveFrom(object);
        return pathMap.retrieveTo(object2);
    }

    default public PathMap<T> retrieveBetween(Object[] objectArray, Object[] objectArray2) {
        PathMap<T> pathMap = this.retrieveFrom(objectArray);
        return pathMap.retrieveTo(objectArray2);
    }

    default public PathMap<T> retrieveBetween(String string, String string2) {
        PathMap<T> pathMap = this.retrieveFrom(string);
        return pathMap.retrieveTo(string2);
    }

    default public PathMap<T> retrieveBetween(String[] stringArray, String[] stringArray2) {
        PathMap<T> pathMap = this.retrieveFrom(stringArray);
        return pathMap.retrieveTo(stringArray2);
    }

    default public PathMap<T> retrieveFrom(Collection<?> collection) {
        return this.retrieveFrom(this.toPath(collection));
    }

    default public PathMap<T> retrieveFrom(Object object) {
        return this.retrieveFrom(this.toPath(object));
    }

    default public PathMap<T> retrieveFrom(Object ... objectArray) {
        return this.retrieveFrom(this.toPath(objectArray));
    }

    public PathMap<T> retrieveFrom(String var1);

    default public PathMap<T> retrieveFrom(String ... stringArray) {
        return this.retrieveFrom(this.toPath(stringArray));
    }

    default public PathMap<T> getDir(Collection<?> collection) {
        return this.getDir(this.toPath(collection));
    }

    default public PathMap<T> getDir(Object object) {
        return this.getDir(this.toPath(object));
    }

    default public PathMap<T> getDir(Object ... objectArray) {
        return this.getDir(this.toPath(objectArray));
    }

    default public PathMap<T> getDir(String string) {
        return this.retrieveFrom(string);
    }

    default public PathMap<T> getDir(String ... stringArray) {
        return this.getDir(this.toPath(stringArray));
    }

    default public PathMap<T>[] getDirs(Collection<?> collection) {
        return this.getDirs(this.toPath(collection));
    }

    default public PathMap<T>[] getDirs(Object object) {
        return this.getDirs(this.toPath(object));
    }

    default public PathMap<T>[] getDirs(Object ... objectArray) {
        return this.getDirs(this.toPath(objectArray));
    }

    default public PathMap<T>[] getDirs(String string) {
        PathMap[] pathMapArray;
        if (this.isIndexDir(string)) {
            int[] nArray = this.getDirIndexes(string);
            pathMapArray = new PathMap[nArray[nArray.length - 1] + 1];
            for (int n : nArray) {
                pathMapArray[nArray[n]] = this.getDirAt(string, nArray[n]);
            }
        } else {
            pathMapArray = new PathMap[]{this.getDir(string)};
        }
        return pathMapArray;
    }

    default public PathMap<T>[] getDirs(String ... stringArray) {
        return this.getDirs(this.toPath(stringArray));
    }

    default public PathMap<T> retrieveTo(Collection<?> collection) {
        return this.retrieveTo(this.toPath(collection));
    }

    default public PathMap<T> retrieveTo(Object object) {
        return this.retrieveTo(this.toPath(object));
    }

    default public PathMap<T> retrieveTo(Object ... objectArray) {
        return this.retrieveTo(this.toPath(objectArray));
    }

    public PathMap<T> retrieveTo(String var1);

    default public PathMap<T> retrieveTo(String ... stringArray) {
        return this.retrieveTo(this.toPath(stringArray));
    }

    default public List<String> sortedKeys() {
        ArrayList<String> arrayList = new ArrayList<String>(this.keySet());
        Collections.sort(arrayList, new PathComparator(this.getDelimiter(), PathSortStrategy.DEFAULT));
        return arrayList;
    }

    default public List<String> sortedKeys(Collection<?> collection) {
        return this.sortedKeys(this.toPath(collection));
    }

    default public List<String> sortedKeys(Object object) {
        return this.sortedKeys(this.toPath(object));
    }

    default public List<String> sortedKeys(Object ... objectArray) {
        return this.sortedKeys(this.toPath(objectArray));
    }

    default public List<String> sortedKeys(String ... stringArray) {
        return this.sortedKeys(this.toPath(stringArray));
    }

    default public List<String> sortedKeys(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(this.keySet(string));
        Collections.sort(arrayList, new PathComparator(this.getDelimiter(), PathSortStrategy.DEFAULT));
        return arrayList;
    }

    default public List<String> sortedKeys(PathSortStrategy pathSortStrategy) {
        ArrayList<String> arrayList = new ArrayList<String>(this.keySet());
        Collections.sort(arrayList, new PathComparator(this.getDelimiter(), pathSortStrategy));
        return arrayList;
    }

    default public List<String> sortedKeys(PathSortStrategy pathSortStrategy, Collection<?> collection) {
        return this.sortedKeys(pathSortStrategy, this.toPath(collection));
    }

    default public List<String> sortedKeys(PathSortStrategy pathSortStrategy, Object object) {
        return this.sortedKeys(pathSortStrategy, this.toPath(object));
    }

    default public List<String> sortedKeys(PathSortStrategy pathSortStrategy, Object ... objectArray) {
        return this.sortedKeys(pathSortStrategy, this.toPath(objectArray));
    }

    default public List<String> sortedKeys(PathSortStrategy pathSortStrategy, String ... stringArray) {
        return this.sortedKeys(pathSortStrategy, this.toPath(stringArray));
    }

    default public List<String> sortedKeys(PathSortStrategy pathSortStrategy, String string) {
        ArrayList<String> arrayList = new ArrayList<String>(this.keySet(string));
        Collections.sort(arrayList, new PathComparator(this.getDelimiter(), PathSortStrategy.DEFAULT));
        return arrayList;
    }

    default public List<String> sortedKeys(Comparator<String> comparator) {
        ArrayList<String> arrayList = new ArrayList<String>(this.keySet());
        Collections.sort(arrayList, comparator);
        return arrayList;
    }

    default public List<String> sortedKeys(Comparator<String> comparator, Collection<?> collection) {
        return this.sortedKeys(comparator, this.toPath(collection));
    }

    default public List<String> sortedKeys(Comparator<String> comparator, Object object) {
        return this.sortedKeys(comparator, this.toPath(object));
    }

    default public List<String> sortedKeys(Comparator<String> comparator, Object ... objectArray) {
        return this.sortedKeys(comparator, this.toPath(objectArray));
    }

    default public List<String> sortedKeys(Comparator<String> comparator, String ... stringArray) {
        return this.sortedKeys(comparator, this.toPath(stringArray));
    }

    default public List<String> sortedKeys(Comparator<String> comparator, String string) {
        ArrayList<String> arrayList = new ArrayList<String>(this.keySet(string));
        Collections.sort(arrayList, comparator);
        return arrayList;
    }

    default public Object toDataStructure() {
        return this.toDataStructure(this.getRootPath());
    }

    public Object toDataStructure(String var1);

    default public String toExternalPath(String string, char c) {
        if (string != null) {
            string = this.toNormalizedPath(string);
            if (c != Delimiter.PATH.getChar() && c != Delimiter.DOS_PATH.getChar()) {
                while (string.startsWith("" + this.getDelimiter())) {
                    string = string.substring(1);
                }
            }
            if (c != this.getDelimiter()) {
                string = string.replace(this.getDelimiter(), c);
            }
        }
        return string;
    }

    default public <TYPE> void toInstance(String string, TYPE TYPE) {
        try {
            TypeUtility.toInstance(this.toDataStructure(string), TYPE);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            throw new IllegalArgumentException("Cannot update the instance of type <" + TYPE.getClass().getName() + ">: " + exception.getMessage(), exception);
        }
    }

    default public <TYPE> void toInstance(TYPE TYPE) {
        this.toInstance(this.getRootPath(), TYPE);
    }

    default public String toLeaf(String string) {
        String string2 = null;
        String[] stringArray = this.toPathElements(string);
        if (stringArray != null && stringArray.length != 0) {
            string2 = stringArray[stringArray.length - 1];
        }
        return string2;
    }

    default public Map<String, ?> toMap() throws IllegalStateException {
        return this.toMap(this.getRootPath());
    }

    default public Map<String, ?> toMap(String string) throws IllegalStateException {
        string = StructureUtility.toGenericPath(this, string);
        HashMap hashMap = new HashMap();
        Set set = this.keySet();
        ArrayList arrayList = new ArrayList(set);
        Collections.sort(arrayList);
        for (String string2 : arrayList) {
            String string3;
            String[] stringArray;
            if (!string2.startsWith(string) || string2.length() <= string.length() || (stringArray = (string3 = string2.substring(string.length() + 1)).split(this.getRootPath())).length <= 0) continue;
            Object object = hashMap;
            int n = 0;
            Iterator<String> iterator = Arrays.asList(stringArray).iterator();
            while (iterator.hasNext()) {
                Object object2;
                Object object3;
                Object object4;
                Object v;
                String string4 = iterator.next();
                ++n;
                if (iterator.hasNext()) {
                    try {
                        v = object.get(string4);
                        if (v != null) {
                            object4 = null;
                            if (v instanceof Map) {
                                object = (Map)v;
                                continue;
                            }
                            if (v.getClass().isArray()) {
                                for (Object object5 : object3 = (Object[])v) {
                                    if (!(object5 instanceof Map)) continue;
                                    object4 = (Map)object5;
                                    break;
                                }
                                if (object4 == null) {
                                    object2 = Arrays.asList(object3);
                                    object4 = new HashMap();
                                    object2.add(object4);
                                    object.put(string4, object2.toArray());
                                    object = object4;
                                    continue;
                                }
                                object = object4;
                                continue;
                            }
                            object3 = new ArrayList();
                            object3.add(v);
                            object4 = new HashMap();
                            object3.add(object4);
                            object.put(string4, object3.toArray());
                            object = object4;
                            continue;
                        }
                        object4 = new HashMap();
                        object.put(string4, object4);
                        object = object4;
                        continue;
                    }
                    catch (ClassCastException classCastException) {
                        throw new IllegalStateException("There is already a value for path element <" + string4 + "> (at a path depth of <" + n + ">) in the path <" + string2 + ">, unable to create an according nested Map in that position for succeeding path elements!");
                    }
                }
                v = object.get(string4);
                object4 = this.get((Object)string2);
                if (v != null) {
                    object3 = null;
                    if (v.getClass().isArray()) {
                        object2 = (Object[])v;
                        List<Object> list = Arrays.asList(object2);
                        list.add(object4);
                        object.put(string4, list.toArray());
                        object = object3;
                        continue;
                    }
                    object2 = new ArrayList();
                    object2.add(v);
                    object2.add(object4);
                    object.put(string4, object2.toArray());
                    continue;
                }
                object.put(string4, object4);
            }
        }
        return hashMap;
    }

    default public String toNormalizedPath(String object) {
        if (object != null) {
            String string = "" + this.getDelimiter() + this.getDelimiter();
            while (((String)object).contains(string)) {
                object = ((String)object).replaceAll(Pattern.quote(string), "" + this.getDelimiter());
            }
            if (!((String)object).startsWith("" + this.getDelimiter())) {
                object = this.getDelimiter() + (String)object;
            }
            while (((String)object).endsWith("" + this.getDelimiter())) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
        }
        if (object == null || ((String)object).length() == 0) {
            object = this.getRootPath();
        }
        return object;
    }

    default public String toParentPath(String string) {
        if ((string = this.toNormalizedPath(string)) != null && string.equals(this.getRootPath())) {
            throw new IllegalArgumentException("The path \"" + string + "\" does not have a parent path!");
        }
        int n = string.lastIndexOf(this.getDelimiter());
        if ((string = string.substring(0, n)).length() == 0) {
            string = this.getRootPath();
        }
        return string;
    }

    default public String toPath(Collection<?> collection) {
        if (collection != null) {
            return this.toPath(collection.toArray(new Object[collection.size()]));
        }
        return null;
    }

    default public String toPath(Object object) {
        return this.toNormalizedPath(object instanceof String ? (String)object : (object != null ? object.toString() : (String)null));
    }

    default public String toPath(Object ... objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Object object : objectArray) {
            String string;
            if (object == null) continue;
            if (object instanceof Collection) {
                string = this.toPath((Collection)object);
            } else if (object instanceof Object[]) {
                string = this.toPath((Object[])object);
            } else {
                String string2 = object instanceof String ? (String)object : (string = object != null ? object.toString() : null);
            }
            while (string != null && string.length() > 0 && string.charAt(0) == this.getDelimiter()) {
                string = string.substring(1);
            }
            while (string != null && string.length() > 0 && string.charAt(string.length() - 1) == this.getDelimiter()) {
                string = string.substring(0, string.length() - 1);
            }
            stringBuffer.append(string);
            stringBuffer.append(this.getDelimiter());
        }
        return this.toNormalizedPath(stringBuffer.toString());
    }

    default public String toPath(String ... stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String string;
            for (string = stringArray2[i]; string != null && string.length() > 0 && string.charAt(0) == this.getDelimiter(); string = string.substring(1)) {
            }
            while (string != null && string.length() > 0 && string.charAt(string.length() - 1) == this.getDelimiter()) {
                string = string.substring(0, string.length() - 1);
            }
            stringBuffer.append(string);
            stringBuffer.append(this.getDelimiter());
        }
        return this.toNormalizedPath(stringBuffer.toString());
    }

    default public String[] toPathElements(String string) {
        String[] stringArray = null;
        if (string != null && string.length() != 0) {
            while (string.startsWith(this.getRootPath())) {
                string = string.substring(1);
            }
            while (string.endsWith(this.getRootPath())) {
                string = string.substring(0, string.length() - 1);
            }
            if (string.length() != 0) {
                stringArray = string.split(Pattern.quote("" + this.getDelimiter()));
            }
        }
        return stringArray;
    }

    default public List<String> toPathList(String string) {
        return new ArrayList<String>(Arrays.asList(this.toPathElements(string)));
    }

    default public Stack<String> toPathStack(String string) {
        Stack<String> stack = new Stack<String>();
        String[] stringArray = this.toPathElements(string);
        if (stringArray != null) {
            stack.addAll(Arrays.asList(stringArray));
        }
        return stack;
    }

    default public String toPropertyPath(String string) {
        if (string != null) {
            while (string.startsWith(this.getRootPath())) {
                string = string.substring(1);
            }
            while (string.endsWith(this.getRootPath())) {
                string = string.substring(0, string.length() - 1);
            }
            return string;
        }
        return null;
    }

    default public <TYPE> TYPE toType(Class<TYPE> clazz) {
        return this.toType(this.getRootPath(), clazz);
    }

    default public <TYPE> TYPE toType(Object object, Class<TYPE> clazz) {
        return this.toType(this.toPath(object), clazz);
    }

    default public <TYPE> TYPE toType(Object[] objectArray, Class<TYPE> clazz) {
        return this.toType(this.toPath(objectArray), clazz);
    }

    default public <TYPE> TYPE toType(Class<TYPE> clazz, Object ... objectArray) {
        return this.toType(this.toPath(objectArray), clazz);
    }

    default public <TYPE> TYPE toType(String[] stringArray, Class<TYPE> clazz) {
        return this.toType(this.toPath(stringArray), clazz);
    }

    default public <TYPE> TYPE toType(Class<TYPE> clazz, String ... stringArray) {
        return this.toType(this.toPath(stringArray), clazz);
    }

    default public <TYPE> TYPE toType(Collection<?> collection, Class<TYPE> clazz) {
        return this.toType(this.toPath(collection), clazz);
    }

    default public <TYPE> TYPE toType(String string, Class<TYPE> clazz) {
        try {
            Object object;
            Object object2 = this.get((Object)string);
            if (object2 != null) {
                try {
                    if (object2 instanceof String) {
                        object = Class.forName((String)object2);
                        if (object != null && clazz.isAssignableFrom((Class<?>)object)) {
                            clazz = object;
                        }
                    } else if (object2 instanceof Class && clazz.isAssignableFrom((Class<?>)(object = (Class)object2))) {
                        clazz = object;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            object2 = this.toDataStructure(string);
            if (SimpleType.isSimpleType(clazz) && this.getRootPath().equals(string) && object2 instanceof Map && (object = (Map)object2).size() == 1 && object.containsKey("")) {
                return (TYPE)TypeUtility.toType(object.get(""), clazz);
            }
            return TypeUtility.toType(object2, clazz);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            throw new IllegalArgumentException("Cannot create an instance of type <" + clazz.getName() + ">: " + exception.getMessage(), exception);
        }
    }

    private /* synthetic */ void lambda$queryTo$4(PathMatcher pathMatcher, PathMapBuilder pathMapBuilder, String string) {
        if (pathMatcher.isMatching(string)) {
            pathMapBuilder.put(string, this.get((Object)string));
        }
    }

    public static interface PathMapBuilder<T>
    extends MutablePathMap<T>,
    Dictionary.MutableDictionary.DictionaryBuilder<String, T, PathMapBuilder<T>> {
        default public PathMapBuilder<T> withInsert(Object object) {
            this.insert(object);
            return this;
        }

        default public PathMapBuilder<T> withInsert(PathMap<T> pathMap) {
            this.insert((Object)pathMap);
            return this;
        }

        default public PathMapBuilder<T> withInsertBetween(Collection<?> collection, Object object, Collection<?> collection2) {
            this.insertBetween(collection, object, collection2);
            return this;
        }

        default public PathMapBuilder<T> withInsertBetween(Collection<?> collection, PathMap<T> pathMap, Collection<?> collection2) {
            this.insertBetween(collection, (Object)pathMap, collection2);
            return this;
        }

        default public PathMapBuilder<T> withInsertBetween(Object object, Object object2, Object object3) {
            this.insertBetween(object, object2, object3);
            return this;
        }

        default public PathMapBuilder<T> withInsertBetween(Object object, PathMap<T> pathMap, Object object2) {
            this.insertBetween(object, (Object)pathMap, object2);
            return this;
        }

        default public PathMapBuilder<T> withInsertBetween(Object[] objectArray, Object object, Object[] objectArray2) {
            this.insertBetween(objectArray, object, objectArray2);
            return this;
        }

        default public PathMapBuilder<T> withInsertBetween(Object[] objectArray, PathMap<T> pathMap, Object[] objectArray2) {
            this.insertBetween(objectArray, (Object)pathMap, objectArray2);
            return this;
        }

        default public PathMapBuilder<T> withInsertBetween(String string, Object object, String string2) {
            this.insertBetween(string, object, string2);
            return this;
        }

        default public PathMapBuilder<T> withInsertBetween(String string, PathMap<T> pathMap, String string2) {
            this.insertBetween(string, (Object)pathMap, string2);
            return this;
        }

        default public PathMapBuilder<T> withInsertBetween(String[] stringArray, Object object, String[] stringArray2) {
            this.insertBetween(stringArray, object, stringArray2);
            return this;
        }

        default public PathMapBuilder<T> withInsertBetween(String[] stringArray, PathMap<T> pathMap, String[] stringArray2) {
            this.insertBetween(stringArray, (Object)pathMap, stringArray2);
            return this;
        }

        default public PathMapBuilder<T> withInsertFrom(Object object, Collection<?> collection) {
            this.insertFrom(object, collection);
            return this;
        }

        default public PathMapBuilder<T> withInsertFrom(Object object, Object object2) {
            this.insertFrom(object, object2);
            return this;
        }

        default public PathMapBuilder<T> withInsertFrom(Object object, Object ... objectArray) {
            this.insertFrom(object, objectArray);
            return this;
        }

        default public PathMapBuilder<T> withInsertFrom(Object object, String string) {
            this.insertFrom(object, string);
            return this;
        }

        default public PathMapBuilder<T> withInsertFrom(Object object, String ... stringArray) {
            this.insertFrom(object, stringArray);
            return this;
        }

        default public PathMapBuilder<T> withInsertFrom(PathMap<T> pathMap, Collection<?> collection) {
            this.insertFrom(pathMap, collection);
            return this;
        }

        default public PathMapBuilder<T> withInsertFrom(PathMap<T> pathMap, Object object) {
            this.insertFrom(pathMap, object);
            return this;
        }

        default public PathMapBuilder<T> withInsertFrom(PathMap<T> pathMap, Object ... objectArray) {
            this.insertFrom((Object)pathMap, objectArray);
            return this;
        }

        default public PathMapBuilder<T> withInsertFrom(PathMap<T> pathMap, String string) {
            this.insertFrom(pathMap, string);
            return this;
        }

        default public PathMapBuilder<T> withInsertFrom(PathMap<T> pathMap, String ... stringArray) {
            this.insertFrom((Object)pathMap, stringArray);
            return this;
        }

        default public PathMapBuilder<T> withInsertTo(Collection<?> collection, Object object) {
            this.insertTo(collection, object);
            return this;
        }

        default public PathMapBuilder<T> withInsertTo(Collection<?> collection, PathMap<T> pathMap) {
            this.insertTo(collection, (Object)pathMap);
            return this;
        }

        default public PathMapBuilder<T> withInsertTo(Object object, Object object2) {
            this.insertTo(object, object2);
            return this;
        }

        default public PathMapBuilder<T> withInsertTo(Object object, PathMap<T> pathMap) {
            this.insertTo(object, pathMap);
            return this;
        }

        default public PathMapBuilder<T> withInsertTo(Object[] objectArray, Object object) {
            this.insertTo(objectArray, object);
            return this;
        }

        default public PathMapBuilder<T> withInsertTo(Object[] objectArray, PathMap<T> pathMap) {
            this.insertTo(objectArray, pathMap);
            return this;
        }

        default public PathMapBuilder<T> withInsertTo(String string, Object object) {
            this.insertTo(string, object);
            return this;
        }

        default public PathMapBuilder<T> withInsertTo(String string, PathMap<T> pathMap) {
            this.insertTo(string, pathMap);
            return this;
        }

        default public PathMapBuilder<T> withInsertTo(String[] stringArray, Object object) {
            this.insertTo(stringArray, object);
            return this;
        }

        default public PathMapBuilder<T> withInsertTo(String[] stringArray, PathMap<T> pathMap) {
            this.insertTo(stringArray, pathMap);
            return this;
        }

        default public PathMapBuilder<T> withMerge(Object object) {
            this.merge(object);
            return this;
        }

        default public PathMapBuilder<T> withMerge(PathMap<T> pathMap) {
            this.merge((Object)pathMap);
            return this;
        }

        default public PathMapBuilder<T> withMergeBetween(Collection<?> collection, Object object, Collection<?> collection2) {
            this.mergeBetween(collection, object, collection2);
            return this;
        }

        default public PathMapBuilder<T> withMergeBetween(Collection<?> collection, PathMap<T> pathMap, Collection<?> collection2) {
            this.mergeBetween(collection, (Object)pathMap, collection2);
            return this;
        }

        default public PathMapBuilder<T> withMergeBetween(Object object, Object object2, Object object3) {
            this.mergeBetween(object, object2, object3);
            return this;
        }

        default public PathMapBuilder<T> withMergeBetween(Object object, PathMap<T> pathMap, Object object2) {
            this.mergeBetween(object, (Object)pathMap, object2);
            return this;
        }

        default public PathMapBuilder<T> withMergeBetween(Object[] objectArray, Object object, Object[] objectArray2) {
            this.mergeBetween(objectArray, object, objectArray2);
            return this;
        }

        default public PathMapBuilder<T> withMergeBetween(Object[] objectArray, PathMap<T> pathMap, Object[] objectArray2) {
            this.mergeBetween(objectArray, (Object)pathMap, objectArray2);
            return this;
        }

        default public PathMapBuilder<T> withMergeBetween(String string, Object object, String string2) {
            this.mergeBetween(string, object, string2);
            return this;
        }

        default public PathMapBuilder<T> withMergeBetween(String string, PathMap<T> pathMap, String string2) {
            this.mergeBetween(string, (Object)pathMap, string2);
            return this;
        }

        default public PathMapBuilder<T> withMergeBetween(String[] stringArray, Object object, String[] stringArray2) {
            this.mergeBetween(stringArray, object, stringArray2);
            return this;
        }

        default public PathMapBuilder<T> withMergeBetween(String[] stringArray, PathMap<T> pathMap, String[] stringArray2) {
            this.mergeBetween(stringArray, (Object)pathMap, stringArray2);
            return this;
        }

        default public PathMapBuilder<T> withMergeFrom(Object object, Collection<?> collection) {
            this.mergeFrom(object, collection);
            return this;
        }

        default public PathMapBuilder<T> withMergeFrom(Object object, Object object2) {
            this.mergeFrom(object, object2);
            return this;
        }

        default public PathMapBuilder<T> withMergeFrom(Object object, Object ... objectArray) {
            this.mergeFrom(object, objectArray);
            return this;
        }

        default public PathMapBuilder<T> withMergeFrom(Object object, String string) {
            this.mergeFrom(object, string);
            return this;
        }

        default public PathMapBuilder<T> withMergeFrom(Object object, String ... stringArray) {
            this.mergeFrom(object, stringArray);
            return this;
        }

        default public PathMapBuilder<T> withMergeFrom(PathMap<T> pathMap, Collection<?> collection) {
            this.mergeFrom(pathMap, collection);
            return this;
        }

        default public PathMapBuilder<T> withMergeFrom(PathMap<T> pathMap, Object object) {
            this.mergeFrom(pathMap, object);
            return this;
        }

        default public PathMapBuilder<T> withMergeFrom(PathMap<T> pathMap, Object ... objectArray) {
            this.mergeFrom((Object)pathMap, objectArray);
            return this;
        }

        default public PathMapBuilder<T> withMergeFrom(PathMap<T> pathMap, String string) {
            this.mergeFrom(pathMap, string);
            return this;
        }

        default public PathMapBuilder<T> withMergeFrom(PathMap<T> pathMap, String ... stringArray) {
            this.mergeFrom((Object)pathMap, stringArray);
            return this;
        }

        default public PathMapBuilder<T> withMergeTo(Collection<?> collection, Object object) {
            this.mergeTo(collection, object);
            return this;
        }

        default public PathMapBuilder<T> withMergeTo(Collection<?> collection, PathMap<T> pathMap) {
            this.mergeTo(collection, pathMap);
            return this;
        }

        default public PathMapBuilder<T> withMergeTo(Object object, Object object2) {
            this.mergeTo(object, object2);
            return this;
        }

        default public PathMapBuilder<T> withMergeTo(Object object, PathMap<T> pathMap) {
            this.mergeTo(object, pathMap);
            return this;
        }

        default public PathMapBuilder<T> withMergeTo(Object[] objectArray, Object object) {
            this.mergeTo(objectArray, object);
            return this;
        }

        default public PathMapBuilder<T> withMergeTo(Object[] objectArray, PathMap<T> pathMap) {
            this.mergeTo(objectArray, pathMap);
            return this;
        }

        default public PathMapBuilder<T> withMergeTo(String string, Object object) {
            this.mergeTo(string, object);
            return this;
        }

        default public PathMapBuilder<T> withMergeTo(String string, PathMap<T> pathMap) {
            this.mergeTo(string, pathMap);
            return this;
        }

        default public PathMapBuilder<T> withMergeTo(String[] stringArray, Object object) {
            this.mergeTo(stringArray, object);
            return this;
        }

        default public PathMapBuilder<T> withMergeTo(String[] stringArray, PathMap<T> pathMap) {
            this.mergeTo(stringArray, pathMap);
            return this;
        }

        @Override
        default public PathMapBuilder<T> withPut(Collection<?> collection, T t) {
            this.put(this.toPath(collection), t);
            return this;
        }

        @Override
        default public PathMapBuilder<T> withPut(Object[] objectArray, T t) {
            this.put(this.toPath(objectArray), t);
            return this;
        }

        @Override
        default public PathMapBuilder<T> withPut(Relation<String, T> relation) {
            this.put(relation);
            return this;
        }

        @Override
        default public PathMapBuilder<T> withPut(String[] stringArray, T t) {
            this.put(this.toPath(stringArray), t);
            return this;
        }

        default public PathMap<T> withPutDirAt(Collection<?> collection, int n, Object object) throws IllegalArgumentException {
            this.putDirAt(collection, n, object);
            return this;
        }

        default public PathMap<T> withPutDirAt(Collection<?> collection, int n, PathMap<T> pathMap) throws IllegalArgumentException {
            this.putDirAt(collection, n, pathMap);
            return this;
        }

        default public PathMap<T> withPutDirAt(int n, Object object) throws IllegalArgumentException {
            this.putDirAt(n, object);
            return this;
        }

        default public PathMap<T> withPutDirAt(int n, PathMap<T> pathMap) throws IllegalArgumentException {
            this.putDirAt(n, pathMap);
            return this;
        }

        default public PathMap<T> withPutDirAt(Object object, int n, Object object2) throws IllegalArgumentException {
            this.putDirAt(object, n, object2);
            return this;
        }

        default public PathMap<T> withPutDirAt(Object object, int n, PathMap<T> pathMap) throws IllegalArgumentException {
            this.putDirAt(object, n, pathMap);
            return this;
        }

        default public PathMap<T> withPutDirAt(Object[] objectArray, int n, Object object) throws IllegalArgumentException {
            this.putDirAt(objectArray, n, object);
            return this;
        }

        default public PathMap<T> withPutDirAt(Object[] objectArray, int n, PathMap<T> pathMap) throws IllegalArgumentException {
            this.putDirAt(objectArray, n, pathMap);
            return this;
        }

        default public PathMap<T> withPutDirAt(String string, int n, Object object) throws IllegalArgumentException {
            this.putDirAt(string, n, object);
            return this;
        }

        default public PathMap<T> withPutDirAt(String string, int n, PathMap<T> pathMap) throws IllegalArgumentException {
            this.putDirAt(string, n, pathMap);
            return this;
        }

        default public PathMap<T> withPutDirAt(String[] stringArray, int n, Object object) throws IllegalArgumentException {
            this.putDirAt(stringArray, n, object);
            return this;
        }

        default public PathMap<T> withPutDirAt(String[] stringArray, int n, PathMap<T> pathMap) throws IllegalArgumentException {
            this.putDirAt(stringArray, n, pathMap);
            return this;
        }

        default public PathMapBuilder<T> withRemoveFrom(Collection<?> collection) {
            this.removeFrom(collection);
            return this;
        }

        default public PathMapBuilder<T> withRemoveFrom(Object object) {
            this.removeFrom(object);
            return this;
        }

        default public PathMapBuilder<T> withRemoveFrom(Object ... objectArray) {
            this.removeFrom(objectArray);
            return this;
        }

        default public PathMapBuilder<T> withRemoveFrom(String string) {
            this.removeFrom(string);
            return this;
        }

        default public PathMapBuilder<T> withRemoveFrom(String ... stringArray) {
            this.removeFrom(stringArray);
            return this;
        }

        default public PathMapBuilder<T> withRemovePaths(String ... stringArray) {
            this.removePaths(stringArray);
            return this;
        }
    }

    public static interface MutablePathMap<T>
    extends PathMap<T>,
    Dictionary.MutableDictionary<String, T>,
    Map<String, T> {
        default public void add(Collection<?> collection, T t) {
            this.add(this.toPath(collection), t);
        }

        default public void add(Object object, T t) {
            this.add(this.toPath(object), t);
        }

        default public void add(Object[] objectArray, T t) {
            this.add(this.toPath(objectArray), t);
        }

        default public void add(String string, T t) {
            if (this.containsKey((Object)string)) {
                int n;
                Object object = this.remove(string);
                if (this.isArray(string)) {
                    n = this.lastArrayIndex(string);
                    if (n == -1) {
                        n = 0;
                    }
                } else {
                    n = 0;
                }
                this.putValueAt(string, n, object);
                this.appendValueTo(string, t);
            } else if (this.isArray(string)) {
                this.appendValueTo(string, t);
            } else {
                this.put(string, t);
            }
        }

        default public void add(String[] stringArray, T t) {
            this.add(this.toPath(stringArray), t);
        }

        default public void add(T t) {
            this.add(this.getRootPath(), t);
        }

        default public void appendDirTo(Collection<?> collection, Object object) throws IllegalArgumentException {
            this.appendDirTo(this.toPath(collection), object);
        }

        default public void appendDirTo(Collection<?> collection, PathMap<T> pathMap) throws IllegalArgumentException {
            this.appendDirTo(this.toPath(collection), pathMap);
        }

        default public void appendDirTo(Object object) throws IllegalArgumentException {
            this.appendDirTo(this.getRootPath(), object);
        }

        default public void appendDirTo(Object object, Object object2) throws IllegalArgumentException {
            this.appendDirTo(this.toPath(object), (PathMap<T>)new PathMapImpl(object2, this.getDelimiter(), this.getType()));
        }

        default public void appendDirTo(Object object, PathMap<T> pathMap) throws IllegalArgumentException {
            this.appendDirTo(this.toPath(object), pathMap);
        }

        default public void appendDirTo(Object[] objectArray, Object object) throws IllegalArgumentException {
            this.appendDirTo(this.toPath(objectArray), object);
        }

        default public void appendDirTo(Object[] objectArray, PathMap<T> pathMap) throws IllegalArgumentException {
            this.appendDirTo(this.toPath(objectArray), pathMap);
        }

        default public void appendDirTo(PathMap<T> pathMap) throws IllegalArgumentException {
            this.appendDirTo(this.getRootPath(), pathMap);
        }

        default public void appendDirTo(String string, Object object) throws IllegalArgumentException {
            this.appendDirTo(string, (PathMap<T>)new PathMapImpl(object, this.getDelimiter(), this.getType()));
        }

        default public void appendDirTo(String string, PathMap<T> pathMap) throws IllegalArgumentException {
            int n = this.nextDirIndex(string);
            for (String string2 : pathMap.keySet()) {
                this.put(this.toPath(string, n, string2), pathMap.get((Object)string2));
            }
        }

        default public void appendDirTo(String[] stringArray, Object object) throws IllegalArgumentException {
            this.appendDirTo(this.toPath(stringArray), object);
        }

        default public void appendDirTo(String[] stringArray, PathMap<T> pathMap) throws IllegalArgumentException {
            this.appendDirTo(this.toPath(stringArray), pathMap);
        }

        default public void appendValueTo(Collection<?> collection, T t) throws IllegalArgumentException {
            this.appendValueTo(this.toPath(collection), t);
        }

        default public void appendValueTo(Object object, T t) throws IllegalArgumentException {
            this.appendValueTo(this.toPath(object), t);
        }

        default public void appendValueTo(Object[] objectArray, T t) throws IllegalArgumentException {
            this.appendValueTo(this.toPath(objectArray), t);
        }

        default public void appendValueTo(String string, T t) throws IllegalArgumentException {
            int n = this.nextArrayIndex(string);
            this.put(this.toPath(string, n), t);
        }

        default public void appendValueTo(String[] stringArray, T t) throws IllegalArgumentException {
            this.appendValueTo(this.toPath(stringArray), t);
        }

        default public void appendValueTo(T t) throws IllegalArgumentException {
            this.appendValueTo(this.getRootPath(), t);
        }

        default public T delete(Collection<?> collection) {
            return (T)this.remove(this.toPath(collection));
        }

        default public T delete(Object object) {
            return (T)this.remove(this.toPath(object));
        }

        default public T delete(Object[] objectArray) {
            return (T)this.remove(this.toPath(objectArray));
        }

        @Override
        default public T delete(String string) {
            return (T)this.remove(string);
        }

        default public T delete(String[] stringArray) {
            return (T)this.remove(this.toPath(stringArray));
        }

        public void insert(Object var1);

        default public void insert(PathMap<T> pathMap) {
            this.insert((Object)pathMap);
        }

        default public void insertBetween(Collection<?> collection, Object object, Collection<?> collection2) {
            this.insertBetween(this.toPath(collection), object, this.toPath(collection2));
        }

        default public void insertBetween(Collection<?> collection, PathMap<T> pathMap, Collection<?> collection2) {
            this.insertBetween(this.toPath(collection), (Object)pathMap, this.toPath(collection2));
        }

        default public void insertBetween(Object object, Object object2, Object object3) {
            this.insertBetween(this.toPath(object), object2, this.toPath(object3));
        }

        default public void insertBetween(Object object, PathMap<T> pathMap, Object object2) {
            this.insertBetween(this.toPath(object), (Object)pathMap, this.toPath(object2));
        }

        default public void insertBetween(Object[] objectArray, Object object, Object[] objectArray2) {
            this.insertBetween(this.toPath(objectArray), object, this.toPath(objectArray2));
        }

        default public void insertBetween(Object[] objectArray, PathMap<T> pathMap, Object[] objectArray2) {
            this.insertBetween(this.toPath(objectArray), (Object)pathMap, this.toPath(objectArray2));
        }

        public void insertBetween(String var1, Object var2, String var3);

        default public void insertBetween(String string, PathMap<T> pathMap, String string2) {
            this.insertBetween(string, (Object)pathMap, string2);
        }

        default public void insertBetween(String[] stringArray, Object object, String[] stringArray2) {
            this.insertBetween(this.toPath(stringArray), object, this.toPath(stringArray2));
        }

        default public void insertBetween(String[] stringArray, PathMap<T> pathMap, String[] stringArray2) {
            this.insertBetween(this.toPath(stringArray), (Object)pathMap, this.toPath(stringArray2));
        }

        default public void insertFrom(Object object, Collection<?> collection) {
            this.insertFrom(object, this.toPath(collection));
        }

        default public void insertFrom(Object object, Object object2) {
            this.insertFrom(object, this.toPath(object2));
        }

        default public void insertFrom(Object object, Object ... objectArray) {
            this.insertFrom(object, this.toPath(objectArray));
        }

        public void insertFrom(Object var1, String var2);

        default public void insertFrom(Object object, String ... stringArray) {
            this.insertFrom(object, this.toPath(stringArray));
        }

        default public void insertFrom(PathMap<T> pathMap, Collection<?> collection) {
            this.insertFrom((Object)pathMap, this.toPath(collection));
        }

        default public void insertFrom(PathMap<T> pathMap, Object object) {
            this.insertFrom((Object)pathMap, this.toPath(object));
        }

        default public void insertFrom(PathMap<T> pathMap, Object ... objectArray) {
            this.insertFrom((Object)pathMap, this.toPath(objectArray));
        }

        default public void insertFrom(PathMap<T> pathMap, String string) {
            this.insertFrom((Object)pathMap, string);
        }

        default public void insertFrom(PathMap<T> pathMap, String ... stringArray) {
            this.insertFrom((Object)pathMap, this.toPath(stringArray));
        }

        default public void insertTo(Collection<?> collection, Object object) {
            this.insertTo(this.toPath(collection), object);
        }

        default public void insertTo(Collection<?> collection, PathMap<T> pathMap) {
            this.insertTo(this.toPath(collection), (Object)pathMap);
        }

        default public void insertTo(Object object, Object object2) {
            this.insertTo(this.toPath(object), object2);
        }

        default public void insertTo(Object object, PathMap<T> pathMap) {
            this.insertTo(this.toPath(object), (Object)pathMap);
        }

        default public void insertTo(Object[] objectArray, Object object) {
            this.insertTo(this.toPath(objectArray), object);
        }

        default public void insertTo(Object[] objectArray, PathMap<T> pathMap) {
            this.insertTo(this.toPath(objectArray), (Object)pathMap);
        }

        public void insertTo(String var1, Object var2);

        default public void insertTo(String string, PathMap<T> pathMap) {
            this.insertTo(string, (Object)pathMap);
        }

        default public void insertTo(String[] stringArray, Object object) {
            this.insertTo(this.toPath(stringArray), object);
        }

        default public void insertTo(String[] stringArray, PathMap<T> pathMap) {
            this.insertTo(this.toPath(stringArray), (Object)pathMap);
        }

        public void merge(Object var1);

        default public void merge(PathMap<T> pathMap) {
            this.merge((Object)pathMap);
        }

        default public void mergeBetween(Collection<?> collection, Object object, Collection<?> collection2) {
            this.mergeBetween(this.toPath(collection), object, this.toPath(collection2));
        }

        default public void mergeBetween(Collection<?> collection, PathMap<T> pathMap, Collection<?> collection2) {
            this.mergeBetween(this.toPath(collection), (Object)pathMap, this.toPath(collection2));
        }

        default public void mergeBetween(Object object, Object object2, Object object3) {
            this.mergeBetween(this.toPath(object), object2, this.toPath(object3));
        }

        default public void mergeBetween(Object object, PathMap<T> pathMap, Object object2) {
            this.mergeBetween(this.toPath(object), (Object)pathMap, this.toPath(object2));
        }

        default public void mergeBetween(Object[] objectArray, Object object, Object[] objectArray2) {
            this.mergeBetween(this.toPath(objectArray), object, this.toPath(objectArray2));
        }

        default public void mergeBetween(Object[] objectArray, PathMap<T> pathMap, Object[] objectArray2) {
            this.mergeBetween(this.toPath(objectArray), (Object)pathMap, this.toPath(objectArray2));
        }

        public void mergeBetween(String var1, Object var2, String var3);

        default public void mergeBetween(String string, PathMap<T> pathMap, String string2) {
            this.mergeBetween(string, (Object)pathMap, string2);
        }

        default public void mergeBetween(String[] stringArray, Object object, String[] stringArray2) {
            this.mergeBetween(this.toPath(stringArray), object, this.toPath(stringArray2));
        }

        default public void mergeBetween(String[] stringArray, PathMap<T> pathMap, String[] stringArray2) {
            this.mergeBetween(this.toPath(stringArray), (Object)pathMap, this.toPath(stringArray2));
        }

        default public void mergeFrom(Object object, Collection<?> collection) {
            this.mergeFrom(object, this.toPath(collection));
        }

        default public void mergeFrom(Object object, Object object2) {
            this.mergeFrom(object, this.toPath(object2));
        }

        default public void mergeFrom(Object object, Object ... objectArray) {
            this.mergeFrom(object, this.toPath(objectArray));
        }

        public void mergeFrom(Object var1, String var2);

        default public void mergeFrom(Object object, String ... stringArray) {
            this.mergeFrom(object, this.toPath(stringArray));
        }

        default public void mergeFrom(PathMap<T> pathMap, Collection<?> collection) {
            this.mergeFrom((Object)pathMap, this.toPath(collection));
        }

        default public void mergeFrom(PathMap<T> pathMap, Object object) {
            this.mergeFrom((Object)pathMap, this.toPath(object));
        }

        default public void mergeFrom(PathMap<T> pathMap, Object ... objectArray) {
            this.mergeFrom((Object)pathMap, this.toPath(objectArray));
        }

        default public void mergeFrom(PathMap<T> pathMap, String string) {
            this.mergeFrom((Object)pathMap, string);
        }

        default public void mergeFrom(PathMap<T> pathMap, String ... stringArray) {
            this.mergeFrom((Object)pathMap, this.toPath(stringArray));
        }

        default public void mergeTo(Collection<?> collection, Object object) {
            this.mergeTo(this.toPath(collection), object);
        }

        default public void mergeTo(Collection<?> collection, PathMap<T> pathMap) {
            this.mergeTo(this.toPath(collection), (Object)pathMap);
        }

        default public void mergeTo(Object object, Object object2) {
            this.mergeTo(this.toPath(object), object2);
        }

        default public void mergeTo(Object object, PathMap<T> pathMap) {
            this.mergeTo(this.toPath(object), (Object)pathMap);
        }

        default public void mergeTo(Object[] objectArray, Object object) {
            this.mergeTo(this.toPath(objectArray), object);
        }

        default public void mergeTo(Object[] objectArray, PathMap<T> pathMap) {
            this.mergeTo(this.toPath(objectArray), (Object)pathMap);
        }

        public void mergeTo(String var1, Object var2);

        default public void mergeTo(String string, PathMap<T> pathMap) {
            this.mergeTo(string, (Object)pathMap);
        }

        default public void mergeTo(String[] stringArray, Object object) {
            this.mergeTo(this.toPath(stringArray), object);
        }

        default public void mergeTo(String[] stringArray, PathMap<T> pathMap) {
            this.mergeTo(this.toPath(stringArray), (Object)pathMap);
        }

        @Override
        default public T put(Collection<?> collection, T t) {
            return (T)this.put(this.toPath(collection), t);
        }

        @Override
        default public T put(Object[] objectArray, T t) {
            return (T)this.put(this.toPath(objectArray), t);
        }

        @Override
        default public T put(Relation<String, T> relation) {
            return (T)this.put((String)relation.getKey(), relation.getValue());
        }

        @Override
        default public T put(String[] stringArray, T t) {
            return (T)this.put(this.toPath(stringArray), t);
        }

        default public T[] putArray(Collection<?> collection, Collection<T> collection2) {
            return this.putArray(this.toPath(collection), collection2);
        }

        default public T[] putArray(Collection<?> collection, T[] TArray) {
            return this.putArray(this.toPath(collection), TArray);
        }

        default public T[] putArray(Collection<T> collection) {
            return this.putArray("", collection);
        }

        default public T[] putArray(Object object, Collection<T> collection) {
            return this.putArray(this.toPath(object), collection);
        }

        default public T[] putArray(Object object, T[] TArray) {
            return this.putArray(this.toPath(object), TArray);
        }

        default public T[] putArray(Object[] objectArray, Collection<T> collection) {
            return this.putArray(this.toPath(objectArray), collection);
        }

        default public T[] putArray(Object[] objectArray, T[] TArray) {
            return this.putArray(this.toPath(objectArray), TArray);
        }

        default public T[] putArray(String string, Collection<T> collection) {
            string = this.toNormalizedPath(string);
            T[] TArray = this.getArray(string);
            this.removeFrom(string);
            if (collection != null && collection.size() != 0) {
                int n = 0;
                Iterator<T> iterator = collection.iterator();
                while (iterator.hasNext()) {
                    this.putValueAt(string, n++, iterator.next());
                }
            }
            return TArray;
        }

        default public T[] putArray(String string, T[] TArray) {
            string = this.toNormalizedPath(string);
            T[] TArray2 = this.getArray(string);
            this.removeFrom(string);
            if (TArray != null && TArray.length != 0) {
                for (int i = 0; i < TArray.length; ++i) {
                    this.putValueAt(string, i, TArray[i]);
                }
            }
            return TArray2;
        }

        default public T[] putArray(String[] stringArray, Collection<T> collection) {
            return this.putArray(this.toPath(stringArray), collection);
        }

        default public T[] putArray(String[] stringArray, T[] TArray) {
            return this.putArray(this.toPath(stringArray), TArray);
        }

        default public T[] putArray(T[] TArray) {
            return this.putArray("", TArray);
        }

        default public PathMap<T> putDirAt(Collection<?> collection, int n, Object object) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(collection), n, object);
        }

        default public PathMap<T> putDirAt(Collection<?> collection, int n, PathMap<T> pathMap) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(collection), n, pathMap);
        }

        default public PathMap<T> putDirAt(int n, Object object) throws IllegalArgumentException {
            return this.putDirAt(this.getRootPath(), n, object);
        }

        default public PathMap<T> putDirAt(int n, PathMap<T> pathMap) throws IllegalArgumentException {
            return this.putDirAt(this.getRootPath(), n, pathMap);
        }

        default public PathMap<T> putDirAt(Object object, int n, Object object2) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(object), n, object2);
        }

        default public PathMap<T> putDirAt(Object object, int n, PathMap<T> pathMap) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(object), n, pathMap);
        }

        default public PathMap<T> putDirAt(Object[] objectArray, int n, Object object) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(objectArray), n, object);
        }

        default public PathMap<T> putDirAt(Object[] objectArray, int n, PathMap<T> pathMap) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(objectArray), n, pathMap);
        }

        default public PathMap<T> putDirAt(String string, int n, Object object) throws IllegalArgumentException {
            PathMap<T> pathMap = this.removeDirAt(string, n);
            this.insertTo(this.toPath(string, n), object);
            return pathMap;
        }

        default public PathMap<T> putDirAt(String string, int n, PathMap<T> pathMap) throws IllegalArgumentException {
            PathMap<T> pathMap2 = this.removeDirAt(string, n);
            this.insertTo(this.toPath(string, n), pathMap);
            return pathMap2;
        }

        default public PathMap<T> putDirAt(String[] stringArray, int n, Object object) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(stringArray), n, object);
        }

        default public PathMap<T> putDirAt(String[] stringArray, int n, PathMap<T> pathMap) throws IllegalArgumentException {
            return this.putDirAt(this.toPath(stringArray), n, pathMap);
        }

        default public T putValueAt(Collection<?> collection, int n, T t) throws IllegalArgumentException {
            String string = this.toPath(collection, n);
            return (T)this.put(string, t);
        }

        default public T putValueAt(int n, T t) throws IllegalArgumentException {
            String string = this.toPath((Object)n);
            return (T)this.put(string, t);
        }

        default public T putValueAt(Object object, int n, T t) throws IllegalArgumentException {
            String string = this.toPath(object, n);
            return (T)this.put(string, t);
        }

        default public T putValueAt(Object[] objectArray, int n, T t) throws IllegalArgumentException {
            String string = this.toPath(objectArray, n);
            return (T)this.put(string, t);
        }

        default public T putValueAt(String string, int n, T t) throws IllegalArgumentException {
            String string2 = this.toPath(string, n);
            return (T)this.put(string2, t);
        }

        default public T putValueAt(String[] stringArray, int n, T t) throws IllegalArgumentException {
            String string = this.toPath(stringArray, n);
            return (T)this.put(string, t);
        }

        default public T remove(Object ... objectArray) {
            return (T)this.remove(this.toPath(objectArray));
        }

        default public T remove(String ... stringArray) {
            return (T)this.remove(this.toPath(stringArray));
        }

        default public T remove(String string, String string2) {
            return (T)this.remove(this.toPath(string, string2));
        }

        default public PathMap<T> removeAll(Collection<?> collection) {
            return this.removeAll(this.toPath(collection));
        }

        default public PathMap<T> removeAll(Object ... objectArray) {
            return this.removeAll(this.toPath(objectArray));
        }

        default public PathMap<T> removeAll(Object object) {
            return this.removeAll(this.toPath(object));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        default public PathMap<T> removeAll(Pattern pattern) {
            HashSet<String> hashSet = new HashSet<String>();
            for (String string : this.paths()) {
                if (!pattern.matcher(string).matches()) continue;
                HashSet<String> hashSet2 = hashSet;
                synchronized (hashSet2) {
                    hashSet.add(string);
                }
            }
            return this.removePaths(hashSet);
        }

        default public PathMap<T> removeAll(String ... stringArray) {
            return this.removeAll(this.toPath(stringArray));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        default public PathMap<T> removeAll(String string) {
            HashSet<String> hashSet = new HashSet<String>();
            PathMatcherImpl pathMatcherImpl = new PathMatcherImpl(string, this.getDelimiter());
            for (String string2 : this.paths()) {
                if (!pathMatcherImpl.isMatching(string2)) continue;
                HashSet<String> hashSet2 = hashSet;
                synchronized (hashSet2) {
                    hashSet.add(string2);
                }
            }
            return this.removePaths(hashSet);
        }

        default public PathMap<T> removeDirAt(int n) {
            return this.removeDirAt(this.getRootPath(), n);
        }

        default public PathMap<T> removeDirAt(Object object, int n) {
            return this.removeDirAt(this.toPath(object), n);
        }

        default public PathMap<T> removeDirAt(Object[] objectArray, int n) {
            return this.removeDirAt(this.toPath(objectArray), n);
        }

        default public PathMap<T> removeDirAt(String string, int n) {
            return this.removeFrom(this.toPath(string, n));
        }

        default public PathMap<T> removeDirAt(String[] stringArray, int n) {
            return this.removeDirAt(this.toPath(stringArray), n);
        }

        default public PathMap<T> removeFrom(Collection<?> collection) {
            return this.removeFrom(this.toPath(collection));
        }

        default public PathMap<T> removeFrom(Object ... objectArray) {
            return this.removeFrom(this.toPath(objectArray));
        }

        default public PathMap<T> removeFrom(Object object) {
            return this.removeFrom(this.toPath(object));
        }

        default public PathMap<T> removeFrom(String object) {
            PathMapBuilderImpl pathMapBuilderImpl = new PathMapBuilderImpl(this.getDelimiter(), this.getType());
            object = this.toNormalizedPath((String)object) + this.getDelimiter();
            Iterator<String> iterator = this.paths().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                if (!string.startsWith((String)object)) continue;
                pathMapBuilderImpl.put(string.substring(((String)object).length()), this.get((Object)string));
                iterator.remove();
            }
            return pathMapBuilderImpl;
        }

        default public PathMap<T> removeFrom(String ... stringArray) {
            return this.removeFrom(this.toPath(stringArray));
        }

        default public PathMap<T> removePaths(Collection<?> collection) {
            PathMapBuilderImpl pathMapBuilderImpl = new PathMapBuilderImpl(this.getDelimiter(), this.getType());
            for (Object obj : collection) {
                pathMapBuilderImpl.put(obj instanceof String ? (String)obj : this.toPath(obj), this.remove(obj));
            }
            return pathMapBuilderImpl;
        }

        default public PathMap<T> removePaths(String ... stringArray) {
            PathMapBuilderImpl pathMapBuilderImpl = new PathMapBuilderImpl(this.getDelimiter(), this.getType());
            for (String string : stringArray) {
                pathMapBuilderImpl.put(string, this.remove(string));
            }
            return pathMapBuilderImpl;
        }

        default public T removeValueAt(int n) {
            return this.removeValueAt(this.getRootPath(), n);
        }

        default public T removeValueAt(Object object, int n) {
            return this.removeValueAt(this.toPath(object), n);
        }

        default public T removeValueAt(Object[] objectArray, int n) {
            return this.removeValueAt(this.toPath(objectArray), n);
        }

        default public T removeValueAt(String string, int n) {
            return (T)this.remove(this.toPath(string, n));
        }

        default public T removeValueAt(String[] stringArray, int n) {
            return this.removeValueAt(this.toPath(stringArray), n);
        }

        default public String toSourceCode() {
            return this.toSourceCode(null, null);
        }

        default public String toSourceCode(String string, String string2) {
            if (string == null || string.length() == 0) {
                string = "Foo";
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (string2 != null && string2.length() != 0) {
                stringBuffer.append("package " + string2 + ";" + System.lineSeparator());
            }
            stringBuffer.append(System.lineSeparator());
            stringBuffer.append("import " + this.getClass().getName() + ";" + System.lineSeparator());
            stringBuffer.append("import " + this.getType().getName() + ";" + System.lineSeparator());
            stringBuffer.append(System.lineSeparator());
            stringBuffer.append("public class " + string + " extends " + this.getClass().getSimpleName() + " {" + System.lineSeparator());
            stringBuffer.append(System.lineSeparator());
            ArrayList arrayList = new ArrayList(this.keySet());
            Collections.sort(arrayList);
            HashSet<String> hashSet = new HashSet<String>();
            for (String string3 : arrayList) {
                boolean bl = false;
                if (this.hasParentPath(string3)) {
                    String string4 = this.toParentPath(string3);
                    if (hashSet.contains(string4)) continue;
                    if (this.isArray(string4)) {
                        hashSet.add(string4);
                        string3 = string4;
                        bl = true;
                    }
                }
                StringBuffer stringBuffer2 = new StringBuffer();
                boolean bl2 = false;
                for (int i = 0; i < string3.length(); ++i) {
                    char c = string3.charAt(i);
                    if (c == this.getDelimiter()) {
                        bl2 = true;
                        continue;
                    }
                    if (!Character.isAlphabetic(c) && !Character.isDigit(c)) continue;
                    if (bl2) {
                        stringBuffer2.append(Character.toUpperCase(c));
                    } else {
                        stringBuffer2.append(c);
                    }
                    bl2 = false;
                }
                String string5 = stringBuffer2.toString();
                if (bl) {
                    stringBuffer.append("\tpublic " + this.getType().getSimpleName() + "[] get" + string5 + "() {" + System.lineSeparator());
                    stringBuffer.append("\t\treturn getArray( \"" + string3 + "\" );" + System.lineSeparator());
                    stringBuffer.append("\t}" + System.lineSeparator());
                    stringBuffer.append(System.lineSeparator());
                    stringBuffer.append("\tpublic void set" + string5 + "(  " + this.getType().getSimpleName() + "[] aValues ) {" + System.lineSeparator());
                    stringBuffer.append("\t\tputArray( \"" + string3 + "\", aValues );" + System.lineSeparator());
                    stringBuffer.append("\t}" + System.lineSeparator());
                    stringBuffer.append(System.lineSeparator());
                    continue;
                }
                stringBuffer.append("\tpublic " + this.getType().getSimpleName() + " get" + string5 + "() {" + System.lineSeparator());
                stringBuffer.append("\t\treturn get( \"" + string3 + "\" );" + System.lineSeparator());
                stringBuffer.append("\t}" + System.lineSeparator());
                stringBuffer.append(System.lineSeparator());
                stringBuffer.append("\tpublic void set" + string5 + "( " + this.getType().getSimpleName() + " aValue ) {" + System.lineSeparator());
                stringBuffer.append("\t\tput( \"" + string3 + "\", aValue );" + System.lineSeparator());
                stringBuffer.append("\t}" + System.lineSeparator());
                stringBuffer.append(System.lineSeparator());
            }
            stringBuffer.append("}");
            return stringBuffer.toString();
        }
    }
}

