/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct;

import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.refcodes.data.Delimiter;
import org.refcodes.struct.Keys;
import org.refcodes.struct.PathMap;
import org.refcodes.struct.PathMapImpl;
import org.refcodes.struct.StructureUtility;
import org.refcodes.struct.TypeUtility;

public class PathMapBuilderImpl<T>
implements PathMap.PathMapBuilder<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean IS_DEBUG_OUTPUT = false;
    private static final String ESCAPE = "\\";
    private static final String SPECIAL_REGEX_CHARS = ".^$*+?()[{\\|";
    private static final String[] BLACKLISTED_PROPERTIES = new String[]{"class"};
    private char _delimiter;
    private char _annotator = ANNOTATOR;
    private Class<T> _type;
    protected Map<String, T> _backingMap = this.createBackingMap();

    public PathMapBuilderImpl(Class<T> clazz) {
        this(Delimiter.PATH.getChar(), clazz);
    }

    public PathMapBuilderImpl(char c, Class<T> clazz) {
        this._delimiter = c;
        this._type = clazz;
    }

    public PathMapBuilderImpl(Object object, Class<T> clazz) {
        this(object, Delimiter.PATH.getChar(), clazz);
    }

    public PathMapBuilderImpl(String string, Object object, Class<T> clazz) {
        this(string, object, Delimiter.PATH.getChar(), clazz);
    }

    public PathMapBuilderImpl(Object object, String string, Class<T> clazz) {
        this(object, string, Delimiter.PATH.getChar(), clazz);
    }

    public PathMapBuilderImpl(String string, Object object, String string2, Class<T> clazz) {
        this(string, object, string2, Delimiter.PATH.getChar(), clazz);
    }

    public PathMapBuilderImpl(Object object, char c, Class<T> clazz) {
        this(c, clazz);
        this.fromValue(this.getRootPath(), object);
    }

    public PathMapBuilderImpl(String string, Object object, char c, Class<T> clazz) {
        this(c, clazz);
        this.insertTo(string, object);
    }

    public PathMapBuilderImpl(Object object, String string, char c, Class<T> clazz) {
        this(c, clazz);
        this.insertFrom(object, string);
    }

    public PathMapBuilderImpl(String string, Object object, String string2, char c, Class<T> clazz) {
        this(c, clazz);
        this.insertBetween(string, object, string2);
    }

    @Override
    public boolean containsKey(Object object) {
        return this._backingMap.containsKey(this.toNormalizedPath(object != null ? object.toString() : null));
    }

    @Override
    public T get(Object object) {
        return this._backingMap.get(this.toNormalizedPath(object != null ? object.toString() : null));
    }

    @Override
    public T put(String string, T t) {
        Object v = null;
        if (t != null && (v = (Object)this.fromInstance(t)) == null) {
            throw new IllegalArgumentException("The key <" + string + "> cannot be set as the value <" + t + "> of type <" + t.getClass().getName() + "> is not of a supported type!");
        }
        return this._backingMap.put(this.toNormalizedPath(string), v);
    }

    @Override
    public T remove(Object object) {
        return this._backingMap.remove(this.toNormalizedPath(object != null ? object.toString() : null));
    }

    @Override
    public T getOrDefault(Object object, T t) {
        return this._backingMap.getOrDefault(this.toNormalizedPath(object != null ? object.toString() : null), t);
    }

    @Override
    public T putIfAbsent(String string, T t) {
        return this._backingMap.putIfAbsent(this.toNormalizedPath(string), t);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        return this._backingMap.remove(this.toNormalizedPath(object != null ? object.toString() : null), object2);
    }

    @Override
    public boolean replace(String string, T t, T t2) {
        return this._backingMap.replace(this.toNormalizedPath(string), t, t2);
    }

    @Override
    public T replace(String string, T t) {
        return this._backingMap.replace(this.toNormalizedPath(string), t);
    }

    @Override
    public T computeIfAbsent(String string, Function<? super String, ? extends T> function) {
        return this._backingMap.computeIfAbsent(this.toNormalizedPath(string), function);
    }

    @Override
    public T computeIfPresent(String string, BiFunction<? super String, ? super T, ? extends T> biFunction) {
        return this._backingMap.computeIfPresent(this.toNormalizedPath(string), biFunction);
    }

    @Override
    public T compute(String string, BiFunction<? super String, ? super T, ? extends T> biFunction) {
        return this._backingMap.compute(this.toNormalizedPath(string), biFunction);
    }

    @Override
    public T merge(String string, T t, BiFunction<? super T, ? super T, ? extends T> biFunction) {
        return this._backingMap.merge(this.toNormalizedPath(string), t, biFunction);
    }

    @Override
    public PathMap<T> retrieveTo(String string) {
        PathMapBuilderImpl<T> pathMapBuilderImpl = new PathMapBuilderImpl<T>(this.getDelimiter(), this._type);
        StructureUtility.retrieveTo(this, string, pathMapBuilderImpl);
        return pathMapBuilderImpl;
    }

    @Override
    public PathMap<T> retrieveFrom(String string) {
        PathMapBuilderImpl<T> pathMapBuilderImpl = new PathMapBuilderImpl<T>(this.getDelimiter(), this._type);
        StructureUtility.retrieveFrom(this, string, pathMapBuilderImpl);
        return pathMapBuilderImpl;
    }

    public char getDelimiter() {
        return this._delimiter;
    }

    public char getAnnotator() {
        return this._annotator;
    }

    public Class<T> getType() {
        return this._type;
    }

    @Override
    public Object toDataStructure(String string) {
        return StructureUtility.toDataStructure(this, string);
    }

    @Override
    public void insert(Object object) {
        PathMap<T> pathMap = this.fromObject(object);
        for (String string : pathMap.paths()) {
            this.put(string, pathMap.get((Object)string));
        }
    }

    @Override
    public void insertBetween(String string, Object object, String string2) {
        PathMap<T> pathMap = this.fromObject(object);
        this.insertTo(string, pathMap.retrieveFrom(string2));
    }

    @Override
    public void insertFrom(Object object, String string) {
        PathMap<T> pathMap = this.fromObject(object);
        pathMap = pathMap.retrieveFrom(string);
        for (String string2 : pathMap.paths()) {
            this.put(string2, pathMap.get((Object)string2));
        }
    }

    @Override
    public void insertTo(String string, Object object) {
        string = this.toNormalizedPath(string);
        if (object == null) {
            this.put(string, (T)null);
        } else {
            PathMap<T> pathMap = this.fromObject(object);
            for (String string2 : pathMap.paths()) {
                this.put(this.toPath(string, string2), pathMap.get((Object)string2));
            }
        }
    }

    @Override
    public void merge(Object object) {
        PathMap<T> pathMap = this.fromObject(object);
        for (String string : pathMap.paths()) {
            if (this.get((Object)string) != null) continue;
            this.put(string, pathMap.get((Object)string));
        }
    }

    @Override
    public void mergeBetween(String string, Object object, String string2) {
        PathMap<T> pathMap = this.fromObject(object);
        this.mergeTo(string, pathMap.retrieveFrom(string2));
    }

    @Override
    public void mergeFrom(Object object, String string) {
        PathMap<T> pathMap = this.fromObject(object);
        pathMap = pathMap.retrieveFrom(string);
        for (String string2 : pathMap.paths()) {
            if (this.get((Object)string2) != null) continue;
            this.put(string2, pathMap.get((Object)string2));
        }
    }

    @Override
    public void mergeTo(String string, Object object) {
        string = this.toNormalizedPath(string);
        if (object == null && !this.containsKey((Object)string)) {
            this.put(string, (T)null);
        } else {
            PathMap<T> pathMap = this.fromObject(object);
            for (String string2 : pathMap.paths()) {
                String string3 = this.toPath(string, string2);
                if (this.get((Object)string3) != null) continue;
                this.put(string3, pathMap.get((Object)string2));
            }
        }
    }

    @Override
    public PathMap.PathMapBuilder<T> withPut(String string, T t) {
        this.put(string, t);
        return this;
    }

    @Override
    public int size() {
        return this._backingMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this._backingMap.isEmpty();
    }

    @Override
    public boolean containsValue(Object object) {
        return this._backingMap.containsValue(object);
    }

    @Override
    public void putAll(Map<? extends String, ? extends T> map) {
        this._backingMap.putAll(map);
    }

    @Override
    public void clear() {
        this._backingMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this._backingMap.keySet();
    }

    @Override
    public Collection<T> values() {
        return this._backingMap.values();
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return this._backingMap.entrySet();
    }

    @Override
    public boolean equals(Object object) {
        return this._backingMap.equals(object);
    }

    @Override
    public int hashCode() {
        return this._backingMap.hashCode();
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super T> biConsumer) {
        this._backingMap.forEach(biConsumer);
    }

    @Override
    public void replaceAll(BiFunction<? super String, ? super T, ? extends T> biFunction) {
        this._backingMap.replaceAll(biFunction);
    }

    @Override
    public <TYPE> TYPE toType(String string, Class<TYPE> clazz) {
        TYPE TYPE;
        T t = this.get((Object)string);
        if (t != null && !this.hasChildren(string) && (TYPE = this.toInstance(t, clazz)) != null) {
            return TYPE;
        }
        return PathMap.PathMapBuilder.super.toType(string, clazz);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this._backingMap.toString();
    }

    private void fromPathMap(String string, PathMap<?> pathMap, Set<Object> set) {
        if (!set.contains(pathMap)) {
            set.add(pathMap);
            String string2 = "" + pathMap.getDelimiter();
            if (SPECIAL_REGEX_CHARS.contains(string2)) {
                string2 = ESCAPE + string2;
            }
            for (String string3 : pathMap.paths()) {
                String string4 = this.toPath(string, string3.replaceAll(string2, this.getRootPath()));
                Object v = pathMap.get((Object)string3);
                this.fromValue(string4, v, set);
            }
            set.remove(pathMap);
        }
    }

    private void fromMap(String string, Map<?, ?> map, Set<Object> set) {
        if (!set.contains(map)) {
            set.add(map);
            for (Object obj : map.keySet()) {
                String string2 = obj instanceof String ? (String)obj : (obj != null ? obj.toString() : null);
                String string3 = this.toPath(string, string2);
                Object obj2 = map.get(obj);
                this.fromValue(string3, obj2, set);
            }
            set.remove(map);
        }
    }

    private void fromKeys(String string, Keys<?, ?> keys, Set<Object> set) {
        if (!set.contains(keys)) {
            set.add(keys);
            for (Object obj : keys.keySet()) {
                String string2 = obj instanceof String ? (String)obj : (obj != null ? obj.toString() : null);
                String string3 = this.toPath(string, string2);
                Object obj2 = keys.get(obj);
                this.fromValue(string3, obj2, set);
            }
            set.remove(keys);
        }
    }

    private void fromCollection(String string, Collection<?> collection, Set<Object> set) {
        if (!set.contains(collection)) {
            set.add(collection);
            int n = 0;
            for (Object obj : collection) {
                String string2 = this.toPath(string, n);
                this.fromValue(string2, obj, set);
                ++n;
            }
            set.remove(collection);
        }
    }

    private void fromArray(String string, Object[] objectArray, Set<Object> set) {
        if (!set.contains(objectArray)) {
            set.add(objectArray);
            int n = 0;
            for (Object object : objectArray) {
                String string2 = this.toPath(string, n);
                this.fromValue(string2, object, set);
                ++n;
            }
            set.remove(objectArray);
        }
    }

    private void fromArray(String string, boolean[] blArray, Set<Object> set) {
        if (!set.contains(blArray) && !set.contains(blArray)) {
            set.add(blArray);
            int n = 0;
            boolean[] blArray2 = blArray;
            int n2 = blArray2.length;
            for (int i = 0; i < n2; ++i) {
                Boolean bl = blArray2[i];
                String string2 = this.toPath(string, n);
                this.fromValue(string2, bl, set);
                ++n;
            }
            set.remove(blArray);
        }
    }

    private void fromArray(String string, byte[] byArray, Set<Object> set) {
        if (!set.contains(byArray)) {
            set.add(byArray);
            int n = 0;
            byte[] byArray2 = byArray;
            int n2 = byArray2.length;
            for (int i = 0; i < n2; ++i) {
                Byte by = byArray2[i];
                String string2 = this.toPath(string, n);
                this.fromValue(string2, by, set);
                ++n;
            }
            set.remove(byArray);
        }
    }

    private void fromArray(String string, char[] cArray, Set<Object> set) {
        if (!set.contains(cArray)) {
            set.add(cArray);
            int n = 0;
            char[] cArray2 = cArray;
            int n2 = cArray2.length;
            for (int i = 0; i < n2; ++i) {
                Character c = Character.valueOf(cArray2[i]);
                String string2 = this.toPath(string, n);
                this.fromValue(string2, c, set);
                ++n;
            }
            set.remove(cArray);
        }
    }

    private void fromArray(String string, short[] sArray, Set<Object> set) {
        if (!set.contains(sArray)) {
            set.add(sArray);
            int n = 0;
            short[] sArray2 = sArray;
            int n2 = sArray2.length;
            for (int i = 0; i < n2; ++i) {
                Short s = sArray2[i];
                String string2 = this.toPath(string, n);
                this.fromValue(string2, s, set);
                ++n;
            }
            set.remove(sArray);
        }
    }

    private void fromArray(String string, int[] nArray, Set<Object> set) {
        if (!set.contains(nArray)) {
            set.add(nArray);
            int n = 0;
            int[] nArray2 = nArray;
            int n2 = nArray2.length;
            for (int i = 0; i < n2; ++i) {
                Integer n3 = nArray2[i];
                String string2 = this.toPath(string, n);
                this.fromValue(string2, n3, set);
                ++n;
            }
            set.remove(nArray);
        }
    }

    private void fromArray(String string, long[] lArray, Set<Object> set) {
        if (!set.contains(lArray)) {
            set.add(lArray);
            int n = 0;
            long[] lArray2 = lArray;
            int n2 = lArray2.length;
            for (int i = 0; i < n2; ++i) {
                Long l = lArray2[i];
                String string2 = this.toPath(string, n);
                this.fromValue(string2, l, set);
                ++n;
            }
            set.remove(lArray);
        }
    }

    private void fromArray(String string, float[] fArray, Set<Object> set) {
        if (!set.contains(fArray)) {
            set.add(fArray);
            int n = 0;
            float[] fArray2 = fArray;
            int n2 = fArray2.length;
            for (int i = 0; i < n2; ++i) {
                Float f = Float.valueOf(fArray2[i]);
                String string2 = this.toPath(string, n);
                this.fromValue(string2, f, set);
                ++n;
            }
            set.remove(fArray);
        }
    }

    private void fromArray(String string, double[] dArray, Set<Object> set) {
        if (!set.contains(dArray)) {
            set.add(dArray);
            int n = 0;
            double[] dArray2 = dArray;
            int n2 = dArray2.length;
            for (int i = 0; i < n2; ++i) {
                Double d = dArray2[i];
                String string2 = this.toPath(string, n);
                this.fromValue(string2, d, set);
                ++n;
            }
            set.remove(dArray);
        }
    }

    private void fromObject(String string, Object object, Set<Object> set) {
        if (!set.contains(object)) {
            set.add(object);
            T t = this.fromInstance(object);
            if (t != null) {
                this.put(string, t);
            } else {
                Object object2;
                String string2;
                AccessibleObject[] accessibleObjectArray;
                Class<?> clazz = object.getClass();
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                Method[] methodArray = clazz.getMethods();
                if (methodArray != null && methodArray.length > 0) {
                    accessibleObjectArray = methodArray;
                    int n = accessibleObjectArray.length;
                    for (int i = 0; i < n; ++i) {
                        AccessibleObject accessibleObject = accessibleObjectArray[i];
                        if (!TypeUtility.isGetter((Method)accessibleObject)) continue;
                        try {
                            string2 = TypeUtility.fromGetterMethod((Method)accessibleObject);
                            if (this.isBlackListed(string2) || hashMap.containsKey(string2)) continue;
                            try {
                                ((Method)accessibleObject).setAccessible(true);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            object2 = ((Method)accessibleObject).invoke(object, new Object[0]);
                            if (set.contains(object2)) continue;
                            hashMap.put(string2, object2);
                            continue;
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                            // empty catch block
                        }
                    }
                }
                if ((accessibleObjectArray = clazz.getDeclaredFields()) != null && accessibleObjectArray.length > 0) {
                    for (AccessibleObject accessibleObject : accessibleObjectArray) {
                        try {
                            string2 = TypeUtility.toPropertyName((Field)accessibleObject);
                            if (this.isBlackListed(string2) || hashMap.containsKey(string2)) continue;
                            try {
                                ((Field)accessibleObject).setAccessible(true);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (Modifier.isTransient(((Field)accessibleObject).getModifiers()) || (object2 = ((Field)accessibleObject).get(object)) == null || set.contains(object2)) continue;
                            hashMap.put(string2, object2);
                        }
                        catch (IllegalAccessException | IllegalArgumentException exception) {
                            // empty catch block
                        }
                    }
                }
                if (!hashMap.isEmpty()) {
                    this.fromValue(string, hashMap, set);
                }
            }
            set.remove(object);
        }
    }

    protected void fromValue(String string, Object object, Set<Object> set) {
        string = this.toNormalizedPath(string);
        if (object == null) {
            this.put(string, (T)null);
        } else if (object instanceof PathMap) {
            this.fromPathMap(string, (PathMap)object, set);
        } else if (object instanceof Map) {
            this.fromMap(string, (Map)object, set);
        } else if (object instanceof Keys) {
            this.fromKeys(string, (Keys)object, set);
        } else if (object instanceof Collection) {
            this.fromCollection(string, (Collection)object, set);
        } else if (object.getClass().isArray()) {
            Class<?> clazz = object.getClass().getComponentType();
            if (clazz.equals(Boolean.TYPE)) {
                this.fromArray(string, (boolean[])object, set);
            } else if (clazz.equals(Byte.TYPE)) {
                this.fromArray(string, (byte[])object, set);
            } else if (clazz.equals(Character.TYPE)) {
                this.fromArray(string, (char[])object, set);
            } else if (clazz.equals(Short.TYPE)) {
                this.fromArray(string, (short[])object, set);
            } else if (clazz.equals(Integer.TYPE)) {
                this.fromArray(string, (int[])object, set);
            } else if (clazz.equals(Long.TYPE)) {
                this.fromArray(string, (long[])object, set);
            } else if (clazz.equals(Float.TYPE)) {
                this.fromArray(string, (float[])object, set);
            } else if (clazz.equals(Double.TYPE)) {
                this.fromArray(string, (double[])object, set);
            } else {
                this.fromArray(string, (Object[])object, set);
            }
        } else {
            this.fromObject(string, object, set);
        }
    }

    private boolean isBlackListed(String string) {
        for (String string2 : BLACKLISTED_PROPERTIES) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    protected void fromValue(String string, Object object) {
        this.fromValue(string, object, new HashSet<Object>());
    }

    protected PathMap<T> fromObject(Object object) {
        return new PathMapImpl<T>(object, this.getDelimiter(), this.getType());
    }

    protected T fromInstance(Object object) {
        if (this._type.isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        return null;
    }

    protected <TYPE> TYPE toInstance(T t, Class<TYPE> clazz) {
        if (clazz.isAssignableFrom(t.getClass())) {
            return (TYPE)t;
        }
        return null;
    }

    protected Map<String, T> createBackingMap() {
        return new HashMap();
    }
}

