// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// =============================================================================
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// =============================================================================
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// together with the GPL linking exception applied; as being applied by the GNU
// Classpath ("http://www.gnu.org/software/classpath/license.html")
// =============================================================================
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// =============================================================================
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.struct;

import org.refcodes.mixin.KeyAccessor;

/**
 * Thrown in case this instance does not contain the requested element (no such
 * key found in the collection).
 */
public class KeyNotFoundException extends StructureException implements KeyAccessor<String> {

	private static final long serialVersionUID = 1L;

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private String _key;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new net runtime exception.
	 *
	 * @param aKey The key which has not been found.
	 * @param aMessage the message
	 * @param aErrorCode the error code
	 */
	public KeyNotFoundException( String aKey, String aMessage, String aErrorCode ) {
		super( aMessage, aErrorCode );
		_key = aKey;
	}

	/**
	 * Instantiates a new net runtime exception.
	 *
	 * @param aKey The key which has not been found.
	 * @param aMessage the message
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public KeyNotFoundException( String aKey, String aMessage, Throwable aCause, String aErrorCode ) {
		super( aMessage, aCause, aErrorCode );
		_key = aKey;
	}

	/**
	 * Instantiates a new net runtime exception.
	 *
	 * @param aKey The key which has not been found.
	 * @param message the message
	 * @param cause the cause
	 */
	public KeyNotFoundException( String aKey, String message, Throwable cause ) {
		super( message, cause );
		_key = aKey;
	}

	/**
	 * Instantiates a new net runtime exception.
	 *
	 * @param aKey The key which has not been found.
	 * @param message the message
	 */
	public KeyNotFoundException( String aKey, String message ) {
		super( message );
		_key = aKey;
	}

	/**
	 * Instantiates a new net runtime exception.
	 *
	 * @param aKey The key which has not been found.
	 * @param aCause the cause
	 * @param aErrorCode the error code
	 */
	public KeyNotFoundException( String aKey, Throwable aCause, String aErrorCode ) {
		super( aCause, aErrorCode );
		_key = aKey;
	}

	/**
	 * Instantiates a new net runtime exception.
	 *
	 * @param aKey The key which has not been found.
	 * @param cause the cause
	 */
	public KeyNotFoundException( String aKey, Throwable cause ) {
		super( cause );
		_key = aKey;
	}

	// /////////////////////////////////////////////////////////////////////////^
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getKey() {
		return _key;
	}

}
