// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/TEXT-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.struct;

import java.util.Collection;
import java.util.Set;

import org.refcodes.data.Delimiter;

/**
 * The Class PathMapImpl.
 *
 * @param <T> the generic type
 */
public class PathMapImpl<T> implements PathMap<T> {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private PathMapBuilderImpl<T> _pathMap;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Create a {@link PathMap} instance from the provided {@link PathMap}
	 * instance containing the elements as of
	 * {@link MutablePathMap#insert(Object)} using the {@link PathMap}'s path
	 * delimiter for the path declarations the the type of the {@link PathMap}.
	 *
	 * @param aPathMap The {@link PathMap} from which the elements are to be
	 *        added.
	 */
	protected PathMapImpl( PathMap<T> aPathMap ) {
		_pathMap = new PathMapBuilderImpl<T>( aPathMap, aPathMap.getDelimiter(), aPathMap.getType() );
	}

	/**
	 * Create a {@link PathMap} instance using the provided path delimiter for
	 * the path declarations.
	 *
	 * @param aDelimiter The path delimiter to be used for the path
	 *        declarations.
	 * @param aType The type of the values being referenced by the paths.
	 */
	public PathMapImpl( char aDelimiter, Class<T> aType ) {
		_pathMap = new PathMapBuilderImpl<T>( aDelimiter, aType );
	}

	/**
	 * Create a {@link PathMap} instance containing the elements as of
	 * {@link MutablePathMap#insert(Object)} using the default path delimiter
	 * "/" ({@link Delimiter#PATH}) for the path declarations.
	 * 
	 * @param aObj The object from which the elements are to be added.
	 * @param aType The type of the values being referenced by the paths.
	 */
	public PathMapImpl( Object aObj, Class<T> aType ) {
		_pathMap = new PathMapBuilderImpl<T>( aObj, aType );
	}

	/**
	 * Create a {@link PathMap} instance containing the elements as of
	 * {@link MutablePathMap#insert(Object)} using the default path delimiter
	 * "/" ({@link Delimiter#PATH}) for the path declarations.
	 * 
	 * @param aToPath The sub-path where to insert the object's introspected
	 *        values to.
	 * @param aObj The object from which the elements are to be added.
	 * @param aType The type of the values being referenced by the paths.
	 */
	public PathMapImpl( String aToPath, Object aObj, Class<T> aType ) {
		_pathMap = new PathMapBuilderImpl<T>( aToPath, aObj, aType );
	}

	/**
	 * Creates a {@link PathMap} instance containing the elements as of
	 * {@link MutablePathMap#insert(Object)} using the default path delimiter
	 * "/" ({@link Delimiter#PATH}) for the path declarations.
	 * 
	 * @param aObj The object from which the elements are to be added.
	 * @param aFromPath The path from where to start adding elements of the
	 *        provided object.
	 * @param aType The type of the values being referenced by the paths.
	 */
	public PathMapImpl( Object aObj, String aFromPath, Class<T> aType ) {
		_pathMap = new PathMapBuilderImpl<T>( aObj, aFromPath, aType );
	}

	/**
	 * Creates a {@link PathMap} instance containing the elements as of
	 * {@link MutablePathMap#insert(Object)} using the default path delimiter
	 * "/" ({@link Delimiter#PATH} for the path declarations.
	 * 
	 * @param aToPath The sub-path where to insert the object's introspected
	 *        values to.
	 * @param aObj The object from which the elements are to be added.
	 * @param aFromPath The path from where to start adding elements of the
	 *        provided object.
	 * @param aType The type of the values being referenced by the paths.
	 */
	public PathMapImpl( String aToPath, Object aObj, String aFromPath, Class<T> aType ) {
		_pathMap = new PathMapBuilderImpl<T>( aToPath, aObj, aFromPath, aType );
	}

	/**
	 * Creates a {@link PathMap} instance containing the elements as of
	 * {@link MutablePathMap#insert(Object)}.
	 * 
	 * @param aObj The object from which the elements are to be added.
	 * @param aDelimiter The path delimiter to be used for the path
	 *        declarations.
	 * @param aType The type of the values being referenced by the paths.
	 */
	public PathMapImpl( Object aObj, char aDelimiter, Class<T> aType ) {
		_pathMap = new PathMapBuilderImpl<T>( aObj, aDelimiter, aType );
	}

	/**
	 * Creates a {@link PathMap} instance containing the elements as of
	 * {@link MutablePathMap#insert(Object)}.
	 *
	 * @param aToPath The sub-path where to insert the object's introspected
	 *        values to.
	 * @param aObj The object from which the elements are to be added.
	 * @param aDelimiter The path delimiter to be used for the path
	 *        declarations.
	 * @param aType The type of the values being referenced by the paths.
	 */
	public PathMapImpl( String aToPath, Object aObj, char aDelimiter, Class<T> aType ) {
		_pathMap = new PathMapBuilderImpl<T>( aToPath, aObj, aDelimiter, aType );
	}

	/**
	 * Creates a {@link PathMap} instance containing the elements as of
	 * {@link MutablePathMap#insert(Object)}.
	 * 
	 * @param aObj The object from which the elements are to be added.
	 * @param aFromPath The path from where to start adding elements of the
	 *        provided object.
	 * @param aDelimiter The path delimiter to be used for the path
	 *        declarations.
	 * @param aType The type of the values being referenced by the paths.
	 */
	public PathMapImpl( Object aObj, String aFromPath, char aDelimiter, Class<T> aType ) {
		_pathMap = new PathMapBuilderImpl<T>( aObj, aFromPath, aDelimiter, aType );
	}

	/**
	 * Create a {@link PathMap} instance containing the elements as of
	 * {@link MutablePathMap#insert(Object)}.
	 *
	 * @param aToPath The sub-path where to insert the object's introspected
	 *        values to.
	 * @param aObj The object from which the elements are to be added.
	 * @param aFromPath The path from where to start adding elements of the
	 *        provided object.
	 * @param aDelimiter The path delimiter to be used for the path
	 *        declarations.
	 * @param aType The type of the values being referenced by the paths.
	 */
	public PathMapImpl( String aToPath, Object aObj, String aFromPath, char aDelimiter, Class<T> aType ) {
		_pathMap = new PathMapBuilderImpl<T>( aToPath, aObj, aFromPath, aDelimiter, aType );
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean containsKey( Object aKey ) {
		return _pathMap.containsKey( aKey );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean containsValue( Object aValue ) {
		return _pathMap.containsValue( aValue );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public T get( Object aKey ) {
		return _pathMap.get( aKey );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Set<String> keySet() {
		return _pathMap.keySet();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Collection<T> values() {
		return _pathMap.values();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int size() {
		return _pathMap.size();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isEmpty() {
		return _pathMap.isEmpty();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public char getDelimiter() {
		return _pathMap.getDelimiter();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public char getAnnotator() {
		return _pathMap.getAnnotator();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public PathMap<T> retrieveFrom( String aFromPath ) {
		return _pathMap.retrieveFrom( aFromPath );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public PathMap<T> retrieveTo( String aToPath ) {
		return _pathMap.retrieveTo( aToPath );
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Class<T> getType() {
		return _pathMap.getType();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Object toDataStructure( String aFromPath ) {
		return _pathMap.toDataStructure();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return getClass().getSimpleName() + " " + _pathMap._backingMap.toString();
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// UTILITY:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////
}
