package org.refcodes.struct;

/**
 * Implementation of the {@link Range} interface.
 *
 * @param <V> The type used for the values.
 */
public class RangeImpl<V extends Number & Comparable<V>> implements Range<V> {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	protected V _minValue = null;

	protected V _maxValue = null;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Instantiates a new range impl.
	 */
	protected RangeImpl() {}

	/**
	 * Instantiates a new range impl.
	 *
	 * @param aMinValue the min value
	 * @param aMaxValue the max value
	 */
	public RangeImpl( V aMinValue, V aMaxValue ) {
		_minValue = aMinValue;
		_maxValue = aMaxValue;
	}

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * {@inheritDoc}
	 */
	@Override
	public V getMinValue() {
		return _minValue;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public V getMaxValue() {
		return _maxValue;
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

	/**
	 * Implementation of the {@link RangeBuilder} interface.
	 *
	 * @param <V> The type used for the values.
	 */
	public static class RangeBuilderImpl<V extends Number & Comparable<V>> extends RangeImpl<V> implements RangeBuilder<V> {

		/**
		 * Instantiates a new range builder impl.
		 */
		public RangeBuilderImpl() {
			super();
		}

		/**
		 * Instantiates a new range builder impl.
		 *
		 * @param aMinValue the min value
		 * @param aMaxValue the max value
		 */
		public RangeBuilderImpl( V aMinValue, V aMaxValue ) {
			super( aMinValue, aMaxValue );
		}

		/**
		 * Sets the min value.
		 *
		 * @param aMinValue the new min value
		 */
		@Override
		public void setMinValue( V aMinValue ) {
			_minValue = aMinValue;
		}

		/**
		 * Sets the max value.
		 *
		 * @param aMaxValue the new max value
		 */
		@Override
		public void setMaxValue( V aMaxValue ) {
			_maxValue = aMaxValue;
		}
	}
}
