/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import org.refcodes.data.BooleanLiterals;
import org.refcodes.data.Literal;
import org.refcodes.struct.PrimitiveArrayType;
import org.refcodes.time.DateFormat;
import org.refcodes.time.DateFormats;

public enum SimpleType {
    DEFAULT(false, true, false),
    KEEP_TYPES(true, true, false),
    WRAPPER_TYPES(false, true, false),
    PRIMITIVE_TYPES(true, false, false),
    KEEP_TYPES_WITH_ARRAY_TYPES(true, true, true),
    WRAPPER_TYPES_WITH_ARRAY_TYPES(false, true, true),
    PRIMITIVE_TYPES_WITH_ARRAY_TYPES(true, false, true);

    private boolean _hasPrimitiveTypeSupport;
    private boolean _hasWrapperTypeSupport;
    private boolean _hasArrayTypeSupport;

    private SimpleType(boolean hasPrimitiveTypeSupport, boolean hasWrapperTypeSupport, boolean hasArrayTypeSupport) {
        this._hasPrimitiveTypeSupport = hasPrimitiveTypeSupport;
        this._hasWrapperTypeSupport = hasWrapperTypeSupport;
        this._hasArrayTypeSupport = hasArrayTypeSupport;
    }

    public boolean hasPrimitiveTypeSupport() {
        return this._hasPrimitiveTypeSupport;
    }

    public boolean hasWrapperTypeSupport() {
        return this._hasWrapperTypeSupport;
    }

    public boolean hasArrayTypeSupport() {
        return this._hasArrayTypeSupport;
    }

    public Class<?> toType(Class<?> aClass) {
        boolean isPrimitiveType = SimpleType.isPrimitiveType(aClass, this._hasArrayTypeSupport);
        boolean isWrapperType = SimpleType.isWrapperType(aClass, this._hasArrayTypeSupport);
        if (this._hasPrimitiveTypeSupport && this._hasWrapperTypeSupport && (isPrimitiveType || isWrapperType)) {
            return isPrimitiveType ? SimpleType.toPrimitiveType(aClass, this._hasArrayTypeSupport) : SimpleType.toWrapperType(aClass, this._hasArrayTypeSupport);
        }
        if (isWrapperType && this._hasPrimitiveTypeSupport && !this._hasWrapperTypeSupport) {
            return SimpleType.toPrimitiveType(aClass, this._hasArrayTypeSupport);
        }
        if (isPrimitiveType && !this._hasPrimitiveTypeSupport && this._hasWrapperTypeSupport) {
            return SimpleType.toWrapperType(aClass, this._hasArrayTypeSupport);
        }
        if (isPrimitiveType && this._hasPrimitiveTypeSupport) {
            return SimpleType.toPrimitiveType(aClass, this._hasArrayTypeSupport);
        }
        if (isWrapperType && this._hasWrapperTypeSupport) {
            return SimpleType.toWrapperType(aClass, this._hasArrayTypeSupport);
        }
        return null;
    }

    public static Class<?> toPrimitiveType(Class<?> aClass) {
        return SimpleType.toPrimitiveType(aClass, false);
    }

    public static Class<?> toPrimitiveType(Class<?> aClass, boolean hasArraySupport) {
        if (Boolean.class.isAssignableFrom(aClass) || Boolean.TYPE.isAssignableFrom(aClass)) {
            return Boolean.TYPE;
        }
        if (Byte.class.isAssignableFrom(aClass) || Byte.TYPE.isAssignableFrom(aClass)) {
            return Byte.TYPE;
        }
        if (Character.class.isAssignableFrom(aClass) || Character.TYPE.isAssignableFrom(aClass)) {
            return Character.TYPE;
        }
        if (Double.class.isAssignableFrom(aClass) || Double.TYPE.isAssignableFrom(aClass)) {
            return Double.TYPE;
        }
        if (Float.class.isAssignableFrom(aClass) || Float.TYPE.isAssignableFrom(aClass)) {
            return Float.TYPE;
        }
        if (Integer.class.isAssignableFrom(aClass) || Integer.TYPE.isAssignableFrom(aClass)) {
            return Integer.TYPE;
        }
        if (Long.class.isAssignableFrom(aClass) || Long.TYPE.isAssignableFrom(aClass)) {
            return Long.TYPE;
        }
        if (Short.class.isAssignableFrom(aClass) || Short.TYPE.isAssignableFrom(aClass)) {
            return Short.TYPE;
        }
        if (hasArraySupport && aClass.isArray()) {
            Class<?> theArrayClass = aClass.getComponentType();
            if (Boolean.TYPE.isAssignableFrom(theArrayClass)) {
                return aClass;
            }
            if (Boolean.class.isAssignableFrom(theArrayClass)) {
                return Array.newInstance(Boolean.TYPE, 0).getClass();
            }
            if (Byte.TYPE.isAssignableFrom(theArrayClass)) {
                return aClass;
            }
            if (Byte.class.isAssignableFrom(theArrayClass)) {
                return Array.newInstance(Byte.TYPE, 0).getClass();
            }
            if (Character.TYPE.isAssignableFrom(theArrayClass)) {
                return aClass;
            }
            if (Character.class.isAssignableFrom(theArrayClass)) {
                return Array.newInstance(Character.TYPE, 0).getClass();
            }
            if (Double.TYPE.isAssignableFrom(theArrayClass)) {
                return aClass;
            }
            if (Double.class.isAssignableFrom(theArrayClass)) {
                return Array.newInstance(Double.TYPE, 0).getClass();
            }
            if (Float.TYPE.isAssignableFrom(theArrayClass)) {
                return aClass;
            }
            if (Float.class.isAssignableFrom(theArrayClass)) {
                return Array.newInstance(Float.TYPE, 0).getClass();
            }
            if (Integer.TYPE.isAssignableFrom(theArrayClass)) {
                return aClass;
            }
            if (Integer.class.isAssignableFrom(theArrayClass)) {
                return Array.newInstance(Integer.TYPE, 0).getClass();
            }
            if (Long.TYPE.isAssignableFrom(theArrayClass)) {
                return aClass;
            }
            if (Long.class.isAssignableFrom(theArrayClass)) {
                return Array.newInstance(Long.TYPE, 0).getClass();
            }
            if (Short.TYPE.isAssignableFrom(theArrayClass)) {
                return aClass;
            }
            if (Short.class.isAssignableFrom(theArrayClass)) {
                return Array.newInstance(Short.TYPE, 0).getClass();
            }
        }
        return null;
    }

    public static Class<?> toWrapperType(Class<?> aClass) {
        return SimpleType.toWrapperType(aClass, false);
    }

    public static Class<?> toWrapperType(Class<?> aClass, boolean hasArraySupport) {
        if (Boolean.class.isAssignableFrom(aClass) || Boolean.TYPE.isAssignableFrom(aClass)) {
            return Boolean.class;
        }
        if (Byte.class.isAssignableFrom(aClass) || Byte.TYPE.isAssignableFrom(aClass)) {
            return Byte.class;
        }
        if (Character.class.isAssignableFrom(aClass) || Character.TYPE.isAssignableFrom(aClass)) {
            return Character.class;
        }
        if (Double.class.isAssignableFrom(aClass) || Double.TYPE.isAssignableFrom(aClass)) {
            return Double.class;
        }
        if (Float.class.isAssignableFrom(aClass) || Float.TYPE.isAssignableFrom(aClass)) {
            return Float.class;
        }
        if (Integer.class.isAssignableFrom(aClass) || Integer.TYPE.isAssignableFrom(aClass)) {
            return Integer.class;
        }
        if (Long.class.isAssignableFrom(aClass) || Long.TYPE.isAssignableFrom(aClass)) {
            return Long.class;
        }
        if (Short.class.isAssignableFrom(aClass) || Short.TYPE.isAssignableFrom(aClass)) {
            return Short.class;
        }
        if (hasArraySupport && aClass.isArray()) {
            Class<?> theArrayClass = aClass.getComponentType();
            if (Boolean.class.isAssignableFrom(theArrayClass)) {
                return aClass;
            }
            if (Boolean.TYPE.isAssignableFrom(theArrayClass)) {
                return Array.newInstance(Boolean.class, 0).getClass();
            }
            if (Byte.class.isAssignableFrom(theArrayClass)) {
                return aClass;
            }
            if (Byte.TYPE.isAssignableFrom(theArrayClass)) {
                return Array.newInstance(Byte.class, 0).getClass();
            }
            if (Character.class.isAssignableFrom(theArrayClass)) {
                return aClass;
            }
            if (Character.TYPE.isAssignableFrom(theArrayClass)) {
                return Array.newInstance(Character.class, 0).getClass();
            }
            if (Double.class.isAssignableFrom(theArrayClass)) {
                return aClass;
            }
            if (Double.TYPE.isAssignableFrom(theArrayClass)) {
                return Array.newInstance(Double.class, 0).getClass();
            }
            if (Float.class.isAssignableFrom(theArrayClass)) {
                return aClass;
            }
            if (Float.TYPE.isAssignableFrom(theArrayClass)) {
                return Array.newInstance(Float.class, 0).getClass();
            }
            if (Integer.class.isAssignableFrom(theArrayClass)) {
                return aClass;
            }
            if (Integer.TYPE.isAssignableFrom(theArrayClass)) {
                return Array.newInstance(Integer.class, 0).getClass();
            }
            if (Long.class.isAssignableFrom(theArrayClass)) {
                return aClass;
            }
            if (Long.TYPE.isAssignableFrom(theArrayClass)) {
                return Array.newInstance(Long.class, 0).getClass();
            }
            if (Short.class.isAssignableFrom(theArrayClass)) {
                return aClass;
            }
            if (Short.TYPE.isAssignableFrom(theArrayClass)) {
                return Array.newInstance(Short.class, 0).getClass();
            }
        }
        return null;
    }

    public static boolean isPrimitiveType(Class<?> aClass, boolean hasArraySupport) {
        return SimpleType.isPrimitiveType(aClass) || hasArraySupport && SimpleType.isPrimitiveArrayType(aClass);
    }

    public static boolean isPrimitiveType(Class<?> aClass) {
        if (Boolean.TYPE.isAssignableFrom(aClass)) {
            return true;
        }
        if (Byte.TYPE.isAssignableFrom(aClass)) {
            return true;
        }
        if (Character.TYPE.isAssignableFrom(aClass)) {
            return true;
        }
        if (Double.TYPE.isAssignableFrom(aClass)) {
            return true;
        }
        if (Float.TYPE.isAssignableFrom(aClass)) {
            return true;
        }
        if (Integer.TYPE.isAssignableFrom(aClass)) {
            return true;
        }
        if (Long.TYPE.isAssignableFrom(aClass)) {
            return true;
        }
        return Short.TYPE.isAssignableFrom(aClass);
    }

    public static boolean isPrimitiveArrayType(Class<?> aClass) {
        return PrimitiveArrayType.isPrimitiveArrayType(aClass);
    }

    public static boolean isWrapperType(Class<?> aClass, boolean hasArraySupport) {
        return SimpleType.isWrapperType(aClass) || hasArraySupport && SimpleType.isWrapperArrayType(aClass);
    }

    public static boolean isWrapperType(Class<?> aClass) {
        if (Boolean.class.isAssignableFrom(aClass)) {
            return true;
        }
        if (Byte.class.isAssignableFrom(aClass)) {
            return true;
        }
        if (Character.class.isAssignableFrom(aClass)) {
            return true;
        }
        if (Double.class.isAssignableFrom(aClass)) {
            return true;
        }
        if (Float.class.isAssignableFrom(aClass)) {
            return true;
        }
        if (Integer.class.isAssignableFrom(aClass)) {
            return true;
        }
        if (Long.class.isAssignableFrom(aClass)) {
            return true;
        }
        return Short.class.isAssignableFrom(aClass);
    }

    public static boolean isWrapperArrayType(Class<?> aClass) {
        if (Boolean[].class.isAssignableFrom(aClass)) {
            return true;
        }
        if (Byte[].class.isAssignableFrom(aClass)) {
            return true;
        }
        if (Character[].class.isAssignableFrom(aClass)) {
            return true;
        }
        if (Double[].class.isAssignableFrom(aClass)) {
            return true;
        }
        if (Float[].class.isAssignableFrom(aClass)) {
            return true;
        }
        if (Integer[].class.isAssignableFrom(aClass)) {
            return true;
        }
        if (Long[].class.isAssignableFrom(aClass)) {
            return true;
        }
        return Short[].class.isAssignableFrom(aClass);
    }

    public static boolean isSimpleType(Class<?> aClass, boolean hasArraySupport) {
        return SimpleType.isSimpleType(aClass) || hasArraySupport && SimpleType.isSimpleArrayType(aClass);
    }

    public static boolean isSimpleType(Class<?> aClass) {
        if (String.class.isAssignableFrom(aClass)) {
            return true;
        }
        if (Number.class.isAssignableFrom(aClass)) {
            return true;
        }
        if (Boolean.class.isAssignableFrom(aClass)) {
            return true;
        }
        if (Character.class.isAssignableFrom(aClass)) {
            return true;
        }
        if (Enum.class.isAssignableFrom(aClass)) {
            return true;
        }
        if (Class.class.isAssignableFrom(aClass)) {
            return true;
        }
        if (Date.class.isAssignableFrom(aClass)) {
            return true;
        }
        if (LocalDate.class.isAssignableFrom(aClass)) {
            return true;
        }
        if (LocalDateTime.class.isAssignableFrom(aClass)) {
            return true;
        }
        if (Locale.class.isAssignableFrom(aClass)) {
            return true;
        }
        if (UUID.class.isAssignableFrom(aClass)) {
            return true;
        }
        return SimpleType.isPrimitiveType(aClass) || SimpleType.isWrapperType(aClass);
    }

    public static boolean isSimpleArrayType(Class<?> aClass) {
        if (String[].class.isAssignableFrom(aClass)) {
            return true;
        }
        if (Number[].class.isAssignableFrom(aClass)) {
            return true;
        }
        if (Boolean[].class.isAssignableFrom(aClass)) {
            return true;
        }
        if (Character[].class.isAssignableFrom(aClass)) {
            return true;
        }
        if (Enum[].class.isAssignableFrom(aClass)) {
            return true;
        }
        if (Class[].class.isAssignableFrom(aClass)) {
            return true;
        }
        if (Date[].class.isAssignableFrom(aClass)) {
            return true;
        }
        if (LocalDate[].class.isAssignableFrom(aClass)) {
            return true;
        }
        if (LocalDateTime[].class.isAssignableFrom(aClass)) {
            return true;
        }
        if (Locale[].class.isAssignableFrom(aClass)) {
            return true;
        }
        if (UUID[].class.isAssignableFrom(aClass)) {
            return true;
        }
        return SimpleType.isPrimitiveArrayType(aClass) || SimpleType.isWrapperArrayType(aClass);
    }

    public static boolean isCompositeType(Class<?> aClass, boolean hasArraySupport) {
        return SimpleType.isCompositeType(aClass) || hasArraySupport && SimpleType.isCompositeArrayType(aClass);
    }

    public static boolean isCompositeType(Class<?> aClass) {
        return !SimpleType.isSimpleArrayType(aClass);
    }

    public static boolean isCompositeArrayType(Class<?> aClass) {
        return !SimpleType.isSimpleArrayType(aClass);
    }

    public static <T> String fromSimpleType(T aValue) {
        if (String.class.isAssignableFrom(aValue.getClass())) {
            return (String)aValue;
        }
        if (Number.class.isAssignableFrom(aValue.getClass())) {
            return SimpleType.fromNumber(aValue);
        }
        if (Boolean.class.isAssignableFrom(aValue.getClass())) {
            return SimpleType.fromNumber(aValue);
        }
        if (Character.class.isAssignableFrom(aValue.getClass())) {
            return SimpleType.fromCharacter((Character)aValue);
        }
        if (Enum.class.isAssignableFrom(aValue.getClass())) {
            return SimpleType.fromEnum((Enum)aValue);
        }
        if (Class.class.isAssignableFrom(aValue.getClass())) {
            return ((Class)aValue).getName();
        }
        if (Date.class.isAssignableFrom(aValue.getClass())) {
            return SimpleType.fromDate((Date)aValue);
        }
        if (LocalDate.class.isAssignableFrom(aValue.getClass())) {
            return SimpleType.fromLocalDate((LocalDate)aValue);
        }
        if (LocalDateTime.class.isAssignableFrom(aValue.getClass())) {
            return SimpleType.fromLocalDateTime((LocalDateTime)aValue);
        }
        if (Locale.class.isAssignableFrom(aValue.getClass())) {
            return SimpleType.fromLocale((Locale)aValue);
        }
        if (UUID.class.isAssignableFrom(aValue.getClass())) {
            return SimpleType.fromUUID((UUID)aValue);
        }
        return null;
    }

    public static <TYPE> TYPE toSimpleType(String aValue, Class<TYPE> aType) {
        if (aType.isAssignableFrom(String.class)) {
            return (TYPE)aValue;
        }
        if (aType.isAssignableFrom(Integer.class) || aType.equals(Integer.TYPE)) {
            return (TYPE)Integer.valueOf(aValue);
        }
        if (aType.isAssignableFrom(Short.class) || aType.equals(Short.TYPE)) {
            return (TYPE)Short.valueOf(aValue);
        }
        if (aType.isAssignableFrom(Byte.class) || aType.equals(Byte.TYPE)) {
            return (TYPE)Byte.valueOf(aValue);
        }
        if (aType.isAssignableFrom(Float.class) || aType.equals(Float.TYPE)) {
            return (TYPE)Float.valueOf(aValue);
        }
        if (aType.isAssignableFrom(Double.class) || aType.equals(Double.TYPE)) {
            return (TYPE)Double.valueOf(aValue);
        }
        if (aType.isAssignableFrom(Long.class) || aType.equals(Long.TYPE)) {
            return (TYPE)Long.valueOf(aValue);
        }
        if (aType.isAssignableFrom(Boolean.class) || aType.equals(Boolean.TYPE)) {
            if (aValue != null) {
                if (aValue.equalsIgnoreCase(Literal.TRUE.getValue())) {
                    return (TYPE)Boolean.TRUE;
                }
                if (aValue.equalsIgnoreCase(Literal.FALSE.getValue())) {
                    return (TYPE)Boolean.FALSE;
                }
            }
        } else {
            if (aType.isAssignableFrom(Character.class) || aType.equals(Character.TYPE)) {
                return (TYPE)SimpleType.toCharacter(aValue);
            }
            if (Enum.class.isAssignableFrom(aType)) {
                return (TYPE)SimpleType.toEnum(aValue, aType);
            }
            if (aType.isAssignableFrom(Class.class)) {
                try {
                    return (TYPE)Class.forName(aValue);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            } else {
                if (aType.isAssignableFrom(Date.class)) {
                    return (TYPE)SimpleType.toDate(aValue);
                }
                if (aType.isAssignableFrom(LocalDate.class)) {
                    return (TYPE)SimpleType.toLocalDate(aValue);
                }
                if (aType.isAssignableFrom(LocalDateTime.class)) {
                    return (TYPE)SimpleType.toLocalDateTime(aValue);
                }
                if (Locale.class.isAssignableFrom(aType)) {
                    return (TYPE)SimpleType.toLocale(aValue);
                }
                if (UUID.class.isAssignableFrom(aType)) {
                    return (TYPE)SimpleType.toUUID(aValue);
                }
            }
        }
        return null;
    }

    public static <T> boolean invokeSimpleType(T aToInstance, Method aToMethod, String aToValue, Class<?> aToType) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        if (aToType.equals(String.class)) {
            aToMethod.invoke(aToInstance, aToValue);
        } else if (Number.class.isAssignableFrom(aToType)) {
            Constructor<String> theCtor = SimpleType.toNumber(aToType);
            aToMethod.invoke(aToInstance, theCtor.newInstance(aToValue));
        } else if (Boolean.class.isAssignableFrom(aToType)) {
            Constructor<String> theCtor = SimpleType.toNumber(aToType);
            aToMethod.invoke(aToInstance, theCtor.newInstance(aToValue));
        } else if (aToType.equals(Character.class)) {
            aToMethod.invoke(aToInstance, SimpleType.toCharacter(aToValue));
        } else if (Enum.class.isAssignableFrom(aToType)) {
            aToMethod.invoke(aToInstance, SimpleType.toEnum(aToValue, aToType));
        } else if (aToType.equals(Class.class)) {
            aToMethod.invoke(aToInstance, Class.forName(aToValue));
        } else if (aToType.equals(Date.class)) {
            aToMethod.invoke(aToInstance, SimpleType.toDate(aToValue));
        } else if (aToType.equals(LocalDate.class)) {
            aToMethod.invoke(aToInstance, SimpleType.toLocalDate(aToValue));
        } else if (aToType.equals(LocalDateTime.class)) {
            aToMethod.invoke(aToInstance, SimpleType.toLocalDateTime(aToValue));
        } else if (Locale.class.isAssignableFrom(aToType)) {
            aToMethod.invoke(aToInstance, SimpleType.toLocale(aToValue));
        } else if (UUID.class.isAssignableFrom(aToType)) {
            aToMethod.invoke(aToInstance, SimpleType.toUUID(aToValue));
        } else if (aToType.equals(Boolean.TYPE)) {
            if (!BooleanLiterals.isTrue((String)aToValue) && !BooleanLiterals.isFalse((String)aToValue)) {
                return false;
            }
            aToMethod.invoke(aToInstance, BooleanLiterals.isTrue((String)aToValue));
        } else if (aToType.equals(Byte.TYPE)) {
            aToMethod.invoke(aToInstance, Byte.parseByte(aToValue));
        } else if (aToType.equals(Character.TYPE)) {
            aToMethod.invoke(aToInstance, SimpleType.toCharacter(aToValue));
        } else if (aToType.equals(Short.TYPE)) {
            aToMethod.invoke(aToInstance, Short.parseShort(aToValue));
        } else if (aToType.equals(Integer.TYPE)) {
            aToMethod.invoke(aToInstance, Integer.parseInt(aToValue));
        } else if (aToType.equals(Long.TYPE)) {
            aToMethod.invoke(aToInstance, Long.parseLong(aToValue));
        } else if (aToType.equals(Float.TYPE)) {
            aToMethod.invoke(aToInstance, Float.valueOf(Float.parseFloat(aToValue)));
        } else if (aToType.equals(Double.TYPE)) {
            aToMethod.invoke(aToInstance, Double.parseDouble(aToValue));
        } else {
            return false;
        }
        return true;
    }

    public static <T> boolean invokeSimpleType(T aToInstance, Field aToField, String aToValue, Class<?> aToType) throws NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException, ClassNotFoundException {
        if (aToType.equals(String.class)) {
            aToField.set(aToInstance, aToValue);
        } else if (Number.class.isAssignableFrom(aToType)) {
            Constructor<String> theCtor = SimpleType.toNumber(aToType);
            aToField.set(aToInstance, theCtor.newInstance(aToValue));
        } else if (Boolean.class.isAssignableFrom(aToType)) {
            Constructor<String> theCtor = SimpleType.toNumber(aToType);
            aToField.set(aToInstance, theCtor.newInstance(aToValue));
        } else if (aToType.equals(Character.class)) {
            aToField.set(aToInstance, SimpleType.toCharacter(aToValue));
        } else if (Enum.class.isAssignableFrom(aToType)) {
            aToField.set(aToInstance, SimpleType.toEnum(aToValue, aToType));
        } else if (aToType.equals(Class.class)) {
            aToField.set(aToInstance, Class.forName(aToValue));
        } else if (aToType.equals(Date.class)) {
            aToField.set(aToInstance, SimpleType.toDate(aToValue));
        } else if (aToType.equals(LocalDate.class)) {
            aToField.set(aToInstance, SimpleType.toLocalDate(aToValue));
        } else if (aToType.equals(LocalDateTime.class)) {
            aToField.set(aToInstance, SimpleType.toLocalDateTime(aToValue));
        } else if (Locale.class.isAssignableFrom(aToType)) {
            aToField.set(aToInstance, SimpleType.toLocale(aToValue));
        } else if (UUID.class.isAssignableFrom(aToType)) {
            aToField.set(aToInstance, SimpleType.toUUID(aToValue));
        } else if (aToType.equals(Boolean.TYPE)) {
            if (!BooleanLiterals.isTrue((String)aToValue) && !BooleanLiterals.isFalse((String)aToValue)) {
                return false;
            }
            aToField.setBoolean(aToInstance, BooleanLiterals.isTrue((String)aToValue));
        } else if (aToType.equals(Byte.TYPE)) {
            aToField.setByte(aToInstance, Byte.parseByte(aToValue));
        } else if (aToType.equals(Character.TYPE)) {
            aToField.setChar(aToInstance, SimpleType.toCharacter(aToValue).charValue());
        } else if (aToType.equals(Short.TYPE)) {
            aToField.setShort(aToInstance, Short.parseShort(aToValue));
        } else if (aToType.equals(Integer.TYPE)) {
            aToField.setInt(aToInstance, Integer.parseInt(aToValue));
        } else if (aToType.equals(Long.TYPE)) {
            aToField.setLong(aToInstance, Long.parseLong(aToValue));
        } else if (aToType.equals(Float.TYPE)) {
            aToField.setFloat(aToInstance, Float.parseFloat(aToValue));
        } else if (aToType.equals(Double.TYPE)) {
            aToField.setDouble(aToInstance, Double.parseDouble(aToValue));
        } else {
            return false;
        }
        return true;
    }

    public static <T> boolean invokeSimpleType(T aToArray, int aToIndex, String aToValue, Class<?> aToType) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        if (aToType.equals(String.class)) {
            Array.set(aToArray, aToIndex, aToValue);
        } else if (Number.class.isAssignableFrom(aToType)) {
            Constructor<String> theCtor = SimpleType.toNumber(aToType);
            Array.set(aToArray, aToIndex, theCtor.newInstance(aToValue));
        } else if (Boolean.class.isAssignableFrom(aToType)) {
            Constructor<String> theCtor = SimpleType.toNumber(aToType);
            Array.set(aToArray, aToIndex, theCtor.newInstance(aToValue));
        } else if (aToType.equals(Character.class)) {
            Array.set(aToArray, aToIndex, SimpleType.toCharacter(aToValue));
        } else if (Enum.class.isAssignableFrom(aToType)) {
            Array.set(aToArray, aToIndex, SimpleType.toEnum(aToValue, aToType));
        } else if (aToType.equals(Class.class)) {
            Array.set(aToArray, aToIndex, Class.forName(aToValue));
        } else if (aToType.equals(Date.class)) {
            Array.set(aToArray, aToIndex, SimpleType.toDate(aToValue));
        } else if (aToType.equals(LocalDate.class)) {
            Array.set(aToArray, aToIndex, SimpleType.toLocalDate(aToValue));
        } else if (aToType.equals(LocalDateTime.class)) {
            Array.set(aToArray, aToIndex, SimpleType.toLocalDateTime(aToValue));
        } else if (Locale.class.isAssignableFrom(aToType)) {
            Array.set(aToArray, aToIndex, SimpleType.toLocale(aToValue));
        } else if (UUID.class.isAssignableFrom(aToType)) {
            Array.set(aToArray, aToIndex, SimpleType.toUUID(aToValue));
        } else if (aToType.equals(Boolean.TYPE)) {
            if (!BooleanLiterals.isTrue((String)aToValue) && !BooleanLiterals.isFalse((String)aToValue)) {
                return false;
            }
            Array.set(aToArray, aToIndex, BooleanLiterals.isTrue((String)aToValue));
        } else if (aToType.equals(Byte.TYPE)) {
            Array.set(aToArray, aToIndex, Byte.parseByte(aToValue));
        } else if (aToType.equals(Character.TYPE)) {
            Array.set(aToArray, aToIndex, SimpleType.toCharacter(aToValue));
        } else if (aToType.equals(Short.TYPE)) {
            Array.set(aToArray, aToIndex, Short.parseShort(aToValue));
        } else if (aToType.equals(Integer.TYPE)) {
            Array.set(aToArray, aToIndex, Integer.parseInt(aToValue));
        } else if (aToType.equals(Long.TYPE)) {
            Array.set(aToArray, aToIndex, Long.parseLong(aToValue));
        } else if (aToType.equals(Float.TYPE)) {
            Array.set(aToArray, aToIndex, Float.valueOf(Float.parseFloat(aToValue)));
        } else if (aToType.equals(Double.TYPE)) {
            Array.set(aToArray, aToIndex, Double.parseDouble(aToValue));
        } else {
            return false;
        }
        return true;
    }

    private static <T> String fromDate(Date aValue) {
        return DateFormat.ISO_OFFSET_DATE_TIME.getFormatter().format(Instant.ofEpochMilli(aValue.getTime()));
    }

    private static Date toDate(String aValue) {
        return DateFormats.asDate((String)aValue);
    }

    private static <T> String fromLocalDate(LocalDate aValue) {
        return DateFormat.ISO_LOCAL_DATE.getFormatter().format(aValue);
    }

    private static LocalDate toLocalDate(String aValue) {
        return DateFormats.asLocalDate((String)aValue);
    }

    private static <T> String fromLocalDateTime(LocalDateTime aValue) {
        return DateFormat.ISO_LOCAL_DATE_TIME.getFormatter().format(aValue);
    }

    private static LocalDateTime toLocalDateTime(String aValue) {
        return DateFormats.asLocalDateTime((String)aValue);
    }

    private static <T> String fromEnum(Enum<?> aValue) {
        return aValue.name();
    }

    private static Enum<?> toEnum(String aValue, Class<?> aType) {
        return Enum.valueOf(aType, aValue);
    }

    private static <T> String fromLocale(Locale aValue) {
        return aValue.getLanguage() + "-" + aValue.getCountry();
    }

    private static Locale toLocale(String aValue) {
        return Locale.forLanguageTag(aValue);
    }

    private static <T> String fromUUID(UUID aValue) {
        return aValue.toString();
    }

    private static UUID toUUID(String aValue) {
        return UUID.fromString(aValue);
    }

    private static <T> String fromCharacter(Character aValue) {
        return aValue.toString();
    }

    private static Character toCharacter(String aValue) {
        if (aValue.length() != 0) {
            return Character.valueOf(aValue.charAt(0));
        }
        return null;
    }

    private static <T> String fromNumber(T aValue) {
        String theValue = aValue.toString();
        if (theValue.endsWith(".0")) {
            theValue = theValue.substring(0, theValue.length() - 2);
        }
        return theValue;
    }

    private static Constructor<String> toNumber(Class<?> aType) throws NoSuchMethodException {
        Constructor<String> theCtor = aType.getConstructor(String.class);
        try {
            theCtor.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return theCtor;
    }
}

