/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.refcodes.data.Wildcard;
import org.refcodes.struct.ClassStructMapImpl;
import org.refcodes.struct.PathMap;
import org.refcodes.struct.Property;
import org.refcodes.struct.Relation;
import org.refcodes.struct.SimpleType;
import org.refcodes.struct.TypeModeAccessor;

public interface ClassStructMap
extends PathMap<Class<?>>,
TypeModeAccessor {
    public static final String ARRAY_SELECTOR = Wildcard.FILE.getValue();

    @Override
    default public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    default public ClassStructMap getDirAt(int aIndex) {
        return this.getDirAt(this.getRootPath(), aIndex);
    }

    default public ClassStructMap getDirAt(Collection<?> aPathElements, int aIndex) {
        return this.getDirAt(this.toPath(aPathElements), aIndex);
    }

    default public ClassStructMap getDirAt(Object aPath, int aIndex) {
        return this.getDirAt(this.toPath(aPath), aIndex);
    }

    default public ClassStructMap getDirAt(Object[] aPathElements, int aIndex) {
        return this.getDirAt(this.toPath(aPathElements), aIndex);
    }

    default public ClassStructMap getDirAt(String[] aPathElements, int aIndex) {
        return this.getDirAt(this.toPath(aPathElements), aIndex);
    }

    default public ClassStructMap getDirAt(String aPath, int aIndex) {
        return this.retrieveFrom(this.toPath(aPath, Integer.toString(aIndex)));
    }

    default public ClassStructMap query(Collection<?> aQueryElements) {
        return this.query(this.toPath(aQueryElements));
    }

    default public ClassStructMap query(Object ... aQueryElements) {
        return this.query(this.toPath(aQueryElements));
    }

    default public ClassStructMap query(Pattern aRegExp) {
        return new ClassStructMapImpl(PathMap.super.query(aRegExp));
    }

    default public ClassStructMap query(String aPathQuery) {
        return new ClassStructMapImpl(PathMap.super.query(aPathQuery));
    }

    default public ClassStructMap query(String ... aQueryElements) {
        return this.query(this.toPath(aQueryElements));
    }

    default public ClassStructMap queryBetween(Collection<?> aFromPath, Collection<?> aPathQuery, Collection<?> aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    default public ClassStructMap queryBetween(Object aFromPath, Object aPathQuery, Object aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    default public ClassStructMap queryBetween(Object[] aFromPath, Object[] aPathQuery, Object[] aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    default public ClassStructMap queryBetween(String aFromPath, Pattern aRegExp, String aToPath) {
        return new ClassStructMapImpl(PathMap.super.queryBetween(aFromPath, aRegExp, aToPath));
    }

    default public ClassStructMap queryBetween(String aFromPath, String aPathQuery, String aToPath) {
        return new ClassStructMapImpl(PathMap.super.queryBetween(aFromPath, aPathQuery, aToPath));
    }

    default public ClassStructMap queryBetween(String[] aFromPath, String[] aPathQuery, String[] aToPath) {
        return this.queryBetween(this.toPath(aFromPath), this.toPath(aPathQuery), this.toPath(aToPath));
    }

    default public ClassStructMap queryFrom(Collection<?> aPathQuery, Collection<?> aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    default public ClassStructMap queryFrom(Object aPathQuery, Object aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    default public ClassStructMap queryFrom(Object[] aPathQuery, Object[] aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    default public ClassStructMap queryFrom(Pattern aRegExp, String aFromPath) {
        return new ClassStructMapImpl(PathMap.super.queryFrom(aRegExp, aFromPath));
    }

    default public ClassStructMap queryFrom(String aPathQuery, String aFromPath) {
        return new ClassStructMapImpl(PathMap.super.queryFrom(aPathQuery, aFromPath));
    }

    default public ClassStructMap queryFrom(String[] aPathQuery, String[] aFromPath) {
        return this.queryFrom(this.toPath(aPathQuery), this.toPath(aFromPath));
    }

    default public ClassStructMap queryTo(Collection<?> aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), this.toPath((Object)aToPath));
    }

    default public ClassStructMap queryTo(Object aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), this.toPath((Object)aToPath));
    }

    default public ClassStructMap queryTo(Object[] aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), this.toPath((Object)aToPath));
    }

    default public ClassStructMap queryTo(Pattern aRegExp, String aToPath) {
        return new ClassStructMapImpl(PathMap.super.queryTo(aRegExp, aToPath));
    }

    default public ClassStructMap queryTo(String aPathQuery, String aToPath) {
        return new ClassStructMapImpl(PathMap.super.queryTo(aPathQuery, aToPath));
    }

    default public ClassStructMap queryTo(String[] aPathQuery, String aToPath) {
        return this.queryTo(this.toPath(aPathQuery), this.toPath((Object)aToPath));
    }

    default public ClassStructMap retrieveBetween(Collection<?> aFromPath, Collection<?> aToPath) {
        return this.retrieveBetween(this.toPath(aFromPath), this.toPath(aToPath));
    }

    default public ClassStructMap retrieveBetween(Object aFromPath, Object aToPath) {
        return this.retrieveBetween(this.toPath(aFromPath), this.toPath(aToPath));
    }

    default public ClassStructMap retrieveBetween(Object[] aFromPath, Object[] aToPath) {
        return this.retrieveBetween(this.toPath(aFromPath), this.toPath(aToPath));
    }

    default public ClassStructMap retrieveBetween(String aFromPath, String aToPath) {
        ClassStructMap thePathMap = this.retrieveFrom(aFromPath);
        return thePathMap.retrieveTo(aToPath);
    }

    default public ClassStructMap retrieveBetween(String[] aFromPath, String[] aToPath) {
        return this.retrieveBetween(this.toPath(aFromPath), this.toPath(aToPath));
    }

    default public ClassStructMap retrieveFrom(Collection<?> aPathElements) {
        return this.retrieveFrom(this.toPath(aPathElements));
    }

    default public ClassStructMap retrieveFrom(Object aParentPath) {
        return this.retrieveFrom(this.toPath(aParentPath));
    }

    default public ClassStructMap retrieveFrom(Object ... aPathElements) {
        return this.retrieveFrom(this.toPath(aPathElements));
    }

    public ClassStructMap retrieveFrom(String var1);

    default public ClassStructMap retrieveFrom(String ... aPathElements) {
        return this.retrieveFrom(this.toPath(aPathElements));
    }

    default public ClassStructMap getDir(Collection<?> aPathElements) {
        return this.getDir(this.toPath(aPathElements));
    }

    default public ClassStructMap getDir(Object aPath) {
        return this.getDir(this.toPath(aPath));
    }

    default public ClassStructMap getDir(Object ... aPathElements) {
        return this.getDir(this.toPath(aPathElements));
    }

    default public ClassStructMap getDir(String aPath) {
        return this.retrieveFrom(aPath);
    }

    default public ClassStructMap getDir(String ... aPathElements) {
        return this.getDir(this.toPath(aPathElements));
    }

    default public ClassStructMap[] getDirs(Collection<?> aPathElements) {
        return this.getDirs(this.toPath(aPathElements));
    }

    default public ClassStructMap[] getDirs(Object aPath) {
        return this.getDirs(this.toPath(aPath));
    }

    default public ClassStructMap[] getDirs(Object ... aPathElements) {
        return this.getDirs(this.toPath(aPathElements));
    }

    default public ClassStructMap[] getDirs(String aPath) {
        ClassStructMap[] theDirs;
        if (this.isIndexDir(aPath)) {
            int[] theIndexes = this.getDirIndexes(aPath);
            theDirs = new ClassStructMap[theIndexes[theIndexes.length - 1] + 1];
            int[] nArray = theIndexes;
            int n = theIndexes.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                theDirs[theIndexes[i]] = this.getDirAt(aPath, theIndexes[i]);
                ++n2;
            }
        } else {
            theDirs = new ClassStructMap[]{this.getDir(aPath)};
        }
        return theDirs;
    }

    default public ClassStructMap[] getDirs(String ... aPathElements) {
        return this.getDirs(this.toPath(aPathElements));
    }

    default public ClassStructMap retrieveTo(Collection<?> aToPathElements) {
        return this.retrieveTo(this.toPath(aToPathElements));
    }

    default public ClassStructMap retrieveTo(Object aToPath) {
        return this.retrieveTo(this.toPath(aToPath));
    }

    default public ClassStructMap retrieveTo(Object ... aToPathElements) {
        return this.retrieveTo(this.toPath(aToPathElements));
    }

    public ClassStructMap retrieveTo(String var1);

    default public ClassStructMap retrieveTo(String ... aToPathElements) {
        return this.retrieveTo(this.toPath(aToPathElements));
    }

    @Override
    default public Map<String, Class<?>> toMap() {
        HashMap theProperties = new HashMap();
        for (String eKey : this.keySet()) {
            theProperties.put(eKey, (Class)this.get((Object)eKey));
        }
        return theProperties;
    }

    default public Properties toProperties() {
        Properties theProperties = new Properties();
        for (String eKey : this.keySet()) {
            theProperties.put(this.toPropertyPath(eKey), this.get((Object)eKey));
        }
        return theProperties;
    }

    default public String getArraySelector() {
        return ARRAY_SELECTOR;
    }

    default public boolean isArrayType() {
        return this.isArrayType(this.getRootPath());
    }

    default public boolean isArrayType(String ... aPathElements) {
        return this.isArrayType(this.toPath(aPathElements));
    }

    default public boolean isArrayType(Collection<?> aPathElements) {
        return this.isArrayType(this.toPath(aPathElements));
    }

    default public boolean isArrayType(Object aPath) {
        return this.isArrayType(this.toPath(aPath));
    }

    default public boolean isArrayType(Object ... aPathElements) {
        return this.isArrayType(this.toPath(aPathElements));
    }

    default public boolean isArrayType(String aPath) {
        return this.isSimpleArrayType(aPath) || this.isCompositeArrayDir(aPath);
    }

    default public boolean isSimpleArrayType() {
        return this.isSimpleArrayType(this.getRootPath());
    }

    default public boolean isSimpleArrayType(Object aPath) {
        return this.isSimpleArrayType(this.toPath(aPath));
    }

    default public boolean isSimpleArrayType(Object ... aPathElements) {
        return this.isSimpleArrayType(this.toPath(aPathElements));
    }

    default public boolean isSimpleArrayType(String ... aPathElements) {
        return this.isSimpleArrayType(this.toPath(aPathElements));
    }

    default public boolean isSimpleArrayType(Collection<?> aPathElements) {
        return this.isSimpleArrayType(this.toPath(aPathElements));
    }

    default public boolean isSimpleArrayType(String aPath) {
        Class theClass = (Class)this.get((Object)(aPath = this.toNormalizedPath(aPath)));
        if (theClass != null && theClass.isArray() && SimpleType.isSimpleArrayType(theClass = theClass.getComponentType())) {
            return true;
        }
        theClass = (Class)this.get((Object)(aPath.endsWith(String.valueOf(this.getDelimiter()) + this.getArraySelector()) ? aPath : this.toPath(aPath, this.getArraySelector())));
        return theClass != null && SimpleType.isSimpleType(theClass);
    }

    default public Class<?> getSimpleArrayType() {
        return this.getSimpleArrayType(this.getRootPath());
    }

    default public Class<?> getSimpleArrayType(Object aPath) {
        return this.getSimpleArrayType(this.toPath(aPath));
    }

    default public Class<?> getSimpleArrayType(Object ... aPathElements) {
        return this.getSimpleArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getSimpleArrayType(String ... aPathElements) {
        return this.getSimpleArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getSimpleArrayType(Collection<?> aPathElements) {
        return this.getSimpleArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getSimpleArrayType(String aPath) {
        Class theClass = (Class)this.get((Object)(aPath = this.toNormalizedPath(aPath)));
        if (theClass != null && theClass.isArray() && SimpleType.isSimpleArrayType(theClass = theClass.getComponentType())) {
            return theClass;
        }
        theClass = (Class)this.get((Object)(aPath.endsWith(String.valueOf(this.getDelimiter()) + this.getArraySelector()) ? aPath : this.toPath(aPath, this.getArraySelector())));
        if (theClass != null && SimpleType.isSimpleType(theClass)) {
            return theClass;
        }
        throw new IllegalArgumentException("The provided path <" + aPath + "> does not direct to a simple array type!");
    }

    default public boolean isSimpleType() {
        return this.isSimpleType(this.getRootPath());
    }

    default public boolean isSimpleType(Object aPath) {
        return this.isSimpleType(this.toPath(aPath));
    }

    default public boolean isSimpleType(Object ... aPathElements) {
        return this.isSimpleType(this.toPath(aPathElements));
    }

    default public boolean isSimpleType(String ... aPathElements) {
        return this.isSimpleType(this.toPath(aPathElements));
    }

    default public boolean isSimpleType(Collection<?> aPathElements) {
        return this.isSimpleType(this.toPath(aPathElements));
    }

    default public boolean isSimpleType(String aPath) {
        Class theClass;
        if (!this.isSimpleArrayType() && (theClass = (Class)this.get((Object)(aPath = this.toNormalizedPath(aPath)))) != null) {
            return SimpleType.isSimpleType(theClass);
        }
        return false;
    }

    default public Class<?> getSimpleType() {
        return this.getSimpleArrayType(this.getRootPath());
    }

    default public Class<?> getSimpleType(Object aPath) {
        return this.getSimpleArrayType(this.toPath(aPath));
    }

    default public Class<?> getSimpleType(Object ... aPathElements) {
        return this.getSimpleArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getSimpleType(String ... aPathElements) {
        return this.getSimpleArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getSimpleType(Collection<?> aPathElements) {
        return this.getSimpleArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getSimpleType(String aPath) {
        Class theClass = (Class)this.get((Object)(aPath = this.toNormalizedPath(aPath)));
        return SimpleType.isSimpleType(theClass) ? theClass : null;
    }

    default public boolean isPrimitiveArrayType() {
        return this.isPrimitiveArrayType(this.getRootPath());
    }

    default public boolean isPrimitiveArrayType(Object aPath) {
        return this.isPrimitiveArrayType(this.toPath(aPath));
    }

    default public boolean isPrimitiveArrayType(Object ... aPathElements) {
        return this.isPrimitiveArrayType(this.toPath(aPathElements));
    }

    default public boolean isPrimitiveArrayType(String ... aPathElements) {
        return this.isPrimitiveArrayType(this.toPath(aPathElements));
    }

    default public boolean isPrimitiveArrayType(Collection<?> aPathElements) {
        return this.isPrimitiveArrayType(this.toPath(aPathElements));
    }

    default public boolean isPrimitiveArrayType(String aPath) {
        Class theClass = (Class)this.get((Object)(aPath = this.toNormalizedPath(aPath)));
        if (theClass != null && theClass.isArray() && SimpleType.isPrimitiveArrayType(theClass = theClass.getComponentType())) {
            return true;
        }
        theClass = (Class)this.get((Object)(aPath.endsWith(String.valueOf(this.getDelimiter()) + this.getArraySelector()) ? aPath : this.toPath(aPath, this.getArraySelector())));
        return theClass != null && SimpleType.isPrimitiveType(theClass);
    }

    default public Class<?> getPrimitiveArrayType() {
        return this.getPrimitiveArrayType(this.getRootPath());
    }

    default public Class<?> getPrimitiveArrayType(Object aPath) {
        return this.getPrimitiveArrayType(this.toPath(aPath));
    }

    default public Class<?> getPrimitiveArrayType(Object ... aPathElements) {
        return this.getPrimitiveArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getPrimitiveArrayType(String ... aPathElements) {
        return this.getPrimitiveArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getPrimitiveArrayType(Collection<?> aPathElements) {
        return this.getPrimitiveArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getPrimitiveArrayType(String aPath) {
        Class theClass = (Class)this.get((Object)(aPath = this.toNormalizedPath(aPath)));
        if (theClass != null && theClass.isArray() && SimpleType.isPrimitiveArrayType(theClass = theClass.getComponentType())) {
            return theClass;
        }
        theClass = (Class)this.get((Object)(aPath.endsWith(String.valueOf(this.getDelimiter()) + this.getArraySelector()) ? aPath : this.toPath(aPath, this.getArraySelector())));
        if (theClass != null && SimpleType.isPrimitiveType(theClass)) {
            return theClass;
        }
        throw new IllegalArgumentException("The provided path <" + aPath + "> does not direct to a primitive array type!");
    }

    default public boolean isPrimitiveType() {
        return this.isPrimitiveType(this.getRootPath());
    }

    default public boolean isPrimitiveType(Object aPath) {
        return this.isPrimitiveType(this.toPath(aPath));
    }

    default public boolean isPrimitiveType(Object ... aPathElements) {
        return this.isPrimitiveType(this.toPath(aPathElements));
    }

    default public boolean isPrimitiveType(String ... aPathElements) {
        return this.isPrimitiveType(this.toPath(aPathElements));
    }

    default public boolean isPrimitiveType(Collection<?> aPathElements) {
        return this.isPrimitiveType(this.toPath(aPathElements));
    }

    default public boolean isPrimitiveType(String aPath) {
        Class theClass;
        if (!this.isPrimitiveArrayType() && (theClass = (Class)this.get((Object)(aPath = this.toNormalizedPath(aPath)))) != null) {
            return SimpleType.isPrimitiveType(theClass);
        }
        return false;
    }

    default public Class<?> getPrimitiveType() {
        return this.getPrimitiveArrayType(this.getRootPath());
    }

    default public Class<?> getPrimitiveType(Object aPath) {
        return this.getPrimitiveArrayType(this.toPath(aPath));
    }

    default public Class<?> getPrimitiveType(Object ... aPathElements) {
        return this.getPrimitiveArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getPrimitiveType(String ... aPathElements) {
        return this.getPrimitiveArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getPrimitiveType(Collection<?> aPathElements) {
        return this.getPrimitiveArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getPrimitiveType(String aPath) {
        Class theClass = (Class)this.get((Object)(aPath = this.toNormalizedPath(aPath)));
        return SimpleType.isPrimitiveType(theClass) ? theClass : null;
    }

    default public boolean isWrapperArrayType() {
        return this.isWrapperArrayType(this.getRootPath());
    }

    default public boolean isWrapperArrayType(Object aPath) {
        return this.isWrapperArrayType(this.toPath(aPath));
    }

    default public boolean isWrapperArrayType(Object ... aPathElements) {
        return this.isWrapperArrayType(this.toPath(aPathElements));
    }

    default public boolean isWrapperArrayType(String ... aPathElements) {
        return this.isWrapperArrayType(this.toPath(aPathElements));
    }

    default public boolean isWrapperArrayType(Collection<?> aPathElements) {
        return this.isWrapperArrayType(this.toPath(aPathElements));
    }

    default public boolean isWrapperArrayType(String aPath) {
        Class theClass = (Class)this.get((Object)(aPath = this.toNormalizedPath(aPath)));
        if (theClass != null && theClass.isArray() && SimpleType.isWrapperArrayType(theClass = theClass.getComponentType())) {
            return true;
        }
        theClass = (Class)this.get((Object)(aPath.endsWith(String.valueOf(this.getDelimiter()) + this.getArraySelector()) ? aPath : this.toPath(aPath, this.getArraySelector())));
        return theClass != null && SimpleType.isWrapperType(theClass);
    }

    default public Class<?> getWrapperArrayType() {
        return this.getWrapperArrayType(this.getRootPath());
    }

    default public Class<?> getWrapperArrayType(Object aPath) {
        return this.getWrapperArrayType(this.toPath(aPath));
    }

    default public Class<?> getWrapperArrayType(Object ... aPathElements) {
        return this.getWrapperArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getWrapperArrayType(String ... aPathElements) {
        return this.getWrapperArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getWrapperArrayType(Collection<?> aPathElements) {
        return this.getWrapperArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getWrapperArrayType(String aPath) {
        Class theClass = (Class)this.get((Object)(aPath = this.toNormalizedPath(aPath)));
        if (theClass != null && theClass.isArray() && SimpleType.isWrapperArrayType(theClass = theClass.getComponentType())) {
            return theClass;
        }
        theClass = (Class)this.get((Object)(aPath.endsWith(String.valueOf(this.getDelimiter()) + this.getArraySelector()) ? aPath : this.toPath(aPath, this.getArraySelector())));
        if (theClass != null && SimpleType.isWrapperType(theClass)) {
            return theClass;
        }
        throw new IllegalArgumentException("The provided path <" + aPath + "> does not direct to a wrapper array type!");
    }

    default public boolean isWrapperType() {
        return this.isWrapperType(this.getRootPath());
    }

    default public boolean isWrapperType(Object aPath) {
        return this.isWrapperType(this.toPath(aPath));
    }

    default public boolean isWrapperType(Object ... aPathElements) {
        return this.isWrapperType(this.toPath(aPathElements));
    }

    default public boolean isWrapperType(String ... aPathElements) {
        return this.isWrapperType(this.toPath(aPathElements));
    }

    default public boolean isWrapperType(Collection<?> aPathElements) {
        return this.isWrapperType(this.toPath(aPathElements));
    }

    default public boolean isWrapperType(String aPath) {
        Class theClass;
        if (!this.isWrapperArrayType() && (theClass = (Class)this.get((Object)(aPath = this.toNormalizedPath(aPath)))) != null) {
            return SimpleType.isWrapperType(theClass);
        }
        return false;
    }

    default public Class<?> getWrapperType() {
        return this.getWrapperArrayType(this.getRootPath());
    }

    default public Class<?> getWrapperType(Object aPath) {
        return this.getWrapperArrayType(this.toPath(aPath));
    }

    default public Class<?> getWrapperType(Object ... aPathElements) {
        return this.getWrapperArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getWrapperType(String ... aPathElements) {
        return this.getWrapperArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getWrapperType(Collection<?> aPathElements) {
        return this.getWrapperArrayType(this.toPath(aPathElements));
    }

    default public Class<?> getWrapperType(String aPath) {
        Class theClass = (Class)this.get((Object)(aPath = this.toNormalizedPath(aPath)));
        return SimpleType.isWrapperType(theClass) ? theClass : null;
    }

    default public boolean isCompositeArrayDir() {
        return this.isCompositeArrayDir(this.getRootPath());
    }

    default public boolean isCompositeArrayDir(Object aPath) {
        return this.isCompositeArrayDir(this.toPath(aPath));
    }

    default public boolean isCompositeArrayDir(Object ... aPathElements) {
        return this.isCompositeArrayDir(this.toPath(aPathElements));
    }

    default public boolean isCompositeArrayDir(String ... aPathElements) {
        return this.isCompositeArrayDir(this.toPath(aPathElements));
    }

    default public boolean isCompositeArrayDir(Collection<?> aPathElements) {
        return this.isCompositeArrayDir(this.toPath(aPathElements));
    }

    default public boolean isCompositeArrayDir(String aPath) {
        return this.isDir((aPath = this.toNormalizedPath(aPath)).endsWith(String.valueOf(this.getDelimiter()) + this.getArraySelector()) ? aPath : this.toPath(aPath, this.getArraySelector()));
    }

    default public ClassStructMap getCompositeArrayDir() {
        return this.getCompositeArrayDir(this.getRootPath());
    }

    default public ClassStructMap getCompositeArrayDir(Object aPath) {
        return this.getCompositeArrayDir(this.toPath(aPath));
    }

    default public ClassStructMap getCompositeArrayDir(Object ... aPathElements) {
        return this.getCompositeArrayDir(this.toPath(aPathElements));
    }

    default public ClassStructMap getCompositeArrayDir(String ... aPathElements) {
        return this.getCompositeArrayDir(this.toPath(aPathElements));
    }

    default public ClassStructMap getCompositeArrayDir(Collection<?> aPathElements) {
        return this.getCompositeArrayDir(this.toPath(aPathElements));
    }

    default public ClassStructMap getCompositeArrayDir(String aPath) {
        if (this.isCompositeArrayDir(aPath = this.toNormalizedPath(aPath))) {
            return this.retrieveFrom(aPath.endsWith(String.valueOf(this.getDelimiter()) + this.getArraySelector()) ? aPath : this.toPath(aPath, this.getArraySelector()));
        }
        return null;
    }

    default public boolean isCompositeDir() {
        return this.isCompositeDir(this.getRootPath());
    }

    default public boolean isCompositeDir(Object aPath) {
        return this.isCompositeDir(this.toPath(aPath));
    }

    default public boolean isCompositeDir(Object ... aPathElements) {
        return this.isCompositeDir(this.toPath(aPathElements));
    }

    default public boolean isCompositeDir(String ... aPathElements) {
        return this.isCompositeDir(this.toPath(aPathElements));
    }

    default public boolean isCompositeDir(Collection<?> aPathElements) {
        return this.isCompositeDir(this.toPath(aPathElements));
    }

    default public boolean isCompositeDir(String aPath) {
        return this.isDir(aPath = this.toNormalizedPath(aPath)) && !this.isCompositeArrayDir() && !this.isSimpleType(aPath);
    }

    default public ClassStructMap getCompositeDir() {
        return this.getCompositeDir(this.getRootPath());
    }

    default public ClassStructMap getCompositeDir(Object aPath) {
        return this.getCompositeDir(this.toPath(aPath));
    }

    default public ClassStructMap getCompositeDir(Object ... aPathElements) {
        return this.getCompositeDir(this.toPath(aPathElements));
    }

    default public ClassStructMap getCompositeDir(String ... aPathElements) {
        return this.getCompositeDir(this.toPath(aPathElements));
    }

    default public ClassStructMap getCompositeDir(Collection<?> aPathElements) {
        return this.getCompositeDir(this.toPath(aPathElements));
    }

    default public ClassStructMap getCompositeDir(String aPath) {
        if (this.isCompositeDir(aPath = this.toNormalizedPath(aPath))) {
            return this.retrieveFrom(aPath);
        }
        return null;
    }

    public static interface ClassStructMapBuilder
    extends MutableClassStructMap,
    PathMap.PathMapBuilder<Class<?>> {
        @Override
        default public ClassStructMapBuilder withPut(Collection<?> aPathElements, Class<?> aValue) {
            this.put(aPathElements, aValue);
            return this;
        }

        @Override
        default public ClassStructMapBuilder withPut(Object[] aPathElements, Class<?> aValue) {
            this.put(aPathElements, aValue);
            return this;
        }

        @Override
        default public ClassStructMapBuilder withPut(Relation<String, Class<?>> aProperty) {
            this.put((Relation)aProperty);
            return this;
        }

        default public ClassStructMapBuilder withPut(Property aProperty) {
            this.put(aProperty);
            return this;
        }

        @Override
        default public ClassStructMapBuilder withPut(String[] aKey, Class<?> aValue) {
            this.put(aKey, aValue);
            return this;
        }

        default public ClassStructMapBuilder withInsert(Object aObj) {
            this.insert(aObj);
            return this;
        }

        default public ClassStructMapBuilder withInsert(PathMap<Class<?>> aFrom) {
            this.insert(aFrom);
            return this;
        }

        default public ClassStructMapBuilder withInsertBetween(Collection<?> aToPathElements, Object aFrom, Collection<?> aFromPathElements) {
            this.insertBetween(aToPathElements, aFrom, aFromPathElements);
            return this;
        }

        default public ClassStructMapBuilder withInsertBetween(Collection<?> aToPathElements, PathMap<Class<?>> aFrom, Collection<?> aFromPathElements) {
            this.insertBetween(aToPathElements, aFrom, aFromPathElements);
            return this;
        }

        default public ClassStructMapBuilder withInsertBetween(Object aToPath, Object aFrom, Object aFromPath) {
            this.insertBetween(aToPath, aFrom, aFromPath);
            return this;
        }

        default public ClassStructMapBuilder withInsertBetween(Object aToPath, PathMap<Class<?>> aFrom, Object aFromPath) {
            this.insertBetween(aToPath, aFrom, aFromPath);
            return this;
        }

        default public ClassStructMapBuilder withInsertBetween(Object[] aToPathElements, Object aFrom, Object[] aFromPathElements) {
            this.insertBetween(aToPathElements, aFrom, aFromPathElements);
            return this;
        }

        default public ClassStructMapBuilder withInsertBetween(Object[] aToPathElements, PathMap<Class<?>> aFrom, Object[] aFromPathElements) {
            this.insertBetween(aToPathElements, aFrom, aFromPathElements);
            return this;
        }

        default public ClassStructMapBuilder withInsertBetween(String aToPath, Object aFrom, String aFromPath) {
            this.insertBetween(aToPath, aFrom, aFromPath);
            return this;
        }

        default public ClassStructMapBuilder withInsertBetween(String aToPath, PathMap<Class<?>> aFrom, String aFromPath) {
            this.insertBetween(aToPath, aFrom, aFromPath);
            return this;
        }

        default public ClassStructMapBuilder withInsertBetween(String[] aToPathElements, Object aFrom, String[] aFromPathElements) {
            this.insertBetween(aToPathElements, aFrom, aFromPathElements);
            return this;
        }

        default public ClassStructMapBuilder withInsertBetween(String[] aToPathElements, PathMap<Class<?>> aFrom, String[] aFromPathElements) {
            this.insertBetween(aToPathElements, aFrom, aFromPathElements);
            return this;
        }

        default public ClassStructMapBuilder withInsertFrom(Object aFrom, Collection<?> aFromPathElements) {
            this.insertFrom(aFrom, aFromPathElements);
            return this;
        }

        default public ClassStructMapBuilder withInsertFrom(Object aFrom, Object aFromPath) {
            this.insertFrom(aFrom, aFromPath);
            return this;
        }

        default public ClassStructMapBuilder withInsertFrom(Object aFrom, Object ... aFromPathElements) {
            this.withInsertFrom(aFrom, aFromPathElements);
            return this;
        }

        default public ClassStructMapBuilder withInsertFrom(Object aFrom, String aFromPath) {
            this.insertFrom(aFrom, aFromPath);
            return this;
        }

        default public ClassStructMapBuilder withInsertFrom(Object aFrom, String ... aFromPathElements) {
            this.insertFrom(aFrom, aFromPathElements);
            return this;
        }

        default public ClassStructMapBuilder withInsertFrom(PathMap<Class<?>> aFrom, Collection<?> aFromPathElements) {
            this.insertFrom(aFrom, aFromPathElements);
            return this;
        }

        default public ClassStructMapBuilder withInsertFrom(PathMap<Class<?>> aFrom, Object aFromPath) {
            this.insertFrom(aFrom, aFromPath);
            return this;
        }

        default public ClassStructMapBuilder withInsertFrom(PathMap<Class<?>> aFrom, Object ... aFromPathElements) {
            this.withInsertFrom((PathMap)aFrom, aFromPathElements);
            return this;
        }

        default public ClassStructMapBuilder withInsertFrom(PathMap<Class<?>> aFrom, String aFromPath) {
            this.insertFrom(aFrom, aFromPath);
            return this;
        }

        default public ClassStructMapBuilder withInsertFrom(PathMap<Class<?>> aFrom, String ... aFromPathElements) {
            this.insertFrom(aFrom, aFromPathElements);
            return this;
        }

        default public ClassStructMapBuilder withInsertTo(Collection<?> aToPathElements, Object aFrom) {
            this.insertTo(aToPathElements, aFrom);
            return this;
        }

        default public ClassStructMapBuilder withInsertTo(Collection<?> aToPathElements, PathMap<Class<?>> aFrom) {
            this.insertTo(aToPathElements, aFrom);
            return this;
        }

        default public ClassStructMapBuilder withInsertTo(Object aToPath, Object aFrom) {
            this.insertTo(aToPath, aFrom);
            return this;
        }

        default public ClassStructMapBuilder withInsertTo(Object aToPath, PathMap<Class<?>> aFrom) {
            this.insertTo(aToPath, aFrom);
            return this;
        }

        default public ClassStructMapBuilder withInsertTo(Object[] aToPathElements, Object aFrom) {
            this.insertTo(aToPathElements, aFrom);
            return this;
        }

        default public ClassStructMapBuilder withInsertTo(Object[] aToPathElements, PathMap<Class<?>> aFrom) {
            this.insertTo(aToPathElements, aFrom);
            return this;
        }

        default public ClassStructMapBuilder withInsertTo(String aToPath, Object aFrom) {
            this.insertTo(aToPath, aFrom);
            return this;
        }

        default public ClassStructMapBuilder withInsertTo(String aToPath, PathMap<Class<?>> aFrom) {
            this.insertTo(aToPath, aFrom);
            return this;
        }

        default public ClassStructMapBuilder withInsertTo(String[] aToPathElements, Object aFrom) {
            this.insertTo(aToPathElements, aFrom);
            return this;
        }

        default public ClassStructMapBuilder withInsertTo(String[] aToPathElements, PathMap<Class<?>> aFrom) {
            this.insertTo(aToPathElements, aFrom);
            return this;
        }

        default public ClassStructMapBuilder withMerge(Object aObj) {
            this.merge(aObj);
            return this;
        }

        default public ClassStructMapBuilder withMerge(PathMap<Class<?>> aFrom) {
            this.merge(aFrom);
            return this;
        }

        default public ClassStructMapBuilder withMergeBetween(Collection<?> aToPathElements, Object aFrom, Collection<?> aFromPathElements) {
            this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
            return this;
        }

        default public ClassStructMapBuilder withMergeBetween(Collection<?> aToPathElements, PathMap<Class<?>> aFrom, Collection<?> aFromPathElements) {
            this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
            return this;
        }

        default public ClassStructMapBuilder withMergeBetween(Object aToPath, Object aFrom, Object aFromPath) {
            this.mergeBetween(aToPath, aFrom, aFromPath);
            return this;
        }

        default public ClassStructMapBuilder withMergeBetween(Object aToPath, PathMap<Class<?>> aFrom, Object aFromPath) {
            this.mergeBetween(aToPath, aFrom, aFromPath);
            return this;
        }

        default public ClassStructMapBuilder withMergeBetween(Object[] aToPathElements, Object aFrom, Object[] aFromPathElements) {
            this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
            return this;
        }

        default public ClassStructMapBuilder withMergeBetween(Object[] aToPathElements, PathMap<Class<?>> aFrom, Object[] aFromPathElements) {
            this.mergeBetween(aToPathElements, aFromPathElements, aFromPathElements);
            return this;
        }

        default public ClassStructMapBuilder withMergeBetween(String aToPath, Object aFrom, String aFromPath) {
            this.mergeBetween(aToPath, aFrom, aFromPath);
            return this;
        }

        default public ClassStructMapBuilder withMergeBetween(String aToPath, PathMap<Class<?>> aFrom, String aFromPath) {
            this.mergeBetween(aToPath, aFrom, aFromPath);
            return this;
        }

        default public ClassStructMapBuilder withMergeBetween(String[] aToPathElements, Object aFrom, String[] aFromPathElements) {
            this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
            return this;
        }

        default public ClassStructMapBuilder withMergeBetween(String[] aToPathElements, PathMap<Class<?>> aFrom, String[] aFromPathElements) {
            this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
            return this;
        }

        default public ClassStructMapBuilder withMergeFrom(Object aFrom, Collection<?> aFromPathElements) {
            this.mergeFrom(aFrom, aFromPathElements);
            return this;
        }

        default public ClassStructMapBuilder withMergeFrom(Object aFrom, Object aFromPath) {
            this.mergeFrom(aFrom, aFromPath);
            return this;
        }

        default public ClassStructMapBuilder withMergeFrom(Object aFrom, Object ... aFromPathElements) {
            this.mergeFrom(aFrom, aFromPathElements);
            return this;
        }

        default public ClassStructMapBuilder withMergeFrom(Object aFrom, String aFromPath) {
            this.mergeFrom(aFrom, aFromPath);
            return this;
        }

        default public ClassStructMapBuilder withMergeFrom(Object aFrom, String ... aFromPathElements) {
            this.mergeFrom(aFrom, aFromPathElements);
            return this;
        }

        default public ClassStructMapBuilder withMergeFrom(PathMap<Class<?>> aFrom, Collection<?> aFromPathElements) {
            this.mergeFrom(aFrom, aFromPathElements);
            return this;
        }

        default public ClassStructMapBuilder withMergeFrom(PathMap<Class<?>> aFrom, Object aFromPath) {
            this.mergeFrom(aFrom, aFromPath);
            return this;
        }

        default public ClassStructMapBuilder withMergeFrom(PathMap<Class<?>> aFrom, Object ... aFromPathElements) {
            this.mergeFrom(aFrom, aFromPathElements);
            return this;
        }

        default public ClassStructMapBuilder withMergeFrom(PathMap<Class<?>> aFrom, String aFromPath) {
            this.mergeFrom(aFrom, aFromPath);
            return this;
        }

        default public ClassStructMapBuilder withMergeFrom(PathMap<Class<?>> aFrom, String ... aFromPathElements) {
            this.mergeFrom(aFrom, aFromPathElements);
            return this;
        }

        default public ClassStructMapBuilder withMergeTo(Collection<?> aToPathElements, Object aFrom) {
            this.mergeTo(aToPathElements, aFrom);
            return this;
        }

        default public ClassStructMapBuilder withMergeTo(Collection<?> aToPathElements, PathMap<Class<?>> aFrom) {
            this.mergeTo(aToPathElements, aFrom);
            return this;
        }

        default public ClassStructMapBuilder withMergeTo(Object aToPath, Object aFrom) {
            this.mergeTo(aToPath, aFrom);
            return this;
        }

        default public ClassStructMapBuilder withMergeTo(Object aToPath, PathMap<Class<?>> aFrom) {
            this.mergeTo(aToPath, aFrom);
            return this;
        }

        default public ClassStructMapBuilder withMergeTo(Object[] aToPathElements, Object aFrom) {
            this.mergeTo(aToPathElements, aFrom);
            return this;
        }

        default public ClassStructMapBuilder withMergeTo(Object[] aToPathElements, PathMap<Class<?>> aFrom) {
            this.mergeTo(aToPathElements, aFrom);
            return this;
        }

        default public ClassStructMapBuilder withMergeTo(String aToPath, Object aFrom) {
            this.mergeTo(aToPath, aFrom);
            return this;
        }

        default public ClassStructMapBuilder withMergeTo(String aToPath, PathMap<Class<?>> aFrom) {
            this.mergeTo(aToPath, aFrom);
            return this;
        }

        default public ClassStructMapBuilder withMergeTo(String[] aToPathElements, Object aFrom) {
            this.mergeTo(aToPathElements, aFrom);
            return this;
        }

        default public ClassStructMapBuilder withMergeTo(String[] aToPathElements, PathMap<Class<?>> aFrom) {
            this.mergeTo(aToPathElements, aFrom);
            return this;
        }

        default public ClassStructMapBuilder withPutDirAt(Collection<?> aPathElements, int aIndex, Object aDir) {
            this.putDirAt((Collection)aPathElements, aIndex, aDir);
            return this;
        }

        default public ClassStructMapBuilder withPutDirAt(Collection<?> aPathElements, int aIndex, PathMap<Class<?>> aDir) {
            this.putDirAt((Collection)aPathElements, aIndex, (PathMap)aDir);
            return this;
        }

        default public ClassStructMapBuilder withPutDirAt(int aIndex, Object aDir) {
            this.putDirAt(aIndex, aDir);
            return this;
        }

        default public ClassStructMapBuilder withPutDirAt(int aIndex, PathMap<Class<?>> aDir) {
            this.putDirAt(aIndex, (PathMap)aDir);
            return this;
        }

        default public ClassStructMapBuilder withPutDirAt(Object aPath, int aIndex, Object aDir) {
            this.putDirAt(aPath, aIndex, aDir);
            return this;
        }

        default public ClassStructMapBuilder withPutDirAt(Object aPath, int aIndex, PathMap<Class<?>> aDir) {
            this.putDirAt(aPath, aIndex, (PathMap)aDir);
            return this;
        }

        default public ClassStructMapBuilder withPutDirAt(Object[] aPathElements, int aIndex, Object aDir) {
            this.putDirAt(aPathElements, aIndex, aDir);
            return this;
        }

        default public ClassStructMapBuilder withPutDirAt(Object[] aPathElements, int aIndex, PathMap<Class<?>> aDir) {
            this.putDirAt(aPathElements, aIndex, (PathMap)aDir);
            return this;
        }

        default public ClassStructMapBuilder withPutDirAt(String aPath, int aIndex, Object aDir) {
            this.putDirAt(aPath, aIndex, aDir);
            return this;
        }

        default public ClassStructMapBuilder withPutDirAt(String aPath, int aIndex, PathMap<Class<?>> aDir) {
            this.putDirAt(aPath, aIndex, (PathMap)aDir);
            return this;
        }

        default public ClassStructMapBuilder withPutDirAt(String[] aPathElements, int aIndex, Object aDir) {
            this.putDirAt(aPathElements, aIndex, aDir);
            return this;
        }

        default public ClassStructMapBuilder withPutDirAt(String[] aPathElements, int aIndex, PathMap<Class<?>> aDir) {
            this.putDirAt(aPathElements, aIndex, (PathMap)aDir);
            return this;
        }

        default public ClassStructMapBuilder withRemoveFrom(Collection<?> aPathElements) {
            this.removeFrom((Collection)aPathElements);
            return this;
        }

        default public ClassStructMapBuilder withRemoveFrom(Object aPath) {
            this.removeFrom(aPath);
            return this;
        }

        default public ClassStructMapBuilder withRemoveFrom(Object ... aPathElements) {
            this.removeFrom(aPathElements);
            return this;
        }

        default public ClassStructMapBuilder withRemoveFrom(String aPath) {
            this.removeFrom(aPath);
            return this;
        }

        default public ClassStructMapBuilder withRemoveFrom(String ... aPathElements) {
            this.removeFrom(aPathElements);
            return this;
        }

        default public ClassStructMapBuilder withRemovePaths(String ... aPathElements) {
            this.removeFrom(aPathElements);
            return this;
        }
    }

    public static interface MutableClassStructMap
    extends ClassStructMap,
    PathMap.MutablePathMap<Class<?>>,
    Map<String, Class<?>> {
        @Override
        default public boolean containsValue(Object value) {
            return this.values().contains(value);
        }

        default public void insert(ClassStructMap aFrom) {
            this.insert(aFrom);
        }

        default public void insertBetween(String aToPath, ClassStructMap aFrom, String aFromPath) {
            this.insertBetween(aToPath, aFrom, aFromPath);
        }

        default public void insertFrom(ClassStructMap aFrom, String aFromPath) {
            this.insertFrom(aFrom, aFromPath);
        }

        default public void insertTo(String aToPath, ClassStructMap aFrom) {
            this.insertTo(aToPath, aFrom);
        }

        @Override
        default public String put(Object aKey, String aValue) {
            return this.put(aKey instanceof String ? (String)aKey : (aKey != null ? aKey.toString() : null), aValue);
        }

        @Override
        default public Class<?> put(Object[] aPathElements, Class<?> aValue) {
            return (Class)this.put(this.toPath(aPathElements), aValue);
        }

        default public String put(Property aProperty) {
            return this.put(aProperty.getKey(), (String)aProperty.getValue());
        }

        @Override
        default public Class<?> put(Relation<String, Class<?>> aRelation) {
            return (Class)this.put((String)aRelation.getKey(), (Class)aRelation.getValue());
        }

        @Override
        default public Class<?> put(String[] aPathElements, Class<?> aValue) {
            return (Class)this.put(this.toPath(aPathElements), aValue);
        }

        default public void putAll(ClassStructMap aProperties) {
            for (Object eKey : aProperties.keySet()) {
                this.put((String)eKey, (Class)this.get((Object)((String)eKey)));
            }
        }

        default public void putAll(Properties aProperties) {
            for (Object eKey : aProperties.keySet()) {
                this.put((String)eKey, (Class)this.get((Object)((String)eKey)));
            }
        }

        @Override
        default public void putAll(Map<? extends String, ? extends Class<?>> aProperties) {
            for (String string : aProperties.keySet()) {
                this.put(string, (Class)this.get((Object)string));
            }
        }

        default public ClassStructMap putDirAt(Collection<?> aPathElements, int aIndex, Object aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
        }

        default public ClassStructMap putDirAt(Collection<?> aPathElements, int aIndex, PathMap<Class<?>> aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, (PathMap)aDir);
        }

        default public ClassStructMap putDirAt(int aIndex, Object aDir) {
            return this.putDirAt(this.getRootPath(), aIndex, aDir);
        }

        default public ClassStructMap putDirAt(int aIndex, PathMap<Class<?>> aDir) {
            return this.putDirAt(this.getRootPath(), aIndex, (PathMap)aDir);
        }

        default public ClassStructMap putDirAt(Object aPath, int aIndex, Object aDir) {
            return this.putDirAt(this.toPath(aPath), aIndex, aDir);
        }

        default public ClassStructMap putDirAt(Object aPath, int aIndex, PathMap<Class<?>> aDir) {
            return this.putDirAt(this.toPath(aPath), aIndex, (PathMap)aDir);
        }

        default public ClassStructMap putDirAt(Object[] aPathElements, int aIndex, Object aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
        }

        default public ClassStructMap putDirAt(Object[] aPathElements, int aIndex, PathMap<Class<?>> aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, (PathMap)aDir);
        }

        default public ClassStructMap putDirAt(String aPath, int aIndex, Object aDir) {
            ClassStructMap theReplaced = this.removeDirAt(aPath, aIndex);
            this.insertTo(this.toPath(aPath, aIndex), aDir);
            return theReplaced;
        }

        default public ClassStructMap putDirAt(String aPath, int aIndex, PathMap<Class<?>> aDir) {
            ClassStructMap theReplaced = this.removeDirAt(aPath, aIndex);
            this.insertTo(this.toPath(aPath, aIndex), aDir);
            return theReplaced;
        }

        default public ClassStructMap putDirAt(String[] aPathElements, int aIndex, Object aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, aDir);
        }

        default public ClassStructMap putDirAt(String[] aPathElements, int aIndex, PathMap<Class<?>> aDir) {
            return this.putDirAt(this.toPath(aPathElements), aIndex, (PathMap)aDir);
        }

        default public ClassStructMap removeAll(Collection<?> aPathQueryElements) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeAll(aPathQueryElements));
        }

        default public ClassStructMap removeAll(Object ... aPathQueryElements) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeAll(aPathQueryElements));
        }

        default public ClassStructMap removeAll(Object aPathQuery) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeAll(aPathQuery));
        }

        default public ClassStructMap removeAll(Pattern aRegExp) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeAll(aRegExp));
        }

        default public ClassStructMap removeAll(String ... aPathQueryElements) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeAll(aPathQueryElements));
        }

        default public ClassStructMap removeAll(String aPathQuery) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeAll(aPathQuery));
        }

        default public ClassStructMap removeDirAt(int aIndex) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeDirAt(aIndex));
        }

        default public ClassStructMap removeDirAt(Object aPath, int aIndex) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeDirAt(aPath, aIndex));
        }

        default public ClassStructMap removeDirAt(Object[] aPathElements, int aIndex) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeDirAt(aPathElements, aIndex));
        }

        default public ClassStructMap removeDirAt(String aPath, int aIndex) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeDirAt(aPath, aIndex));
        }

        default public ClassStructMap removeDirAt(String[] aPathElements, int aIndex) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeDirAt(aPathElements, aIndex));
        }

        default public ClassStructMap removeFrom(Collection<?> aPathElements) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeFrom(aPathElements));
        }

        default public ClassStructMap removeFrom(Object ... aPathElements) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeFrom(aPathElements));
        }

        default public ClassStructMap removeFrom(Object aPath) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeFrom(aPath));
        }

        default public ClassStructMap removeFrom(String aPath) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeFrom(aPath));
        }

        default public ClassStructMap removeFrom(String ... aPathElements) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removeFrom(aPathElements));
        }

        default public ClassStructMap removePaths(Collection<?> aPaths) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removePaths(aPaths));
        }

        default public ClassStructMap removePaths(String ... aPaths) {
            return new ClassStructMapImpl(PathMap.MutablePathMap.super.removePaths(aPaths));
        }

        default public Map<String, String> toDump(Map<String, String> aDump) {
            Iterator iterator = this.keySet().iterator();
            while (iterator.hasNext()) {
                String eKey;
                Class eValue = (Class)this.get((Object)(eKey = (String)iterator.next()));
                aDump.put(eKey, eValue != null ? eValue.getName() : null);
            }
            return aDump;
        }
    }
}

