/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct;

import java.util.Collection;
import org.refcodes.data.BooleanLiterals;
import org.refcodes.data.Literal;
import org.refcodes.mixin.AliasAccessor;
import org.refcodes.struct.PathMap;
import org.refcodes.struct.Relation;

public interface InterOperableMap<T>
extends PathMap<T> {
    default public Boolean getBoolean(Object ... aPathElements) {
        return this.getBoolean(this.toPath(aPathElements));
    }

    default public Boolean getBoolean(Collection<?> aPathElements) {
        return this.getBoolean(this.toPath(aPathElements));
    }

    default public Boolean getBoolean(Object aKey) {
        return this.getBoolean(InterOperableMap.asKey(aKey));
    }

    default public Boolean getBoolean(String ... aPathElements) {
        return this.getBoolean(this.toPath(aPathElements));
    }

    default public Boolean getBoolean(String aKey) {
        Object theValue = this.get((Object)aKey);
        if (theValue == null) {
            return false;
        }
        if (theValue instanceof Boolean) {
            return (Boolean)theValue;
        }
        if (theValue instanceof String) {
            String[] stringArray = BooleanLiterals.TRUE.getNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String eTrue = stringArray[n2];
                if (eTrue.equalsIgnoreCase((String)theValue)) {
                    return true;
                }
                ++n2;
            }
            stringArray = BooleanLiterals.FALSE.getNames();
            n = stringArray.length;
            n2 = 0;
            while (n2 < n) {
                String eFalse = stringArray[n2];
                if (eFalse.equalsIgnoreCase((String)theValue)) {
                    return false;
                }
                ++n2;
            }
        }
        throw new NumberFormatException("Unable to parse a boolean from the value <" + theValue + "> of type <" + theValue.getClass().getName() + ">!");
    }

    default public Boolean getBooleanOr(Object aKey, Boolean aDefaultValue) {
        Boolean theValue = this.getBoolean(aKey);
        if (theValue == null) {
            return aDefaultValue;
        }
        return theValue;
    }

    default public Boolean getBooleanOr(Object[] aPathElements, Boolean aDefaultValue) {
        return this.getBooleanOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Boolean getBooleanOr(Collection<?> aPathElements, Boolean aDefaultValue) {
        return this.getBooleanOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Boolean getBooleanOr(String aKey, Boolean aDefaultValue) {
        Boolean theValue = this.getBoolean(aKey);
        if (theValue == null) {
            return aDefaultValue;
        }
        return theValue;
    }

    default public Boolean getBooleanOr(String[] aPathElements, Boolean aDefaultValue) {
        return this.getBooleanOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Byte getByte(Object ... aPathElements) {
        return this.getByte(this.toPath(aPathElements));
    }

    default public Byte getByte(Collection<?> aPathElements) {
        return this.getByte(this.toPath(aPathElements));
    }

    default public Byte getByte(Object aKey) {
        return this.getByte(InterOperableMap.asKey(aKey));
    }

    default public Byte getByte(String ... aPathElements) {
        return this.getByte(this.toPath(aPathElements));
    }

    default public Byte getByte(String aKey) {
        Object theValue = this.get((Object)aKey);
        if (theValue == null) {
            return null;
        }
        if (theValue instanceof Byte) {
            return (Byte)theValue;
        }
        Object v = theValue;
        if (v instanceof String) {
            String theString;
            String string = (String)v;
            String cfr_ignored_0 = (String)v;
            if (theString.endsWith(".0")) {
                theString = theString.substring(0, theString.length() - 2);
            }
            return Byte.valueOf(theString);
        }
        throw new NumberFormatException("Unable to parse a byte from the value <" + theValue + "> of type <" + theValue.getClass().getName() + ">!");
    }

    default public Byte getByteOr(Object aKey, Byte aDefaultValue) {
        Byte theValue = this.getByte(aKey);
        if (theValue == null) {
            return aDefaultValue;
        }
        return theValue;
    }

    default public Byte getByteOr(Object[] aPathElements, Byte aDefaultValue) {
        return this.getByteOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Byte getByteOr(Collection<?> aPathElements, Byte aDefaultValue) {
        return this.getByteOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Byte getByteOr(String aKey, Byte aDefaultValue) {
        Byte theValue = this.getByte(aKey);
        if (theValue == null) {
            return aDefaultValue;
        }
        return theValue;
    }

    default public Byte getByteOr(String[] aPathElements, Byte aDefaultValue) {
        return this.getByteOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Character getChar(Object aKey) {
        return this.getChar(InterOperableMap.asKey(aKey));
    }

    /*
     * WARNING - void declaration
     */
    default public Character getChar(String aKey) {
        Object theValue = this.get((Object)aKey);
        if (theValue == null) {
            return null;
        }
        if (theValue instanceof Character) {
            return (Character)theValue;
        }
        Object v = theValue;
        if (v instanceof String) {
            void theString;
            String string = (String)v;
            String cfr_ignored_0 = (String)v;
            if (theString.length() == 1) {
                return Character.valueOf(theString.charAt(0));
            }
        }
        throw new NumberFormatException("Unable to convert a character from the value <" + theValue + "> of type <" + theValue.getClass().getName() + ">!");
    }

    default public Character getChar(String ... aPathElements) {
        return this.getChar(this.toPath(aPathElements));
    }

    default public Character getChar(Object ... aPathElements) {
        return this.getChar(this.toPath(aPathElements));
    }

    default public Character getChar(Collection<?> aPathElements) {
        return this.getChar(this.toPath(aPathElements));
    }

    default public Character getCharOr(Object aKey, Character aDefaultValue) {
        Character theValue = this.getChar(aKey);
        if (theValue == null) {
            return aDefaultValue;
        }
        return theValue;
    }

    default public Character getCharOr(Object[] aPathElements, Character aDefaultValue) {
        return this.getCharOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Character getCharOr(Collection<?> aPathElements, Character aDefaultValue) {
        return this.getCharOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Character getCharOr(String aKey, Character aDefaultValue) {
        Character theValue = this.getChar(aKey);
        if (theValue == null) {
            return aDefaultValue;
        }
        return theValue;
    }

    default public Character getCharOr(String[] aPathElements, Character aDefaultValue) {
        return this.getCharOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public <C> Class<C> getClass(Object ... aPathElements) {
        return this.getClass(this.toPath(aPathElements));
    }

    default public <C> Class<C> getClass(Collection<?> aPathElements) {
        return this.getClass(this.toPath(aPathElements));
    }

    default public <C> Class<C> getClass(Object aKey) {
        return this.getClass(InterOperableMap.asKey(aKey));
    }

    default public <C> Class<C> getClass(String ... aPathElements) {
        return this.getClass(this.toPath(aPathElements));
    }

    /*
     * WARNING - void declaration
     */
    default public <C> Class<C> getClass(String aKey) {
        Object theValue = this.get((Object)aKey);
        if (theValue == null) {
            return null;
        }
        if (theValue instanceof Class) {
            try {
                return (Class)theValue;
            }
            catch (ClassCastException e) {
                throw new NumberFormatException("Unable to parse a class from the value <" + theValue + "> of type <" + theValue.getClass().getName() + ">: " + e.getMessage());
            }
        }
        Object v = theValue;
        if (v instanceof String) {
            String e = (String)v;
            String cfr_ignored_0 = (String)v;
            try {
                void theString;
                return Class.forName((String)theString);
            }
            catch (Exception e2) {
                throw new NumberFormatException("Unable to parse a class from the value <" + theValue + "> of type <" + theValue.getClass().getName() + ">: " + e2.getMessage());
            }
        }
        throw new NumberFormatException("Unable to parse a class from the value <" + theValue + "> of type <" + theValue.getClass().getName() + ">!");
    }

    default public <C> Class<C> getClassOr(Object aKey, Class<C> aDefaultValue) {
        Class<C> theValue = this.getClass(aKey);
        if (theValue == null) {
            return aDefaultValue;
        }
        return theValue;
    }

    default public <C> Class<C> getClassOr(Object[] aPathElements, Class<C> aDefaultValue) {
        return this.getClassOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public <C> Class<C> getClassOr(Collection<?> aPathElements, Class<C> aDefaultValue) {
        return this.getClassOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public <C> Class<C> getClassOr(String aKey, Class<C> aDefaultValue) {
        Class<C> theValue = this.getClass(aKey);
        if (theValue == null) {
            return aDefaultValue;
        }
        return theValue;
    }

    default public <C> Class<C> getClassOr(String[] aPathElements, Class<C> aDefaultValue) {
        return this.getClassOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Double getDouble(Object ... aPathElements) {
        return this.getDouble(this.toPath(aPathElements));
    }

    default public Double getDouble(Collection<?> aPathElements) {
        return this.getDouble(this.toPath(aPathElements));
    }

    default public Double getDouble(Object aKey) {
        return this.getDouble(InterOperableMap.asKey(aKey));
    }

    default public Double getDouble(String ... aPathElements) {
        return this.getDouble(this.toPath(aPathElements));
    }

    default public Double getDouble(String aKey) {
        Object theValue = this.get((Object)aKey);
        if (theValue == null) {
            return null;
        }
        if (theValue instanceof Double) {
            return (Double)theValue;
        }
        if (theValue instanceof String) {
            return Double.valueOf((String)theValue);
        }
        throw new NumberFormatException("Unable to convert a double from the value <" + theValue + "> of type <" + theValue.getClass().getName() + ">!");
    }

    default public Double getDoubleOr(Object aKey, Double aDefaultValue) {
        Double theValue = this.getDouble(aKey);
        if (theValue == null) {
            return aDefaultValue;
        }
        return theValue;
    }

    default public Double getDoubleOr(Object[] aPathElements, Double aDefaultValue) {
        return this.getDoubleOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Double getDoubleOr(Collection<?> aPathElements, Double aDefaultValue) {
        return this.getDoubleOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Double getDoubleOr(String aKey, Double aDefaultValue) {
        Double theValue = this.getDouble(aKey);
        if (theValue == null) {
            return aDefaultValue;
        }
        return theValue;
    }

    default public Double getDoubleOr(String[] aPathElements, Double aDefaultValue) {
        return this.getDoubleOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public <E extends Enum<E>> E getEnum(Class<E> aEnumType, Object aKey) {
        return this.getEnum(aEnumType, InterOperableMap.asKey(aKey));
    }

    default public <E extends Enum<E>> E getEnum(Class<E> aEnumType, String aKey) {
        Object theValue = this.get((Object)aKey);
        if (theValue == null) {
            return null;
        }
        if (theValue instanceof String) {
            Enum[] theValues;
            Enum[] enumArray = theValues = (Enum[])aEnumType.getEnumConstants();
            int n = theValues.length;
            int n2 = 0;
            while (n2 < n) {
                Enum eValue = enumArray[n2];
                if (eValue.name().equals(theValue)) {
                    return (E)eValue;
                }
                ++n2;
            }
        }
        if (theValue instanceof Enum) {
            try {
                return (E)((Enum)theValue);
            }
            catch (Exception e) {
                throw new NumberFormatException("Unable to convert a enumeration from the value <" + theValue + "> of type <" + theValue.getClass().getName() + "> to enum type <\" + aEnumType.getName() + \">:" + e.getMessage());
            }
        }
        throw new NumberFormatException("Unable to convert a enumeration from the value <" + theValue + "> of type <" + theValue.getClass().getName() + "> to enum type <" + aEnumType.getName() + ">!");
    }

    default public <E extends Enum<E>> E getEnum(Class<E> aEnumType, String ... aPathElements) {
        return this.getEnum(aEnumType, this.toPath(aPathElements));
    }

    default public <E extends Enum<E>> E getEnum(Class<E> aEnumType, Object ... aPathElements) {
        return this.getEnum(aEnumType, this.toPath(aPathElements));
    }

    default public <E extends Enum<E>> E getEnum(Class<E> aEnumType, Collection<?> aPathElements) {
        return this.getEnum(aEnumType, this.toPath(aPathElements));
    }

    default public <E extends Enum<E>> E getEnumOr(Class<E> aEnumType, Object aKey, E aDefaultValue) {
        E theValue = this.getEnum(aEnumType, aKey);
        if (theValue == null) {
            return aDefaultValue;
        }
        return theValue;
    }

    default public <E extends Enum<E>> E getEnumOr(Class<E> aEnumType, Object[] aPathElements, E aDefaultValue) {
        return this.getEnumOr(aEnumType, this.toPath(aPathElements), aDefaultValue);
    }

    default public <E extends Enum<E>> E getEnumOr(Class<E> aEnumType, Collection<?> aPathElements, E aDefaultValue) {
        return this.getEnumOr(aEnumType, this.toPath(aPathElements), aDefaultValue);
    }

    default public <E extends Enum<E>> E getEnumOr(Class<E> aEnumType, String aKey, E aDefaultValue) {
        E theValue = this.getEnum(aEnumType, aKey);
        if (theValue == null) {
            return aDefaultValue;
        }
        return theValue;
    }

    default public <E extends Enum<E>> E getEnumOr(Class<E> aEnumType, String[] aPathElements, E aDefaultValue) {
        return this.getEnumOr(aEnumType, this.toPath(aPathElements), aDefaultValue);
    }

    default public <E extends Enum<E>> E getEnumOr(Object aKey, E aDefaultValue) {
        Object theValue = this.getEnum((Class<E>)aDefaultValue.getClass(), aKey);
        if (theValue == null) {
            return aDefaultValue;
        }
        return (E)theValue;
    }

    default public <E extends Enum<E>> E getEnumOr(Object[] aPathElements, E aDefaultValue) {
        return this.getEnumOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public <E extends Enum<E>> E getEnumOr(Collection<?> aPathElements, E aDefaultValue) {
        return this.getEnumOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public <E extends Enum<E>> E getEnumOr(String aKey, E aDefaultValue) {
        Object theValue = this.getEnum((Class<E>)aDefaultValue.getClass(), aKey);
        if (theValue == null) {
            return aDefaultValue;
        }
        return (E)theValue;
    }

    default public <E extends Enum<E>> E getEnumOr(String[] aPathElements, E aDefaultValue) {
        return this.getEnumOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Float getFloat(Object ... aPathElements) {
        return this.getFloat(this.toPath(aPathElements));
    }

    default public Float getFloat(Collection<?> aPathElements) {
        return this.getFloat(this.toPath(aPathElements));
    }

    default public Float getFloat(Object aKey) {
        return this.getFloat(InterOperableMap.asKey(aKey));
    }

    default public Float getFloat(String ... aPathElements) {
        return this.getFloat(this.toPath(aPathElements));
    }

    default public Float getFloat(String aKey) {
        Object theValue = this.get((Object)aKey);
        if (theValue == null) {
            return null;
        }
        if (theValue instanceof Float) {
            return (Float)theValue;
        }
        if (theValue instanceof String) {
            return Float.valueOf((String)theValue);
        }
        throw new NumberFormatException("Unable to convert a float from the value <" + theValue + "> of type <" + theValue.getClass().getName() + ">!");
    }

    default public Float getFloatOr(Object aKey, Float aDefaultValue) {
        Float theValue = this.getFloat(aKey);
        if (theValue == null) {
            return aDefaultValue;
        }
        return theValue;
    }

    default public Float getFloatOr(Object[] aPathElements, Float aDefaultValue) {
        return this.getFloatOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Float getFloatOr(Collection<?> aPathElements, Float aDefaultValue) {
        return this.getFloatOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Float getFloatOr(String aKey, Float aDefaultValue) {
        Float theValue = this.getFloat(aKey);
        if (theValue == null) {
            return aDefaultValue;
        }
        return theValue;
    }

    default public Float getFloatOr(String[] aPathElements, Float aDefaultValue) {
        return this.getFloatOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Integer getInt(Object ... aPathElements) {
        return this.getInt(this.toPath(aPathElements));
    }

    default public Integer getInt(Collection<?> aPathElements) {
        return this.getInt(this.toPath(aPathElements));
    }

    default public Integer getInt(Object aKey) {
        return this.getInt(InterOperableMap.asKey(aKey));
    }

    default public Integer getInt(String ... aPathElements) {
        return this.getInt(this.toPath(aPathElements));
    }

    default public Integer getInt(String aKey) {
        Object theValue = this.get((Object)aKey);
        if (theValue == null) {
            return null;
        }
        if (theValue instanceof Integer) {
            return (Integer)theValue;
        }
        Object v = theValue;
        if (v instanceof String) {
            String theString;
            String string = (String)v;
            String cfr_ignored_0 = (String)v;
            if (theString.endsWith(".0")) {
                theString = theString.substring(0, theString.length() - 2);
            }
            return Integer.valueOf(theString);
        }
        throw new NumberFormatException("Unable to convert an Integer from the value <" + theValue + "> of type <" + theValue.getClass().getName() + ">!");
    }

    default public Integer getIntOr(Object aKey, Integer aDefaultValue) {
        Integer theValue = this.getInt(aKey);
        if (theValue == null) {
            return aDefaultValue;
        }
        return theValue;
    }

    default public Integer getIntOr(Object[] aPathElements, Integer aDefaultValue) {
        return this.getIntOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Integer getIntOr(Collection<?> aPathElements, Integer aDefaultValue) {
        return this.getIntOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Integer getIntOr(String aKey, Integer aDefaultValue) {
        Integer theValue = this.getInt(aKey);
        if (theValue == null) {
            return aDefaultValue;
        }
        return theValue;
    }

    default public Integer getIntOr(String[] aPathElements, Integer aDefaultValue) {
        return this.getIntOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Long getLong(Object ... aPathElements) {
        return this.getLong(this.toPath(aPathElements));
    }

    default public Long getLong(Collection<?> aPathElements) {
        return this.getLong(this.toPath(aPathElements));
    }

    default public Long getLong(Object aKey) {
        return this.getLong(InterOperableMap.asKey(aKey));
    }

    default public Long getLong(String ... aPathElements) {
        return this.getLong(this.toPath(aPathElements));
    }

    default public Long getLong(String aKey) {
        Object theValue = this.get((Object)aKey);
        if (theValue == null) {
            return null;
        }
        if (theValue instanceof Long) {
            return (Long)theValue;
        }
        Object v = theValue;
        if (v instanceof String) {
            String theString;
            String string = (String)v;
            String cfr_ignored_0 = (String)v;
            if (theString.endsWith(".0")) {
                theString = theString.substring(0, theString.length() - 2);
            }
            return Long.valueOf(theString);
        }
        throw new NumberFormatException("Unable to convert an Long from the value <" + theValue + "> of type <" + theValue.getClass().getName() + ">!");
    }

    default public Long getLongOr(Object aKey, Long aDefaultValue) {
        Long theValue = this.getLong(aKey);
        if (theValue == null) {
            return aDefaultValue;
        }
        return theValue;
    }

    default public Long getLongOr(Object[] aPathElements, Long aDefaultValue) {
        return this.getLongOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Long getLongOr(Collection<?> aPathElements, Long aDefaultValue) {
        return this.getLongOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Long getLongOr(String aKey, Long aDefaultValue) {
        Long theValue = this.getLong(aKey);
        if (theValue == null) {
            return aDefaultValue;
        }
        return theValue;
    }

    default public Long getLongOr(String[] aPathElements, Long aDefaultValue) {
        return this.getLongOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Short getShort(Object ... aPathElements) {
        return this.getShort(this.toPath(aPathElements));
    }

    default public Short getShort(Collection<?> aPathElements) {
        return this.getShort(this.toPath(aPathElements));
    }

    default public Short getShort(Object aKey) {
        return this.getShort(InterOperableMap.asKey(aKey));
    }

    default public Short getShort(String ... aPathElements) {
        return this.getShort(this.toPath(aPathElements));
    }

    default public Short getShort(String aKey) {
        Object theValue = this.get((Object)aKey);
        if (theValue == null) {
            return null;
        }
        if (theValue instanceof Short) {
            return (Short)theValue;
        }
        Object v = theValue;
        if (v instanceof String) {
            String theString;
            String string = (String)v;
            String cfr_ignored_0 = (String)v;
            if (theString.endsWith(".0")) {
                theString = theString.substring(0, theString.length() - 2);
            }
            return Short.valueOf(theString);
        }
        throw new NumberFormatException("Unable to convert an Short from the value <" + theValue + "> of type <" + theValue.getClass().getName() + ">!");
    }

    default public Short getShortOr(Object aKey, Short aDefaultValue) {
        Short theValue = this.getShort(aKey);
        if (theValue == null) {
            return aDefaultValue;
        }
        return theValue;
    }

    default public Short getShortOr(Object[] aPathElements, Short aDefaultValue) {
        return this.getShortOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Short getShortOr(Collection<?> aPathElements, Short aDefaultValue) {
        return this.getShortOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public Short getShortOr(String aKey, Short aDefaultValue) {
        Short theValue = this.getShort(aKey);
        if (theValue == null) {
            return aDefaultValue;
        }
        return theValue;
    }

    default public Short getShortOr(String[] aPathElements, Short aDefaultValue) {
        return this.getShortOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public String getString(Object ... aPathElements) {
        return this.getString(this.toPath(aPathElements));
    }

    default public String getString(Collection<?> aPathElements) {
        return this.getString(this.toPath(aPathElements));
    }

    default public String getString(Object aKey) {
        return this.getString(InterOperableMap.asKey(aKey));
    }

    default public String getString(String ... aPathElements) {
        return this.getString(this.toPath(aPathElements));
    }

    default public String getString(String aKey) {
        Object theValue = this.get((Object)aKey);
        if (theValue == null) {
            return null;
        }
        if (theValue instanceof String) {
            return (String)theValue;
        }
        throw new NumberFormatException("Unable to convert an String from the value <" + theValue + "> of type <" + theValue.getClass().getName() + ">!");
    }

    default public String getStringOr(Object aKey, String aDefaultValue) {
        String theValue = this.getString(aKey);
        if (theValue == null) {
            return aDefaultValue;
        }
        return theValue;
    }

    default public String getStringOr(Object[] aPathElements, String aDefaultValue) {
        return this.getStringOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public String getStringOr(Collection<?> aPathElements, String aDefaultValue) {
        return this.getStringOr(this.toPath(aPathElements), aDefaultValue);
    }

    default public String getStringOr(String aKey, String aDefaultValue) {
        String theValue = this.getString(aKey);
        if (theValue == null) {
            return aDefaultValue;
        }
        return theValue;
    }

    default public String getStringOr(String[] aPathElements, String aDefaultValue) {
        return this.getStringOr(this.toPath(aPathElements), aDefaultValue);
    }

    public static String asKey(Object aKey) {
        if (aKey instanceof String) {
            return (String)aKey;
        }
        if (aKey instanceof AliasAccessor && ((AliasAccessor)aKey).getAlias() != null) {
            return ((AliasAccessor)aKey).getAlias();
        }
        if (aKey != null) {
            return aKey.toString();
        }
        return null;
    }

    public static interface InterOperableMapBuilder<T>
    extends MutableInterOperableMap<T>,
    PathMap.PathMapBuilder<T> {
        @Override
        default public InterOperableMapBuilder<T> withInsert(Object aObj) {
            this.insert(aObj);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsert(PathMap<T> aFrom) {
            this.insert((Object)aFrom);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertBetween(Collection<?> aToPathElements, Object aFrom, Collection<?> aFromPathElements) {
            this.insertBetween(aToPathElements, aFrom, aFromPathElements);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertBetween(Collection<?> aToPathElements, PathMap<T> aFrom, Collection<?> aFromPathElements) {
            this.insertBetween(aToPathElements, (Object)aFrom, aFromPathElements);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertBetween(Object aToPath, Object aFrom, Object aFromPath) {
            this.insertBetween(aToPath, aFrom, aFromPath);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertBetween(Object aToPath, PathMap<T> aFrom, Object aFromPath) {
            this.insertBetween(aToPath, (Object)aFrom, aFromPath);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertBetween(Object[] aToPathElements, Object aFrom, Object[] aFromPathElements) {
            this.insertBetween(aToPathElements, aFrom, aFromPathElements);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertBetween(Object[] aToPathElements, PathMap<T> aFrom, Object[] aFromPathElements) {
            this.insertBetween(aToPathElements, (Object)aFrom, aFromPathElements);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertBetween(String aToPath, Object aFrom, String aFromPath) {
            this.insertBetween(aToPath, aFrom, aFromPath);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertBetween(String aToPath, PathMap<T> aFrom, String aFromPath) {
            this.insertBetween(aToPath, (Object)aFrom, aFromPath);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertBetween(String[] aToPathElements, Object aFrom, String[] aFromPathElements) {
            this.insertBetween(aToPathElements, aFrom, aFromPathElements);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertBetween(String[] aToPathElements, PathMap<T> aFrom, String[] aFromPathElements) {
            this.insertBetween(aToPathElements, (Object)aFrom, aFromPathElements);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertFrom(Object aFrom, Collection<?> aFromPathElements) {
            this.insertFrom(aFrom, aFromPathElements);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertFrom(Object aFrom, Object aFromPath) {
            this.insertFrom(aFrom, aFromPath);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertFrom(Object aFrom, Object ... aFromPathElements) {
            this.insertFrom(aFrom, aFromPathElements);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertFrom(Object aFrom, String aFromPath) {
            this.insertFrom(aFrom, aFromPath);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertFrom(Object aFrom, String ... aFromPathElements) {
            this.insertFrom(aFrom, aFromPathElements);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertFrom(PathMap<T> aFrom, Collection<?> aFromPathElements) {
            return this.withInsertFrom((Object)aFrom, (Collection)aFromPathElements);
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertFrom(PathMap<T> aFrom, Object aFromPath) {
            return this.withInsertFrom((Object)aFrom, aFromPath);
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertFrom(PathMap<T> aFrom, Object ... aFromPathElements) {
            return this.withInsertFrom((Object)aFrom, aFromPathElements);
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertFrom(PathMap<T> aFrom, String aFromPath) {
            this.insertFrom((Object)aFrom, aFromPath);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertFrom(PathMap<T> aFrom, String ... aFromPathElements) {
            return this.withInsertFrom((Object)aFrom, aFromPathElements);
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertTo(Collection<?> aToPathElements, Object aFrom) {
            this.insertTo(aToPathElements, aFrom);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertTo(Collection<?> aToPathElements, PathMap<T> aFrom) {
            return this.withInsertTo((Collection)aToPathElements, (Object)aFrom);
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertTo(Object aToPath, Object aFrom) {
            this.insertTo(aToPath, aFrom);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertTo(Object aToPath, PathMap<T> aFrom) {
            return this.withInsertTo(aToPath, (Object)aFrom);
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertTo(Object[] aToPathElements, Object aFrom) {
            this.insertTo(aToPathElements, aFrom);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertTo(Object[] aToPathElements, PathMap<T> aFrom) {
            return this.withInsertTo(aToPathElements, (Object)aFrom);
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertTo(String aToPath, Object aFrom) {
            this.insertTo(aToPath, aFrom);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertTo(String aToPath, PathMap<T> aFrom) {
            this.insertTo(aToPath, (Object)aFrom);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertTo(String[] aToPathElements, Object aFrom) {
            this.insertTo(aToPathElements, aFrom);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withInsertTo(String[] aToPathElements, PathMap<T> aFrom) {
            return this.withInsertTo(aToPathElements, (Object)aFrom);
        }

        @Override
        default public InterOperableMapBuilder<T> withMerge(Object aObj) {
            this.merge(aObj);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMerge(PathMap<T> aFrom) {
            this.merge((Object)aFrom);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeBetween(Collection<?> aToPathElements, Object aFrom, Collection<?> aFromPathElements) {
            this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeBetween(Collection<?> aToPathElements, PathMap<T> aFrom, Collection<?> aFromPathElements) {
            this.mergeBetween(aToPathElements, (Object)aFrom, aFromPathElements);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeBetween(Object aToPath, Object aFrom, Object aFromPath) {
            this.mergeBetween(aToPath, aFrom, aFromPath);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeBetween(Object aToPath, PathMap<T> aFrom, Object aFromPath) {
            this.mergeBetween(aToPath, (Object)aFrom, aFromPath);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeBetween(Object[] aToPathElements, Object aFrom, Object[] aFromPathElements) {
            this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeBetween(Object[] aToPathElements, PathMap<T> aFrom, Object[] aFromPathElements) {
            this.mergeBetween(aToPathElements, (Object)aFrom, aFromPathElements);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeBetween(String aToPath, Object aFrom, String aFromPath) {
            this.mergeBetween(aToPath, aFrom, aFromPath);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeBetween(String aToPath, PathMap<T> aFrom, String aFromPath) {
            this.mergeBetween(aToPath, (Object)aFrom, aFromPath);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeBetween(String[] aToPathElements, Object aFrom, String[] aFromPathElements) {
            this.mergeBetween(aToPathElements, aFrom, aFromPathElements);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeBetween(String[] aToPathElements, PathMap<T> aFrom, String[] aFromPathElements) {
            this.mergeBetween(aToPathElements, (Object)aFrom, aFromPathElements);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeFrom(Object aFrom, Collection<?> aFromPathElements) {
            this.mergeFrom(aFrom, aFromPathElements);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeFrom(Object aFrom, Object aFromPath) {
            this.mergeFrom(aFrom, aFromPath);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeFrom(Object aFrom, Object ... aFromPathElements) {
            this.mergeFrom(aFrom, aFromPathElements);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeFrom(Object aFrom, String aFromPath) {
            this.mergeFrom(aFrom, aFromPath);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeFrom(Object aFrom, String ... aFromPathElements) {
            this.mergeFrom(aFrom, aFromPathElements);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeFrom(PathMap<T> aFrom, Collection<?> aFromPathElements) {
            return this.withMergeFrom((Object)aFrom, (Collection)aFromPathElements);
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeFrom(PathMap<T> aFrom, Object aFromPath) {
            return this.withMergeFrom((Object)aFrom, aFromPath);
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeFrom(PathMap<T> aFrom, Object ... aFromPathElements) {
            return this.withMergeFrom((Object)aFrom, aFromPathElements);
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeFrom(PathMap<T> aFrom, String aFromPath) {
            this.mergeFrom((Object)aFrom, aFromPath);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeFrom(PathMap<T> aFrom, String ... aFromPathElements) {
            return this.withMergeFrom((Object)aFrom, aFromPathElements);
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeTo(Collection<?> aToPathElements, Object aFrom) {
            this.mergeTo(aToPathElements, aFrom);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeTo(Collection<?> aToPathElements, PathMap<T> aFrom) {
            return this.withMergeTo((Collection)aToPathElements, (Object)aFrom);
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeTo(Object aToPath, Object aFrom) {
            this.mergeTo(aToPath, aFrom);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeTo(Object aToPath, PathMap<T> aFrom) {
            return this.withMergeTo(aToPath, (Object)aFrom);
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeTo(Object[] aToPathElements, Object aFrom) {
            this.mergeTo(aToPathElements, aFrom);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeTo(Object[] aToPathElements, PathMap<T> aFrom) {
            return this.withMergeTo(aToPathElements, (Object)aFrom);
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeTo(String aToPath, Object aFrom) {
            this.mergeTo(aToPath, aFrom);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeTo(String aToPath, PathMap<T> aFrom) {
            this.mergeTo(aToPath, (Object)aFrom);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeTo(String[] aToPathElements, Object aFrom) {
            this.mergeTo(aToPathElements, aFrom);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withMergeTo(String[] aToPathElements, PathMap<T> aFrom) {
            return this.withMergeTo(aToPathElements, (Object)aFrom);
        }

        @Override
        default public InterOperableMapBuilder<T> withPut(Collection<?> aPathElements, T aValue) {
            this.put(this.toPath(aPathElements), aValue);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withPut(Object[] aPathElements, T aValue) {
            this.put(this.toPath(aPathElements), aValue);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withPut(Relation<String, T> aProperty) {
            this.put(aProperty);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withPut(String aKey, T aValue) {
            this.put(aKey, aValue);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withPut(String[] aPathElements, T aValue) {
            this.put(this.toPath(aPathElements), aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutBoolean(Collection<?> aPathElements, Boolean aValue) {
            this.putBoolean(this.toPath(aPathElements), aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutBoolean(Object aKey, Boolean aValue) {
            this.putBoolean(aKey, aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutBoolean(Object[] aPathElements, Boolean aValue) {
            this.putBoolean(this.toPath(aPathElements), aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutBoolean(String aKey, Boolean aValue) {
            this.putBoolean(aKey, aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutBoolean(String[] aPathElements, Boolean aValue) {
            this.putBoolean(this.toPath(aPathElements), aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutByte(Collection<?> aPathElements, Byte aValue) {
            this.putByte(this.toPath(aPathElements), aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutByte(Object aKey, Byte aValue) {
            this.putByte(aKey, aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutByte(Object[] aPathElements, Byte aValue) {
            this.putByte(this.toPath(aPathElements), aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutByte(String aKey, Byte aValue) {
            this.putByte(aKey, aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutByte(String[] aPathElements, Byte aValue) {
            this.putByte(this.toPath(aPathElements), aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutChar(Collection<?> aPathElements, Character aValue) {
            this.putChar(this.toPath(aPathElements), aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutChar(Object aKey, Character aValue) {
            this.putChar(aKey, aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutChar(Object[] aPathElements, Character aValue) {
            this.putChar(this.toPath(aPathElements), aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutChar(String aKey, Character aValue) {
            this.putChar(aKey, aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutChar(String[] aPathElements, Character aValue) {
            this.putChar(this.toPath(aPathElements), aValue);
            return this;
        }

        default public <C> InterOperableMapBuilder<T> withPutClass(Collection<?> aPathElements, Class<C> aValue) {
            this.putClass(this.toPath(aPathElements), aValue);
            return this;
        }

        default public <C> InterOperableMapBuilder<T> withPutClass(Object aKey, Class<C> aValue) {
            this.putClass(aKey, aValue);
            return this;
        }

        default public <C> InterOperableMapBuilder<T> withPutClass(Object[] aPathElements, Class<C> aValue) {
            this.putClass(this.toPath(aPathElements), aValue);
            return this;
        }

        default public <C> InterOperableMapBuilder<T> withPutClass(String aKey, Class<C> aValue) {
            this.putClass(aKey, aValue);
            return this;
        }

        default public <C> InterOperableMapBuilder<T> withPutClass(String[] aPathElements, Class<C> aValue) {
            this.putClass(this.toPath(aPathElements), aValue);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withPutDirAt(int aIndex, Object aDir) {
            this.putDirAt(aIndex, aDir);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withPutDirAt(int aIndex, PathMap<T> aDir) {
            this.putDirAt(aIndex, aDir);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withPutDirAt(Object aPath, int aIndex, Object aDir) {
            this.putDirAt(aPath, aIndex, aDir);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withPutDirAt(Object aPath, int aIndex, PathMap<T> aDir) {
            this.putDirAt(aPath, aIndex, aDir);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withPutDirAt(Object[] aPathElements, int aIndex, Object aDir) {
            this.putDirAt(aPathElements, aIndex, aDir);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withPutDirAt(Object[] aPathElements, int aIndex, PathMap<T> aDir) {
            this.putDirAt(aPathElements, aIndex, aDir);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withPutDirAt(String aPath, int aIndex, Object aDir) {
            this.putDirAt(aPath, aIndex, aDir);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withPutDirAt(String aPath, int aIndex, PathMap<T> aDir) {
            this.putDirAt(aPath, aIndex, aDir);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withPutDirAt(String[] aPathElements, int aIndex, Object aDir) {
            this.putDirAt(aPathElements, aIndex, aDir);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withPutDirAt(String[] aPathElements, int aIndex, PathMap<T> aDir) {
            this.putDirAt(aPathElements, aIndex, aDir);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutDouble(Collection<?> aPathElements, Double aValue) {
            this.putDouble(this.toPath(aPathElements), aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutDouble(Object aKey, Double aValue) {
            this.putDouble(aKey, aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutDouble(Object[] aPathElements, Double aValue) {
            this.putDouble(this.toPath(aPathElements), aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutDouble(String aKey, Double aValue) {
            this.putDouble(aKey, aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutDouble(String[] aPathElements, Double aValue) {
            this.putDouble(this.toPath(aPathElements), aValue);
            return this;
        }

        default public <E extends Enum<E>> InterOperableMapBuilder<T> withPutEnum(Collection<?> aPathElements, E aValue) {
            this.putEnum(this.toPath(aPathElements), aValue);
            return this;
        }

        default public <E extends Enum<E>> InterOperableMapBuilder<T> withPutEnum(Object aKey, E aValue) {
            this.putEnum(aKey, aValue);
            return this;
        }

        default public <E extends Enum<E>> InterOperableMapBuilder<T> withPutEnum(Object[] aPathElements, E aValue) {
            this.putEnum(this.toPath(aPathElements), aValue);
            return this;
        }

        default public <E extends Enum<E>> InterOperableMapBuilder<T> withPutEnum(String aKey, E aValue) {
            this.putEnum(aKey, aValue);
            return this;
        }

        default public <E extends Enum<E>> InterOperableMapBuilder<T> withPutEnum(String[] aPathElements, E aValue) {
            this.putEnum(this.toPath(aPathElements), aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutFloat(Collection<?> aPathElements, Float aValue) {
            this.putFloat(this.toPath(aPathElements), aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutFloat(Object aKey, Float aValue) {
            this.putFloat(aKey, aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutFloat(Object[] aPathElements, Float aValue) {
            this.putFloat(this.toPath(aPathElements), aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutFloat(String aKey, Float aValue) {
            this.putFloat(aKey, aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutFloat(String[] aPathElements, Float aValue) {
            this.putFloat(this.toPath(aPathElements), aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutInt(Collection<?> aPathElements, Integer aValue) {
            this.putInt(this.toPath(aPathElements), aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutInt(Object aKey, Integer aValue) {
            this.putInt(aKey, aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutInt(Object[] aPathElements, Integer aValue) {
            this.putInt(this.toPath(aPathElements), aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutInt(String aKey, Integer aValue) {
            this.putInt(aKey, aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutInt(String[] aPathElements, Integer aValue) {
            this.putInt(this.toPath(aPathElements), aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutLong(Collection<?> aPathElements, Long aValue) {
            this.putLong(this.toPath(aPathElements), aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutLong(Object aKey, Long aValue) {
            this.putLong(aKey, aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutLong(Object[] aPathElements, Long aValue) {
            this.putLong(this.toPath(aPathElements), aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutLong(String aKey, Long aValue) {
            this.putLong(aKey, aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutLong(String[] aPathElements, Long aValue) {
            this.putLong(this.toPath(aPathElements), aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutShort(Collection<?> aPathElements, Short aValue) {
            this.putShort(this.toPath(aPathElements), aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutShort(Object aKey, Short aValue) {
            this.putShort(aKey, aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutShort(Object[] aPathElements, Short aValue) {
            this.putShort(this.toPath(aPathElements), aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutShort(String aKey, Short aValue) {
            this.putShort(aKey, aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutShort(String[] aPathElements, Short aValue) {
            this.putShort(this.toPath(aPathElements), aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutString(Collection<?> aPathElements, String aValue) {
            this.putString(this.toPath(aPathElements), aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutString(Object aKey, String aValue) {
            this.putString(aKey, aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutString(Object[] aPathElements, String aValue) {
            this.putString(this.toPath(aPathElements), aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutString(String aKey, String aValue) {
            this.putString(aKey, aValue);
            return this;
        }

        default public InterOperableMapBuilder<T> withPutString(String[] aPathElements, String aValue) {
            this.putString(this.toPath(aPathElements), aValue);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withRemoveFrom(Collection<?> aPathElements) {
            this.removeFrom(aPathElements);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withRemoveFrom(Object aPath) {
            this.removeFrom(aPath);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withRemoveFrom(Object ... aPathElements) {
            this.removeFrom(aPathElements);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withRemoveFrom(String aPath) {
            this.removeFrom(aPath);
            return this;
        }

        @Override
        default public InterOperableMapBuilder<T> withRemoveFrom(String ... aPathElements) {
            this.removeFrom(aPathElements);
            return this;
        }
    }

    public static interface MutableInterOperableMap<T>
    extends PathMap.MutablePathMap<T> {
        @Override
        default public boolean containsValue(Object value) {
            return this.values().contains(value);
        }

        @Override
        default public void insert(InterOperableMapBuilder<T> aFrom) {
            this.insert((Object)aFrom);
        }

        @Override
        default public void insertBetween(String aToPath, InterOperableMapBuilder<T> aFrom, String aFromPath) {
            this.insertBetween(aToPath, (Object)aFrom, aFromPath);
        }

        @Override
        default public void insertFrom(InterOperableMapBuilder<T> aFrom, String aFromPath) {
            this.insertFrom((Object)aFrom, aFromPath);
        }

        @Override
        default public void insertTo(String aToPath, InterOperableMapBuilder<T> aFrom) {
            this.insertTo(aToPath, (Object)aFrom);
        }

        default public T putBoolean(Object aKey, Boolean aValue) {
            return this.putBoolean(InterOperableMap.asKey(aKey), aValue);
        }

        default public T putBoolean(Object[] aPathElements, Boolean aValue) {
            return this.putBoolean(this.toPath(aPathElements), aValue);
        }

        default public T putBoolean(Collection<?> aPathElements, Boolean aValue) {
            return this.putBoolean(this.toPath(aPathElements), aValue);
        }

        default public T putBoolean(String aKey, Boolean aValue) {
            if (aValue == null) {
                return (T)this.put(aKey, null);
            }
            if (this.getType().isAssignableFrom(Boolean.class)) {
                return (T)this.put(aKey, aValue);
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(aKey, Boolean.TRUE.equals(aValue) ? Literal.TRUE.getValue() : Literal.FALSE.getValue());
            }
            throw new NumberFormatException("Unable to convert a boolean from the value <" + aValue + "> of type <" + aValue.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public T putBoolean(String[] aPathElements, Boolean aValue) {
            return this.putBoolean(this.toPath(aPathElements), aValue);
        }

        default public T putByte(Object aKey, Byte aValue) {
            return this.putByte(InterOperableMap.asKey(aKey), aValue);
        }

        default public T putByte(Object[] aPathElements, Byte aValue) {
            return this.putByte(this.toPath(aPathElements), aValue);
        }

        default public T putByte(Collection<?> aPathElements, Byte aValue) {
            return this.putByte(this.toPath(aPathElements), aValue);
        }

        default public T putByte(String aKey, Byte aValue) {
            if (aValue == null) {
                return (T)this.put(aKey, null);
            }
            if (this.getType().isAssignableFrom(Byte.class)) {
                return (T)this.put(aKey, aValue);
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(aKey, aValue.toString());
            }
            throw new NumberFormatException("Unable to convert a byte from the value <" + aValue + "> of type <" + aValue.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public T putByte(String[] aPathElements, Byte aValue) {
            return this.putByte(this.toPath(aPathElements), aValue);
        }

        default public T putChar(Object aKey, Character aValue) {
            return this.putChar(InterOperableMap.asKey(aKey), aValue);
        }

        default public T putChar(Object[] aPathElements, Character aValue) {
            return this.putChar(this.toPath(aPathElements), aValue);
        }

        default public T putChar(Collection<?> aPathElements, Character aValue) {
            return this.putChar(this.toPath(aPathElements), aValue);
        }

        default public T putChar(String aKey, Character aValue) {
            if (aValue == null) {
                return (T)this.put(aKey, null);
            }
            if (this.getType().isAssignableFrom(Character.class)) {
                return (T)this.put(aKey, aValue);
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(aKey, aValue.toString());
            }
            throw new NumberFormatException("Unable to convert a character from the value <" + aValue + "> of type <" + aValue.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public T putChar(String[] aPathElements, Character aValue) {
            return this.putChar(this.toPath(aPathElements), aValue);
        }

        default public <C> T putClass(Object aKey, Class<C> aValue) {
            return this.putClass(InterOperableMap.asKey(aKey), aValue);
        }

        default public <C> T putClass(Object[] aPathElements, Class<C> aValue) {
            return this.putClass(this.toPath(aPathElements), aValue);
        }

        default public <C> T putClass(Collection<?> aPathElements, Class<C> aValue) {
            return this.putClass(this.toPath(aPathElements), aValue);
        }

        default public <C> T putClass(String aKey, Class<C> aValue) {
            if (aValue == null) {
                return (T)this.put(aKey, null);
            }
            if (this.getType().isAssignableFrom(Class.class)) {
                try {
                    return (T)this.put(aKey, aValue);
                }
                catch (Exception e) {
                    throw new NumberFormatException("Unable to convert a class from the value <" + aValue + "> of type <" + aValue.getClass().getName() + "> to type <" + this.getType().getName() + ">: " + e.getMessage());
                }
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(aKey, aValue.getName());
            }
            throw new NumberFormatException("Unable to convert a class from the value <" + aValue + "> of type <" + aValue.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public <C> T putClass(String[] aPathElements, Class<C> aValue) {
            return this.putClass(this.toPath(aPathElements), aValue);
        }

        default public T putDouble(Object aKey, Double aValue) {
            return this.putDouble(InterOperableMap.asKey(aKey), aValue);
        }

        default public T putDouble(Object[] aPathElements, Double aValue) {
            return this.putDouble(this.toPath(aPathElements), aValue);
        }

        default public T putDouble(Collection<?> aPathElements, Double aValue) {
            return this.putDouble(this.toPath(aPathElements), aValue);
        }

        default public T putDouble(String aKey, Double aValue) {
            if (aValue == null) {
                return (T)this.put(aKey, null);
            }
            if (this.getType().isAssignableFrom(Double.class)) {
                return (T)this.put(aKey, aValue);
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(aKey, aValue.toString());
            }
            throw new NumberFormatException("Unable to convert a double from the value <" + aValue + "> of type <" + aValue.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public T putDouble(String[] aPathElements, Double aValue) {
            return this.putDouble(this.toPath(aPathElements), aValue);
        }

        default public <E extends Enum<E>> T putEnum(Object aKey, E aValue) {
            return this.putEnum(InterOperableMap.asKey(aKey), aValue);
        }

        default public <E extends Enum<E>> T putEnum(Object[] aPathElements, E aValue) {
            return this.putEnum(this.toPath(aPathElements), aValue);
        }

        default public <E extends Enum<E>> T putEnum(Collection<?> aPathElements, E aValue) {
            return this.putEnum(this.toPath(aPathElements), aValue);
        }

        default public <E extends Enum<E>> T putEnum(String aKey, E aValue) {
            if (aValue == null) {
                return (T)this.put(aKey, null);
            }
            if (this.getType().isAssignableFrom(Enum.class)) {
                try {
                    return (T)this.put(aKey, aValue);
                }
                catch (Exception e) {
                    throw new NumberFormatException("Unable to convert a enumeration from the value <" + aValue + "> of type <" + aValue.getClass().getName() + "> to type <" + this.getType().getName() + ">: " + e.getMessage());
                }
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(aKey, aValue.name());
            }
            throw new NumberFormatException("Unable to convert a enumeration from the value <" + aValue + "> of type <" + aValue.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public <E extends Enum<E>> T putEnum(String[] aPathElements, E aValue) {
            return this.putEnum(this.toPath(aPathElements), aValue);
        }

        default public T putFloat(Object aKey, Float aValue) {
            return this.putFloat(InterOperableMap.asKey(aKey), aValue);
        }

        default public T putFloat(Object[] aPathElements, Float aValue) {
            return this.putFloat(this.toPath(aPathElements), aValue);
        }

        default public T putFloat(Collection<?> aPathElements, Float aValue) {
            return this.putFloat(this.toPath(aPathElements), aValue);
        }

        default public T putFloat(String aKey, Float aValue) {
            if (aValue == null) {
                return (T)this.put(aKey, null);
            }
            if (this.getType().isAssignableFrom(Float.class)) {
                return (T)this.put(aKey, aValue);
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(aKey, aValue.toString());
            }
            throw new NumberFormatException("Unable to convert a float from the value <" + aValue + "> of type <" + aValue.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public T putFloat(String[] aPathElements, Float aValue) {
            return this.putFloat(this.toPath(aPathElements), aValue);
        }

        default public T putInt(Object aKey, Integer aValue) {
            return this.putInt(InterOperableMap.asKey(aKey), aValue);
        }

        default public T putInt(Object[] aPathElements, Integer aValue) {
            return this.putInt(this.toPath(aPathElements), aValue);
        }

        default public T putInt(Collection<?> aPathElements, Integer aValue) {
            return this.putInt(this.toPath(aPathElements), aValue);
        }

        default public T putInt(String aKey, Integer aValue) {
            if (aValue == null) {
                return (T)this.put(aKey, null);
            }
            if (this.getType().isAssignableFrom(Integer.class)) {
                return (T)this.put(aKey, aValue);
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(aKey, aValue.toString());
            }
            throw new NumberFormatException("Unable to convert a integer from the value <" + aValue + "> of type <" + aValue.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public T putInt(String[] aPathElements, Integer aValue) {
            return this.putInt(this.toPath(aPathElements), aValue);
        }

        default public T putLong(Object aKey, Long aValue) {
            return this.putLong(InterOperableMap.asKey(aKey), aValue);
        }

        default public T putLong(Object[] aPathElements, Long aValue) {
            return this.putLong(this.toPath(aPathElements), aValue);
        }

        default public T putLong(Collection<?> aPathElements, Long aValue) {
            return this.putLong(this.toPath(aPathElements), aValue);
        }

        default public T putLong(String aKey, Long aValue) {
            if (aValue == null) {
                return (T)this.put(aKey, null);
            }
            if (this.getType().isAssignableFrom(Long.class)) {
                return (T)this.put(aKey, aValue);
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(aKey, aValue.toString());
            }
            throw new NumberFormatException("Unable to convert a long from the value <" + aValue + "> of type <" + aValue.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public T putLong(String[] aPathElements, Long aValue) {
            return this.putLong(this.toPath(aPathElements), aValue);
        }

        default public T putShort(Object aKey, Short aValue) {
            return this.putShort(InterOperableMap.asKey(aKey), aValue);
        }

        default public T putShort(Object[] aPathElements, Short aValue) {
            return this.putShort(this.toPath(aPathElements), aValue);
        }

        default public T putShort(Collection<?> aPathElements, Short aValue) {
            return this.putShort(this.toPath(aPathElements), aValue);
        }

        default public T putShort(String aKey, Short aValue) {
            if (aValue == null) {
                return (T)this.put(aKey, null);
            }
            if (this.getType().isAssignableFrom(Short.class)) {
                return (T)this.put(aKey, aValue);
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(aKey, aValue.toString());
            }
            throw new NumberFormatException("Unable to convert a short from the value <" + aValue + "> of type <" + aValue.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public T putShort(String[] aPathElements, Short aValue) {
            return this.putShort(this.toPath(aPathElements), aValue);
        }

        default public T putString(Object aKey, String aValue) {
            return this.putString(InterOperableMap.asKey(aKey), aValue);
        }

        default public T putString(Object[] aPathElements, String aValue) {
            return this.putString(this.toPath(aPathElements), aValue);
        }

        default public T putString(Collection<?> aPathElements, String aValue) {
            return this.putString(this.toPath(aPathElements), aValue);
        }

        default public T putString(String aKey, String aValue) {
            if (aValue == null) {
                return (T)this.put(aKey, null);
            }
            if (this.getType().isAssignableFrom(String.class)) {
                return (T)this.put(aKey, aValue);
            }
            throw new NumberFormatException("Unable to convert a string from the value <" + aValue + "> of type <" + aValue.getClass().getName() + "> to type <" + this.getType().getName() + ">!");
        }

        default public T putString(String[] aPathElements, String aValue) {
            return this.putString(this.toPath(aPathElements), aValue);
        }
    }
}

