/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct;

import java.util.HashMap;
import java.util.Map;
import org.refcodes.struct.PathMap;

public class StructureUtility {
    private StructureUtility() {
    }

    public static <T> void retrieveFrom(PathMap<T> aFromPathMap, String aFromPath, PathMap.PathMapBuilder<T> aToPathMap) {
        String theFromPath = StructureUtility.toGenericPath(aFromPathMap, aFromPath);
        for (String ePath : aFromPathMap.paths()) {
            String eToPath;
            if (!ePath.startsWith(theFromPath) || !(eToPath = ePath.substring(theFromPath.length())).startsWith(aFromPathMap.getRootPath()) && !eToPath.isEmpty()) continue;
            aToPathMap.put(eToPath, aFromPathMap.get((Object)ePath));
        }
    }

    public static <T> void retrieveTo(PathMap<T> aFromPathMap, String aToPath, PathMap.PathMapBuilder<T> aToPathMap) {
        String thetoPath = StructureUtility.toGenericPath(aFromPathMap, aToPath);
        for (String ePath : aFromPathMap.paths()) {
            aToPathMap.put(String.valueOf(thetoPath) + ePath, aFromPathMap.get((Object)ePath));
        }
    }

    public static Object toDataStructure(PathMap<?> aPathMap, String aFromPath) {
        return StructureUtility.toArray(aPathMap.toMap(aFromPath));
    }

    public static String toGenericPath(PathMap<?> aPathMap, String aPath) {
        aPath = aPathMap.toNormalizedPath(aPath);
        while (aPath.endsWith(String.valueOf(aPathMap.getDelimiter()))) {
            aPath = aPath.substring(0, aPath.length() - 1);
        }
        return aPath;
    }

    private static Object toArray(Map<String, ?> aMap) {
        int index;
        int theMax = -1;
        for (String eKey : aMap.keySet()) {
            try {
                index = Integer.valueOf(eKey);
                if (index < 0) {
                    return StructureUtility.toMap(aMap);
                }
                if (index <= theMax) continue;
                theMax = index;
            }
            catch (NumberFormatException e) {
                return StructureUtility.toMap(aMap);
            }
        }
        Object[] theObjects = new Object[theMax + 1];
        for (String eKey : aMap.keySet()) {
            try {
                index = Integer.valueOf(eKey);
                theObjects[index] = StructureUtility.toValue(aMap.get(eKey));
            }
            catch (NumberFormatException e) {
                return StructureUtility.toMap(aMap);
            }
        }
        return theObjects;
    }

    private static Map<String, ?> toMap(Map<String, ?> aMap) {
        HashMap<String, Object> theMap = new HashMap<String, Object>();
        for (String eKey : aMap.keySet()) {
            theMap.put(eKey, StructureUtility.toValue(aMap.get(eKey)));
        }
        return theMap;
    }

    private static Object toValue(Object aObj) {
        if (aObj instanceof Map) {
            return StructureUtility.toArray((Map)aObj);
        }
        return aObj;
    }
}

