/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.refcodes.data.Literal;
import org.refcodes.struct.SimpleType;

public class TypeUtility {
    private static final String[] SETTER_PREFIXES = new String[]{"set"};
    private static final String[] GETTER_PREFIXES = new String[]{"is", "has", "get"};
    private static final String[] FIELD_PREFIXES = new String[]{"_"};

    private TypeUtility() {
        throw new IllegalStateException("Utility class");
    }

    public static <T> T toType(Object aValue, Class<T> aType) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        T theInstance;
        if (aType.isArray()) {
            theInstance = TypeUtility.toArray(aValue, aType);
        } else {
            if (aType.isAssignableFrom(aValue.getClass())) {
                return (T)aValue;
            }
            theInstance = TypeUtility.toInstance(aValue, aType);
        }
        return theInstance;
    }

    public static <T> void toInstance(Object aValue, T aInstance) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        Class<?> theClass = aInstance.getClass();
        if (theClass.isArray()) {
            Object theInstance = TypeUtility.toArray(aValue, theClass);
            int fromLength = Array.getLength(theInstance);
            int toLength = Array.getLength(aInstance);
            for (int i = 0; i < fromLength && i < toLength; ++i) {
                Array.set(aInstance, i, Array.get(theInstance, i));
            }
        } else {
            TypeUtility.updateInstance(aValue, aInstance);
        }
    }

    public static boolean isSetter(Method aMethod) {
        String thePropertyName = TypeUtility.fromSetterMethod(aMethod);
        if (thePropertyName == null || thePropertyName.isEmpty()) {
            return false;
        }
        return Modifier.isPublic(aMethod.getModifiers()) && aMethod.getParameterCount() == 1 && Void.TYPE.equals(aMethod.getReturnType());
    }

    public static boolean isGetter(Method aMethod) {
        String thePropertyName = TypeUtility.fromGetterMethod(aMethod);
        if (thePropertyName == null || thePropertyName.isEmpty()) {
            return false;
        }
        return Modifier.isPublic(aMethod.getModifiers()) && aMethod.getParameterCount() == 0 && !Void.TYPE.equals(aMethod.getReturnType());
    }

    public static String toPropertyName(Method aMethod) {
        if (TypeUtility.isSetter(aMethod)) {
            return TypeUtility.fromSetterMethod(aMethod);
        }
        if (TypeUtility.isGetter(aMethod)) {
            return TypeUtility.fromGetterMethod(aMethod);
        }
        return null;
    }

    public static String toPropertyName(Field aField) {
        String theName = aField.getName();
        return TypeUtility.fromFieldName(theName);
    }

    public static String[] toProperties(Class<?> aType) {
        ArrayList<String> theProperties = new ArrayList<String>();
        if (aType.isRecord()) {
            RecordComponent[] theComponents;
            for (RecordComponent theComponent : theComponents = aType.getRecordComponents()) {
                String eProperty = theComponent.getName();
                if (eProperty == null || theProperties.contains(eProperty)) continue;
                theProperties.add(eProperty);
            }
        } else {
            Field[] theFields;
            String eProperty;
            Method[] theMethods;
            for (Method theMethod : theMethods = aType.getMethods()) {
                eProperty = TypeUtility.toPropertyName(theMethod);
                if (eProperty == null || theProperties.contains(eProperty)) continue;
                theProperties.add(eProperty);
            }
            for (Field theField : theFields = aType.getFields()) {
                eProperty = TypeUtility.toPropertyName(theField);
                if (eProperty == null || theProperties.contains(eProperty)) continue;
                theProperties.add(eProperty);
            }
        }
        return theProperties.toArray(new String[theProperties.size()]);
    }

    public static <T> T toArrayType(Object aValue, Class<T> aType) {
        if (!aValue.getClass().isArray()) {
            throw new IllegalArgumentException("The provided value <" + aValue + "> of type <" + aValue.getClass() + "> must be an array type!");
        }
        if (!aType.isArray()) {
            throw new IllegalArgumentException("The provided type <" + aType + "> must be an array type!");
        }
        try {
            return TypeUtility.toArray(aValue, aType);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot create an array type <" + aType + "> for the given value <" + aValue + ")!", e);
        }
    }

    public static <T> Map<String, Object> toMap(T aInstance) {
        Field[] theFields;
        Class<?> theType = aInstance.getClass();
        HashMap<String, Object> theResult = new HashMap<String, Object>();
        Method[] theMethods = theType.getDeclaredMethods();
        if (theMethods != null && theMethods.length > 0) {
            for (Method eMethod : theMethods) {
                if (!TypeUtility.isGetter(eMethod)) continue;
                String ePropertyName = TypeUtility.fromGetterMethod(eMethod);
                try {
                    eMethod.setAccessible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Object eValue = eMethod.invoke(aInstance, new Object[0]);
                    theResult.put(ePropertyName, eValue);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
        }
        if ((theFields = theType.getDeclaredFields()) != null && theFields.length > 0) {
            for (Field eField : theFields) {
                String ePropertyName = TypeUtility.toPropertyName(eField);
                try {
                    eField.setAccessible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Object eValue = eField.get(aInstance);
                    theResult.put(ePropertyName, eValue);
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {
                    // empty catch block
                }
            }
        }
        return theResult;
    }

    public static Constructor<?> toConstructor(Class<Record> aType) {
        RecordComponent[] theComponents = aType.getRecordComponents();
        return TypeUtility.toConstructor(aType, theComponents);
    }

    private static Constructor<?> toConstructor(Class<Record> aType, RecordComponent[] aComponents) {
        if (aComponents.length != 0) {
            Constructor<?>[] theCtors;
            block0: for (Constructor<?> eCtor : theCtors = aType.getDeclaredConstructors()) {
                Parameter[] eParams = eCtor.getParameters();
                if (eParams == null || eParams.length != aComponents.length) continue;
                for (int i = 0; i < eParams.length; ++i) {
                    if (!eParams[i].getType().equals(aComponents[i].getType())) continue block0;
                }
                return eCtor;
            }
        }
        return null;
    }

    private static <T> T toInstance(Object aValue, Class<T> aType) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        if (aValue instanceof String) {
            try {
                Class<?> theClass = Class.forName((String)aValue);
                if (aType.isAssignableFrom(theClass)) {
                    Constructor<?> theCtor = theClass.getConstructor(new Class[0]);
                    return (T)theCtor.newInstance(new Object[0]);
                }
            }
            catch (Exception | NoClassDefFoundError theClass) {
                // empty catch block
            }
        }
        if (aType.isEnum() && aValue instanceof String) {
            Enum[] theEnums;
            for (Enum eEnum : theEnums = (Enum[])aType.getEnumConstants()) {
                if (!eEnum.name().equals(aValue)) continue;
                return (T)eEnum;
            }
        }
        if (aType.isRecord()) {
            return TypeUtility.fromRecord(aValue, aType);
        }
        if (aValue instanceof String && SimpleType.isSimpleType(aType)) {
            return (T)SimpleType.toSimpleType((String)aValue, aType);
        }
        return (T)TypeUtility.fromClass(aValue, aType);
    }

    private static <T> T fromRecord(Object aValue, Class<Record> aType) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        RecordComponent[] theComponents = aType.getRecordComponents();
        Constructor<?> theCtor = TypeUtility.toConstructor(aType, theComponents);
        if (aValue instanceof Map) {
            Map theMap = (Map)aValue;
            HashSet<String> theInjected = new HashSet<String>();
            ArrayList<Object> theArgs = new ArrayList<Object>();
            Parameter[] theParams = theCtor.getParameters();
            if (theParams != null && theParams.length > 0) {
                for (int i = 0; i < theParams.length; ++i) {
                    Parameter eParam = theParams[i];
                    String ePropertyName = theComponents[i].getName();
                    if (theInjected.contains(ePropertyName)) continue;
                    Object eValue = theMap.get(ePropertyName);
                    try {
                        if (eValue != null) {
                            if (eValue.getClass().isArray() && !eParam.getType().isArray() && !Collection.class.isAssignableFrom(eParam.getType())) {
                                Object[] eArray;
                                for (Object eElement : eArray = (Object[])eValue) {
                                    if (eElement == null || !eElement.getClass().isAssignableFrom(eParam.getType())) continue;
                                    TypeUtility.addToArgs(theArgs, eElement, eParam);
                                    theInjected.add(ePropertyName);
                                }
                                continue;
                            }
                            TypeUtility.addToArgs(theArgs, eValue, eParam);
                            theInjected.add(ePropertyName);
                            continue;
                        }
                        eValue = SimpleType.isPrimitiveType(eParam.getType()) ? (eParam.getType() == Boolean.TYPE ? "false" : "0") : null;
                        TypeUtility.addToArgs(theArgs, eValue, eParam);
                        theInjected.add(ePropertyName);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException("Unable to determine property <" + ePropertyName + "> of type <" + aType.getName() + "> from value <" + eValue + ">!", e);
                    }
                }
            }
            try {
                return (T)theCtor.newInstance(theArgs.toArray());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Cannot create instace for type <" + aType.getName() + "> with arguments " + Arrays.toString(theArgs.toArray()), e);
            }
        }
        throw new IllegalArgumentException("Unable to match the value <" + aValue + "> with type <" + aType + ">!");
    }

    private static <T> T fromClass(Object aValue, Class<T> aType) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Constructor<T> theCtor = aType.getConstructor(new Class[0]);
        try {
            theCtor.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        T theToInstance = theCtor.newInstance(new Object[0]);
        TypeUtility.toInstance(aValue, theToInstance);
        return theToInstance;
    }

    private static <T> void updateInstance(Object aValue, T aInstance) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class<?> aType = aInstance.getClass();
        if (aValue instanceof Map) {
            Field[] theFields;
            Map theMap = (Map)aValue;
            HashSet<String> theInjected = new HashSet<String>();
            Method[] theMethods = aType.getDeclaredMethods();
            if (theMethods != null && theMethods.length > 0) {
                HashSet<String> theFailedProperties = new HashSet<String>();
                Exception theFailedException = null;
                Method[] methodArray = theMethods;
                int n = methodArray.length;
                for (int i = 0; i < n; ++i) {
                    Method eMethod = methodArray[i];
                    if (!TypeUtility.isSetter(eMethod)) continue;
                    try {
                        Object eValue2;
                        String ePropertyName = TypeUtility.fromSetterMethod(eMethod);
                        if (theInjected.contains(ePropertyName) || (eValue2 = theMap.get(ePropertyName)) == null) continue;
                        try {
                            eMethod.setAccessible(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (eValue2.getClass().isArray() && !eMethod.getParameters()[0].getType().isArray() && !Collection.class.isAssignableFrom(eMethod.getParameters()[0].getType())) {
                            Object[] eArray = (Object[])eValue2;
                            Object eObj = null;
                            for (Object eElement : eArray) {
                                if (eElement == null) continue;
                                if (eObj != null && eElement instanceof Map) {
                                    TypeUtility.updateInstance(eElement, eObj);
                                    continue;
                                }
                                try {
                                    eObj = TypeUtility.addToMethod(aInstance, eElement, eMethod);
                                    theInjected.add(ePropertyName);
                                }
                                catch (Exception e) {
                                    theFailedProperties.add(ePropertyName);
                                    theFailedException = theFailedException == null ? e : theFailedException;
                                }
                            }
                            continue;
                        }
                        try {
                            TypeUtility.addToMethod(aInstance, eValue2, eMethod);
                            theInjected.add(ePropertyName);
                        }
                        catch (Exception e) {
                            theFailedProperties.add(ePropertyName);
                            theFailedException = theFailedException == null ? e : theFailedException;
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException eValue2) {
                        // empty catch block
                    }
                }
                if (!theFailedProperties.isEmpty()) {
                    for (String eInjectedName : theInjected) {
                        theFailedProperties.remove(eInjectedName);
                    }
                    if (!theFailedProperties.isEmpty()) {
                        if (theFailedException != null) {
                            throw new NoSuchMethodNotInvokedException("Unable to satisfy the following properties " + Arrays.toString(theFailedProperties.toArray()) + " (without the square braces) as there are no according methods with the required argument types!", theFailedException);
                        }
                        throw new NoSuchMethodException("Unable to satisfy the following properties " + Arrays.toString(theFailedProperties.toArray()) + " (without the square braces) as there are no according methods with the required argument types!");
                    }
                }
            }
            if ((theFields = aType.getDeclaredFields()) != null && theFields.length > 0) {
                for (Field eField : theFields) {
                    try {
                        Object eValue;
                        String ePropertyName = TypeUtility.toPropertyName(eField);
                        if (theInjected.contains(ePropertyName) || (eValue = theMap.get(ePropertyName)) == null) continue;
                        try {
                            eField.setAccessible(true);
                        }
                        catch (Exception eValue2) {
                            // empty catch block
                        }
                        if (eValue.getClass().isArray() && !eField.getType().isArray() && !Collection.class.isAssignableFrom(eField.getType())) {
                            Object[] eArray;
                            for (Object eElement : eArray = (Object[])eValue) {
                                if (eElement == null) continue;
                                TypeUtility.addToField(aInstance, eElement, eField);
                                theInjected.add(ePropertyName);
                            }
                            continue;
                        }
                        TypeUtility.addToField(aInstance, eValue, eField);
                        theInjected.add(ePropertyName);
                    }
                    catch (IllegalAccessException | IllegalArgumentException exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static <T> Object addToMethod(T aToInstance, Object aToValue, Method aToMethod) throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        String theToText = aToValue.toString();
        Class<?> theToType = aToMethod.getParameters()[0].getType();
        if (theToType.equals(String.class)) {
            aToMethod.invoke(aToInstance, theToText);
        } else if (theToText.length() != 0 && !Literal.NULL.getValue().equals(theToText) && !SimpleType.invokeSimpleType(aToInstance, aToMethod, theToText, theToType)) {
            if (List.class.isAssignableFrom(theToType)) {
                List<?> theToList = TypeUtility.toList(aToValue, aToMethod.getParameters()[0].getType(), aToMethod.getParameters()[0].getParameterizedType());
                aToMethod.invoke(aToInstance, theToList);
            } else if (Map.class.isAssignableFrom(theToType)) {
                Map<?, ?> theToMap = TypeUtility.toMap(aToValue, aToMethod.getParameters()[0].getType(), aToMethod.getParameters()[0].getParameterizedType());
                aToMethod.invoke(aToInstance, theToMap);
            } else {
                Object theInstance = TypeUtility.toType(aToValue, theToType);
                aToMethod.invoke(aToInstance, theInstance);
                return theInstance;
            }
        }
        return null;
    }

    private static <T> void addToField(T aToInstance, Object aToValue, Field aToField) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        String theToText = aToValue.toString();
        Class<?> theToType = aToField.getType();
        if (theToType.equals(String.class)) {
            aToField.set(aToInstance, theToText);
        } else if (theToText.length() != 0 && !Literal.NULL.getValue().equals(theToText) && !SimpleType.invokeSimpleType(aToInstance, aToField, theToText, theToType)) {
            if (List.class.isAssignableFrom(theToType)) {
                List<?> theToList = TypeUtility.toList(aToValue, aToField.getType(), aToField.getGenericType());
                aToField.set(aToInstance, theToList);
            } else if (Map.class.isAssignableFrom(theToType)) {
                Map<?, ?> theToMap = TypeUtility.toMap(aToValue, aToField.getType(), aToField.getGenericType());
                aToField.set(aToInstance, theToMap);
            } else {
                aToField.set(aToInstance, TypeUtility.toType(aToValue, theToType));
            }
        }
    }

    private static <T> void addToArgs(List<Object> aArgs, Object aToValue, Parameter aToParam) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        String theToText = aToValue != null ? aToValue.toString() : null;
        Class<?> theToType = aToParam.getType();
        if (theToType.equals(String.class)) {
            aArgs.add(theToText);
        } else if (theToText != null && theToText.length() != 0) {
            Object theValue = SimpleType.toSimpleType(theToText, theToType);
            if (theValue != null) {
                aArgs.add(theValue);
            } else if (List.class.isAssignableFrom(theToType)) {
                List<?> theToList = TypeUtility.toList(aToValue, aToParam.getType(), aToParam.getParameterizedType());
                aArgs.add(theToList);
            } else if (Map.class.isAssignableFrom(theToType)) {
                Map<?, ?> theToMap = TypeUtility.toMap(aToValue, aToParam.getType(), aToParam.getParameterizedType());
                aArgs.add(theToMap);
            } else {
                aArgs.add(TypeUtility.toType(aToValue, theToType));
            }
        } else {
            aArgs.add(null);
        }
    }

    private static <T> T toArray(Object aValue, Class<T> aType) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class<?> theToType = aType.getComponentType();
        Object[] theArray = (Object[])aValue;
        Object theToInstance = Array.newInstance(aType.getComponentType(), theArray.length);
        for (int i = 0; i < theArray.length; ++i) {
            if (theArray[i] == null) continue;
            String eToText = theArray[i].toString();
            if (theToType.equals(String.class)) {
                Array.set(theToInstance, i, eToText);
                continue;
            }
            if (eToText.length() == 0 || Literal.NULL.getValue().equals(eToText) || SimpleType.invokeSimpleType(theToInstance, i, eToText, theToType)) continue;
            Array.set(theToInstance, i, TypeUtility.toType(theArray[i], theToType));
        }
        return (T)theToInstance;
    }

    private static Map<?, ?> toMap(Object aToValue, Class<?> aToType, Type aToGenericType) throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Map theMap = (Map)aToValue;
        Map theToMap = aToType.equals(Map.class) ? new HashMap() : (Map)aToType.getConstructor(new Class[0]).newInstance(new Object[0]);
        Class theKeyType = Object.class;
        Class theValueType = Object.class;
        if (aToGenericType instanceof ParameterizedType) {
            ParameterizedType theGenericType = (ParameterizedType)aToGenericType;
            theKeyType = TypeUtility.toClass(theGenericType.getActualTypeArguments()[0]);
            theValueType = TypeUtility.toClass(theGenericType.getActualTypeArguments()[1]);
        }
        for (Object eKey : theMap.keySet()) {
            Object theValue = theMap.get(eKey);
            if (theValue == null) continue;
            theToMap.put(TypeUtility.toValue(eKey, theKeyType), TypeUtility.toValue(theValue, theValueType));
        }
        return theMap;
    }

    private static List<?> toList(Object aToValue, Class<?> aToType, Type aToGenericType) throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        List theToList = null;
        Object[] theArray = (Object[])aToValue;
        theToList = aToType.equals(List.class) ? new ArrayList() : (List)aToType.getConstructor(new Class[0]).newInstance(new Object[0]);
        Class theType = Object.class;
        if (aToGenericType instanceof ParameterizedType) {
            theType = TypeUtility.toClass(((ParameterizedType)aToGenericType).getActualTypeArguments()[0]);
        }
        for (Object aTheArray : theArray) {
            if (aTheArray == null) {
                theToList.add(null);
                continue;
            }
            theToList.add(TypeUtility.toValue(aTheArray, theType));
        }
        return theToList;
    }

    private static Object toValue(Object aValue, Class<?> aType) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        String theValue = aValue.toString();
        String theResult = null;
        if (aType.equals(String.class)) {
            theResult = theValue;
        } else if (theValue.length() != 0 && !Literal.NULL.getValue().equals(theValue) && (theResult = SimpleType.toSimpleType(theValue, aType)) == null) {
            theResult = TypeUtility.toType(aValue, aType);
        }
        return theResult;
    }

    private static Class<?> toClass(Type aType) throws ClassNotFoundException {
        if (aType instanceof Class) {
            return (Class)aType;
        }
        return Class.forName(aType.getTypeName());
    }

    private static String toPropertyName(String aName) {
        char[] theChars = aName.toCharArray();
        for (int i = 0; i < theChars.length && Character.isUpperCase(theChars[i]); ++i) {
            theChars[i] = Character.toLowerCase(theChars[i]);
        }
        return new String(theChars);
    }

    private static String fromSetterMethod(Method aMethod) {
        String theName = aMethod.getName();
        return TypeUtility.fromSetterName(theName);
    }

    private static String fromSetterName(String aName) {
        String ePrefix2;
        block4: {
            for (String ePrefix2 : SETTER_PREFIXES) {
                if (!aName.startsWith(ePrefix2)) {
                    continue;
                }
                break block4;
            }
            return null;
        }
        aName = aName.substring(ePrefix2.length());
        if (aName.length() > 0) {
            if (Character.isLowerCase(aName.charAt(0))) {
                return null;
            }
            return TypeUtility.toPropertyName(aName);
        }
        return null;
    }

    protected static String fromGetterMethod(Method aMethod) {
        String theName = aMethod.getName();
        return TypeUtility.fromGetterName(theName);
    }

    private static String fromGetterName(String aName) {
        String ePrefix2;
        block4: {
            for (String ePrefix2 : GETTER_PREFIXES) {
                if (!aName.startsWith(ePrefix2)) {
                    continue;
                }
                break block4;
            }
            return null;
        }
        aName = aName.substring(ePrefix2.length());
        if (aName.length() > 0) {
            if (Character.isLowerCase(aName.charAt(0))) {
                return null;
            }
            return TypeUtility.toPropertyName(aName);
        }
        return null;
    }

    private static String fromFieldName(String aFieldName) {
        String eName = aFieldName;
        for (String ePrefix : FIELD_PREFIXES) {
            if (!eName.startsWith(ePrefix)) continue;
            eName = aFieldName.substring(ePrefix.length());
            break;
        }
        if (eName.length() > 0) {
            aFieldName = eName;
        }
        if ((eName = TypeUtility.fromGetterName(aFieldName)) != null && eName.length() > 0) {
            aFieldName = eName;
        }
        return TypeUtility.toPropertyName(aFieldName);
    }

    public static class NoSuchMethodNotInvokedException
    extends NoSuchMethodException {
        private static final long serialVersionUID = 1L;
        private final Throwable _cause;

        public NoSuchMethodNotInvokedException(String aMessage, Throwable aCause) {
            super(aMessage);
            this._cause = aCause;
        }

        @Override
        public Throwable getCause() {
            return this._cause;
        }
    }
}

