/*
 * Decompiled with CFR 0.152.
 */
package org.refcodes.struct;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.refcodes.data.Literal;
import org.refcodes.struct.SimpleType;

public class TypeUtility {
    private static final String[] SETTER_PREFIXES = new String[]{"set"};
    private static final String[] GETTER_PREFIXES = new String[]{"is", "has", "get"};
    private static final String[] FIELD_PREFIXES = new String[]{"_"};

    private TypeUtility() {
    }

    public static boolean isGetter(Method aMethod) {
        if (aMethod.getDeclaringClass().isRecord()) {
            return false;
        }
        String thePropertyName = TypeUtility.toGetterPropertyName(aMethod);
        if (thePropertyName == null || thePropertyName.isEmpty()) {
            return false;
        }
        return Modifier.isPublic(aMethod.getModifiers()) && aMethod.getParameterCount() == 0 && !Void.TYPE.equals(aMethod.getReturnType());
    }

    public static boolean isProperty(Method aMethod) {
        if (!aMethod.getDeclaringClass().isRecord()) {
            return false;
        }
        String thePropertyName = aMethod.getName();
        if (thePropertyName == null || thePropertyName.isEmpty()) {
            return false;
        }
        return Modifier.isPublic(aMethod.getModifiers()) && aMethod.getParameterCount() == 0 && !Void.TYPE.equals(aMethod.getReturnType());
    }

    public static boolean isSetter(Method aMethod) {
        String thePropertyName = TypeUtility.toSetterPropertyName(aMethod);
        if (thePropertyName == null || thePropertyName.isEmpty()) {
            return false;
        }
        return Modifier.isPublic(aMethod.getModifiers()) && aMethod.getParameterCount() == 1 && Void.TYPE.equals(aMethod.getReturnType());
    }

    public static <T> T[] toArray(Collection<T> aCollection) {
        if (aCollection == null || aCollection.isEmpty()) {
            return null;
        }
        Class<T> theElementType = TypeUtility.toCommonType(aCollection);
        if (theElementType == null) {
            return null;
        }
        int theSize = aCollection.size();
        Object[] theArray = (Object[])Array.newInstance(theElementType, theSize);
        int i = 0;
        for (T eElement : aCollection) {
            theArray[i] = eElement;
            ++i;
        }
        return theArray;
    }

    public static <T> T toArray(Object aValue, Class<T> aType) {
        if (!aType.isArray()) {
            throw new IllegalArgumentException("The provided type <" + String.valueOf(aType) + "> must be an array type!");
        }
        try {
            return TypeUtility.toArrayOfType(aValue, aType);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot create an array type <" + String.valueOf(aType) + "> for the given value <" + String.valueOf(aValue) + ")!", e);
        }
    }

    public static <T> Map<String, Object> toAttributeMap(T aInstance) {
        Field[] theFields;
        Class<?> theType = aInstance.getClass();
        HashMap<String, Object> theResult = new HashMap<String, Object>();
        Method[] theMethods = theType.getDeclaredMethods();
        if (theMethods != null && theMethods.length > 0) {
            for (Method eMethod : theMethods) {
                if (!TypeUtility.isGetter(eMethod) && !TypeUtility.isProperty(eMethod)) continue;
                String ePropertyName = TypeUtility.toPropertyName(eMethod);
                try {
                    eMethod.setAccessible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Object eValue = eMethod.invoke(aInstance, new Object[0]);
                    theResult.put(ePropertyName, eValue);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                    // empty catch block
                }
            }
        }
        if ((theFields = theType.getDeclaredFields()) != null && theFields.length > 0) {
            for (Field eField : theFields) {
                String ePropertyName = TypeUtility.toPropertyName(eField);
                try {
                    eField.setAccessible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Object eValue = eField.get(aInstance);
                    theResult.put(ePropertyName, eValue);
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {
                    // empty catch block
                }
            }
        }
        return theResult;
    }

    public static List<Class<?>> toCommonAncestors(Collection<Class<?>> aTypes) {
        LinkedHashSet theCommonAncestors = new LinkedHashSet();
        if (aTypes != null && !aTypes.isEmpty()) {
            Iterator<Class<?>> e = aTypes.iterator();
            theCommonAncestors.addAll(TypeUtility.toSuperTypes(e.next()));
            while (e.hasNext()) {
                theCommonAncestors.retainAll(TypeUtility.toSuperTypes(e.next()));
            }
        }
        return new LinkedList(theCommonAncestors);
    }

    public static <T> Class<T> toCommonType(Collection<T> aCollection) {
        ArrayList theClasses = new ArrayList();
        for (T eElement : aCollection) {
            if (eElement == null) continue;
            theClasses.add(eElement.getClass());
        }
        List<Class<?>> theElementTypes = TypeUtility.toCommonAncestors(theClasses);
        return theElementTypes.size() != 0 ? theElementTypes.get(0) : null;
    }

    public static Constructor<?> toConstructor(Class<Record> aType) {
        RecordComponent[] theComponents = aType.getRecordComponents();
        return TypeUtility.toRecordConstructor(aType, theComponents);
    }

    public static String[] toPropertieNames(Class<?> aType) {
        ArrayList<String> theProperties = new ArrayList<String>();
        if (aType.isRecord()) {
            RecordComponent[] theComponents;
            for (RecordComponent theComponent : theComponents = aType.getRecordComponents()) {
                String eProperty = theComponent.getName();
                if (eProperty == null || theProperties.contains(eProperty)) continue;
                theProperties.add(eProperty);
            }
        } else {
            Field[] theFields;
            String eProperty;
            Method[] theMethods;
            for (Method theMethod : theMethods = aType.getMethods()) {
                eProperty = TypeUtility.toPropertyName(theMethod);
                if (eProperty == null || theProperties.contains(eProperty)) continue;
                theProperties.add(eProperty);
            }
            for (Field theField : theFields = aType.getFields()) {
                eProperty = TypeUtility.toPropertyName(theField);
                if (eProperty == null || theProperties.contains(eProperty)) continue;
                theProperties.add(eProperty);
            }
        }
        return theProperties.toArray(new String[theProperties.size()]);
    }

    public static String toPropertyName(Field aField) {
        String theFieldName;
        String eFieldName = theFieldName = aField.getName();
        for (String ePrefix : FIELD_PREFIXES) {
            if (!eFieldName.startsWith(ePrefix)) continue;
            eFieldName = theFieldName.substring(ePrefix.length());
            break;
        }
        if (eFieldName.length() > 0) {
            theFieldName = eFieldName;
        }
        if ((eFieldName = TypeUtility.toGetterPropertyName(theFieldName)) != null && eFieldName.length() > 0) {
            theFieldName = eFieldName;
        }
        return TypeUtility.toPropertyName(theFieldName);
    }

    public static String toPropertyName(Method aMethod) {
        if (TypeUtility.isGetter(aMethod)) {
            return TypeUtility.toGetterPropertyName(aMethod);
        }
        if (TypeUtility.isProperty(aMethod)) {
            return aMethod.getName();
        }
        if (TypeUtility.isSetter(aMethod)) {
            return TypeUtility.toSetterPropertyName(aMethod);
        }
        return null;
    }

    public static Set<Class<?>> toSuperTypes(Class<?> aType) {
        LinkedHashSet theClasses = new LinkedHashSet();
        theClasses.add(aType);
        Class<?> theSuper = aType.getSuperclass();
        if (theSuper != null && theSuper != Object.class) {
            theClasses.addAll(TypeUtility.toSuperTypes(theSuper));
        }
        for (Class<?> eInterface : aType.getInterfaces()) {
            theClasses.addAll(TypeUtility.toSuperTypes(eInterface));
        }
        return theClasses;
    }

    public static <T> T toType(Object aValue, Class<T> aType) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        if (aType.isArray()) {
            return TypeUtility.toArrayOfType(aValue, aType);
        }
        if (aType.isAssignableFrom(aValue.getClass())) {
            return (T)aValue;
        }
        if (aValue != null && aValue.getClass().isArray() && aType.isAssignableFrom(Map.class)) {
            HashMap<String, Object> theMap = new HashMap<String, Object>();
            Object[] theArray = (Object[])aValue;
            for (int i = 0; i < theArray.length; ++i) {
                if (theArray[i] == null) continue;
                theMap.put(Integer.toString(i), theArray[i]);
            }
            return TypeUtility.toValueOfType(theMap, aType);
        }
        return TypeUtility.toValueOfType(aValue, aType);
    }

    public static Object toUnwrappedMap(Object aValue) {
        if (aValue instanceof Map) {
            Map theMap = (Map)aValue;
            return TypeUtility.toArrayFromMap(theMap);
        }
        return aValue;
    }

    public static <T> void updateInstance(Object aValue, T aInstance) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        Class<?> theClass = aInstance.getClass();
        if (theClass.isArray()) {
            Object theInstance = TypeUtility.toArrayOfType(aValue, theClass);
            int fromLength = Array.getLength(theInstance);
            int toLength = Array.getLength(aInstance);
            for (int i = 0; i < fromLength && i < toLength; ++i) {
                Array.set(aInstance, i, Array.get(theInstance, i));
            }
        } else if (aValue instanceof Map) {
            Map eMap = (Map)aValue;
            TypeUtility.updateInstance(eMap, aInstance);
        }
    }

    protected static String toGetterPropertyName(Method aMethod) {
        String theName = aMethod.getName();
        return TypeUtility.toGetterPropertyName(theName);
    }

    private static Object toArrayFromMap(Map<?, ?> aMap) {
        int index;
        int theMax = -1;
        for (Object eKey : aMap.keySet()) {
            try {
                if (eKey instanceof Integer) {
                    Integer eInt = (Integer)eKey;
                    v0 = eInt;
                } else {
                    v0 = index = Integer.valueOf(eKey instanceof String ? (String)eKey : (eKey != null ? eKey.toString() : null)).intValue();
                }
                if (index < 0) {
                    return TypeUtility.toMapWithStringKeys(aMap);
                }
                if (index <= theMax) continue;
                theMax = index;
            }
            catch (NumberFormatException e) {
                return TypeUtility.toMapWithStringKeys(aMap);
            }
        }
        Object[] theObjects = new Object[theMax + 1];
        for (Object eKey : aMap.keySet()) {
            try {
                if (eKey instanceof Integer) {
                    Integer eInt = (Integer)eKey;
                    v1 = eInt;
                } else {
                    v1 = index = Integer.valueOf(eKey instanceof String ? (String)eKey : (eKey != null ? eKey.toString() : null)).intValue();
                }
                if (theObjects[index] != null) {
                    return TypeUtility.toMapWithStringKeys(aMap);
                }
                theObjects[index] = TypeUtility.toUnwrappedMap(aMap.get(eKey));
            }
            catch (NumberFormatException e) {
                return TypeUtility.toMapWithStringKeys(aMap);
            }
        }
        return theObjects;
    }

    private static <T> T toArrayOfType(Object aValue, Class<T> aType) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class<?> theToType = aType.getComponentType();
        aValue = TypeUtility.toUnwrappedMap(aValue);
        Object[] theArray = (Object[])aValue;
        Object theToInstance = Array.newInstance(aType.getComponentType(), theArray.length);
        for (int i = 0; i < theArray.length; ++i) {
            if (theArray[i] == null) continue;
            String eToText = theArray[i].toString();
            if (theToType.equals(String.class)) {
                Array.set(theToInstance, i, eToText);
                continue;
            }
            if (eToText.length() == 0 || Literal.NULL.getValue().equals(eToText) || SimpleType.invokeSimpleType(theToInstance, i, eToText, theToType)) continue;
            Array.set(theToInstance, i, TypeUtility.toType(theArray[i], theToType));
        }
        return (T)theToInstance;
    }

    private static Class<?> toClassOfType(Type aType) throws ClassNotFoundException {
        if (aType instanceof Class) {
            return (Class)aType;
        }
        return Class.forName(aType.getTypeName());
    }

    private static <T> T toCollectionOfType(Class<T> aType) {
        if (Map.class.equals(aType)) {
            return (T)new HashMap();
        }
        if (List.class.equals(aType)) {
            return (T)new ArrayList();
        }
        if (Set.class.equals(aType)) {
            return (T)new HashSet();
        }
        if (Collection.class.equals(aType)) {
            return (T)new ArrayList();
        }
        return null;
    }

    private static String toGetterPropertyName(String aName) {
        String ePrefix2;
        block4: {
            for (String ePrefix2 : GETTER_PREFIXES) {
                if (!aName.startsWith(ePrefix2)) {
                    continue;
                }
                break block4;
            }
            return null;
        }
        aName = aName.substring(ePrefix2.length());
        if (aName.length() > 0) {
            if (Character.isLowerCase(aName.charAt(0))) {
                return null;
            }
            return TypeUtility.toPropertyName(aName);
        }
        return null;
    }

    private static List<?> toListOfType(Object aToValue, Class<? extends List<?>> aToType, Type aToGenericType) throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        List<Object> theToList = null;
        aToValue = TypeUtility.toUnwrappedMap(aToValue);
        Object[] theArray = (Object[])aToValue;
        theToList = aToType.equals(List.class) ? new ArrayList() : aToType.getConstructor(new Class[0]).newInstance(new Object[0]);
        Class theType = Object.class;
        if (aToGenericType instanceof ParameterizedType) {
            theType = TypeUtility.toClassOfType(((ParameterizedType)aToGenericType).getActualTypeArguments()[0]);
        }
        for (Object eArray : theArray) {
            if (eArray == null) {
                theToList.add(null);
                continue;
            }
            theToList.add(TypeUtility.toElementOfType(eArray, theType));
        }
        return theToList;
    }

    private static Map<?, ?> toMapOfType(Object aToValue, Class<? extends Map<?, ?>> aToType, Type aToGenericType) throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Map theMap = (Map)aToValue;
        Map<Object, Object> theToMap = aToType.equals(Map.class) ? new HashMap() : aToType.getConstructor(new Class[0]).newInstance(new Object[0]);
        Class theKeyType = Object.class;
        Class theValueType = Object.class;
        if (aToGenericType instanceof ParameterizedType) {
            ParameterizedType theGenericType = (ParameterizedType)aToGenericType;
            theKeyType = TypeUtility.toClassOfType(theGenericType.getActualTypeArguments()[0]);
            theValueType = TypeUtility.toClassOfType(theGenericType.getActualTypeArguments()[1]);
        }
        for (Object eKey : theMap.keySet()) {
            Object theValue = theMap.get(eKey);
            if (theValue == null) continue;
            theToMap.put(TypeUtility.toElementOfType(eKey, theKeyType), TypeUtility.toElementOfType(theValue, theValueType));
        }
        return theMap;
    }

    private static Map<String, ?> toMapWithStringKeys(Map<?, ?> aMap) {
        HashMap<String, Object> theMap = new HashMap<String, Object>();
        for (Object eKey : aMap.keySet()) {
            theMap.put(eKey instanceof String ? (String)eKey : (eKey != null ? eKey.toString() : null), TypeUtility.toUnwrappedMap(aMap.get(eKey)));
        }
        return theMap;
    }

    private static String toPropertyName(String aName) {
        char[] theChars = aName.toCharArray();
        for (int i = 0; i < theChars.length && Character.isUpperCase(theChars[i]); ++i) {
            theChars[i] = Character.toLowerCase(theChars[i]);
        }
        return new String(theChars);
    }

    private static Constructor<?> toRecordConstructor(Class<Record> aType, RecordComponent[] aComponents) {
        if (aComponents.length != 0) {
            Constructor<?>[] theCtors;
            block0: for (Constructor<?> eCtor : theCtors = aType.getDeclaredConstructors()) {
                Parameter[] eParams = eCtor.getParameters();
                if (eParams == null || eParams.length != aComponents.length) continue;
                for (int i = 0; i < eParams.length; ++i) {
                    if (!eParams[i].getType().equals(aComponents[i].getType())) continue block0;
                }
                return eCtor;
            }
        }
        return null;
    }

    private static <T> T toRecordFromValue(Object aValue, Class<Record> aType) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        RecordComponent[] theComponents = aType.getRecordComponents();
        Constructor<?> theCtor = TypeUtility.toRecordConstructor(aType, theComponents);
        if (aValue instanceof Map) {
            Map theMap = (Map)aValue;
            HashSet<String> theInjected = new HashSet<String>();
            ArrayList<Object> theArgs = new ArrayList<Object>();
            Parameter[] theParams = theCtor.getParameters();
            if (theParams != null && theParams.length > 0) {
                for (int i = 0; i < theParams.length; ++i) {
                    Parameter eParam = theParams[i];
                    String ePropertyName = theComponents[i].getName();
                    if (theInjected.contains(ePropertyName)) continue;
                    Object eValue = theMap.get(ePropertyName);
                    try {
                        if (eValue != null) {
                            if (eValue.getClass().isArray() && !eParam.getType().isArray() && !Collection.class.isAssignableFrom(eParam.getType())) {
                                Object[] eArray;
                                for (Object eElement : eArray = (Object[])eValue) {
                                    if (eElement == null || !eElement.getClass().isAssignableFrom(eParam.getType())) continue;
                                    TypeUtility.writeParameterToArgs(theArgs, eElement, eParam);
                                    theInjected.add(ePropertyName);
                                }
                                continue;
                            }
                            TypeUtility.writeParameterToArgs(theArgs, eValue, eParam);
                            theInjected.add(ePropertyName);
                            continue;
                        }
                        eValue = SimpleType.isPrimitiveType(eParam.getType()) ? (eParam.getType() == Boolean.TYPE ? "false" : "0") : null;
                        TypeUtility.writeParameterToArgs(theArgs, eValue, eParam);
                        theInjected.add(ePropertyName);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException("Unable to determine property <" + ePropertyName + "> of type <" + aType.getName() + "> from value <" + String.valueOf(eValue) + ">!", e);
                    }
                }
            }
            try {
                return (T)theCtor.newInstance(theArgs.toArray());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Cannot create instance for type <" + aType.getName() + "> with arguments " + Arrays.toString(theArgs.toArray()), e);
            }
        }
        throw new IllegalArgumentException("Unable to match the value <" + String.valueOf(aValue) + "> " + (String)(aValue != null ? "of type <" + aValue.getClass().getName() + "> " : " ") + "with type <" + String.valueOf(aType) + ">!");
    }

    private static String toSetterPropertyName(Method aMethod) {
        String theName = aMethod.getName();
        return TypeUtility.toSetterPropertyName(theName);
    }

    private static String toSetterPropertyName(String aName) {
        String ePrefix2;
        block4: {
            for (String ePrefix2 : SETTER_PREFIXES) {
                if (!aName.startsWith(ePrefix2)) {
                    continue;
                }
                break block4;
            }
            return null;
        }
        aName = aName.substring(ePrefix2.length());
        if (aName.length() > 0) {
            if (Character.isLowerCase(aName.charAt(0))) {
                return null;
            }
            return TypeUtility.toPropertyName(aName);
        }
        return null;
    }

    private static Object toElementOfType(Object aValue, Class<?> aType) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        String theValue = aValue.toString();
        String theResult = null;
        if (aType.equals(String.class)) {
            theResult = theValue;
        } else if (theValue.length() != 0 && !Literal.NULL.getValue().equals(theValue) && (theResult = SimpleType.toSimpleType(theValue, aType)) == null) {
            theResult = TypeUtility.toType(aValue, aType);
        }
        return theResult;
    }

    private static <T> T toValueOfType(Object aValue, Class<T> aType) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Record theToInstance;
        if (aValue instanceof String) {
            String theClassName = (String)aValue;
            try {
                Enum[] theClass = Class.forName(theClassName);
                if (aType.isAssignableFrom((Class<?>)theClass)) {
                    Constructor theCtor = theClass.getConstructor(new Class[0]);
                    return theCtor.newInstance(new Object[0]);
                }
            }
            catch (Exception | NoClassDefFoundError theClass) {
                // empty catch block
            }
        }
        if (aType.isEnum() && aValue instanceof String) {
            Enum[] theEnums;
            for (Enum eEnum : theEnums = (Enum[])aType.getEnumConstants()) {
                if (!eEnum.name().equals(aValue)) continue;
                return (T)eEnum;
            }
        }
        if (aType.isRecord()) {
            return TypeUtility.toRecordFromValue(aValue, aType);
        }
        if (aValue instanceof String) {
            String theValue = (String)aValue;
            if (SimpleType.isSimpleType(aType)) {
                return (T)SimpleType.toSimpleType(theValue, aType);
            }
        }
        if ((theToInstance = TypeUtility.toCollectionOfType(aType)) == null) {
            Constructor<Record> theCtor = aType.getConstructor(new Class[0]);
            try {
                theCtor.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            theToInstance = theCtor.newInstance(new Object[0]);
        }
        TypeUtility.updateInstance(aValue, theToInstance);
        return (T)theToInstance;
    }

    private static <T> void updateInstance(Map<?, ?> aValue, T aInstance) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        block26: {
            Field[] theFields;
            Class<?> aType;
            block25: {
                aType = aInstance.getClass();
                if (!(aInstance instanceof Map)) break block25;
                Map theToMap = (Map)aInstance;
                for (Object eKey : aValue.keySet()) {
                    theToMap.put(eKey, aValue.get(eKey));
                }
                break block26;
            }
            HashSet<String> theInjected = new HashSet<String>();
            Method[] theMethods = aType.getDeclaredMethods();
            if (theMethods != null && theMethods.length > 0) {
                HashSet<String> theFailedProperties = new HashSet<String>();
                Exception theFailedException = null;
                Method[] methodArray = theMethods;
                int n = methodArray.length;
                for (int i = 0; i < n; ++i) {
                    Method eMethod = methodArray[i];
                    if (!TypeUtility.isSetter(eMethod)) continue;
                    try {
                        Object eValue2;
                        String ePropertyName = TypeUtility.toSetterPropertyName(eMethod);
                        if (theInjected.contains(ePropertyName) || (eValue2 = aValue.get(ePropertyName)) == null) continue;
                        try {
                            eMethod.setAccessible(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (eValue2.getClass().isArray() && !eMethod.getParameters()[0].getType().isArray() && !Collection.class.isAssignableFrom(eMethod.getParameters()[0].getType())) {
                            Object[] eArray = (Object[])eValue2;
                            Object eObj = null;
                            for (Object eElement : eArray) {
                                if (eElement == null) continue;
                                if (eObj != null && eElement instanceof Map) {
                                    Map eMap = (Map)eElement;
                                    TypeUtility.updateInstance(eMap, eObj);
                                    continue;
                                }
                                try {
                                    eObj = TypeUtility.writeToMethod(aInstance, eElement, eMethod);
                                    theInjected.add(ePropertyName);
                                }
                                catch (Exception e) {
                                    theFailedProperties.add(ePropertyName);
                                    theFailedException = theFailedException == null ? e : theFailedException;
                                }
                            }
                            continue;
                        }
                        try {
                            TypeUtility.writeToMethod(aInstance, eValue2, eMethod);
                            theInjected.add(ePropertyName);
                        }
                        catch (Exception e) {
                            theFailedProperties.add(ePropertyName);
                            theFailedException = theFailedException == null ? e : theFailedException;
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException eValue2) {
                        // empty catch block
                    }
                }
                if (!theFailedProperties.isEmpty()) {
                    for (String eInjectedName : theInjected) {
                        theFailedProperties.remove(eInjectedName);
                    }
                    if (!theFailedProperties.isEmpty()) {
                        if (theFailedException != null) {
                            throw new NoSuchMethodNotInvokedException("Unable to satisfy the following properties " + Arrays.toString(theFailedProperties.toArray()) + " (without the square braces) as there are no according methods with the required argument types!", theFailedException);
                        }
                        throw new NoSuchMethodException("Unable to satisfy the following properties " + Arrays.toString(theFailedProperties.toArray()) + " (without the square braces) as there are no according methods with the required argument types!");
                    }
                }
            }
            if ((theFields = aType.getDeclaredFields()) == null || theFields.length <= 0) break block26;
            for (Field eField : theFields) {
                try {
                    Object eValue;
                    String ePropertyName = TypeUtility.toPropertyName(eField);
                    if (theInjected.contains(ePropertyName) || (eValue = aValue.get(ePropertyName)) == null) continue;
                    try {
                        eField.setAccessible(true);
                    }
                    catch (Exception eValue2) {
                        // empty catch block
                    }
                    if (eValue.getClass().isArray() && !eField.getType().isArray() && !Collection.class.isAssignableFrom(eField.getType())) {
                        Object[] eArray;
                        for (Object eElement : eArray = (Object[])eValue) {
                            if (eElement == null) continue;
                            TypeUtility.writeToField(aInstance, eElement, eField);
                            theInjected.add(ePropertyName);
                        }
                        continue;
                    }
                    TypeUtility.writeToField(aInstance, eValue, eField);
                    theInjected.add(ePropertyName);
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {
                    // empty catch block
                }
            }
        }
    }

    private static <T> void writeParameterToArgs(List<Object> aArgs, Object aToValue, Parameter aToParam) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        String theToText = aToValue != null ? aToValue.toString() : null;
        Class<?> theToType = aToParam.getType();
        if (theToType.equals(String.class)) {
            aArgs.add(theToText);
        } else if (theToText != null && theToText.length() != 0) {
            Object theValue = SimpleType.toSimpleType(theToText, theToType);
            if (theValue != null) {
                aArgs.add(theValue);
            } else if (List.class.isAssignableFrom(theToType)) {
                List<?> theToList = TypeUtility.toListOfType(aToValue, theToType, aToParam.getParameterizedType());
                aArgs.add(theToList);
            } else if (Map.class.isAssignableFrom(theToType)) {
                Map<?, ?> theToMap = TypeUtility.toMapOfType(aToValue, theToType, aToParam.getParameterizedType());
                aArgs.add(theToMap);
            } else {
                aArgs.add(TypeUtility.toType(aToValue, theToType));
            }
        } else {
            aArgs.add(null);
        }
    }

    private static <T> void writeToField(T aToInstance, Object aToValue, Field aToField) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException, ClassNotFoundException {
        String theToText = aToValue.toString();
        Class<?> theToType = aToField.getType();
        if (theToType.equals(String.class)) {
            aToField.set(aToInstance, theToText);
        } else if (theToText.length() != 0 && !Literal.NULL.getValue().equals(theToText) && !SimpleType.invokeSimpleType(aToInstance, aToField, theToText, theToType)) {
            if (List.class.isAssignableFrom(theToType)) {
                List<?> theToList = TypeUtility.toListOfType(aToValue, theToType, aToField.getGenericType());
                aToField.set(aToInstance, theToList);
            } else if (Map.class.isAssignableFrom(theToType)) {
                Map<?, ?> theToMap = TypeUtility.toMapOfType(aToValue, theToType, aToField.getGenericType());
                aToField.set(aToInstance, theToMap);
            } else {
                aToField.set(aToInstance, TypeUtility.toType(aToValue, theToType));
            }
        }
    }

    private static <T> Object writeToMethod(T aToInstance, Object aToValue, Method aToMethod) throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        String theToText = aToValue.toString();
        Class<?> theToType = aToMethod.getParameters()[0].getType();
        if (theToType.equals(String.class)) {
            aToMethod.invoke(aToInstance, theToText);
        } else if (theToText.length() != 0 && !Literal.NULL.getValue().equals(theToText) && !SimpleType.invokeSimpleType(aToInstance, aToMethod, theToText, theToType)) {
            if (List.class.isAssignableFrom(theToType)) {
                List<?> theToList = TypeUtility.toListOfType(aToValue, theToType, aToMethod.getParameters()[0].getParameterizedType());
                aToMethod.invoke(aToInstance, theToList);
            } else if (Map.class.isAssignableFrom(theToType)) {
                Map<?, ?> theToMap = TypeUtility.toMapOfType(aToValue, theToType, aToMethod.getParameters()[0].getParameterizedType());
                aToMethod.invoke(aToInstance, theToMap);
            } else {
                Object theInstance = TypeUtility.toType(aToValue, theToType);
                aToMethod.invoke(aToInstance, theInstance);
                return theInstance;
            }
        }
        return null;
    }

    public static class NoSuchMethodNotInvokedException
    extends NoSuchMethodException {
        private static final long serialVersionUID = 1L;
        private final Throwable _cause;

        public NoSuchMethodNotInvokedException(String aMessage, Throwable aCause) {
            super(aMessage);
            this._cause = aCause;
        }

        @Override
        public Throwable getCause() {
            return this._cause;
        }
    }
}

