/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.loaders.lw3d;

import java.io.IOException;
import java.io.StreamTokenizer;
import org.scijava.java3d.BoundingSphere;
import org.scijava.java3d.Bounds;
import org.scijava.java3d.Fog;
import org.scijava.java3d.LinearFog;
import org.scijava.java3d.loaders.ParsingErrorException;
import org.scijava.java3d.loaders.lw3d.TextfileParser;
import org.scijava.vecmath.Color3f;
import org.scijava.vecmath.Point3d;

class LwsFog
extends TextfileParser {
    float minDist;
    float maxDist;
    float minAmount;
    float maxAmount;
    int backdropFog;
    Color3f color;
    int type;
    Fog fogObject = null;

    LwsFog(StreamTokenizer st, int debugVals) throws ParsingErrorException {
        this.debugPrinter.setValidOutput(debugVals);
        this.debugOutput(1, "LwsFog()");
        this.color = new Color3f(0.0f, 0.0f, 0.0f);
        while (!this.isCurrentToken(st, "DitherIntensity")) {
            this.debugOutputLn(8, "currentToken = " + st.sval);
            if (this.isCurrentToken(st, "FogMinDist")) {
                this.minDist = (float)this.getNumber(st);
            } else if (this.isCurrentToken(st, "FogMaxDist")) {
                this.maxDist = (float)this.getNumber(st);
            } else if (this.isCurrentToken(st, "FogMinAmount")) {
                this.minAmount = (float)this.getNumber(st);
            } else if (this.isCurrentToken(st, "FogMaxAmount")) {
                this.maxAmount = (float)this.getNumber(st);
            } else if (this.isCurrentToken(st, "BackdropFog")) {
                this.backdropFog = (int)this.getNumber(st);
            } else if (this.isCurrentToken(st, "FogColor")) {
                this.color.x = (float)this.getNumber(st) / 255.0f;
                this.color.y = (float)this.getNumber(st) / 255.0f;
                this.color.z = (float)this.getNumber(st) / 255.0f;
            }
            try {
                st.nextToken();
            }
            catch (IOException e) {
                throw new ParsingErrorException(e.getMessage());
            }
        }
        st.pushBack();
    }

    void createJava3dObject() {
        this.fogObject = new LinearFog(this.color, (double)this.minDist, (double)this.maxDist);
        this.debugOutputLn(2, "just set linearFog with color, minDist, maxDist = " + this.color + ", " + this.minDist + ", " + this.maxDist);
        BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100000.0);
        this.fogObject.setInfluencingBounds((Bounds)bounds);
    }

    Fog getObjectNode() {
        return this.fogObject;
    }

    void printVals() {
        this.debugOutputLn(2, "  FOG vals: ");
    }
}

