/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.loaders.lw3d;

import java.io.StreamTokenizer;
import org.scijava.java3d.loaders.lw3d.TextfileParser;
import org.scijava.vecmath.Matrix4d;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.Vector3d;

class LwsFrame
extends TextfileParser {
    double x;
    double y;
    double z;
    double heading;
    double pitch;
    double bank;
    double xScale;
    double yScale;
    double zScale;
    double frameNumber;
    int linearValue;
    double tension;
    double continuity;
    double bias;

    LwsFrame(StreamTokenizer st) {
        this.x = this.getNumber(st);
        this.y = this.getNumber(st);
        this.z = -this.getNumber(st);
        this.debugOutputLn(2, "x, y, z " + this.x + ", " + this.y + ", " + this.z);
        this.heading = this.getNumber(st);
        this.pitch = this.getNumber(st);
        this.bank = this.getNumber(st);
        this.debugOutputLn(2, "(degrees) h, p, b = " + this.heading + ", " + this.pitch + ", " + this.bank);
        this.heading *= Math.PI / 180;
        this.pitch *= Math.PI / 180;
        this.bank *= Math.PI / 180;
        this.debugOutputLn(2, "(radians) h, p, b = " + this.heading + ", " + this.pitch + ", " + this.bank);
        this.debugOutputLn(8, "got pos and ori");
        this.xScale = this.getNumber(st);
        this.yScale = this.getNumber(st);
        this.zScale = this.getNumber(st);
        this.debugOutputLn(2, "xs, ys, zs " + this.xScale + ", " + this.yScale + ", " + this.zScale);
        this.frameNumber = (int)this.getNumber(st);
        this.linearValue = (int)this.getNumber(st);
        this.debugOutputLn(2, "framenum, linear " + this.frameNumber + " , " + this.linearValue);
        this.tension = this.getNumber(st);
        this.continuity = this.getNumber(st);
        this.bias = this.getNumber(st);
        this.debugOutputLn(2, "tension, cont, bias = " + this.tension + ", " + this.continuity + ", " + this.bias);
    }

    LwsFrame(LwsFrame prevFrame, LwsFrame nextFrame, double ratio) {
        this.x = prevFrame.x + (nextFrame.x - prevFrame.x) * ratio;
        this.y = prevFrame.y + (nextFrame.y - prevFrame.y) * ratio;
        this.z = prevFrame.z + (nextFrame.z - prevFrame.z) * ratio;
        this.heading = prevFrame.heading + (nextFrame.heading - prevFrame.heading) * ratio;
        this.pitch = prevFrame.pitch + (nextFrame.pitch - prevFrame.pitch) * ratio;
        this.bank = prevFrame.bank + (nextFrame.bank - prevFrame.bank) * ratio;
        this.xScale = prevFrame.xScale + (nextFrame.xScale - prevFrame.xScale) * ratio;
        this.yScale = prevFrame.yScale + (nextFrame.yScale - prevFrame.yScale) * ratio;
        this.zScale = prevFrame.zScale + (nextFrame.zScale - prevFrame.zScale) * ratio;
        this.frameNumber = prevFrame.frameNumber + (nextFrame.frameNumber - prevFrame.frameNumber) * ratio;
        this.linearValue = prevFrame.linearValue;
        this.tension = prevFrame.tension;
        this.continuity = prevFrame.continuity;
        this.bias = prevFrame.bias;
    }

    LwsFrame(LwsFrame prevFrame, LwsFrame frame1, LwsFrame frame2, LwsFrame nextFrame, double u, double adj0, double adj1) {
        double u2 = u * u;
        double u3 = u2 * u;
        double z1 = 3.0 * u2 - u3 - u3;
        double h1 = 1.0 - z1;
        double h2 = z1;
        double h3 = u3 - u2 - u2 + u;
        double h4 = u3 - u2;
        double dd0a = (1.0 - frame1.tension) * (1.0 + frame1.continuity) * (1.0 + frame1.bias);
        double dd0b = (1.0 - frame1.tension) * (1.0 - frame1.continuity) * (1.0 - frame1.bias);
        double ds1a = (1.0 - frame2.tension) * (1.0 - frame2.continuity) * (1.0 + frame2.bias);
        double ds1b = (1.0 - frame2.tension) * (1.0 + frame2.continuity) * (1.0 - frame2.bias);
        double[] v = new double[]{prevFrame.x, frame1.x, frame2.x, nextFrame.x};
        this.x = this.computeInterpolation(v, dd0a, dd0b, ds1a, ds1b, adj0, adj1, h1, h2, h3, h4);
        v[0] = prevFrame.y;
        v[1] = frame1.y;
        v[2] = frame2.y;
        v[3] = nextFrame.y;
        this.y = this.computeInterpolation(v, dd0a, dd0b, ds1a, ds1b, adj0, adj1, h1, h2, h3, h4);
        v[0] = prevFrame.z;
        v[1] = frame1.z;
        v[2] = frame2.z;
        v[3] = nextFrame.z;
        this.z = this.computeInterpolation(v, dd0a, dd0b, ds1a, ds1b, adj0, adj1, h1, h2, h3, h4);
        v[0] = prevFrame.heading;
        v[1] = frame1.heading;
        v[2] = frame2.heading;
        v[3] = nextFrame.heading;
        this.heading = this.computeInterpolation(v, dd0a, dd0b, ds1a, ds1b, adj0, adj1, h1, h2, h3, h4);
        v[0] = prevFrame.pitch;
        v[1] = frame1.pitch;
        v[2] = frame2.pitch;
        v[3] = nextFrame.pitch;
        this.pitch = this.computeInterpolation(v, dd0a, dd0b, ds1a, ds1b, adj0, adj1, h1, h2, h3, h4);
        v[0] = prevFrame.bank;
        v[1] = frame1.bank;
        v[2] = frame2.bank;
        v[3] = nextFrame.bank;
        this.bank = this.computeInterpolation(v, dd0a, dd0b, ds1a, ds1b, adj0, adj1, h1, h2, h3, h4);
        this.xScale = frame1.xScale + (frame2.xScale - frame1.xScale) * u;
        this.yScale = frame1.yScale + (frame2.yScale - frame1.yScale) * u;
        this.zScale = frame1.zScale + (frame2.zScale - frame1.zScale) * u;
        this.frameNumber = frame1.frameNumber + (frame2.frameNumber - frame1.frameNumber) * u;
        this.linearValue = frame2.linearValue;
        this.tension = 0.0;
        this.continuity = 0.0;
        this.bias = 0.0;
    }

    double computeInterpolation(double[] value, double dd0a, double dd0b, double ds1a, double ds1b, double adj0, double adj1, double h1, double h2, double h3, double h4) {
        double delta = value[2] - value[1];
        double dd0 = adj0 < -1.0E-4 || adj0 > 1.0E-4 ? adj0 * (dd0a * (value[1] - value[0]) + dd0b * delta) : 0.5 * (dd0a + dd0b) * delta;
        double ds1 = adj1 < -1.0E-4 || adj1 > 1.0E-4 ? adj1 * (ds1a * delta + ds1b * (value[3] - value[2])) : 0.5 * (ds1a + ds1b) * delta;
        double result = value[1] * h1 + value[2] * h2 + dd0 * h3 + ds1 * h4;
        return result;
    }

    double getHeading() {
        return this.heading;
    }

    double getPitch() {
        return this.pitch;
    }

    double getBank() {
        return this.bank;
    }

    void setMatrix(Matrix4d mat) {
        this.setRotationMatrix(mat);
        mat.setTranslation(new Vector3d(this.x, this.y, this.z));
        Matrix4d m = new Matrix4d();
        m.setColumn(0, this.xScale, 0.0, 0.0, 0.0);
        m.setColumn(1, 0.0, this.yScale, 0.0, 0.0);
        m.setColumn(2, 0.0, 0.0, this.zScale, 0.0);
        m.setColumn(3, 0.0, 0.0, 0.0, 1.0);
        mat.mul(m);
    }

    void setRotationMatrix(Matrix4d mat) {
        this.debugOutputLn(1, "setRotMat()");
        this.debugOutputLn(2, " p, h, b = " + this.pitch + ", " + this.heading + ", " + this.bank);
        Matrix4d pitchMat = new Matrix4d();
        pitchMat.rotX(-this.pitch);
        Matrix4d bankMat = new Matrix4d();
        bankMat.rotZ(this.bank);
        mat.rotY(-this.heading);
        mat.mul(pitchMat);
        mat.mul(bankMat);
        this.debugOutputLn(2, "setRotMat(), mat = " + mat);
    }

    Point3f getPosition() {
        return new Point3f((float)this.x, (float)this.y, (float)this.z);
    }

    Point3f getScale() {
        if ((this.xScale < -1.0E-4 || this.xScale > 1.0E-4) && (this.yScale < -1.0E-4 || this.yScale > 1.0E-4) && (this.zScale < -1.0E-4 || this.zScale > 1.0E-4)) {
            return new Point3f((float)this.xScale, (float)this.yScale, (float)this.zScale);
        }
        return new Point3f(1.0f, 1.0f, 1.0f);
    }

    double getFrameNum() {
        return this.frameNumber;
    }

    void printVals() {
        this.debugOutputLn(2, "         x = " + this.x);
        this.debugOutputLn(2, "         y = " + this.y);
        this.debugOutputLn(2, "         z = " + this.z);
        this.debugOutputLn(2, "         xScale = " + this.xScale);
        this.debugOutputLn(2, "         yScale = " + this.yScale);
        this.debugOutputLn(2, "         zScale = " + this.zScale);
        this.debugOutputLn(2, "         heading = " + this.heading);
        this.debugOutputLn(2, "         pitch = " + this.pitch);
        this.debugOutputLn(2, "         bank = " + this.bank);
        this.debugOutputLn(2, "         frameNum = " + this.frameNumber);
        this.debugOutputLn(2, "         lin = " + this.linearValue);
        this.debugOutputLn(2, "         tension = " + this.tension);
        this.debugOutputLn(2, "         continuity = " + this.continuity);
        this.debugOutputLn(2, "         bias = " + this.bias);
    }
}

