/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.loaders.lw3d;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.scijava.java3d.loaders.IncorrectFormatException;
import org.scijava.java3d.loaders.ParsingErrorException;
import org.scijava.java3d.loaders.lw3d.ParserObject;

class TargaReader
extends ParserObject {
    BufferedInputStream bufferedReader;
    Image theImage = null;

    TargaReader(String fileName, int debugVals) throws FileNotFoundException {
        super(debugVals);
        this.debugOutputLn(1, "constructor");
        this.bufferedReader = new BufferedInputStream(new DataInputStream(new FileInputStream(fileName)));
        if (this.bufferedReader != null) {
            this.parseFile();
        }
    }

    Image getImage() {
        return this.theImage;
    }

    void parseFile() throws IncorrectFormatException, ParsingErrorException {
        try {
            int idLength = this.bufferedReader.read();
            int colormapPresent = this.bufferedReader.read();
            int imageType = this.bufferedReader.read();
            this.bufferedReader.skip(9L);
            int width = this.bufferedReader.read() | this.bufferedReader.read() << 8;
            int height = this.bufferedReader.read() | this.bufferedReader.read() << 8;
            int depth = this.bufferedReader.read();
            int flags = this.bufferedReader.read();
            boolean bottomToTop = (flags & 0x20) == 0;
            boolean leftToRight = (flags & 0x10) == 0;
            this.bufferedReader.skip(idLength);
            if (colormapPresent == 1 || imageType != 2 || depth != 24 && depth != 32) {
                throw new IncorrectFormatException("This format is not readable by the Lightwave loader.  Only 24- or 32-bit true-color uncompressed Targa images will work");
            }
            BufferedImage bImage = new BufferedImage(width, height, 2);
            int[] imageBits = ((DataBufferInt)bImage.getRaster().getDataBuffer()).getData();
            for (int i = 0; i < height; ++i) {
                int row = bottomToTop ? height - i - 1 : i;
                for (int j = 0; j < width; ++j) {
                    int column = leftToRight ? j : width - j - 1;
                    int blue = this.bufferedReader.read();
                    int green = this.bufferedReader.read();
                    int red = this.bufferedReader.read();
                    int alpha = 255;
                    if (depth == 32) {
                        alpha = this.bufferedReader.read();
                    }
                    imageBits[row * width + column] = alpha << 24 | red << 16 | green << 8 | blue;
                }
            }
            this.theImage = bImage;
        }
        catch (IOException e) {
            throw new ParsingErrorException(e.getMessage());
        }
    }
}

