/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.scijava.java3d.Group;
import org.scijava.java3d.Node;
import org.scijava.java3d.SceneGraphObject;
import org.scijava.java3d.utils.scenegraph.io.SceneGraphIO;
import org.scijava.java3d.utils.scenegraph.io.retained.Controller;
import org.scijava.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.NodeState;
import org.scijava.java3d.utils.scenegraph.io.state.org.scijava.java3d.SceneGraphObjectState;

public class GroupState
extends NodeState {
    protected SceneGraphObjectState[] groupChildren;

    public GroupState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        this.control.writeBounds(out, ((Group)this.node).getCollisionBounds());
        int numChildren = this.checkProcessChildren() ? ((Group)this.node).numChildren() : 0;
        out.writeInt(numChildren);
        for (int i = 0; i < numChildren; ++i) {
            this.control.writeObject(out, this.control.createState((SceneGraphObject)((Group)this.node).getChild(i)));
        }
        out.writeBoolean(((Group)this.node).getAlternateCollisionTarget());
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        ((Group)this.node).setCollisionBounds(this.control.readBounds(in));
        int numChildren = in.readInt();
        this.groupChildren = new SceneGraphObjectState[numChildren];
        for (int i = 0; i < numChildren; ++i) {
            this.groupChildren[i] = this.control.readObject(in);
            ((Group)this.node).addChild((Node)this.groupChildren[i].getNode());
        }
        ((Group)this.node).setAlternateCollisionTarget(in.readBoolean());
    }

    private boolean checkProcessChildren() {
        if (this.node instanceof SceneGraphIO) {
            return ((SceneGraphIO)this.node).saveChildren();
        }
        return this.processChildren();
    }

    protected boolean processChildren() {
        return true;
    }

    @Override
    public void buildGraph() {
        for (int i = 0; i < this.groupChildren.length; ++i) {
            if (this.groupChildren[i].getSymbol().graphBuilt) continue;
            this.groupChildren[i].getSymbol().graphBuilt = true;
            this.groupChildren[i].buildGraph();
        }
        super.buildGraph();
    }

    @Override
    public void cleanup() {
        for (int i = 0; i < this.groupChildren.length; ++i) {
            this.groupChildren[i].cleanup();
            this.groupChildren[i] = null;
        }
        this.groupChildren = null;
        super.cleanup();
    }

    @Override
    protected SceneGraphObject createNode() {
        return new Group();
    }
}

