/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d.utils.universe;

import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.scijava.java3d.BranchGroup;
import org.scijava.java3d.Canvas3D;
import org.scijava.java3d.HiResCoord;
import org.scijava.java3d.utils.universe.ConfigContainer;
import org.scijava.java3d.utils.universe.ConfigViewPlatform;
import org.scijava.java3d.utils.universe.LocaleFactory;
import org.scijava.java3d.utils.universe.SimpleUniverse;
import org.scijava.java3d.utils.universe.Viewer;
import org.scijava.java3d.utils.universe.ViewingPlatform;

public class ConfiguredUniverse
extends SimpleUniverse {
    private ConfigContainer configContainer = null;

    public ConfiguredUniverse() {
    }

    public ConfiguredUniverse(int transformCount) {
        super(transformCount);
    }

    public ConfiguredUniverse(Canvas3D canvas) {
        super(canvas);
    }

    public ConfiguredUniverse(Canvas3D canvas, int transformCount) {
        super(canvas, transformCount);
    }

    public ConfiguredUniverse(ViewingPlatform viewingPlatform, Viewer viewer) {
        super(viewingPlatform, viewer, null);
    }

    public ConfiguredUniverse(ViewingPlatform viewingPlatform, Viewer viewer, LocaleFactory localeFactory) {
        super(viewingPlatform, viewer, localeFactory);
    }

    public ConfiguredUniverse(Canvas3D[] canvases) {
        this(1, canvases, null, null, null, true);
    }

    public ConfiguredUniverse(Canvas3D[] canvases, int transformCount) {
        this(transformCount, canvases, null, null, null, true);
    }

    public ConfiguredUniverse(Canvas3D[] canvases, int transformCount, LocaleFactory localeFactory) {
        this(transformCount, canvases, null, localeFactory, null, true);
    }

    public ConfiguredUniverse(URL userConfig) {
        this(1, null, userConfig, null, null, true);
    }

    public ConfiguredUniverse(URL userConfig, int transformCount) {
        this(transformCount, null, userConfig, null, null, true);
    }

    public ConfiguredUniverse(URL userConfig, int transformCount, boolean setVisible) {
        this(transformCount, null, userConfig, null, null, setVisible);
    }

    public ConfiguredUniverse(URL userConfig, LocaleFactory localeFactory) {
        this(1, null, userConfig, localeFactory, null, true);
    }

    public ConfiguredUniverse(URL userConfig, LocaleFactory localeFactory, boolean setVisible) {
        this(1, null, userConfig, localeFactory, null, setVisible);
    }

    public ConfiguredUniverse(URL userConfig, LocaleFactory localeFactory, HiResCoord origin, int transformCount, boolean setVisible) {
        this(transformCount, null, userConfig, localeFactory, origin, setVisible);
    }

    public ConfiguredUniverse(ConfigContainer userConfig) {
        this(userConfig, null, null);
    }

    public ConfiguredUniverse(ConfigContainer userConfig, LocaleFactory localeFactory, HiResCoord origin) {
        super(origin, localeFactory);
        this.configContainer = userConfig;
        Set c = this.configContainer.getViewers();
        if (c == null || c.size() == 0) {
            throw new IllegalArgumentException("no views defined in configuration file");
        }
        this.viewer = c.toArray(new Viewer[1]);
        c = this.configContainer.getViewingPlatforms();
        if (c == null || c.size() == 0) {
            this.createDefaultViewingPlatform(this.configContainer.getViewPlatformTransformCount());
        } else {
            for (ViewingPlatform vp : c) {
                vp.setUniverse(this);
                this.locale.addBranchGraph((BranchGroup)vp);
            }
        }
    }

    ConfiguredUniverse(int transformCount, Canvas3D[] canvases, URL userConfig, LocaleFactory localeFactory, HiResCoord origin, boolean setVisible) {
        super(origin, localeFactory);
        if (userConfig == null) {
            this.viewer = new Viewer[1];
            this.viewer[0] = new Viewer(canvases, null, null, setVisible);
            this.createDefaultViewingPlatform(transformCount);
        } else {
            this.configContainer = new ConfigContainer(userConfig, setVisible, transformCount, false);
            Collection c = this.configContainer.getViewers();
            if (c == null || c.size() == 0) {
                throw new IllegalArgumentException("no views defined in configuration file");
            }
            this.viewer = c.toArray(new Viewer[1]);
            c = this.configContainer.findConfigObjects("ViewPlatform");
            if (c == null || c.size() == 0) {
                this.createDefaultViewingPlatform(transformCount);
            } else {
                for (ConfigViewPlatform cvp : c) {
                    ViewingPlatform vp = cvp.viewingPlatform;
                    if (vp.getViewers() == null && this.viewer.length == 1 && c.size() == 1) {
                        if (cvp.viewAttachPolicy == -1) {
                            this.setDerivedAttachPolicy(this.viewer[0], vp);
                        }
                        this.viewer[0].setViewingPlatform(vp);
                    }
                    vp.setUniverse(this);
                    this.locale.addBranchGraph((BranchGroup)vp);
                    cvp.processBehavior();
                }
            }
        }
    }

    private void createDefaultViewingPlatform(int transformCount) {
        ViewingPlatform vp = new ViewingPlatform(transformCount);
        this.setDerivedAttachPolicy(this.viewer[0], vp);
        this.viewer[0].setViewingPlatform(vp);
        vp.setUniverse(this);
        this.locale.addBranchGraph((BranchGroup)vp);
    }

    private void setDerivedAttachPolicy(Viewer v, ViewingPlatform vp) {
        if (v.getView().getWindowEyepointPolicy() != 2) {
            vp.getViewPlatform().setViewAttachPolicy(2);
        }
    }

    public Viewer getViewer(int index) {
        return this.viewer[index];
    }

    public Viewer[] getViewers() {
        Viewer[] ret = new Viewer[this.viewer.length];
        for (int i = 0; i < this.viewer.length; ++i) {
            ret[i] = this.viewer[i];
        }
        return ret;
    }

    public void setVisible(boolean visible) {
        for (int i = 0; i < this.viewer.length; ++i) {
            if (this.viewer[i] == null) continue;
            this.viewer[i].setVisible(visible);
        }
    }

    public static URL getConfigURL() {
        return ConfigContainer.getConfigURL(null);
    }

    public static URL getConfigURL(String defaultURLString) {
        return ConfigContainer.getConfigURL(defaultURLString);
    }

    public Map getNamedSensors() {
        if (this.configContainer == null) {
            return null;
        }
        return this.configContainer.getNamedSensors();
    }

    public Map getNamedBehaviors() {
        if (this.configContainer == null) {
            return null;
        }
        return this.configContainer.getNamedViewPlatformBehaviors();
    }

    public ConfigContainer getConfigContainer() {
        return this.configContainer;
    }

    @Override
    public void cleanup() {
        if (this.viewer != null) {
            for (int i = 0; i < this.viewer.length; ++i) {
                this.viewer[i].getView().removeAllCanvas3Ds();
                this.viewer[i].setViewingPlatform(null);
                this.viewer[i] = null;
            }
        }
        this.locale = null;
        this.removeAllLocales();
        this.configContainer.clear();
        this.configContainer = null;
    }
}

