/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.annotations;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.scijava.annotations.AnnotatedA;
import org.scijava.annotations.AnnotatedC;
import org.scijava.annotations.AnnotatedInnerClass;
import org.scijava.annotations.Complex;
import org.scijava.annotations.DirectoryIndexer;
import org.scijava.annotations.Fruit;
import org.scijava.annotations.Index;
import org.scijava.annotations.IndexItem;
import org.scijava.annotations.Simple;

public class DirectoryIndexerTest {
    @Test
    public void testIndexer() throws Exception {
        String suffix = DirectoryIndexerTest.getResourcePath(AnnotatedA.class);
        URL url = this.getClass().getResource("/" + suffix);
        Assume.assumeTrue((url != null ? 1 : 0) != 0);
        String path = url.getFile();
        Assume.assumeTrue((path.indexOf(58) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)path.endsWith("/" + suffix));
        File directory = new File(path.substring(0, path.length() - suffix.length()));
        File jsonDirectory = new File(directory, "META-INF/json/");
        File[] list = jsonDirectory.listFiles();
        if (list != null) {
            for (File file : list) {
                Assert.assertTrue((boolean)file.delete());
            }
            Assert.assertTrue((boolean)jsonDirectory.delete());
        }
        new DirectoryIndexer().index(directory);
        Assert.assertTrue((boolean)directory.exists());
        Map<String, IndexItem<Complex>> map = DirectoryIndexerTest.readIndex(Complex.class, DirectoryIndexerTest.class.getClassLoader());
        DirectoryIndexerTest.testDefaultAnnotations(map);
    }

    @Test
    public void testRepeatedClassPathElements() throws Exception {
        String suffix = DirectoryIndexerTest.getResourcePath(AnnotatedA.class);
        String classURL = this.getClass().getResource("/" + suffix).toString();
        URL classPathURL = new URL(classURL.substring(0, classURL.length() - suffix.length()));
        URLClassLoader loader = new URLClassLoader(new URL[]{classPathURL, classPathURL});
        HashSet<String> seen = new HashSet<String>();
        for (IndexItem item : Index.load(Simple.class, (ClassLoader)loader)) {
            String name = item.className();
            Assert.assertFalse((boolean)seen.contains(name));
            seen.add(name);
        }
        Assert.assertEquals((long)2L, (long)seen.size());
    }

    public static void testDefaultAnnotations(Map<String, IndexItem<Complex>> map) {
        Assert.assertEquals((long)4L, (long)map.size());
        Complex a = (Complex)map.get(AnnotatedA.class.getName()).annotation();
        Assert.assertEquals((Object)"Hello, World!", (Object)a.simple().string1());
        Complex c = (Complex)map.get(AnnotatedC.class.getName()).annotation();
        Assert.assertEquals((Object)true, (Object)c.bool0());
        Assert.assertEquals((long)-17L, (long)c.byte0());
        Assert.assertEquals((long)-19L, (long)c.short0());
        Assert.assertEquals((long)-23L, (long)c.int0());
        Assert.assertEquals((long)-29L, (long)c.long0());
        Assert.assertTrue((-31.0f == c.float0() ? 1 : 0) != 0);
        Assert.assertTrue((-37.0 == c.double0() ? 1 : 0) != 0);
        Assert.assertEquals((long)65495L, (long)c.char0());
        Assert.assertEquals((Object)"Narf!", (Object)c.string());
        Assert.assertEquals(Exception.class, c.clazz());
        Assert.assertEquals((Object)((Object)Fruit.Banana), (Object)((Object)c.fruit()));
        Assert.assertEquals((Object)"Hello", (Object)c.simple().string1());
        Assert.assertEquals((long)3L, (long)c.array().length);
        Assert.assertEquals((Object)"one", (Object)c.array()[0].string1());
        Assert.assertEquals((Object)"two", (Object)c.array()[1].string1());
        Assert.assertEquals((Object)"three", (Object)c.array()[2].string1());
        Assert.assertEquals((long)4L, (long)c.array1().length);
        Assert.assertEquals((long)-43L, (long)c.array1()[0]);
        Assert.assertEquals((long)-47L, (long)c.array1()[1]);
        Assert.assertEquals((long)-53L, (long)c.array1()[2]);
        Assert.assertEquals((long)-59L, (long)c.array1()[3]);
        c = (Complex)map.get(AnnotatedInnerClass.InnerClass.class.getName()).annotation();
        Assert.assertNotNull((Object)c);
    }

    public static String getResourcePath(Class<?> clazz) {
        return clazz.getName().replace('.', '/') + ".class";
    }

    public static <A extends Annotation> Map<String, IndexItem<A>> readIndex(Class<A> annotationClass, final URL ... directories) {
        ClassLoader loader = new ClassLoader(){

            @Override
            public final Enumeration<URL> getResources(String path) throws IOException {
                ArrayList<URL> urls = new ArrayList<URL>();
                for (URL directory : directories) {
                    URL url = new URL(directory, path);
                    URLConnection connection = url.openConnection();
                    if (connection.getLastModified() <= 0L) continue;
                    urls.add(url);
                }
                return Collections.enumeration(urls);
            }
        };
        return DirectoryIndexerTest.readIndex(annotationClass, loader);
    }

    public static <A extends Annotation> Map<String, IndexItem<A>> readIndex(Class<A> annotationClass, ClassLoader loader) {
        TreeMap<String, IndexItem<A>> map = new TreeMap<String, IndexItem<A>>();
        for (IndexItem item : Index.load(annotationClass, (ClassLoader)loader)) {
            map.put(item.className(), item);
        }
        return map;
    }
}

