/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.annotations;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.scijava.annotations.DirectoryIndexer;

public class EclipseHelper
extends DirectoryIndexer {
    static Set<URL> indexed = new HashSet<URL>();

    public static void updateAnnotationIndex(ClassLoader loader) {
        if (!(loader instanceof URLClassLoader)) {
            return;
        }
        EclipseHelper helper = new EclipseHelper();
        for (URL url : ((URLClassLoader)loader).getURLs()) {
            if (url.toString().endsWith("/./")) break;
            helper.maybeIndex(url, loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeIndex(URL url, ClassLoader loader) {
        Set<URL> set = indexed;
        synchronized (set) {
            if (indexed.contains(url)) {
                return;
            }
            indexed.add(url);
        }
        if (!"file".equals(url.getProtocol())) {
            return;
        }
        String path = url.getFile();
        if (!path.startsWith("/")) {
            return;
        }
        if (path.endsWith(".jar")) {
            if (path.matches(".*/target/surefire/surefirebooter[0-9]*\\.jar")) {
                try {
                    String classPath;
                    JarFile jar = new JarFile(path);
                    Manifest manifest = jar.getManifest();
                    if (manifest != null && (classPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH)) != null) {
                        for (String element : classPath.split(" +")) {
                            try {
                                this.maybeIndex(new URL(element), loader);
                            }
                            catch (MalformedURLException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    System.err.println("Warning: could not index annotations due to ");
                    e.printStackTrace();
                }
            }
            return;
        }
        File directory = new File(path);
        if (!directory.isDirectory()) {
            return;
        }
        this.index(directory, loader);
    }

    private void index(File directory, ClassLoader loader) {
        if (!directory.canWrite() || this.upToDate(directory)) {
            return;
        }
        System.err.println("[ECLIPSE HELPER] Indexing annotations...");
        try {
            this.discoverAnnotations(directory, "", loader);
            this.write(directory);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File jsonDirectory = new File(directory, "META-INF/json/");
        if (jsonDirectory.isDirectory()) {
            jsonDirectory.setLastModified(System.currentTimeMillis());
        } else {
            jsonDirectory.mkdirs();
        }
    }

    private boolean upToDate(File directory) {
        File jsonDirectory = new File(directory, "META-INF/json/");
        if (!jsonDirectory.isDirectory()) {
            return false;
        }
        return this.upToDate(directory, jsonDirectory.lastModified());
    }

    private boolean upToDate(File directory, long lastModified) {
        if (directory.lastModified() > lastModified) {
            return false;
        }
        File[] list = directory.listFiles();
        if (list != null) {
            for (File file : list) {
                if (!(file.isFile() ? file.lastModified() > lastModified : file.isDirectory() && !this.upToDate(file, lastModified))) continue;
                return false;
            }
        }
        return true;
    }

    public static void main(String ... args) {
        EclipseHelper.updateAnnotationIndex(Thread.currentThread().getContextClassLoader());
    }
}

