/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.app;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.scijava.app.App;
import org.scijava.app.AppService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.PluginService;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultAppService
extends AbstractService
implements AppService {
    @Parameter
    private LogService log;
    @Parameter
    private PluginService pluginService;
    private Map<String, App> apps;

    @Override
    public App getApp(String name) {
        return this.apps.get(name);
    }

    @Override
    public Map<String, App> getApps() {
        return this.apps;
    }

    @Override
    public void initialize() {
        this.apps = Collections.unmodifiableMap(this.discoverApps());
        this.log.info("Found " + this.apps.size() + " applications.");
        super.initialize();
    }

    private HashMap<String, App> discoverApps() {
        HashMap<String, App> map = new HashMap<String, App>();
        List<PluginInfo<App>> infos = this.pluginService.getPluginsOfType(App.class);
        for (PluginInfo<App> info : infos) {
            String name;
            App app = this.pluginService.createInstance(info);
            if (app == null || map.containsKey(name = info.getName())) continue;
            map.put(name, app);
        }
        return map;
    }
}

