/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.util.CharArray;
import org.scijava.util.PrimitiveArray;
import org.scijava.util.PrimitiveArrayTest;

public class CharArrayTest
extends PrimitiveArrayTest {
    @Test
    public void testConstructorNoArgs() {
        CharArray array = new CharArray();
        Assert.assertEquals((long)0L, (long)array.size());
        Assert.assertEquals((long)0L, (long)((char[])array.copyArray()).length);
    }

    @Test
    public void testConstructorSize() {
        int size = 24;
        CharArray array = new CharArray(24);
        Assert.assertEquals((long)24L, (long)array.size());
        Assert.assertEquals((long)24L, (long)((char[])array.copyArray()).length);
    }

    @Test
    public void testConstructorArray() {
        char[] raw = new char[]{'\u0003', '\u0005', '\b', '\r', '\u0015'};
        CharArray array = new CharArray(raw);
        Assert.assertSame((Object)raw, (Object)array.getArray());
        Assert.assertEquals((long)raw.length, (long)array.size());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)raw[i], (long)array.getValue(i));
        }
        Assert.assertArrayEquals((char[])raw, (char[])((char[])array.copyArray()));
    }

    @Test
    public void testAddValue() {
        char[] raw = new char[]{'\u0003', '\u0005', '\b', '\r', '\u0015'};
        CharArray array = new CharArray((char[])raw.clone());
        boolean e6 = true;
        int e7 = 2;
        array.addValue('\u0001');
        array.addValue('\u0002');
        Assert.assertEquals((long)(raw.length + 2), (long)array.size());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)raw[i], (long)array.getValue(i));
        }
        Assert.assertEquals((long)1L, (long)array.getValue(5));
        Assert.assertEquals((long)2L, (long)array.getValue(6));
    }

    public void testRemoveValue() {
        char[] raw = new char[]{'\u0003', '\u0005', '\b', '\r', '\u0015'};
        CharArray array = new CharArray((char[])raw.clone());
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.removeValue(raw[0]);
        Assert.assertEquals((long)(raw.length - 1), (long)array.size());
        array.removeValue(raw[2]);
        Assert.assertEquals((long)(raw.length - 2), (long)array.size());
        array.removeValue(raw[4]);
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((long)raw[1], (long)array.getValue(0));
        Assert.assertEquals((long)raw[3], (long)array.getValue(1));
    }

    public void testGetValue() {
        char[] raw = new char[]{'\u0003', '\u0005', '\b', '\r', '\u0015'};
        CharArray array = new CharArray((char[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)raw[i], (long)array.getValue(i));
        }
    }

    @Test
    public void testSetValue() {
        char[] raw = new char[]{'\u0003', '\u0005', '\b', '\r', '\u0015'};
        CharArray array = new CharArray((char[])raw.clone());
        int e0 = 7;
        boolean e2 = true;
        int e4 = 2;
        array.setValue(0, '\u0007');
        array.setValue(2, '\u0001');
        array.setValue(4, '\u0002');
        Assert.assertEquals((long)raw.length, (long)array.size());
        Assert.assertEquals((long)7L, (long)array.getValue(0));
        Assert.assertEquals((long)raw[1], (long)array.getValue(1));
        Assert.assertEquals((long)1L, (long)array.getValue(2));
        Assert.assertEquals((long)raw[3], (long)array.getValue(3));
        Assert.assertEquals((long)2L, (long)array.getValue(4));
    }

    @Test
    public void testAddValueIndex() {
        char[] raw = new char[]{'\u0003', '\u0005', '\b', '\r', '\u0015'};
        CharArray array = new CharArray((char[])raw.clone());
        int e0 = 7;
        boolean e4 = true;
        int e7 = 2;
        array.addValue(0, '\u0007');
        array.addValue(4, '\u0001');
        array.addValue(7, '\u0002');
        Assert.assertEquals((long)(raw.length + 3), (long)array.size());
        Assert.assertEquals((long)7L, (long)array.getValue(0));
        Assert.assertEquals((long)raw[0], (long)array.getValue(1));
        Assert.assertEquals((long)raw[1], (long)array.getValue(2));
        Assert.assertEquals((long)raw[2], (long)array.getValue(3));
        Assert.assertEquals((long)1L, (long)array.getValue(4));
        Assert.assertEquals((long)raw[3], (long)array.getValue(5));
        Assert.assertEquals((long)raw[4], (long)array.getValue(6));
        Assert.assertEquals((long)2L, (long)array.getValue(7));
    }

    public void testRemoveIndex() {
        char[] raw = new char[]{'\u0003', '\u0005', '\b', '\r', '\u0015'};
        CharArray array = new CharArray((char[])raw.clone());
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.remove(0);
        Assert.assertEquals((long)(raw.length - 1), (long)array.size());
        array.remove(2);
        Assert.assertEquals((long)(raw.length - 2), (long)array.size());
        array.remove(4);
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((long)raw[1], (long)array.getValue(0));
        Assert.assertEquals((long)raw[3], (long)array.getValue(1));
    }

    @Test
    public void testIndexOf() {
        char[] raw = new char[]{'\u0003', '\u0005', '\b', '\r', '\u0015'};
        CharArray array = new CharArray((char[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.indexOf(raw[i]));
        }
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)-1));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)0));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)1));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)Integer.MAX_VALUE));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)Integer.MIN_VALUE));
    }

    @Test
    public void testLastIndexOf() {
        char[] raw = new char[]{'\u0003', '\u0005', '\b', '\r', '\u0015'};
        CharArray array = new CharArray((char[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.lastIndexOf(raw[i]));
        }
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)-1));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)0));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)1));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)Integer.MAX_VALUE));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)Integer.MIN_VALUE));
    }

    @Test
    public void testContains() {
        char[] raw = new char[]{'\u0003', '\u0005', '\b', '\r', '\u0015'};
        CharArray array = new CharArray((char[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertTrue((String)("@" + i), (boolean)array.contains(raw[i]));
        }
        Assert.assertFalse((boolean)array.contains((Object)-1));
        Assert.assertFalse((boolean)array.contains((Object)0));
        Assert.assertFalse((boolean)array.contains((Object)1));
        Assert.assertFalse((boolean)array.contains((Object)Integer.MAX_VALUE));
        Assert.assertFalse((boolean)array.contains((Object)Integer.MIN_VALUE));
    }

    @Test
    public void testSetArray() {
        CharArray array = new CharArray();
        char[] raw = new char[]{'\u0001', '\u0002', '\u0003', '\u0005', '\b', '\r', '\u0015'};
        array.setArray(raw);
        Assert.assertSame((Object)raw, (Object)array.getArray());
    }

    @Test
    public void testInsert() {
        char[] raw = new char[]{'\u0003', '\u0005', '\b', '\r', '\u0015'};
        this.testInsert((PrimitiveArray<?, ?>)new CharArray(raw));
    }

    @Test
    public void testDelete() {
        char[] raw = new char[]{'\u0003', '\u0005', '\b', '\r', '\u0015'};
        this.testDelete((PrimitiveArray<?, ?>)new CharArray(raw));
    }

    @Test
    public void testGet() {
        char[] raw = new char[]{'\u0003', '\u0005', '\b', '\r', '\u0015'};
        CharArray array = new CharArray((char[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)raw[i], (long)array.get(i).charValue());
        }
    }

    @Test
    public void testSet() {
        char[] raw = new char[]{'\u0003', '\u0005', '\b', '\r', '\u0015'};
        CharArray array = new CharArray((char[])raw.clone());
        Character e0 = Character.valueOf('\u0007');
        Character e2 = Character.valueOf('\u0001');
        Character e4 = Character.valueOf('\u0002');
        array.set(0, e0);
        array.set(2, e2);
        array.set(4, e4);
        Assert.assertEquals((long)raw.length, (long)array.size());
        Assert.assertEquals((Object)e0, (Object)array.get(0));
        Assert.assertEquals((long)raw[1], (long)array.getValue(1));
        Assert.assertEquals((Object)e2, (Object)array.get(2));
        Assert.assertEquals((long)raw[3], (long)array.getValue(3));
        Assert.assertEquals((Object)e4, (Object)array.get(4));
    }

    @Test
    public void testAdd() {
        char[] raw = new char[]{'\u0003', '\u0005', '\b', '\r', '\u0015'};
        CharArray array = new CharArray((char[])raw.clone());
        Character e6 = Character.valueOf('\u0001');
        Character e7 = Character.valueOf('\u0002');
        array.add((Object)e6);
        array.add((Object)e7);
        Assert.assertEquals((long)(raw.length + 2), (long)array.size());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)raw[i], (long)array.getValue(i));
        }
        Assert.assertEquals((Object)e6, (Object)array.get(5));
        Assert.assertEquals((Object)e7, (Object)array.get(6));
    }

    @Test
    public void testIndexOfBoxed() {
        char[] raw = new char[]{'\u0003', '\u0005', '\b', '\r', '\u0015'};
        CharArray array = new CharArray((char[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.indexOf((Object)new Character(raw[i])));
        }
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Character('0')));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Character('\uffff')));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Character('\u0000')));
        Assert.assertEquals((long)-1L, (long)array.indexOf(null));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)"Not a char"));
    }

    @Test
    public void testLastIndexOfBoxed() {
        char[] raw = new char[]{'\u0003', '\u0005', '\b', '\r', '\u0015'};
        CharArray array = new CharArray((char[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.lastIndexOf((Object)new Character(raw[i])));
        }
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Character('0')));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Character('\uffff')));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Character('\u0000')));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(null));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)"Not a char"));
    }

    @Test
    public void testContainsBoxed() {
        char[] raw = new char[]{'\u0003', '\u0005', '\b', '\r', '\u0015'};
        CharArray array = new CharArray((char[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertTrue((String)("@" + i), (boolean)array.contains((Object)new Character(raw[i])));
        }
        Assert.assertFalse((boolean)array.contains((Object)new Character('0')));
        Assert.assertFalse((boolean)array.contains((Object)new Character('\uffff')));
        Assert.assertFalse((boolean)array.contains((Object)new Character('\u0000')));
        Assert.assertFalse((boolean)array.contains(null));
        Assert.assertFalse((boolean)array.contains((Object)"Not a char"));
    }

    @Test
    public void testRemove() {
        char[] raw = new char[]{'\u0003', '\u0005', '\b', '\r', '\u0015'};
        CharArray array = new CharArray((char[])raw.clone());
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.remove((Object)new Character(raw[0]));
        Assert.assertEquals((long)(raw.length - 1), (long)array.size());
        array.remove((Object)new Character(raw[2]));
        Assert.assertEquals((long)(raw.length - 2), (long)array.size());
        array.remove((Object)new Character(raw[4]));
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((long)raw[1], (long)array.getValue(0));
        Assert.assertEquals((long)raw[3], (long)array.getValue(1));
    }

    @Test
    public void testContainsAll() {
        char[] raw = new char[]{'\u0003', '\u0005', '\b', '\r', '\u0015'};
        CharArray array = new CharArray((char[])raw.clone());
        ArrayList<Character> list = new ArrayList<Character>();
        Assert.assertTrue((boolean)array.containsAll(list));
        list.add(Character.valueOf('\r'));
        Assert.assertTrue((boolean)array.containsAll(list));
        list.add(Character.valueOf('\u0001'));
        Assert.assertFalse((boolean)array.containsAll(list));
        CharArray yes = new CharArray(new char[]{'\u0003', '\b', '\u0015'});
        Assert.assertTrue((boolean)array.containsAll((Collection)yes));
        CharArray no = new CharArray(new char[]{'\u0005', '\r', '\u0001'});
        Assert.assertFalse((boolean)array.containsAll((Collection)no));
    }

    @Test
    public void testAddAll() {
        int i;
        char[] raw = new char[]{'\u0003', '\u0005', '\b', '\r', '\u0015'};
        CharArray array = new CharArray((char[])raw.clone());
        char[] add = new char[]{'\u0001', '\u0007'};
        CharArray toAdd = new CharArray((char[])add.clone());
        int index = 3;
        array.addAll(3, (Collection)toAdd);
        for (i = 0; i < 3; ++i) {
            Assert.assertEquals((long)raw[i], (long)array.getValue(i));
        }
        for (i = 3; i < 3 + add.length; ++i) {
            Assert.assertEquals((long)add[i - 3], (long)array.getValue(i));
        }
        for (i = 3 + add.length; i < raw.length + add.length; ++i) {
            Assert.assertEquals((long)raw[i - add.length], (long)array.getValue(i));
        }
    }

    @Test
    public void testRemoveAll() {
        char[] raw = new char[]{'\u0003', '\u0005', '\b', '\r', '\u0015'};
        CharArray array = new CharArray((char[])raw.clone());
        CharArray toRemove = new CharArray(new char[]{'\u0003', '\b', '\u0015'});
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.removeAll((Collection)toRemove);
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((long)raw[1], (long)array.getValue(0));
        Assert.assertEquals((long)raw[3], (long)array.getValue(1));
    }
}

