/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.scijava.util.ProcessUtils;

public class ProcessUtilsTest {
    @Test
    public void testInterruptible() throws InterruptedException {
        this.assumePOSIX();
        SleepThread thread = new SleepThread(5000);
        thread.start();
        Thread.sleep(100L);
        thread.interrupt();
        thread.join();
        Assert.assertNotNull((Object)thread.getResult());
    }

    @Test
    public void testStdin() {
        this.assumePOSIX();
        String value = "Hello, World!\n";
        ByteArrayInputStream input = new ByteArrayInputStream("Hello, World!\n".getBytes());
        String result = ProcessUtils.exec(null, (InputStream)input, null, null, (String[])new String[]{"cat"});
        Assert.assertEquals((Object)"Hello, World!\n", (Object)result);
    }

    private void assumePOSIX() {
        String osName = System.getProperty("os.name");
        Assume.assumeTrue((osName.equals("Linux") || osName.equals("Mac OS X") ? 1 : 0) != 0);
    }

    private static class SleepThread
    extends Thread {
        private int seconds;
        private Throwable result;

        public SleepThread(int seconds) {
            this.seconds = seconds;
        }

        @Override
        public void run() {
            try {
                ProcessUtils.exec(null, null, null, (String[])new String[]{"sleep", "" + this.seconds});
            }
            catch (Throwable t) {
                this.result = t;
            }
        }

        public Throwable getResult() {
            return this.result;
        }
    }
}

