/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.annotations;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.annotations.AnnotatedA;
import org.scijava.annotations.AnnotatedB;
import org.scijava.annotations.AnnotatedC;
import org.scijava.annotations.Complex;
import org.scijava.annotations.DirectoryIndexerTest;
import org.scijava.annotations.EclipseHelper;
import org.scijava.annotations.Fruit;
import org.scijava.annotations.Indexable;
import org.scijava.annotations.Simple;

public class EclipseHelperTest {
    @Test
    public void testSkipIndexGeneration() throws Exception {
        File dir = this.createTempDirectory();
        this.copyClasses(dir, Complex.class, Simple.class);
        File jsonDir = new File(dir, "META-INF/json/");
        Assert.assertFalse((boolean)jsonDir.exists());
        URLClassLoader loader = new URLClassLoader(new URL[]{dir.toURI().toURL()}, this.getClass().getClassLoader().getParent());
        EclipseHelper.indexed.clear();
        EclipseHelper.updateAnnotationIndex((ClassLoader)loader);
        Assert.assertFalse((boolean)jsonDir.exists());
    }

    @Test
    public void testIndexing() throws Exception {
        File dir = this.createTempDirectory();
        this.copyClasses(dir, Complex.class, Simple.class, Fruit.class, AnnotatedA.class, AnnotatedB.class, AnnotatedC.class);
        File jsonDir = new File(dir, "META-INF/json/");
        for (Class clazz : new Class[]{Complex.class, Simple.class}) {
            Assert.assertFalse((boolean)new File(jsonDir, clazz.getName()).exists());
        }
        URLClassLoader loader = new URLClassLoader(new URL[]{dir.toURI().toURL()}, this.getClass().getClassLoader().getParent()){

            @Override
            public Class<?> loadClass(String className) throws ClassNotFoundException {
                if (className.equals(Indexable.class.getName())) {
                    return Indexable.class;
                }
                return super.loadClass(className);
            }
        };
        EclipseHelper.indexed.clear();
        EclipseHelper.updateAnnotationIndex((ClassLoader)loader);
        for (Class clazz : new Class[]{Complex.class, Simple.class}) {
            Assert.assertTrue((boolean)new File(jsonDir, clazz.getName()).exists());
        }
        Assert.assertEquals((long)2L, (long)jsonDir.list().length);
        jsonDir.setLastModified(123456789L);
        for (Class clazz : new Class[]{AnnotatedA.class, AnnotatedB.class, AnnotatedC.class}) {
            Assert.assertTrue((boolean)new File(dir, DirectoryIndexerTest.getResourcePath(clazz)).delete());
        }
        long now = System.currentTimeMillis();
        EclipseHelper.indexed.clear();
        EclipseHelper.updateAnnotationIndex((ClassLoader)loader);
        Assert.assertEquals((long)0L, (long)jsonDir.list().length);
        Assert.assertTrue((jsonDir.lastModified() >= now - 999L ? 1 : 0) != 0);
    }

    private void copyClasses(File dir, Class<?> ... classes) throws IOException {
        byte[] buffer = new byte[16384];
        for (Class<?> clazz : classes) {
            int count;
            String classPath = DirectoryIndexerTest.getResourcePath(clazz);
            InputStream in = this.getClass().getResource("/" + classPath).openStream();
            File outFile = new File(dir, classPath);
            File parent = outFile.getParentFile();
            Assert.assertTrue((parent.isDirectory() || parent.mkdirs() ? 1 : 0) != 0);
            FileOutputStream out = new FileOutputStream(outFile);
            while ((count = in.read(buffer)) >= 0) {
                ((OutputStream)out).write(buffer, 0, count);
            }
            in.close();
            ((OutputStream)out).close();
        }
    }

    private File createTempDirectory() throws IOException {
        File testClassesDirectory;
        String directory;
        String classPath = "/" + DirectoryIndexerTest.getResourcePath(this.getClass());
        String url = this.getClass().getResource(classPath).toString();
        if (url.startsWith("file:") && url.endsWith(classPath) && (directory = url.substring(5, url.length() - classPath.length())).endsWith("/target/test-classes") && (testClassesDirectory = new File(directory)).isDirectory()) {
            File result = new File(testClassesDirectory.getParentFile(), "eclipse test");
            if (result.exists()) {
                EclipseHelperTest.rmRF(result);
            }
            return result;
        }
        File result = File.createTempFile("eclipse test", "");
        result.delete();
        result.mkdir();
        return result;
    }

    private static boolean rmRF(File directory) {
        File[] list = directory.listFiles();
        if (list != null) {
            for (File file : list) {
                if (file.isFile() && !file.delete()) {
                    return false;
                }
                if (!file.isDirectory() || EclipseHelperTest.rmRF(file)) continue;
                return false;
            }
        }
        return directory.delete();
    }
}

