/*
 * Decompiled with CFR 0.152.
 */
package org.scijava;

import org.scijava.AbstractBasicDetails;
import org.scijava.MenuEntry;
import org.scijava.MenuPath;
import org.scijava.Prioritized;
import org.scijava.Priority;
import org.scijava.UIDetails;
import org.scijava.util.ClassUtils;
import org.scijava.util.MiscUtils;
import org.scijava.util.StringMaker;

public abstract class AbstractUIDetails
extends AbstractBasicDetails
implements UIDetails {
    private MenuPath menuPath;
    private String menuRoot = "app";
    private String iconPath;
    private double priority = 0.0;
    private boolean selectable;
    private String selectionGroup;
    private boolean selected;
    private boolean enabled = true;
    private boolean visible = true;

    @Override
    public String toString() {
        StringMaker sm = new StringMaker();
        sm.append(super.toString());
        sm.append("menu", this.menuPath == null ? null : this.menuPath.getMenuString());
        sm.append("iconPath", this.iconPath);
        sm.append("priority", this.priority, Integer.MAX_VALUE);
        if (this.selectable) {
            sm.append("selectionGroup", this.selectionGroup);
            sm.append("selected", this.selected);
        }
        sm.append("enabled", this.enabled);
        return sm.toString();
    }

    @Override
    public String getTitle() {
        MenuEntry menuLeaf;
        String menuName;
        if (this.getLabel() != null && !this.getLabel().isEmpty()) {
            return this.getLabel();
        }
        if (this.menuPath != null && this.menuPath.size() > 0 && (menuName = (menuLeaf = this.menuPath.getLeaf()).getName()) != null && !menuName.isEmpty()) {
            return menuName;
        }
        if (this.getName() != null && !this.getName().isEmpty()) {
            return this.getName();
        }
        return this.getClass().getSimpleName();
    }

    @Override
    public MenuPath getMenuPath() {
        return this.menuPath;
    }

    @Override
    public String getMenuRoot() {
        return this.menuRoot;
    }

    @Override
    public String getIconPath() {
        return this.iconPath;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean isSelectable() {
        return this.selectable;
    }

    @Override
    public String getSelectionGroup() {
        return this.selectionGroup;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setMenuPath(MenuPath menuPath) {
        this.menuPath = menuPath == null ? new MenuPath() : menuPath;
    }

    @Override
    public void setMenuRoot(String menuRoot) {
        this.menuRoot = menuRoot;
    }

    @Override
    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    @Override
    public void setSelectionGroup(String selectionGroup) {
        this.selectionGroup = selectionGroup;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public double getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(double priority) {
        this.priority = priority;
    }

    @Override
    public int compareTo(Prioritized that) {
        String thatName;
        if (that == null) {
            return 1;
        }
        int priorityCompare = Priority.compare(this, that);
        if (priorityCompare != 0) {
            return priorityCompare;
        }
        int classCompare = ClassUtils.compare(this.getClass(), that.getClass());
        if (classCompare != 0) {
            return classCompare;
        }
        if (!(that instanceof UIDetails)) {
            return 1;
        }
        UIDetails uiDetails = (UIDetails)that;
        String thisName = this.getName();
        int nameCompare = MiscUtils.compare(thisName, thatName = uiDetails.getName());
        if (nameCompare != 0) {
            return nameCompare;
        }
        String thisTitle = this.getTitle();
        String thatTitle = uiDetails.getTitle();
        return thisTitle.compareTo(thatTitle);
    }
}

