/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.util.Collection;
import java.util.Iterator;
import org.scijava.util.AbstractPrimitiveArray;

public class DoubleArray
extends AbstractPrimitiveArray<double[], Double> {
    private double[] array;

    public DoubleArray() {
        super(Double.TYPE);
    }

    public DoubleArray(int size) {
        super(Double.TYPE, size);
    }

    public DoubleArray(double[] array) {
        super(Double.TYPE, array);
    }

    public void addValue(double value) {
        this.addValue(this.size(), value);
    }

    public boolean removeValue(double value) {
        int index = this.indexOf(value);
        if (index < 0) {
            return false;
        }
        this.delete(index, 1);
        return true;
    }

    public double getValue(int index) {
        this.checkBounds(index);
        return this.array[index];
    }

    public double setValue(int index, double value) {
        this.checkBounds(index);
        double oldValue = this.getValue(index);
        this.array[index] = value;
        return oldValue;
    }

    public void addValue(int index, double value) {
        this.insert(index, 1);
        this.array[index] = value;
    }

    public int indexOf(double value) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(double value) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (this.array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(double value) {
        return this.indexOf(value) >= 0;
    }

    @Override
    public double[] getArray() {
        return this.array;
    }

    @Override
    public void setArray(double[] array) {
        if (array.length < this.size()) {
            throw new IllegalArgumentException("Array too small");
        }
        this.array = array;
    }

    @Override
    public Double get(int index) {
        return this.getValue(index);
    }

    @Override
    public Double set(int index, Double element) {
        return this.setValue(index, element == null ? this.defaultValue() : element);
    }

    @Override
    public void add(int index, Double element) {
        this.addValue(index, element);
    }

    @Override
    public int indexOf(Object o) {
        if (!(o instanceof Double)) {
            return -1;
        }
        double value = (Double)o;
        return this.indexOf(value);
    }

    @Override
    public int lastIndexOf(Object o) {
        if (!(o instanceof Double)) {
            return -1;
        }
        double value = (Double)o;
        return this.lastIndexOf(value);
    }

    @Override
    public boolean contains(Object o) {
        if (!(o instanceof Double)) {
            return false;
        }
        double value = (Double)o;
        return this.contains(value);
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Double)) {
            return false;
        }
        double value = (Double)o;
        return this.removeValue(value);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (!(o instanceof Double)) {
                return false;
            }
            double value = (Double)o;
            if (this.indexOf(value) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Double> c) {
        if (c.size() == 0) {
            return false;
        }
        this.insert(index, c.size());
        int i = index;
        Iterator<? extends Double> i$ = c.iterator();
        while (i$.hasNext()) {
            double e = i$.next();
            this.setValue(i++, e);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            double value;
            boolean result;
            if (!(o instanceof Double) || !(result = this.removeValue(value = ((Double)o).doubleValue()))) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public Double defaultValue() {
        return 0.0;
    }
}

