/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.welcome;

import java.io.File;
import java.io.IOException;
import org.scijava.app.AppService;
import org.scijava.command.CommandService;
import org.scijava.display.DisplayService;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.text.TextService;
import org.scijava.ui.event.UIShownEvent;
import org.scijava.util.Prefs;
import org.scijava.welcome.WelcomeService;
import org.scijava.welcome.event.WelcomeEvent;

@Plugin(type=Service.class)
public class DefaultWelcomeService
extends AbstractService
implements WelcomeService {
    private String WELCOME_FILE = "WELCOME.md";
    @Parameter
    private LogService log;
    @Parameter
    private AppService appService;
    @Parameter
    DisplayService displayService;
    @Parameter
    private CommandService commandService;
    @Parameter
    private TextService textService;
    @Parameter
    private EventService eventService;

    @Override
    public void displayWelcome() {
        File baseDir = this.appService.getApp().getBaseDirectory();
        File welcomeFile = new File(baseDir, this.WELCOME_FILE);
        try {
            if (welcomeFile.exists()) {
                String welcomeText = this.textService.asHTML(welcomeFile);
                this.displayService.createDisplay(welcomeText);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    @Override
    public boolean isFirstRun() {
        String firstRun = Prefs.get(this.getClass(), this.firstRunPrefKey());
        return firstRun == null || Boolean.parseBoolean(firstRun);
    }

    @Override
    public void setFirstRun(boolean firstRun) {
        Prefs.put(this.getClass(), this.firstRunPrefKey(), firstRun);
    }

    @EventHandler
    protected void onEvent(UIShownEvent evt) {
        if (!this.isFirstRun()) {
            return;
        }
        this.eventService.publish(new WelcomeEvent());
        this.setFirstRun(false);
        this.displayWelcome();
    }

    private String firstRunPrefKey() {
        return "firstRun-" + this.appService.getApp().getVersion();
    }
}

