/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.options;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.options.OptionsPlugin;
import org.scijava.options.OptionsService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.PluginService;

public class OptionsTest {
    private OptionsService createOptionsService() {
        Context context = new Context(new Class[]{PluginService.class, OptionsService.class});
        PluginService pluginService = (PluginService)context.getService(PluginService.class);
        PluginInfo info = new PluginInfo(FooOptions.class, OptionsPlugin.class);
        pluginService.addPlugin(info);
        return (OptionsService)context.getService(OptionsService.class);
    }

    @Test
    public void testBasic() {
        OptionsService optionsService = this.createOptionsService();
        Assert.assertNotNull((Object)optionsService);
        List optionsList = optionsService.getInstances();
        Assert.assertEquals((long)1L, (long)optionsList.size());
        FooOptions fooOptions = (FooOptions)optionsService.getOptions(FooOptions.class);
        Assert.assertSame(optionsList.get(0), (Object)((Object)fooOptions));
        Assert.assertSame((Object)((Object)fooOptions), (Object)optionsService.getOptions(FooOptions.class));
    }

    @Test
    public void testPersistence() {
        OptionsService optionsService = this.createOptionsService();
        FooOptions fooOptions = (FooOptions)optionsService.getOptions(FooOptions.class);
        Assert.assertEquals((long)0L, (long)fooOptions.getBar());
        fooOptions.setBar(-889275714);
        Assert.assertEquals((long)-889275714L, (long)fooOptions.getBar());
        fooOptions.save();
        fooOptions.setBar(-559038737);
        fooOptions.load();
        Assert.assertEquals((long)-889275714L, (long)fooOptions.getBar());
        optionsService.getContext().dispose();
        optionsService = this.createOptionsService();
        fooOptions = (FooOptions)optionsService.getOptions(FooOptions.class);
        Assert.assertEquals((long)-889275714L, (long)fooOptions.getBar());
        fooOptions.reset();
    }

    public static class FooOptions
    extends OptionsPlugin {
        @Parameter
        private int bar;

        public int getBar() {
            return this.bar;
        }

        public void setBar(int bar) {
            this.bar = bar;
        }
    }
}

