/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptException;
import org.scijava.Context;
import org.scijava.Contextual;
import org.scijava.ItemIO;
import org.scijava.ItemVisibility;
import org.scijava.NullContextException;
import org.scijava.log.LogService;
import org.scijava.module.AbstractModuleInfo;
import org.scijava.module.DefaultMutableModuleItem;
import org.scijava.module.ModuleException;
import org.scijava.plugin.Parameter;
import org.scijava.script.ScriptModule;
import org.scijava.script.ScriptService;
import org.scijava.util.ConversionUtils;

public class ScriptInfo
extends AbstractModuleInfo
implements Contextual {
    private static final int PARAM_CHAR_MAX = 655360;
    private final String path;
    private final BufferedReader reader;
    @Parameter
    private Context context;
    @Parameter
    private LogService log;
    @Parameter
    private ScriptService scriptService;

    public ScriptInfo(Context context, File file) {
        this(context, file.getPath());
    }

    public ScriptInfo(Context context, String path) {
        this(context, path, null);
    }

    public ScriptInfo(Context context, String path, Reader reader) {
        this.setContext(context);
        this.path = path;
        this.reader = reader == null ? null : new BufferedReader(reader, 655360);
    }

    public String getPath() {
        return this.path;
    }

    public BufferedReader getReader() {
        return this.reader;
    }

    @Override
    public void parseParameters() {
        this.clearParameters();
        try {
            String line;
            BufferedReader in;
            if (this.reader == null) {
                in = new BufferedReader(new FileReader(this.getPath()));
            } else {
                in = this.reader;
                in.mark(655360);
            }
            while ((line = in.readLine()) != null) {
                int at = line.indexOf(64);
                if (at >= 0) {
                    this.parseParam(line.substring(at + 1));
                    continue;
                }
                if (!line.matches(".*\\w.*")) continue;
                break;
            }
            if (this.reader == null) {
                in.close();
            } else {
                in.reset();
            }
            this.addReturnValue();
        }
        catch (IOException exc) {
            this.log.error("Error reading script: " + this.path, exc);
        }
        catch (ScriptException exc) {
            this.log.error("Invalid parameter syntax for script: " + this.path, exc);
        }
    }

    @Override
    public String getDelegateClassName() {
        return ScriptModule.class.getName();
    }

    @Override
    public Class<?> loadDelegateClass() {
        return ScriptModule.class;
    }

    @Override
    public ScriptModule createModule() throws ModuleException {
        return new ScriptModule(this);
    }

    @Override
    public Context context() {
        if (this.context == null) {
            throw new NullContextException();
        }
        return this.context;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public void setContext(Context context) {
        context.inject(this);
    }

    @Override
    public String getIdentifier() {
        return "script:" + this.path;
    }

    private void parseParam(String param) throws ScriptException {
        int lParen = param.indexOf("(");
        int rParen = param.lastIndexOf(")");
        if (rParen < lParen) {
            throw new ScriptException("Invalid parameter: " + param);
        }
        if (lParen < 0) {
            this.parseParam(param, this.parseAttrs(""));
        } else {
            String cutParam = param.substring(0, lParen) + param.substring(rParen + 1);
            String attrs = param.substring(lParen + 1, rParen);
            this.parseParam(cutParam, this.parseAttrs(attrs));
        }
    }

    private void parseParam(String param, HashMap<String, String> attrs) throws ScriptException {
        String varName;
        String typeName;
        String[] tokens = param.trim().split("[ \t\n]+");
        this.checkValid(tokens.length >= 1, param);
        if (this.isIOType(tokens[0])) {
            this.checkValid(tokens.length >= 3, param);
            attrs.put("type", tokens[0]);
            typeName = tokens[1];
            varName = tokens[2];
        } else {
            this.checkValid(tokens.length >= 2, param);
            typeName = tokens[0];
            varName = tokens[1];
        }
        Class<?> type = this.scriptService.lookupClass(typeName);
        this.addItem(varName, type, attrs);
    }

    private HashMap<String, String> parseAttrs(String attrs) throws ScriptException {
        HashMap<String, String> attrsMap = new HashMap<String, String>();
        for (String token : attrs.split(",")) {
            if (token.isEmpty()) continue;
            int equals = token.indexOf("=");
            if (equals < 0) {
                throw new ScriptException("Invalid attribute: " + token);
            }
            String key = token.substring(0, equals).trim();
            String value = token.substring(equals + 1).trim();
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            attrsMap.put(key, value);
        }
        return attrsMap;
    }

    private boolean isIOType(String token) {
        return ConversionUtils.convert((Object)token, ItemIO.class) != null;
    }

    private void checkValid(boolean valid, String param) throws ScriptException {
        if (!valid) {
            throw new ScriptException("Invalid parameter: " + param);
        }
    }

    private void addReturnValue() throws ScriptException {
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put("type", "OUTPUT");
        this.addItem("result", Object.class, attrs);
    }

    private <T> void addItem(String name, Class<T> type, Map<String, String> attrs) throws ScriptException {
        DefaultMutableModuleItem<T> item = new DefaultMutableModuleItem<T>(this, name, type);
        for (String key : attrs.keySet()) {
            String value = attrs.get(key);
            this.assignAttribute(item, key, value);
        }
        if (item.isInput()) {
            this.registerInput(item);
        }
        if (item.isOutput()) {
            this.registerOutput(item);
        }
    }

    private <T> void assignAttribute(DefaultMutableModuleItem<T> item, String key, String value) throws ScriptException {
        if ("callback".equalsIgnoreCase(key)) {
            item.setCallback(value);
        } else if (!"choices".equalsIgnoreCase(key)) {
            if ("columns".equalsIgnoreCase(key)) {
                item.setColumnCount(ConversionUtils.convert((Object)value, Integer.TYPE));
            } else if ("description".equalsIgnoreCase(key)) {
                item.setDescription(value);
            } else if ("initializer".equalsIgnoreCase(key)) {
                item.setInitializer(value);
            } else if ("type".equalsIgnoreCase(key)) {
                item.setIOType(ConversionUtils.convert((Object)value, ItemIO.class));
            } else if ("label".equalsIgnoreCase(key)) {
                item.setLabel(value);
            } else if ("max".equalsIgnoreCase(key)) {
                item.setMaximumValue(ConversionUtils.convert((Object)value, item.getType()));
            } else if ("min".equalsIgnoreCase(key)) {
                item.setMinimumValue(ConversionUtils.convert((Object)value, item.getType()));
            } else if ("name".equalsIgnoreCase(key)) {
                item.setName(value);
            } else if ("persist".equalsIgnoreCase(key)) {
                item.setPersisted(ConversionUtils.convert((Object)value, Boolean.TYPE));
            } else if ("persistKey".equalsIgnoreCase(key)) {
                item.setPersistKey(value);
            } else if ("required".equalsIgnoreCase(key)) {
                item.setRequired(ConversionUtils.convert((Object)value, Boolean.TYPE));
            } else if ("softMax".equalsIgnoreCase(key)) {
                item.setSoftMaximum(ConversionUtils.convert((Object)value, item.getType()));
            } else if ("softMin".equalsIgnoreCase(key)) {
                item.setSoftMinimum(ConversionUtils.convert((Object)value, item.getType()));
            } else if ("stepSize".equalsIgnoreCase(key)) {
                item.setStepSize(ConversionUtils.convert((Object)value, Number.class));
            } else if ("visibility".equalsIgnoreCase(key)) {
                item.setVisibility(ConversionUtils.convert((Object)value, ItemVisibility.class));
            } else if ("value".equalsIgnoreCase(key)) {
                item.setWidgetStyle(value);
            } else {
                throw new ScriptException("Invalid attribute name: " + key);
            }
        }
    }
}

