/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.usage;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.command.Command;
import org.scijava.command.CommandService;
import org.scijava.event.EventService;
import org.scijava.usage.UsageService;
import org.scijava.usage.UsageStats;

public class ModuleUsageTest {
    private UsageService usageService;
    private CommandService commandService;

    @Before
    public void setUp() {
        Context context = new Context(new Class[]{EventService.class, CommandService.class, UsageService.class});
        this.usageService = (UsageService)context.getService(UsageService.class);
        this.commandService = (CommandService)context.getService(CommandService.class);
    }

    @After
    public void tearDown() {
        this.usageService.getContext().dispose();
    }

    @Test
    public void testModuleStats() throws Exception {
        this.commandService.run(MyCommand.class, false, new Object[0]).get();
        String id = "command:" + MyCommand.class.getName();
        UsageStats usageStats = (UsageStats)this.usageService.getStats().get(id);
        Assert.assertNotNull((Object)usageStats);
        Assert.assertEquals((Object)id, (Object)usageStats.getIdentifier());
    }

    public static class MyCommand
    implements Command {
        public void run() {
        }
    }
}

