/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.event;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.WeakHashMap;
import org.bushe.swing.event.annotation.AbstractProxySubscriber;
import org.bushe.swing.event.annotation.ReferenceStrength;
import org.scijava.event.DefaultEventBus;
import org.scijava.event.EventHandler;
import org.scijava.event.EventService;
import org.scijava.event.EventSubscriber;
import org.scijava.event.SciJavaEvent;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.thread.ThreadService;
import org.scijava.util.ClassUtils;

@Plugin(type=Service.class, priority=100000.0)
public class DefaultEventService
extends AbstractService
implements EventService {
    public static final double PRIORITY = 100000.0;
    @Parameter
    private LogService log;
    @Parameter
    private ThreadService threadService;
    private DefaultEventBus eventBus;
    private final HashSet<String> keys = new HashSet();
    private WeakHashMap<Object, List<ProxySubscriber<?>>> keepEm = new WeakHashMap();

    @Override
    public <E extends SciJavaEvent> void publish(E e) {
        e.setContext(this.getContext());
        this.eventBus.publishNow(e);
    }

    @Override
    public <E extends SciJavaEvent> void publishLater(E e) {
        e.setContext(this.getContext());
        this.eventBus.publishLater(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EventSubscriber<?>> subscribe(Object o) {
        ArrayList subscribers = new ArrayList();
        List<Method> eventHandlers = ClassUtils.getAnnotatedMethods(o.getClass(), EventHandler.class);
        for (Method m : eventHandlers) {
            Class<? extends SciJavaEvent> eventClass = this.getEventClass(m);
            if (eventClass == null) {
                this.log.warn("Invalid EventHandler method: " + m);
                continue;
            }
            String key = m.getAnnotation(EventHandler.class).key();
            if (!key.isEmpty()) {
                HashSet<String> hashSet = this.keys;
                synchronized (hashSet) {
                    if (this.keys.contains(key)) {
                        continue;
                    }
                    this.keys.add(key);
                }
            }
            subscribers.add(this.subscribe(eventClass, o, m));
        }
        return subscribers;
    }

    @Override
    public void unsubscribe(Collection<EventSubscriber<?>> subscribers) {
        for (EventSubscriber<?> subscriber : subscribers) {
            this.unsubscribe(subscriber);
        }
    }

    @Override
    public <E extends SciJavaEvent> List<EventSubscriber<E>> getSubscribers(Class<E> c) {
        List list;
        List typedList = list = this.eventBus.getSubscribers(c);
        return typedList;
    }

    @Override
    public void initialize() {
        this.eventBus = new DefaultEventBus(this.threadService, this.log);
        super.initialize();
    }

    @Override
    public void dispose() {
        this.eventBus.clearAllSubscribers();
    }

    private <E extends SciJavaEvent> void subscribe(Class<E> c, EventSubscriber<E> subscriber) {
        this.eventBus.subscribe(c, subscriber);
    }

    private <E extends SciJavaEvent> void unsubscribe(EventSubscriber<E> subscriber) {
        this.unsubscribe(subscriber.getEventClass(), subscriber);
    }

    private <E extends SciJavaEvent> void unsubscribe(Class<E> c, EventSubscriber<E> subscriber) {
        this.eventBus.unsubscribe(c, subscriber);
    }

    private <E extends SciJavaEvent> EventSubscriber<E> subscribe(Class<E> c, Object o, Method m) {
        ProxySubscriber<E> subscriber = new ProxySubscriber<E>(c, o, m);
        this.subscribe(c, subscriber);
        return subscriber;
    }

    private Class<? extends SciJavaEvent> getEventClass(Method m) {
        Class<?>[] c = m.getParameterTypes();
        if (c == null || c.length != 1) {
            return null;
        }
        if (!SciJavaEvent.class.isAssignableFrom(c[0])) {
            return null;
        }
        Class<?> eventClass = c[0];
        return eventClass;
    }

    private synchronized void keepIt(Object o, ProxySubscriber<?> subscriber) {
        List<ProxySubscriber<?>> list = this.keepEm.get(o);
        if (list == null) {
            list = new ArrayList();
            this.keepEm.put(o, list);
        }
        list.add(subscriber);
    }

    private class ProxySubscriber<E extends SciJavaEvent>
    extends AbstractProxySubscriber
    implements EventSubscriber<E> {
        private final Class<E> c;

        public ProxySubscriber(Class<E> c, Object o, Method m) {
            super(o, m, ReferenceStrength.WEAK, (org.bushe.swing.event.EventService)DefaultEventService.this.eventBus, false);
            DefaultEventService.this.keepIt(o, this);
            this.c = c;
            m.setAccessible(true);
        }

        @Override
        public void onEvent(E event) {
            try {
                Object obj = this.getProxiedSubscriber();
                if (obj == null) {
                    return;
                }
                this.getSubscriptionMethod().invoke(obj, event);
            }
            catch (IllegalAccessException exc) {
                DefaultEventService.this.log.error("Exception during event handling:\n\t[Event] " + event.getClass().getName() + ":" + event + "\n\t[Subscriber] " + this.getProxiedSubscriber() + "\n\t[Method] " + this.getSubscriptionMethod(), exc);
            }
            catch (InvocationTargetException exc) {
                DefaultEventService.this.log.error("Exception during event handling:\n\t[Event] " + event.getClass().getName() + event + "\n\t[Subscriber] " + this.getProxiedSubscriber() + "\n\t[Method] " + this.getSubscriptionMethod(), exc.getCause());
            }
        }

        @Override
        public Class<E> getEventClass() {
            return this.c;
        }
    }
}

