/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.util.LongArray;
import org.scijava.util.PrimitiveArray;
import org.scijava.util.PrimitiveArrayTest;

public class LongArrayTest
extends PrimitiveArrayTest {
    @Test
    public void testConstructorNoArgs() {
        LongArray array = new LongArray();
        Assert.assertEquals((long)0L, (long)array.size());
        Assert.assertEquals((long)0L, (long)((long[])array.copyArray()).length);
    }

    @Test
    public void testConstructorSize() {
        int size = 24;
        LongArray array = new LongArray(24);
        Assert.assertEquals((long)24L, (long)array.size());
        Assert.assertEquals((long)24L, (long)((long[])array.copyArray()).length);
    }

    @Test
    public void testConstructorArray() {
        long[] raw = new long[]{3L, 5L, 8L, 13L, 21L};
        LongArray array = new LongArray(raw);
        Assert.assertSame((Object)raw, (Object)array.getArray());
        Assert.assertEquals((long)raw.length, (long)array.size());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)raw[i], (long)array.getValue(i));
        }
        Assert.assertArrayEquals((long[])raw, (long[])((long[])array.copyArray()));
    }

    @Test
    public void testAddValue() {
        long[] raw = new long[]{3L, 5L, 8L, 13L, 21L};
        LongArray array = new LongArray((long[])raw.clone());
        long e6 = 1L;
        long e7 = 2L;
        array.addValue(1L);
        array.addValue(2L);
        Assert.assertEquals((long)(raw.length + 2), (long)array.size());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)raw[i], (long)array.getValue(i));
        }
        Assert.assertEquals((long)1L, (long)array.getValue(5));
        Assert.assertEquals((long)2L, (long)array.getValue(6));
    }

    public void testRemoveValue() {
        long[] raw = new long[]{3L, 5L, 8L, 13L, 21L};
        LongArray array = new LongArray((long[])raw.clone());
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.removeValue(raw[0]);
        Assert.assertEquals((long)(raw.length - 1), (long)array.size());
        array.removeValue(raw[2]);
        Assert.assertEquals((long)(raw.length - 2), (long)array.size());
        array.removeValue(raw[4]);
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((long)raw[1], (long)array.getValue(0));
        Assert.assertEquals((long)raw[3], (long)array.getValue(1));
    }

    public void testGetValue() {
        long[] raw = new long[]{3L, 5L, 8L, 13L, 21L};
        LongArray array = new LongArray((long[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)raw[i], (long)array.getValue(i));
        }
    }

    @Test
    public void testSetValue() {
        long[] raw = new long[]{3L, 5L, 8L, 13L, 21L};
        LongArray array = new LongArray((long[])raw.clone());
        long e0 = 7L;
        long e2 = 1L;
        long e4 = 2L;
        array.setValue(0, 7L);
        array.setValue(2, 1L);
        array.setValue(4, 2L);
        Assert.assertEquals((long)raw.length, (long)array.size());
        Assert.assertEquals((long)7L, (long)array.getValue(0));
        Assert.assertEquals((long)raw[1], (long)array.getValue(1));
        Assert.assertEquals((long)1L, (long)array.getValue(2));
        Assert.assertEquals((long)raw[3], (long)array.getValue(3));
        Assert.assertEquals((long)2L, (long)array.getValue(4));
    }

    @Test
    public void testAddValueIndex() {
        long[] raw = new long[]{3L, 5L, 8L, 13L, 21L};
        LongArray array = new LongArray((long[])raw.clone());
        long e0 = 7L;
        long e4 = 1L;
        long e7 = 2L;
        array.addValue(0, 7L);
        array.addValue(4, 1L);
        array.addValue(7, 2L);
        Assert.assertEquals((long)(raw.length + 3), (long)array.size());
        Assert.assertEquals((long)7L, (long)array.getValue(0));
        Assert.assertEquals((long)raw[0], (long)array.getValue(1));
        Assert.assertEquals((long)raw[1], (long)array.getValue(2));
        Assert.assertEquals((long)raw[2], (long)array.getValue(3));
        Assert.assertEquals((long)1L, (long)array.getValue(4));
        Assert.assertEquals((long)raw[3], (long)array.getValue(5));
        Assert.assertEquals((long)raw[4], (long)array.getValue(6));
        Assert.assertEquals((long)2L, (long)array.getValue(7));
    }

    public void testRemoveIndex() {
        long[] raw = new long[]{3L, 5L, 8L, 13L, 21L};
        LongArray array = new LongArray((long[])raw.clone());
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.remove(0);
        Assert.assertEquals((long)(raw.length - 1), (long)array.size());
        array.remove(2);
        Assert.assertEquals((long)(raw.length - 2), (long)array.size());
        array.remove(4);
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((long)raw[1], (long)array.getValue(0));
        Assert.assertEquals((long)raw[3], (long)array.getValue(1));
    }

    @Test
    public void testIndexOf() {
        long[] raw = new long[]{3L, 5L, 8L, 13L, 21L};
        LongArray array = new LongArray((long[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.indexOf(raw[i]));
        }
        Assert.assertEquals((long)-1L, (long)array.indexOf(-1L));
        Assert.assertEquals((long)-1L, (long)array.indexOf(0L));
        Assert.assertEquals((long)-1L, (long)array.indexOf(1L));
        Assert.assertEquals((long)-1L, (long)array.indexOf(Long.MAX_VALUE));
        Assert.assertEquals((long)-1L, (long)array.indexOf(Long.MIN_VALUE));
    }

    @Test
    public void testLastIndexOf() {
        long[] raw = new long[]{3L, 5L, 8L, 13L, 21L};
        LongArray array = new LongArray((long[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.lastIndexOf(raw[i]));
        }
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(-1L));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(0L));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(1L));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(Long.MAX_VALUE));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(Long.MIN_VALUE));
    }

    @Test
    public void testContains() {
        long[] raw = new long[]{3L, 5L, 8L, 13L, 21L};
        LongArray array = new LongArray((long[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertTrue((String)("@" + i), (boolean)array.contains(raw[i]));
        }
        Assert.assertFalse((boolean)array.contains(-1L));
        Assert.assertFalse((boolean)array.contains(0L));
        Assert.assertFalse((boolean)array.contains(1L));
        Assert.assertFalse((boolean)array.contains(Long.MAX_VALUE));
        Assert.assertFalse((boolean)array.contains(Long.MIN_VALUE));
    }

    @Test
    public void testSetArray() {
        LongArray array = new LongArray();
        long[] raw = new long[]{1L, 2L, 3L, 5L, 8L, 13L, 21L};
        array.setArray(raw);
        Assert.assertSame((Object)raw, (Object)array.getArray());
    }

    @Test
    public void testInsert() {
        long[] raw = new long[]{3L, 5L, 8L, 13L, 21L};
        this.testInsert((PrimitiveArray<?, ?>)new LongArray(raw));
    }

    @Test
    public void testDelete() {
        long[] raw = new long[]{3L, 5L, 8L, 13L, 21L};
        this.testDelete((PrimitiveArray<?, ?>)new LongArray(raw));
    }

    @Test
    public void testGet() {
        long[] raw = new long[]{3L, 5L, 8L, 13L, 21L};
        LongArray array = new LongArray((long[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)raw[i], (long)array.get(i));
        }
    }

    @Test
    public void testSet() {
        long[] raw = new long[]{3L, 5L, 8L, 13L, 21L};
        LongArray array = new LongArray((long[])raw.clone());
        Long e0 = 7L;
        Long e2 = 1L;
        Long e4 = 2L;
        array.set(0, e0);
        array.set(2, e2);
        array.set(4, e4);
        Assert.assertEquals((long)raw.length, (long)array.size());
        Assert.assertEquals((Object)e0, (Object)array.get(0));
        Assert.assertEquals((long)raw[1], (long)array.getValue(1));
        Assert.assertEquals((Object)e2, (Object)array.get(2));
        Assert.assertEquals((long)raw[3], (long)array.getValue(3));
        Assert.assertEquals((Object)e4, (Object)array.get(4));
    }

    @Test
    public void testAdd() {
        long[] raw = new long[]{3L, 5L, 8L, 13L, 21L};
        LongArray array = new LongArray((long[])raw.clone());
        Long e6 = 1L;
        Long e7 = 2L;
        array.add((Object)e6);
        array.add((Object)e7);
        Assert.assertEquals((long)(raw.length + 2), (long)array.size());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)raw[i], (long)array.getValue(i));
        }
        Assert.assertEquals((Object)e6, (Object)array.get(5));
        Assert.assertEquals((Object)e7, (Object)array.get(6));
    }

    @Test
    public void testIndexOfBoxed() {
        long[] raw = new long[]{3L, 5L, 8L, 13L, 21L};
        LongArray array = new LongArray((long[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.indexOf((Object)new Long(raw[i])));
        }
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Long(-1L)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Long(0L)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Long(1L)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Long(Long.MAX_VALUE)));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)new Long(Long.MIN_VALUE)));
        Assert.assertEquals((long)-1L, (long)array.indexOf(null));
        Assert.assertEquals((long)-1L, (long)array.indexOf((Object)"Not a long"));
    }

    @Test
    public void testLastIndexOfBoxed() {
        long[] raw = new long[]{3L, 5L, 8L, 13L, 21L};
        LongArray array = new LongArray((long[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertEquals((String)("@" + i), (long)i, (long)array.lastIndexOf((Object)new Long(raw[i])));
        }
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Long(-1L)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Long(0L)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Long(1L)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Long(Long.MAX_VALUE)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)new Long(Long.MIN_VALUE)));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf(null));
        Assert.assertEquals((long)-1L, (long)array.lastIndexOf((Object)"Not a long"));
    }

    @Test
    public void testContainsBoxed() {
        long[] raw = new long[]{3L, 5L, 8L, 13L, 21L};
        LongArray array = new LongArray((long[])raw.clone());
        for (int i = 0; i < raw.length; ++i) {
            Assert.assertTrue((String)("@" + i), (boolean)array.contains((Object)new Long(raw[i])));
        }
        Assert.assertFalse((boolean)array.contains((Object)new Long(-1L)));
        Assert.assertFalse((boolean)array.contains((Object)new Long(0L)));
        Assert.assertFalse((boolean)array.contains((Object)new Long(1L)));
        Assert.assertFalse((boolean)array.contains((Object)new Long(Long.MAX_VALUE)));
        Assert.assertFalse((boolean)array.contains((Object)new Long(Long.MIN_VALUE)));
        Assert.assertFalse((boolean)array.contains(null));
        Assert.assertFalse((boolean)array.contains((Object)"Not a long"));
    }

    @Test
    public void testRemove() {
        long[] raw = new long[]{3L, 5L, 8L, 13L, 21L};
        LongArray array = new LongArray((long[])raw.clone());
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.remove((Object)new Long(raw[0]));
        Assert.assertEquals((long)(raw.length - 1), (long)array.size());
        array.remove((Object)new Long(raw[2]));
        Assert.assertEquals((long)(raw.length - 2), (long)array.size());
        array.remove((Object)new Long(raw[4]));
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((long)raw[1], (long)array.getValue(0));
        Assert.assertEquals((long)raw[3], (long)array.getValue(1));
    }

    @Test
    public void testContainsAll() {
        long[] raw = new long[]{3L, 5L, 8L, 13L, 21L};
        LongArray array = new LongArray((long[])raw.clone());
        ArrayList<Long> list = new ArrayList<Long>();
        Assert.assertTrue((boolean)array.containsAll(list));
        list.add(13L);
        Assert.assertTrue((boolean)array.containsAll(list));
        list.add(1L);
        Assert.assertFalse((boolean)array.containsAll(list));
        LongArray yes = new LongArray(new long[]{3L, 8L, 21L});
        Assert.assertTrue((boolean)array.containsAll((Collection)yes));
        LongArray no = new LongArray(new long[]{5L, 13L, 1L});
        Assert.assertFalse((boolean)array.containsAll((Collection)no));
    }

    @Test
    public void testAddAll() {
        int i;
        long[] raw = new long[]{3L, 5L, 8L, 13L, 21L};
        LongArray array = new LongArray((long[])raw.clone());
        long[] add = new long[]{1L, 7L};
        LongArray toAdd = new LongArray((long[])add.clone());
        int index = 3;
        array.addAll(3, (Collection)toAdd);
        for (i = 0; i < 3; ++i) {
            Assert.assertEquals((long)raw[i], (long)array.getValue(i));
        }
        for (i = 3; i < 3 + add.length; ++i) {
            Assert.assertEquals((long)add[i - 3], (long)array.getValue(i));
        }
        for (i = 3 + add.length; i < raw.length + add.length; ++i) {
            Assert.assertEquals((long)raw[i - add.length], (long)array.getValue(i));
        }
    }

    @Test
    public void testRemoveAll() {
        long[] raw = new long[]{3L, 5L, 8L, 13L, 21L};
        LongArray array = new LongArray((long[])raw.clone());
        LongArray toRemove = new LongArray(new long[]{3L, 8L, 21L});
        Assert.assertEquals((long)raw.length, (long)array.size());
        array.removeAll((Collection)toRemove);
        Assert.assertEquals((long)(raw.length - 3), (long)array.size());
        Assert.assertEquals((long)raw[1], (long)array.getValue(0));
        Assert.assertEquals((long)raw[3], (long)array.getValue(1));
    }
}

