/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.scijava.prefs.PrefService;
import org.scijava.script.History;
import org.scijava.script.ScriptInterpreter;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptService;

public class DefaultScriptInterpreter
implements ScriptInterpreter {
    private final ScriptLanguage language;
    private final ScriptEngine engine;
    private final History history;

    public DefaultScriptInterpreter(PrefService prefs, ScriptService scriptService, ScriptLanguage language) {
        this.language = language;
        this.engine = language.getScriptEngine();
        this.history = new History(prefs, this.engine.getClass().getName());
        this.readHistory();
    }

    @Override
    public synchronized void readHistory() {
        if (this.history == null) {
            return;
        }
        this.history.read();
    }

    @Override
    public synchronized void writeHistory() {
        if (this.history == null) {
            return;
        }
        this.history.write();
    }

    @Override
    public synchronized String walkHistory(String currentCommand, boolean forward) {
        if (this.history == null) {
            return currentCommand;
        }
        this.history.replace(currentCommand);
        return forward ? this.history.next() : this.history.previous();
    }

    @Override
    public void eval(String command) throws ScriptException {
        if (this.history != null) {
            this.history.add(command);
        }
        if (this.engine == null) {
            throw new IllegalArgumentException();
        }
        this.engine.eval(command);
    }

    @Override
    public ScriptLanguage getLanguage() {
        return this.language;
    }

    @Override
    public ScriptEngine getEngine() {
        return this.engine;
    }
}

