/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugin;

import org.scijava.log.LogService;
import org.scijava.plugin.AbstractTypedService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.WrapperPlugin;
import org.scijava.plugin.WrapperService;

public abstract class AbstractWrapperService<DT, PT extends WrapperPlugin<DT>>
extends AbstractTypedService<DT, PT>
implements WrapperService<DT, PT> {
    @Parameter(required=false)
    private LogService log;

    @Override
    public <D extends DT> PT create(D data) {
        PT instance = this.wrap(data);
        if (instance == null) {
            throw new IllegalArgumentException("No compatible " + this.getPluginType().getSimpleName() + " for data object: " + data);
        }
        return instance;
    }

    @Override
    public void initialize() {
        if (this.log != null) {
            this.log.debug("Found " + this.getPlugins().size() + " " + this.getPluginType().getSimpleName() + " plugins.");
        }
    }

    @Override
    public boolean supports(DT data) {
        return this.wrap(data) != null;
    }

    private <D extends DT> PT wrap(D data) {
        for (PluginInfo plugin : this.getPlugins()) {
            WrapperPlugin instance = (WrapperPlugin)this.getPluginService().createInstance(plugin);
            if (!instance.supports(data)) continue;
            return (PT)instance;
        }
        return null;
    }
}

