/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui;

import java.util.List;
import org.scijava.app.StatusService;
import org.scijava.command.CommandService;
import org.scijava.display.Display;
import org.scijava.display.DisplayService;
import org.scijava.log.LogService;
import org.scijava.plugin.AbstractRichPlugin;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.PluginService;
import org.scijava.prefs.PrefService;
import org.scijava.thread.ThreadService;
import org.scijava.ui.ApplicationFrame;
import org.scijava.ui.Desktop;
import org.scijava.ui.StatusBar;
import org.scijava.ui.ToolBar;
import org.scijava.ui.UIService;
import org.scijava.ui.UserInterface;
import org.scijava.ui.console.ConsolePane;
import org.scijava.ui.viewer.DisplayViewer;
import org.scijava.ui.viewer.DisplayWindow;

public abstract class AbstractUserInterface
extends AbstractRichPlugin
implements UserInterface {
    private static final String LAST_X = "lastXLocation";
    private static final String LAST_Y = "lastYLocation";
    @Parameter
    private CommandService commandService;
    @Parameter
    private DisplayService displayService;
    @Parameter
    private LogService log;
    @Parameter
    private PluginService pluginService;
    @Parameter
    private StatusService statusService;
    @Parameter
    private ThreadService threadService;
    @Parameter
    private UIService uiService;
    @Parameter
    private PrefService prefService;
    private boolean visible = false;

    @Override
    public void show() {
        this.createUI();
        this.visible = true;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void show(Object o) {
        this.show(null, o);
    }

    @Override
    public void show(String name, Object o) {
        Display<?> display = o instanceof Display ? (Display<?>)o : this.displayService.createDisplay(name, o);
        if (!this.isVisible()) {
            this.show(display);
        }
    }

    @Override
    public void show(final Display<?> display) {
        if (this.uiService.getDisplayViewer(display) != null) {
            return;
        }
        List<PluginInfo<DisplayViewer<?>>> viewers = this.uiService.getViewerPlugins();
        DisplayViewer<?> displayViewer = null;
        for (PluginInfo<DisplayViewer<?>> info : viewers) {
            DisplayViewer<?> viewer = this.pluginService.createInstance(info);
            if (viewer == null || !viewer.canView(display) || !viewer.isCompatible(this)) continue;
            displayViewer = viewer;
            break;
        }
        if (displayViewer == null) {
            this.log.warn("For UI '" + this.getClass().getName() + "': no suitable viewer for display: " + display);
            return;
        }
        final DisplayViewer<?> finalViewer = displayViewer;
        this.threadService.queue(new Runnable(){

            @Override
            public void run() {
                DisplayWindow displayWindow = AbstractUserInterface.this.createDisplayWindow(display);
                finalViewer.view(displayWindow, display);
                displayWindow.setTitle(display.getName());
                AbstractUserInterface.this.uiService.addDisplayViewer(finalViewer);
                displayWindow.showDisplay(true);
                display.update();
            }
        });
    }

    @Override
    public Desktop getDesktop() {
        return null;
    }

    @Override
    public ApplicationFrame getApplicationFrame() {
        return null;
    }

    @Override
    public ToolBar getToolBar() {
        return null;
    }

    @Override
    public StatusBar getStatusBar() {
        return null;
    }

    @Override
    public ConsolePane<?> getConsolePane() {
        return null;
    }

    @Override
    public void saveLocation() {
        ApplicationFrame appFrame = this.getApplicationFrame();
        if (appFrame != null) {
            this.prefService.put(this.getClass(), LAST_X, appFrame.getLocationX());
            this.prefService.put(this.getClass(), LAST_Y, appFrame.getLocationY());
        }
    }

    @Override
    public void restoreLocation() {
        ApplicationFrame appFrame = this.getApplicationFrame();
        if (appFrame != null) {
            int lastX = this.prefService.getInt(this.getClass(), LAST_X, 0);
            int lastY = this.prefService.getInt(this.getClass(), LAST_Y, 0);
            appFrame.setLocation(lastX, lastY);
        }
    }

    protected void createUI() {
        this.restoreLocation();
    }
}

