/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.convert;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.convert.AbstractConverter;
import org.scijava.convert.DefaultConverter;
import org.scijava.convert.NullConverter;
import org.scijava.util.ClassUtils;
import org.scijava.util.GenericUtils;

public class ConverterTest {
    private Collection<Number> collection;

    @Test
    public void testNullConverter() {
        NullConverter nc = new NullConverter();
        Assert.assertFalse((boolean)nc.canConvert(Object.class, Object.class));
        Assert.assertFalse((boolean)nc.canConvert(Object.class, Object.class));
        Assert.assertTrue((boolean)nc.canConvert((Class)null, Object.class));
        Assert.assertTrue((boolean)nc.canConvert((Object)null, Object.class));
        Assert.assertTrue((boolean)nc.canConvert((Object)null, ArrayList.class));
        Assert.assertNull((Object)nc.convert((Object)null, Object.class));
        Assert.assertNull((Object)nc.convert((Object)null, Object.class));
        Assert.assertNull((Object)nc.convert(Object.class, (Class)null));
        Assert.assertNull((Object)nc.convert(Object.class, (Type)null));
        Assert.assertNull((Object)nc.convert(new Object(), (Class)null));
        Assert.assertNull((Object)nc.convert(new Object(), (Type)null));
    }

    @Test
    public void testCanConvert() {
        NumberConverter nc = new NumberConverter();
        Assert.assertFalse((boolean)nc.canConvert(Integer.class, Double.class));
        Assert.assertTrue((boolean)nc.canConvert(Integer.class, Number.class));
    }

    @Test
    public void testCanConvertToGenericCollection() {
        DefaultConverter dc = new DefaultConverter();
        Field destField = ClassUtils.getField(this.getClass(), (String)"collection");
        Type destType = GenericUtils.getFieldType((Field)destField, this.getClass());
        Assert.assertTrue((boolean)dc.canConvert(ArrayList.class, destType));
    }

    private static class NumberConverter
    extends AbstractConverter<Number, Number> {
        private NumberConverter() {
        }

        public <T> T convert(Object src, Class<T> dest) {
            return (T)src;
        }

        public Class<Number> getOutputType() {
            return Number.class;
        }

        public Class<Number> getInputType() {
            return Number.class;
        }
    }
}

