/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.util.Enumeration;
import java.util.Iterator;

public class IteratorPlus<E>
implements Enumeration<E>,
Iterator<E>,
Iterable<E> {
    private final Iterator<E> iterator;

    public IteratorPlus(Iterable<E> iterable) {
        this(iterable.iterator());
    }

    public IteratorPlus(Enumeration<E> enumeration) {
        this(new EnumerationIterator(enumeration));
    }

    public IteratorPlus(Iterator<E> iterator) {
        this.iterator = iterator;
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasNext();
    }

    @Override
    public E nextElement() {
        return this.next();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public E next() {
        return this.iterator.next();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    @Override
    public Iterator<E> iterator() {
        return this;
    }

    private static class EnumerationIterator<E>
    implements Iterator<E> {
        private final Enumeration<E> enumeration;

        private EnumerationIterator(Enumeration<E> enumeration) {
            this.enumeration = enumeration;
        }

        @Override
        public boolean hasNext() {
            return this.enumeration.hasMoreElements();
        }

        @Override
        public E next() {
            return this.enumeration.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

