/*
 * Decompiled with CFR 0.152.
 */
package org.scijava;

import org.scijava.BasicDetails;
import org.scijava.Identifiable;
import org.scijava.MenuEntry;
import org.scijava.MenuPath;
import org.scijava.Prioritized;
import org.scijava.Priority;
import org.scijava.util.ClassUtils;
import org.scijava.util.MiscUtils;

public interface UIDetails
extends BasicDetails,
Prioritized {
    public static final String APPLICATION_MENU_ROOT = "app";

    default public String getTitle() {
        String id;
        MenuEntry menuLeaf;
        String menuName;
        if (this.getLabel() != null && !this.getLabel().isEmpty()) {
            return this.getLabel();
        }
        MenuPath menuPath = this.getMenuPath();
        if (menuPath != null && menuPath.size() > 0 && (menuName = (menuLeaf = menuPath.getLeaf()).getName()) != null && !menuName.isEmpty()) {
            return menuName;
        }
        if (this.getName() != null && !this.getName().isEmpty()) {
            return this.getName();
        }
        if (this instanceof Identifiable && (id = ((Identifiable)((Object)this)).getIdentifier()) != null) {
            return id;
        }
        return this.getClass().getSimpleName();
    }

    public MenuPath getMenuPath();

    public String getMenuRoot();

    public String getIconPath();

    public boolean isSelectable();

    public String getSelectionGroup();

    public boolean isSelected();

    public boolean isEnabled();

    public boolean isVisible();

    public void setMenuPath(MenuPath var1);

    public void setMenuRoot(String var1);

    public void setIconPath(String var1);

    public void setEnabled(boolean var1);

    public void setVisible(boolean var1);

    public void setSelectable(boolean var1);

    public void setSelectionGroup(String var1);

    public void setSelected(boolean var1);

    @Override
    default public int compareTo(Prioritized that) {
        String thatName;
        if (that == null) {
            return 1;
        }
        int priorityCompare = Priority.compare(this, that);
        if (priorityCompare != 0) {
            return priorityCompare;
        }
        int classCompare = ClassUtils.compare(this.getClass(), that.getClass());
        if (classCompare != 0) {
            return classCompare;
        }
        if (!(that instanceof UIDetails)) {
            return 1;
        }
        UIDetails uiDetails = (UIDetails)that;
        String thisName = this.getName();
        int nameCompare = MiscUtils.compare(thisName, thatName = uiDetails.getName());
        if (nameCompare != 0) {
            return nameCompare;
        }
        String thisTitle = this.getTitle();
        String thatTitle = uiDetails.getTitle();
        return MiscUtils.compare(thisTitle, thatTitle);
    }
}

