/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.console;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.scijava.console.ConsoleArgument;
import org.scijava.plugin.AbstractHandlerPlugin;

public abstract class AbstractConsoleArgument
extends AbstractHandlerPlugin<LinkedList<String>>
implements ConsoleArgument {
    private int numArgs;
    private Set<String> flags;

    public AbstractConsoleArgument() {
        this(1, new String[0]);
    }

    public AbstractConsoleArgument(String ... flags) {
        this(1, flags);
    }

    public AbstractConsoleArgument(int requiredArgs, String ... flags) {
        this.numArgs = requiredArgs;
        this.flags = new HashSet<String>();
        for (String s : flags) {
            this.flags.add(s);
        }
    }

    @Override
    public boolean supports(LinkedList<String> args) {
        if (args == null || args.size() < this.numArgs) {
            return false;
        }
        return this.isFlag(args);
    }

    protected boolean isFlag(LinkedList<String> args) {
        return this.flags.isEmpty() || this.flags.contains(args.getFirst());
    }

    protected String getParam(LinkedList<String> args) {
        if (args.isEmpty()) {
            return null;
        }
        String arg = args.getFirst();
        return arg.startsWith("-") ? null : arg;
    }
}

