/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.handle;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.DataHandleService;
import org.scijava.io.handle.DataHandleTest;
import org.scijava.io.handle.WriteBufferDataHandle;
import org.scijava.io.location.BytesLocation;
import org.scijava.io.location.Location;

public class WriteBufferDataHandleTest
extends DataHandleTest {
    private Location loc;

    @Override
    public Class<? extends DataHandle<?>> getExpectedHandleType() {
        return null;
    }

    @Override
    @Test
    public void testDataHandle() throws IOException {
        Context context = new Context(new Class[]{DataHandleService.class});
        DataHandleService dataHandleService = (DataHandleService)context.service(DataHandleService.class);
        this.loc = this.createLocation();
        try (DataHandle handle = (DataHandle)dataHandleService.create((Object)this.loc);
             WriteBufferDataHandle buffer = new WriteBufferDataHandle(handle);){
            this.checkWrites((DataHandle)buffer);
        }
    }

    @Override
    public Location createLocation() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.populateData(out);
        return new BytesLocation(out.toByteArray());
    }

    @Override
    protected <L extends Location> void checkWrites(DataHandle<L> handle) throws IOException {
        byte[] copy = (byte[])BYTES.clone();
        handle.seek(7L);
        String splice = "there";
        for (int i = 0; i < "there".length(); ++i) {
            char c = "there".charAt(i);
            handle.write((int)c);
            copy[7 + i] = (byte)c;
        }
        handle.close();
        Context context = new Context(new Class[]{DataHandleService.class});
        DataHandleService dataHandleService = (DataHandleService)context.service(DataHandleService.class);
        try (DataHandle readHandle = (DataHandle)dataHandleService.create((Object)this.loc);){
            readHandle.seek(0L);
            for (int i = 0; i < copy.length; ++i) {
                Assert.assertEquals((String)this.msg(i), (long)(0xFF & copy[i]), (long)readHandle.read());
            }
        }
    }
}

