/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.location;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.Map;
import org.scijava.io.location.AbstractLocation;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;

public class URILocation
extends AbstractLocation {
    @Parameter
    private LogService log;
    private final URI uri;

    public URILocation(URI uri) {
        this.uri = uri;
    }

    public URILocation(String uriPath) throws URISyntaxException {
        this(new URI(uriPath));
    }

    public Map<String, String> getQueryMap() {
        return this.decodeQuery(this.getURI().getRawQuery());
    }

    public String getQueryValue(String key) {
        return this.getQueryMap().get(key);
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    private Map<String, String> decodeQuery(String query) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (query == null) {
            return map;
        }
        for (String param : query.split("&")) {
            int equals = param.indexOf("=");
            if (equals < 0) {
                map.put(this.decode(param), "true");
                continue;
            }
            String key = this.decode(param.substring(0, equals));
            String value = this.decode(param.substring(equals + 1));
            map.put(key, value);
        }
        return map;
    }

    private String decode(String s) {
        try {
            return URLDecoder.decode(s.replace("+", "%2B"), "UTF-8");
        }
        catch (UnsupportedEncodingException exc) {
            return null;
        }
    }
}

