/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.command;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.InstantiableException;
import org.scijava.command.Inputs;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;
import org.scijava.module.MutableModuleItem;
import org.scijava.module.process.AbstractPreprocessorPlugin;
import org.scijava.module.process.PreprocessorPlugin;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.PluginService;

public class InputsTest {
    private Context context;

    @Before
    public void setUp() {
        this.context = new Context();
        this.context.service(PluginService.class);
    }

    @After
    public void tearDown() {
        this.context.dispose();
    }

    @Test
    public void testSingleInput() {
        this.setExpected((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("sigma", Float.valueOf(3.9f));
            }
        });
        Inputs inputs = new Inputs(this.context);
        inputs.getInfo().setName("testSingleInput");
        InputsTest.addTempInput(inputs, "sigma", Float.class);
        float sigma = ((Float)inputs.harvest().get("sigma")).floatValue();
        Assert.assertEquals((float)3.9f, (float)sigma, (float)0.0f);
    }

    @Test
    public void testTwoInputs() {
        this.setExpected((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("name", "Chuckles");
                this.put("age", 37);
            }
        });
        Inputs inputs = new Inputs(this.context);
        inputs.getInfo().setName("testTwoInputs");
        InputsTest.addTempInput(inputs, "name", String.class);
        InputsTest.addTempInput(inputs, "age", Integer.class);
        Map values = inputs.harvest();
        String name = (String)values.get("name");
        int age = (Integer)values.get("age");
        Assert.assertEquals((Object)"Chuckles", (Object)name);
        Assert.assertEquals((long)37L, (long)age);
    }

    @Test
    public void testWithConfiguration() {
        this.setExpected((Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put("word", "brown");
                this.put("opacity", 0.8);
            }
        });
        Inputs inputs = new Inputs(this.context);
        inputs.getInfo().setName("testWithConfiguration");
        MutableModuleItem<String> wordInput = InputsTest.addTempInput(inputs, "word", String.class);
        wordInput.setLabel("Favorite word");
        wordInput.setChoices(Arrays.asList("quick", "brown", "fox"));
        wordInput.setDefaultValue((Object)"fox");
        MutableModuleItem<Double> opacityInput = InputsTest.addTempInput(inputs, "opacity", Double.class);
        opacityInput.setMinimumValue((Object)0.0);
        opacityInput.setMaximumValue((Object)1.0);
        opacityInput.setDefaultValue((Object)0.5);
        opacityInput.setWidgetStyle("scroll bar");
        inputs.harvest();
        String word = (String)wordInput.getValue((Module)inputs);
        double opacity = (Double)opacityInput.getValue((Module)inputs);
        Assert.assertEquals((Object)"brown", (Object)word);
        Assert.assertEquals((double)0.8, (double)opacity, (double)0.0);
    }

    public void setExpected(final Map<String, Object> expected) {
        PluginInfo<PreprocessorPlugin> info = new PluginInfo<PreprocessorPlugin>(MockInputHarvester.class, PreprocessorPlugin.class){

            public PreprocessorPlugin createInstance() throws InstantiableException {
                PreprocessorPlugin pp = (PreprocessorPlugin)super.createInstance();
                ((MockInputHarvester)pp).setExpected(expected);
                return pp;
            }
        };
        info.setPriority(-10000.0);
        ((PluginService)this.context.service(PluginService.class)).addPlugin((PluginInfo)info);
    }

    private static <T> MutableModuleItem<T> addTempInput(Inputs inputs, String inputName, Class<T> inputType) {
        MutableModuleItem input = inputs.addInput(inputName, inputType);
        input.setPersisted(false);
        return input;
    }

    public static class MockInputHarvester
    extends AbstractPreprocessorPlugin {
        private Map<String, Object> expected;

        public void setExpected(Map<String, Object> expected) {
            this.expected = expected;
        }

        public void process(Module module) {
            for (ModuleItem input : module.getInfo().inputs()) {
                if (module.isInputResolved(input.getName())) continue;
                String name = input.getName();
                if (!this.expected.containsKey(name)) {
                    throw new AssertionError((Object)("No value for input: " + input.getName()));
                }
                Object value = this.expected.get(name);
                module.setInput(name, value);
            }
        }
    }
}

