/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public final class DebugUtils {
    private static final String NL = System.getProperty("line.separator");

    private DebugUtils() {
    }

    public static String getStackTrace(Throwable t) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream((OutputStream)out, false, "UTF-8"));
            return new String(out.toByteArray(), "UTF-8");
        }
        catch (IOException exc) {
            return null;
        }
    }

    public static String getStackDump(Thread thread) {
        return DebugUtils.getStackDump(thread, thread.getStackTrace());
    }

    public static String getStackDump(Thread thread, StackTraceElement[] stackTrace) {
        StringBuilder sb = new StringBuilder();
        DebugUtils.dumpThread(thread, stackTrace, sb);
        return sb.toString();
    }

    public static String getStackDump() {
        StringBuilder sb = new StringBuilder();
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        ArrayList<Thread> threads = new ArrayList<Thread>(stackTraces.keySet());
        Collections.sort(threads, (t1, t2) -> t1.getName().compareTo(t2.getName()));
        for (Thread t : threads) {
            DebugUtils.dumpThread(t, stackTraces.get(t), sb);
        }
        return sb.toString();
    }

    public static String getFieldName(Class<?> c, int value) {
        Field[] fields = c.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!Modifier.isStatic(fields[i].getModifiers())) continue;
            fields[i].setAccessible(true);
            try {
                if (fields[i].getInt(null) != value) continue;
                return fields[i].getName();
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return "" + value;
    }

    public static String getMainClassName() {
        Map<Thread, StackTraceElement[]> traceMap = Thread.getAllStackTraces();
        for (Thread thread : traceMap.keySet()) {
            StackTraceElement[] trace;
            if (!"main".equals(thread.getName()) || (trace = traceMap.get(thread)) == null || trace.length == 0) continue;
            StackTraceElement element = trace[trace.length - 1];
            return element.getClassName();
        }
        return null;
    }

    private static void dumpThread(Thread t, StackTraceElement[] trace, StringBuilder sb) {
        DebugUtils.threadInfo(t, sb);
        for (StackTraceElement element : trace) {
            sb.append("\tat ");
            sb.append(element);
            sb.append(NL);
        }
        sb.append(NL);
    }

    private static void threadInfo(Thread t, StringBuilder sb) {
        sb.append("\"");
        sb.append(t.getName());
        sb.append("\"");
        if (!t.isAlive()) {
            sb.append(" DEAD");
        }
        if (t.isInterrupted()) {
            sb.append(" INTERRUPTED");
        }
        if (t.isDaemon()) {
            sb.append(" daemon");
        }
        sb.append(" prio=");
        sb.append(t.getPriority());
        sb.append(" id=");
        sb.append(t.getId());
        sb.append(" group=");
        sb.append(t.getThreadGroup().getName());
        sb.append(NL);
        sb.append("   java.lang.Thread.State: ");
        sb.append((Object)t.getState());
        sb.append(NL);
    }
}

