/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.convert;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.convert.Converter;
import org.scijava.convert.StringToNumberConverter;

public class StringToNumberConverterTest {
    Converter<String, Number> conv;

    @Before
    public void setUp() {
        this.conv = new StringToNumberConverter();
    }

    @Test
    public void stringToByteTest() {
        String s = "0";
        Assert.assertTrue((boolean)this.conv.canConvert((Object)s, Byte.class));
        Assert.assertEquals((Object)new Byte(0), (Object)this.conv.convert((Object)s, Byte.class));
    }

    @Test
    public void stringToPrimitiveByteTest() {
        String s = "0";
        Assert.assertTrue((boolean)this.conv.canConvert((Object)s, Byte.TYPE));
        Assert.assertEquals((long)0L, (long)((Byte)this.conv.convert((Object)s, Byte.TYPE)).byteValue());
    }

    @Test
    public void stringToShortTest() {
        String s = "0";
        Assert.assertTrue((boolean)this.conv.canConvert((Object)s, Short.class));
        Assert.assertEquals((Object)new Short(0), (Object)this.conv.convert((Object)s, Short.class));
    }

    @Test
    public void stringToPrimitiveShortTest() {
        String s = "0";
        Assert.assertTrue((boolean)this.conv.canConvert((Object)s, Short.TYPE));
        Assert.assertEquals((long)0L, (long)((Short)this.conv.convert((Object)s, Short.TYPE)).shortValue());
    }

    @Test
    public void stringToIntegerTest() {
        String s = "0";
        Assert.assertTrue((boolean)this.conv.canConvert((Object)s, Integer.class));
        Assert.assertEquals((Object)new Integer(0), (Object)this.conv.convert((Object)s, Integer.class));
    }

    @Test
    public void stringToPrimitiveIntegerTest() {
        String s = "0";
        Assert.assertTrue((boolean)this.conv.canConvert((Object)s, Integer.TYPE));
        Assert.assertEquals((long)0L, (long)((Integer)this.conv.convert((Object)s, Integer.TYPE)).intValue());
    }

    @Test
    public void stringToLongTest() {
        String s = "0";
        Assert.assertTrue((boolean)this.conv.canConvert((Object)s, Long.class));
        Assert.assertEquals((Object)new Long(0L), (Object)this.conv.convert((Object)s, Long.class));
    }

    @Test
    public void stringToPrimitiveLongTest() {
        String s = "0";
        Assert.assertTrue((boolean)this.conv.canConvert((Object)s, Long.TYPE));
        Assert.assertEquals((long)0L, (long)((Long)this.conv.convert((Object)s, Long.TYPE)));
    }

    @Test
    public void stringToFloatTest() {
        String s = "0";
        Assert.assertTrue((boolean)this.conv.canConvert((Object)s, Float.class));
        Assert.assertEquals((Object)new Float(0.0f), (Object)this.conv.convert((Object)s, Float.class));
    }

    @Test
    public void stringToPrimitiveFloat() {
        String s = "0";
        Assert.assertTrue((boolean)this.conv.canConvert((Object)s, Float.TYPE));
        Assert.assertEquals((double)0.0, (double)((Float)this.conv.convert((Object)s, Float.TYPE)).floatValue(), (double)1.0E-6);
    }

    @Test
    public void stringToDoubleTest() {
        String s = "0";
        Assert.assertTrue((boolean)this.conv.canConvert((Object)s, Double.class));
        Assert.assertEquals((Object)new Double(0.0), (Object)this.conv.convert((Object)s, Double.class));
    }

    @Test
    public void stringToPrimitiveDouble() {
        String s = "0";
        Assert.assertTrue((boolean)this.conv.canConvert((Object)s, Double.TYPE));
        Assert.assertEquals((double)0.0, (double)((Double)this.conv.convert((Object)s, Double.TYPE)), (double)1.0E-6);
    }

    @Test
    public void stringToNumberTest() {
        String s = "0";
        Assert.assertTrue((boolean)this.conv.canConvert((Object)s, Number.class));
        Assert.assertEquals((Object)0.0, (Object)this.conv.convert((Object)s, Number.class));
    }

    @Test
    public void invalidStringToNumberTest() {
        String s = "invalid";
        Assert.assertFalse((boolean)this.conv.canConvert((Object)s, Number.class));
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            Number cfr_ignored_0 = (Number)this.conv.convert((Object)s, Number.class);
        });
    }
}

