/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.io.ByteBank;

public abstract class ByteBankTest {
    private static byte[] testBytes = new byte[]{0, -1, 2, -3, 4, 120, -128, 127, 32, 42};
    private ByteBank bank;

    public abstract ByteBank createByteBank();

    @Before
    public void setup() {
        this.bank = this.createByteBank();
    }

    @Test
    public void testSetGetBytesArray() {
        this.bank.setBytes(0L, (byte[])testBytes.clone(), 0, testBytes.length);
        this.assertEqualRead(testBytes.length, 0);
        this.assertEqualRead(testBytes.length - 4, 2);
    }

    @Test
    public void testToByteArray() {
        this.bank.setBytes(0L, (byte[])testBytes.clone(), 0, testBytes.length);
        Assert.assertArrayEquals((byte[])testBytes, (byte[])this.bank.toByteArray());
        byte[] actuals = this.bank.toByteArray(0L, testBytes.length);
        Assert.assertArrayEquals((byte[])actuals, (byte[])testBytes);
    }

    @Test
    public void testSetGetBytesPartialArray() {
        this.bank.setBytes(0L, testBytes, 0, testBytes.length - 4);
        this.assertEqualRead(testBytes.length - 4, 0);
        this.assertEqualRead(testBytes.length - 4, 2);
    }

    @Test
    public void testSetGetByte() {
        int i;
        int numElements = 200000;
        for (i = 0; i < 200000; ++i) {
            this.bank.setByte((long)i, (byte)i);
        }
        for (i = 0; i < 200000; ++i) {
            Assert.assertEquals((long)((byte)i), (long)this.bank.getByte((long)i));
        }
    }

    @Test
    public void testClear() {
        this.bank.setBytes(0L, testBytes, 0, testBytes.length);
        Assert.assertEquals((long)testBytes.length, (long)this.bank.size());
        this.bank.clear();
        Assert.assertEquals((long)0L, (long)this.bank.size());
    }

    @Test
    public void testAppendBytes() {
        this.bank.appendBytes(testBytes, testBytes.length);
        this.assertEqualRead(testBytes.length, 0);
        this.bank.clear();
        this.bank.setByte(0L, (byte)42);
        this.bank.setByte(1L, (byte)43);
        this.bank.appendBytes(testBytes, testBytes.length);
        byte[] expected = new byte[testBytes.length + 2];
        expected[0] = 42;
        expected[1] = 43;
        System.arraycopy(testBytes, 0, expected, 2, testBytes.length);
        byte[] actuals = new byte[expected.length];
        this.bank.getBytes(0L, actuals);
        Assert.assertArrayEquals((byte[])expected, (byte[])actuals);
    }

    private void assertEqualRead(int length, int offset) {
        byte[] bytes = new byte[length];
        int read = this.bank.getBytes((long)offset, bytes);
        byte[] expected = new byte[length];
        System.arraycopy(testBytes, offset, expected, 0, read);
        Assert.assertArrayEquals((byte[])expected, (byte[])bytes);
        byte[] offsetBytes = new byte[testBytes.length];
        int readOffset = this.bank.getBytes((long)offset, offsetBytes, offset, length);
        byte[] offsetExpected = new byte[testBytes.length];
        System.arraycopy(testBytes, offset, offsetExpected, offset, readOffset);
        Assert.assertArrayEquals((byte[])expected, (byte[])bytes);
    }
}

