/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.task;

import java.util.HashSet;
import java.util.Set;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scijava.Context;
import org.scijava.event.EventHandler;
import org.scijava.task.Task;
import org.scijava.task.TaskService;
import org.scijava.task.event.TaskEvent;

public class TaskEventTest {
    private TaskService taskService;
    private TaskEventListener eventListener;
    static int nTasks = 500;

    @Before
    public void setUp() {
        Context ctx = new Context(new Class[]{TaskService.class});
        this.taskService = (TaskService)ctx.service(TaskService.class);
        this.eventListener = new TaskEventListener();
        ctx.inject((Object)this.eventListener);
    }

    @After
    public void tearDown() {
        this.taskService.context().dispose();
    }

    @Test
    public void testManyTasks() throws InterruptedException {
        for (int i = 0; i < nTasks; ++i) {
            TaskEventTest.createTask(this.taskService, "Task_" + i, 100, 10, 100);
        }
        long start = System.currentTimeMillis();
        long maxWaitTime = 5000L;
        while (System.currentTimeMillis() - start < maxWaitTime && !this.eventListener.tasks.isEmpty()) {
            Thread.sleep(10L);
        }
        Assert.assertEquals((long)0L, (long)this.eventListener.getLeftOvers().size());
    }

    public static void createTask(TaskService taskService, String taskName, int msBeforeStart, int msUpdate, int msTaskDuration) {
        Task task = taskService.createTask(taskName);
        new Thread(() -> {
            try {
                Thread.sleep(msBeforeStart);
                task.setProgressMaximum(100L);
                task.run(() -> {
                    int totalMs = 0;
                    while (totalMs < msTaskDuration) {
                        try {
                            Thread.sleep(msUpdate);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        task.setProgressValue((long)((int)((double)(totalMs += msUpdate) / (double)msTaskDuration * 100.0)));
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }).start();
    }

    public static class TaskEventListener {
        Set<Task> tasks = new HashSet<Task>();

        @EventHandler
        private synchronized void onEvent(TaskEvent evt) {
            Task task = evt.getTask();
            if (task.isDone()) {
                this.tasks.remove(task);
            } else {
                this.tasks.add(task);
            }
        }

        public synchronized Set<Task> getLeftOvers() {
            return new HashSet<Task>(this.tasks);
        }
    }
}

