/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.concurrent;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scijava.concurrent.TaskExecutors;

public class DefaultTaskExecutorTest {
    private final TaskExecutors.DefaultTaskExecutor sequential = new TaskExecutors.DefaultTaskExecutor((ExecutorService)new TaskExecutors.SequentialExecutorService());
    private final TaskExecutors.DefaultTaskExecutor twoThreads = new TaskExecutors.DefaultTaskExecutor((ExecutorService)new ForkJoinPool(2));

    @Test
    public void testGetParallelism() {
        this.testGetParallelism(1, (ExecutorService)new TaskExecutors.SequentialExecutorService());
        this.testGetParallelism(2, Executors.newFixedThreadPool(2));
        this.testGetParallelism(3, new ForkJoinPool(3));
        this.testGetParallelism(1, Executors.newCachedThreadPool());
        this.testGetParallelism(ForkJoinPool.commonPool().getParallelism(), (ExecutorService)new TaskExecutors.ForkJoinExecutorService());
    }

    private void testGetParallelism(int expectedParallelism, ExecutorService executorService) {
        TaskExecutors.DefaultTaskExecutor taskExecutor = new TaskExecutors.DefaultTaskExecutor(executorService);
        Assertions.assertEquals((int)expectedParallelism, (int)taskExecutor.getParallelism());
    }

    @Test
    public void testSuggestNumberOfTasks() {
        Assertions.assertEquals((int)1, (int)this.sequential.suggestNumberOfTasks());
        Assertions.assertEquals((int)8, (int)this.twoThreads.suggestNumberOfTasks());
    }

    @Test
    public void testForEach() {
        AtomicInteger sum = new AtomicInteger();
        List<Integer> parameters = Arrays.asList(1, 2, 3);
        this.twoThreads.forEach(parameters, sum::addAndGet);
        Assertions.assertEquals((int)6, (int)sum.get());
    }

    @Test
    public void testForEachApply() {
        List<Integer> parameters = Arrays.asList(1, 2, 3);
        List squared = this.twoThreads.forEachApply(parameters, i -> i * i);
        Assertions.assertEquals(Arrays.asList(1, 4, 9), (Object)squared);
    }

    @Test
    public void testRunAll() {
        AtomicInteger sum = new AtomicInteger();
        List<Runnable> tasks = Arrays.asList(() -> sum.addAndGet(1), () -> sum.addAndGet(2), () -> sum.addAndGet(3));
        this.twoThreads.runAll(tasks);
        Assertions.assertEquals((int)6, (int)sum.get());
    }

    @Test
    public void testExceptionHandling() {
        try {
            this.twoThreads.runAll(Collections.singletonList(this::throwDummyException));
            Assertions.fail((String)"DefaultTaskExecutor.runAll() failed to rethrow the DummyException.");
        }
        catch (DummyException e) {
            this.assertStackTraceContainsMethod(e, "testExceptionHandling");
            this.assertStackTraceContainsMethod(e, "runAll");
            this.assertStackTraceContainsMethod(e, "throwDummyException");
        }
    }

    public void assertStackTraceContainsMethod(Exception e, String methodName) {
        StackTraceElement[] stack = e.getStackTrace();
        Assertions.assertTrue((boolean)Stream.of(stack).anyMatch(stackTraceElement -> stackTraceElement.getMethodName().equals(methodName)));
    }

    public void throwDummyException() {
        throw new DummyException();
    }

    private static class DummyException
    extends RuntimeException {
        private DummyException() {
        }
    }
}

